/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.imagemap;

import java.awt.Shape;
import java.awt.geom.GeneralPath;
import org.pentaho.reporting.engine.classic.core.imagemap.AbstractImageMapEntry;

public class PolygonImageMapEntry
extends AbstractImageMapEntry {
    private float[] coordinates;
    private GeneralPath polygon;

    public PolygonImageMapEntry(float[] coordinates) {
        if (coordinates == null) {
            throw new NullPointerException();
        }
        if (coordinates.length == 0) {
            throw new IllegalArgumentException();
        }
        this.coordinates = (float[])coordinates.clone();
    }

    public String getAreaType() {
        return "poly";
    }

    public float[] getAreaCoordinates() {
        return (float[])this.coordinates.clone();
    }

    public Shape getShape() {
        if (this.polygon == null) {
            this.polygon = new GeneralPath();
            for (int i = 0; i < this.coordinates.length; i += 2) {
                float coordinateX = this.coordinates[i];
                float coordinateY = this.coordinates[i + 1];
                if (i == 0) {
                    this.polygon.moveTo(coordinateX, coordinateY);
                    continue;
                }
                this.polygon.lineTo(coordinateX, coordinateY);
            }
            this.polygon.closePath();
        }
        return this.polygon;
    }
}

