/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.imagemap.parser;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;
import org.pentaho.reporting.engine.classic.core.imagemap.ImageMap;
import org.pentaho.reporting.engine.classic.core.imagemap.ImageMapEntry;
import org.pentaho.reporting.libraries.formatting.FastDecimalFormat;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.writer.DefaultTagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public class ImageMapWriter {
    private ImageMapWriter() {
    }

    public static String writeImageMapAsString(ImageMap imageMap) {
        try {
            DefaultTagDescription tagDescription = new DefaultTagDescription();
            tagDescription.setDefaultNamespace("http://www.w3.org/1999/xhtml");
            tagDescription.addDefaultDefinition("http://www.w3.org/1999/xhtml", false);
            StringWriter sbwriter = new StringWriter(5000);
            XmlWriter writer = new XmlWriter((Writer)sbwriter);
            writer.setHtmlCompatiblityMode(true);
            writer.setWriteFinalLinebreak(true);
            ImageMapWriter.writeImageMap(writer, imageMap, 1.0);
            writer.close();
            return sbwriter.toString();
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Failed to write ImageMap - I am confused.");
        }
    }

    public static void writeImageMap(XmlWriter writer, ImageMap imageMap, double scale) throws IOException {
        AttributeList attrs = new AttributeList();
        if (!writer.isNamespaceDefined("http://www.w3.org/1999/xhtml")) {
            attrs.addNamespaceDeclaration("", "http://www.w3.org/1999/xhtml");
        }
        String[] mapNamespaces = imageMap.getNameSpaces();
        for (int i = 0; i < mapNamespaces.length; ++i) {
            String namespace = mapNamespaces[i];
            String[] names = imageMap.getNames(namespace);
            for (int j = 0; j < names.length; ++j) {
                String name = names[j];
                String value = imageMap.getAttribute(namespace, name);
                attrs.setAttribute(namespace, name, value);
            }
        }
        writer.writeTag("http://www.w3.org/1999/xhtml", "map", attrs, false);
        ImageMapEntry[] imageMapEntries = imageMap.getMapEntries();
        for (int i = 0; i < imageMapEntries.length; ++i) {
            ImageMapEntry mapEntry = imageMapEntries[i];
            ImageMapWriter.writeMapEntry(writer, mapEntry, scale);
        }
        writer.writeCloseTag();
    }

    private static void writeMapEntry(XmlWriter writer, ImageMapEntry mapEntry, double scale) throws IOException {
        AttributeList attrs = new AttributeList();
        String[] mapNamespaces = mapEntry.getNameSpaces();
        for (int i = 0; i < mapNamespaces.length; ++i) {
            String namespace = mapNamespaces[i];
            String[] names = mapEntry.getNames(namespace);
            for (int j = 0; j < names.length; ++j) {
                String name = names[j];
                String value = mapEntry.getAttribute(namespace, name);
                attrs.setAttribute(namespace, name, value);
            }
        }
        String areaType = mapEntry.getAreaType();
        attrs.setAttribute("http://www.w3.org/1999/xhtml", "shape", areaType);
        if (!"default".equals(areaType)) {
            float[] coordinates = mapEntry.getAreaCoordinates();
            attrs.setAttribute("http://www.w3.org/1999/xhtml", "coords", ImageMapWriter.convertCoordinates(coordinates, scale));
        }
        writer.writeTag("http://www.w3.org/1999/xhtml", "area", attrs, true);
    }

    private static String convertCoordinates(float[] coordinates, double scale) {
        if (coordinates == null || coordinates.length == 0) {
            return null;
        }
        FastDecimalFormat decimalFormat = new FastDecimalFormat("######################0.0########", Locale.US);
        StringBuilder b = new StringBuilder(coordinates.length * 10);
        b.append(decimalFormat.format((Object)((double)coordinates[0] * scale)));
        for (int i = 1; i < coordinates.length; ++i) {
            float coordinate = coordinates[i];
            b.append(',');
            b.append(decimalFormat.format((Object)((double)coordinate * scale)));
        }
        return b.toString();
    }
}

