/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.GroupBody;
import org.pentaho.reporting.engine.classic.core.InvalidReportStateException;
import org.pentaho.reporting.engine.classic.core.ReportAttributeMap;
import org.pentaho.reporting.engine.classic.core.ReportDefinition;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.filter.types.AutoLayoutBoxType;
import org.pentaho.reporting.engine.classic.core.filter.types.bands.SubReportType;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.layout.DefaultLayoutBuilder;
import org.pentaho.reporting.engine.classic.core.layout.FooterLayoutBuilder;
import org.pentaho.reporting.engine.classic.core.layout.HeaderLayoutBuilder;
import org.pentaho.reporting.engine.classic.core.layout.InlineSubreportMarker;
import org.pentaho.reporting.engine.classic.core.layout.LayoutBuilder;
import org.pentaho.reporting.engine.classic.core.layout.Renderer;
import org.pentaho.reporting.engine.classic.core.layout.RepeatedFooterLayoutBuilder;
import org.pentaho.reporting.engine.classic.core.layout.StyleCache;
import org.pentaho.reporting.engine.classic.core.layout.model.BlockRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.BreakMarkerRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.InlineProgressMarkerRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.ProgressMarkerRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderLength;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.SectionRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.WatermarkAreaBox;
import org.pentaho.reporting.engine.classic.core.layout.model.context.BoxDefinition;
import org.pentaho.reporting.engine.classic.core.layout.model.context.BoxDefinitionFactory;
import org.pentaho.reporting.engine.classic.core.layout.output.ContentProcessingException;
import org.pentaho.reporting.engine.classic.core.layout.output.LayoutPagebreakHandler;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessor;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorFeature;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.output.ValidateSafeToStoreStateStep;
import org.pentaho.reporting.engine.classic.core.layout.process.ApplyAutoCommitStep;
import org.pentaho.reporting.engine.classic.core.layout.process.ApplyCachedValuesStep;
import org.pentaho.reporting.engine.classic.core.layout.process.ApplyCommitStep;
import org.pentaho.reporting.engine.classic.core.layout.process.CanvasMajorAxisLayoutStep;
import org.pentaho.reporting.engine.classic.core.layout.process.CommitStep;
import org.pentaho.reporting.engine.classic.core.layout.process.ComputeStaticPropertiesProcessStep;
import org.pentaho.reporting.engine.classic.core.layout.process.CountBoxesStep;
import org.pentaho.reporting.engine.classic.core.layout.process.InfiniteMajorAxisLayoutStep;
import org.pentaho.reporting.engine.classic.core.layout.process.InfiniteMinorAxisLayoutStep;
import org.pentaho.reporting.engine.classic.core.layout.process.ParagraphLineBreakStep;
import org.pentaho.reporting.engine.classic.core.layout.process.RevalidateAllAxisLayoutStep;
import org.pentaho.reporting.engine.classic.core.layout.process.RollbackStep;
import org.pentaho.reporting.engine.classic.core.layout.process.ValidateModelStep;
import org.pentaho.reporting.engine.classic.core.layout.style.ManualBreakIndicatorStyleSheet;
import org.pentaho.reporting.engine.classic.core.layout.style.SectionKeepTogetherStyleSheet;
import org.pentaho.reporting.engine.classic.core.layout.style.SimpleStyleSheet;
import org.pentaho.reporting.engine.classic.core.layout.style.SubReportStyleSheet;
import org.pentaho.reporting.engine.classic.core.states.ReportStateKey;
import org.pentaho.reporting.engine.classic.core.style.BandDefaultStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.BandStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;
import org.pentaho.reporting.libraries.base.util.FastStack;

public abstract class AbstractRenderer
implements Renderer {
    private static final Log logger = LogFactory.getLog(AbstractRenderer.class);
    private LogicalPageBox pageBox;
    private DefaultLayoutBuilder normalFlowLayoutBuilder;
    private LayoutBuilder watermarkLayoutBuilder;
    private HeaderLayoutBuilder headerLayoutBuilder;
    private FooterLayoutBuilder footerLayoutBuilder;
    private RepeatedFooterLayoutBuilder repeatedFooterLayoutBuilder;
    private CountBoxesStep countBoxesStep;
    private ValidateModelStep validateModelStep;
    private ComputeStaticPropertiesProcessStep staticPropertiesStep;
    private ParagraphLineBreakStep paragraphLineBreakStep;
    private InfiniteMinorAxisLayoutStep minorAxisLayoutStep;
    private InfiniteMajorAxisLayoutStep majorAxisLayoutStep;
    private CanvasMajorAxisLayoutStep canvasMajorAxisLayoutStep;
    private RevalidateAllAxisLayoutStep revalidateAllAxisLayoutStep;
    private ValidateSafeToStoreStateStep validateSafeToStoreStateStep;
    private CommitStep commitStep;
    private ApplyCommitStep applyCommitStep;
    private RollbackStep rollbackStep;
    private ApplyAutoCommitStep applyAutoCommitStep;
    private OutputProcessorMetaData metaData;
    private OutputProcessor outputProcessor;
    private Section section;
    private int pagebreaks;
    private boolean dirty;
    private ReportStateKey lastStateKey;
    private ApplyCachedValuesStep applyCachedValuesStep;
    private SimpleStyleSheet manualBreakBoxStyle;
    private StyleCache sectionStyleCache;
    private boolean readOnly;
    private FastStack groupStack;
    private Object stateKey;
    private boolean paranoidChecks;
    private BoxDefinitionFactory boxDefinitionFactory;
    private BoxDefinition watermarkBoxDefinition;
    private SimpleStyleSheet bandWithoutKeepTogetherStyle;
    private SimpleStyleSheet bandWithKeepTogetherStyle;
    private static final InlineSubreportMarker[] EMPTY_ARRAY = new InlineSubreportMarker[0];
    private SectionRenderBox[] sectionBoxes;
    private Renderer.LayoutResult lastValidateResult;

    protected AbstractRenderer(OutputProcessor outputProcessor) {
        BoxDefinition boxDefinition = new BoxDefinition();
        boxDefinition.setPreferredHeight(RenderLength.createPercentage(100.0));
        this.watermarkBoxDefinition = boxDefinition.lock();
        this.outputProcessor = outputProcessor;
        this.metaData = outputProcessor.getMetaData();
        this.normalFlowLayoutBuilder = this.createNormalFlowLayoutBuilder(this.metaData);
        this.headerLayoutBuilder = new HeaderLayoutBuilder(this.metaData);
        this.watermarkLayoutBuilder = new HeaderLayoutBuilder(this.metaData);
        this.footerLayoutBuilder = new FooterLayoutBuilder(this.metaData);
        this.repeatedFooterLayoutBuilder = new RepeatedFooterLayoutBuilder(this.metaData);
        this.paranoidChecks = "true".equals(this.metaData.getConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.core.layout.ParanoidChecks"));
        this.validateModelStep = new ValidateModelStep();
        this.staticPropertiesStep = new ComputeStaticPropertiesProcessStep(this.metaData);
        this.paragraphLineBreakStep = new ParagraphLineBreakStep();
        this.minorAxisLayoutStep = new InfiniteMinorAxisLayoutStep(this.metaData);
        this.majorAxisLayoutStep = new InfiniteMajorAxisLayoutStep();
        this.canvasMajorAxisLayoutStep = new CanvasMajorAxisLayoutStep();
        this.revalidateAllAxisLayoutStep = new RevalidateAllAxisLayoutStep(this.metaData);
        this.validateSafeToStoreStateStep = new ValidateSafeToStoreStateStep();
        this.applyCachedValuesStep = new ApplyCachedValuesStep();
        this.commitStep = new CommitStep();
        this.applyAutoCommitStep = new ApplyAutoCommitStep();
        this.applyCommitStep = new ApplyCommitStep();
        this.rollbackStep = new RollbackStep();
        this.countBoxesStep = new CountBoxesStep();
        this.sectionBoxes = new SectionRenderBox[5];
        this.groupStack = new FastStack(50);
        this.bandWithKeepTogetherStyle = new SimpleStyleSheet(new SectionKeepTogetherStyleSheet(true));
        this.bandWithoutKeepTogetherStyle = new SimpleStyleSheet(new SectionKeepTogetherStyleSheet(false));
        boolean paddingsDisabled = this.metaData.isFeatureSupported(OutputProcessorFeature.DISABLE_PADDING);
        this.sectionStyleCache = new StyleCache(paddingsDisabled);
        this.boxDefinitionFactory = new BoxDefinitionFactory();
    }

    public boolean isSafeToStore() {
        if (this.pageBox == null) {
            return true;
        }
        return this.validateSafeToStoreStateStep.isSafeToStore(this.pageBox);
    }

    protected DefaultLayoutBuilder createNormalFlowLayoutBuilder(OutputProcessorMetaData metaData) {
        return new DefaultLayoutBuilder(metaData);
    }

    protected OutputProcessorMetaData getMetaData() {
        return this.metaData;
    }

    public Object getStateKey() {
        return this.stateKey;
    }

    public void setStateKey(Object stateKey) {
        this.stateKey = stateKey;
    }

    public OutputProcessor getOutputProcessor() {
        return this.outputProcessor;
    }

    public void startReport(ReportDefinition report) {
        if (report == null) {
            throw new NullPointerException();
        }
        if (this.readOnly) {
            throw new IllegalStateException();
        }
        SimpleStyleSheet reportStyle = this.sectionStyleCache.getStyleSheet(report.getStyle());
        BoxDefinition boxDefinition = this.boxDefinitionFactory.getBoxDefinition(reportStyle);
        this.pageBox = new LogicalPageBox(report, reportStyle, boxDefinition);
        if (reportStyle.getBooleanStyleProperty(ElementStyleKeys.AVOID_PAGEBREAK_INSIDE)) {
            this.groupStack.push((Object)new GroupSection(this.pageBox.getContentArea(), this.bandWithKeepTogetherStyle));
        } else {
            this.groupStack.push((Object)new GroupSection(this.pageBox.getContentArea(), this.bandWithoutKeepTogetherStyle));
        }
        this.markDirty();
    }

    public void startSubReport(ReportDefinition report, InstanceID insertationPoint) {
        RenderBox box;
        if (this.readOnly) {
            throw new IllegalStateException("Renderer is marked read-only");
        }
        if (this.isIgnoreContent()) {
            this.groupStack.push((Object)new IgnoredContentIndicator());
            return;
        }
        if (insertationPoint == null) {
            SubReportStyleSheet styleSheet = new SubReportStyleSheet(report.getStyle().getBooleanStyleProperty(BandStyleKeys.PAGEBREAK_BEFORE), report.getStyle().getBooleanStyleProperty(BandStyleKeys.PAGEBREAK_AFTER));
            SimpleStyleSheet reportStyle = new SimpleStyleSheet(report.getStyle().getId(), styleSheet);
            BoxDefinition boxDefinition = this.boxDefinitionFactory.getBoxDefinition(reportStyle);
            box = new BlockRenderBox(reportStyle, report.getObjectID(), boxDefinition, SubReportType.INSTANCE, report.getAttributes(), null);
            if (report.getName() != null) {
                box.setName("Banded-SubReport-Section: name=" + report.getName());
            } else {
                box.setName("Banded-SubReport-Section");
            }
            box.getStaticBoxLayoutProperties().setPlaceholderBox(true);
            this.addBox(box);
        } else {
            RenderNode maybeBox = this.pageBox.findNodeById(insertationPoint);
            box = maybeBox == null || (maybeBox.getNodeType() & 2) != 2 ? null : (RenderBox)maybeBox;
        }
        if (box == null) {
            this.groupStack.push((Object)new IgnoredContentIndicator());
        } else {
            this.groupStack.push((Object)new GroupSection(box, this.bandWithoutKeepTogetherStyle));
        }
    }

    public void startGroup(Group group) {
        if (this.readOnly) {
            throw new IllegalStateException();
        }
        if (this.isIgnoreContent()) {
            this.groupStack.push((Object)new IgnoredContentIndicator());
            return;
        }
        SimpleStyleSheet reportStyle = this.sectionStyleCache.getStyleSheet(group.getStyle());
        BoxDefinition boxDefinition = this.boxDefinitionFactory.getBoxDefinition(reportStyle);
        BlockRenderBox groupBox = new BlockRenderBox(reportStyle, group.getObjectID(), boxDefinition, group.getElementType(), group.getAttributes(), null);
        groupBox.getStaticBoxLayoutProperties().setPlaceholderBox(true);
        groupBox.setName(group.getElementTypeName());
        this.addBox(groupBox);
        if (reportStyle.getBooleanStyleProperty(ElementStyleKeys.AVOID_PAGEBREAK_INSIDE)) {
            this.groupStack.push((Object)new GroupSection(groupBox, this.bandWithKeepTogetherStyle));
        } else {
            this.groupStack.push((Object)new GroupSection(groupBox, this.bandWithoutKeepTogetherStyle));
        }
    }

    public void startGroupBody(GroupBody groupBody) {
        if (this.isIgnoreContent()) {
            this.groupStack.push((Object)new IgnoredContentIndicator());
            return;
        }
        SimpleStyleSheet reportStyle = this.sectionStyleCache.getStyleSheet(groupBody.getStyle());
        BoxDefinition boxDefinition = this.boxDefinitionFactory.getBoxDefinition(reportStyle);
        BlockRenderBox groupBox = new BlockRenderBox(reportStyle, groupBody.getObjectID(), boxDefinition, groupBody.getElementType(), groupBody.getAttributes(), null);
        groupBox.getStaticBoxLayoutProperties().setPlaceholderBox(true);
        groupBox.setName(groupBody.getElementTypeName());
        this.addBox(groupBox);
        if (reportStyle.getBooleanStyleProperty(ElementStyleKeys.AVOID_PAGEBREAK_INSIDE)) {
            this.groupStack.push((Object)new GroupSection(groupBox, this.bandWithKeepTogetherStyle));
        } else {
            this.groupStack.push((Object)new GroupSection(groupBox, this.bandWithoutKeepTogetherStyle));
        }
        this.markDirty();
    }

    private void addBox(RenderNode node) {
        GroupSection groupSection = (GroupSection)this.groupStack.peek();
        groupSection.addedSection(node);
    }

    private boolean mergeSection(RenderNode node) {
        GroupSection groupSection = (GroupSection)this.groupStack.peek();
        return groupSection.mergeSection(node.getStateKey());
    }

    private SectionRenderBox createSectionBox(int type, BoxDefinition boxDefinition) {
        if (type == 0 && this.sectionBoxes[type] != null) {
            SectionRenderBox renderBox = this.sectionBoxes[type];
            this.sectionBoxes[type] = null;
            return renderBox;
        }
        return new SectionRenderBox(this.bandWithoutKeepTogetherStyle, new InstanceID(), boxDefinition, AutoLayoutBoxType.INSTANCE, ReportAttributeMap.EMPTY_MAP, null);
    }

    public void startSection(int type) {
        if (this.readOnly) {
            throw new IllegalStateException();
        }
        if (this.isIgnoreContent()) {
            return;
        }
        if (type == 4) {
            this.watermarkLayoutBuilder.startSection(this.pageBox.getWatermarkArea(), true);
            SectionRenderBox sectionBox = this.createSectionBox(type, this.watermarkBoxDefinition);
            sectionBox.setName("Watermark-Section");
            this.section = new Section(type, sectionBox);
        } else if (type == 1) {
            this.headerLayoutBuilder.startSection(this.pageBox.getHeaderArea(), true);
            SectionRenderBox sectionBox = this.createSectionBox(type, BoxDefinition.EMPTY);
            sectionBox.setName("Header-" + type);
            this.section = new Section(type, sectionBox);
        } else if (type == 2) {
            this.footerLayoutBuilder.startSection(this.pageBox.getFooterArea(), true);
            SectionRenderBox sectionBox = this.createSectionBox(type, BoxDefinition.EMPTY);
            sectionBox.setName("Footer-" + type);
            this.section = new Section(type, sectionBox);
        } else if (type == 3) {
            this.repeatedFooterLayoutBuilder.startSection(this.pageBox.getRepeatFooterArea(), true);
            SectionRenderBox sectionBox = this.createSectionBox(type, BoxDefinition.EMPTY);
            sectionBox.setName("Repeat-Footer-" + type);
            this.section = new Section(type, sectionBox);
        } else {
            this.normalFlowLayoutBuilder.startSection(this.pageBox, false);
            SectionRenderBox sectionBox = this.createSectionBox(0, BoxDefinition.EMPTY);
            sectionBox.setName("Section-" + type);
            this.section = new Section(type, sectionBox);
        }
    }

    public InlineSubreportMarker[] endSection() {
        if (this.readOnly) {
            throw new IllegalStateException();
        }
        if (this.isIgnoreContent()) {
            return EMPTY_ARRAY;
        }
        Section section = this.section;
        this.section = null;
        SectionRenderBox sectionBox = section.getSectionBox();
        sectionBox.close();
        int sectionType = section.getType();
        switch (sectionType) {
            case 0: {
                RenderNode firstChild = sectionBox.getFirstChild();
                if (firstChild == null) {
                    sectionBox.makeReusable();
                    this.sectionBoxes[sectionType] = sectionBox;
                    return this.normalFlowLayoutBuilder.endSection(this.getPageBox(), sectionBox);
                }
                int type = firstChild.getNodeType();
                if ((sectionBox.getLastChild() == firstChild && type == 16777282 || type == 0x1000012) && this.mergeSection(sectionBox)) {
                    sectionBox.makeReusable();
                    this.sectionBoxes[sectionType] = sectionBox;
                    return this.normalFlowLayoutBuilder.endSection(this.getPageBox(), sectionBox);
                }
                this.addBox(sectionBox);
                this.markDirty();
                return this.normalFlowLayoutBuilder.endSection(this.getPageBox(), sectionBox);
            }
            case 2: {
                BlockRenderBox footerArea = this.pageBox.getFooterArea();
                if (sectionBox.getFirstChild() == sectionBox.getLastChild() && this.isEmptyOrMarker(footerArea.getFirstChild()) && this.isEmptyOrMarker(sectionBox.getFirstChild())) {
                    return this.footerLayoutBuilder.endSection(footerArea, sectionBox);
                }
                this.markDirty();
                return this.footerLayoutBuilder.endSection(footerArea, sectionBox);
            }
            case 3: {
                BlockRenderBox footerArea = this.pageBox.getRepeatFooterArea();
                if (sectionBox.getFirstChild() == sectionBox.getLastChild() && this.isEmptyOrMarker(footerArea.getFirstChild()) && this.isEmptyOrMarker(sectionBox.getFirstChild())) {
                    return this.repeatedFooterLayoutBuilder.endSection(footerArea, sectionBox);
                }
                this.markDirty();
                return this.repeatedFooterLayoutBuilder.endSection(footerArea, sectionBox);
            }
            case 1: {
                BlockRenderBox headerArea = this.pageBox.getHeaderArea();
                if (sectionBox.getFirstChild() == sectionBox.getLastChild() && this.isEmptyOrMarker(headerArea.getFirstChild()) && this.isEmptyOrMarker(sectionBox.getFirstChild())) {
                    return this.headerLayoutBuilder.endSection(headerArea, sectionBox);
                }
                this.markDirty();
                return this.headerLayoutBuilder.endSection(headerArea, sectionBox);
            }
            case 4: {
                WatermarkAreaBox watermarkArea = this.pageBox.getWatermarkArea();
                if (sectionBox.getFirstChild() == sectionBox.getLastChild() && this.isEmptyOrMarker(watermarkArea.getFirstChild()) && this.isEmptyOrMarker(sectionBox.getFirstChild())) {
                    return this.watermarkLayoutBuilder.endSection(watermarkArea, sectionBox);
                }
                this.markDirty();
                return this.watermarkLayoutBuilder.endSection(watermarkArea, sectionBox);
            }
        }
        throw new IllegalStateException("Type " + sectionType + " not recognized");
    }

    private boolean isEmptyOrMarker(RenderNode box) {
        if (box == null) {
            return true;
        }
        int type = box.getNodeType();
        return type == 16777282 || type == 0x1000012;
    }

    private boolean isIgnoreContent() {
        return !this.groupStack.isEmpty() && this.groupStack.peek() instanceof IgnoredContentIndicator;
    }

    public void endGroupBody() {
        if (this.readOnly) {
            throw new IllegalStateException();
        }
        Object o = this.groupStack.pop();
        if (o instanceof IgnoredContentIndicator) {
            return;
        }
        GroupSection groupSection = (GroupSection)o;
        if (groupSection.getChildCount() == 0) {
            RenderBox groupBox = groupSection.getGroupBox();
            groupBox.getParent().remove(groupBox);
        }
        groupSection.close();
    }

    public void endGroup() {
        if (this.readOnly) {
            throw new IllegalStateException();
        }
        Object o = this.groupStack.pop();
        if (o instanceof IgnoredContentIndicator) {
            return;
        }
        GroupSection groupSection = (GroupSection)o;
        groupSection.close();
    }

    protected LogicalPageBox getPageBox() {
        return this.pageBox;
    }

    public void endSubReport() {
        if (this.readOnly) {
            throw new IllegalStateException();
        }
        Object o = this.groupStack.pop();
        if (o instanceof IgnoredContentIndicator) {
            return;
        }
        GroupSection groupSection = (GroupSection)o;
        groupSection.close();
    }

    public void endReport() {
        if (this.readOnly) {
            throw new IllegalStateException();
        }
        GroupSection groupSection = (GroupSection)this.groupStack.pop();
        groupSection.close();
        this.pageBox.close();
        this.markDirty();
    }

    public void addEmptyRootLevelBand(ReportStateKey stateKey) throws ReportProcessingException {
        if (this.readOnly) {
            throw new IllegalStateException();
        }
        if (this.isIgnoreContent()) {
            return;
        }
        SectionRenderBox sectionBox = this.section.getSectionBox();
        int type = this.section.getType();
        if (type == 2) {
            this.footerLayoutBuilder.addEmptyRootLevelBand(sectionBox, stateKey);
        } else if (type == 3) {
            this.repeatedFooterLayoutBuilder.addEmptyRootLevelBand(sectionBox, stateKey);
        } else if (type == 1) {
            this.headerLayoutBuilder.addEmptyRootLevelBand(sectionBox, stateKey);
        } else if (type == 4) {
            this.watermarkLayoutBuilder.addEmptyRootLevelBand(sectionBox, stateKey);
        } else {
            this.normalFlowLayoutBuilder.addEmptyRootLevelBand(sectionBox, stateKey);
        }
    }

    public void add(Band band, ExpressionRuntime runtime, ReportStateKey stateKey) throws ReportProcessingException {
        if (this.readOnly) {
            throw new IllegalStateException();
        }
        if (this.isIgnoreContent()) {
            return;
        }
        SectionRenderBox sectionBox = this.section.getSectionBox();
        int type = this.section.getType();
        if (type == 2) {
            this.footerLayoutBuilder.add(sectionBox, band, runtime, stateKey);
        } else if (type == 3) {
            this.repeatedFooterLayoutBuilder.add(sectionBox, band, runtime, stateKey);
        } else if (type == 1) {
            this.headerLayoutBuilder.add(sectionBox, band, runtime, stateKey);
        } else if (type == 4) {
            this.watermarkLayoutBuilder.add(sectionBox, band, runtime, stateKey);
        } else {
            this.normalFlowLayoutBuilder.add(sectionBox, band, runtime, stateKey);
        }
    }

    public void add(RenderBox box) {
        if (this.readOnly) {
            throw new IllegalStateException();
        }
        if (this.isIgnoreContent()) {
            return;
        }
        if (box.isOpen()) {
            throw new IllegalStateException();
        }
        SectionRenderBox sectionBox = this.section.getSectionBox();
        sectionBox.addChild(box);
    }

    public Renderer.LayoutResult validatePages() throws ContentProcessingException {
        if (this.readOnly) {
            throw new IllegalStateException();
        }
        if (this.pageBox == null) {
            this.lastValidateResult = Renderer.LayoutResult.LAYOUT_UNVALIDATABLE;
            return Renderer.LayoutResult.LAYOUT_UNVALIDATABLE;
        }
        if (!this.dirty && this.lastValidateResult != null) {
            return this.lastValidateResult;
        }
        this.setLastStateKey(null);
        this.setPagebreaks(0);
        if (!this.validateModelStep.isLayoutable(this.pageBox)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Content-Ref# " + this.pageBox.getContentRefCount()));
            }
            this.lastValidateResult = Renderer.LayoutResult.LAYOUT_UNVALIDATABLE;
            return Renderer.LayoutResult.LAYOUT_UNVALIDATABLE;
        }
        this.staticPropertiesStep.compute(this.pageBox);
        this.paragraphLineBreakStep.compute(this.pageBox);
        this.minorAxisLayoutStep.compute(this.pageBox);
        this.majorAxisLayoutStep.compute(this.pageBox);
        this.canvasMajorAxisLayoutStep.compute(this.pageBox);
        this.revalidateAllAxisLayoutStep.compute(this.pageBox);
        this.applyCachedValuesStep.compute(this.pageBox);
        if (this.isPageFinished()) {
            this.lastValidateResult = Renderer.LayoutResult.LAYOUT_PAGEBREAK;
            return Renderer.LayoutResult.LAYOUT_PAGEBREAK;
        }
        this.lastValidateResult = Renderer.LayoutResult.LAYOUT_NO_PAGEBREAK;
        return Renderer.LayoutResult.LAYOUT_NO_PAGEBREAK;
    }

    protected void clearDirty() {
        this.dirty = false;
    }

    protected abstract boolean isPageFinished();

    public void processIncrementalUpdate(boolean performOutput) throws ContentProcessingException {
    }

    public boolean processPage(LayoutPagebreakHandler handler, Object commitMarker, boolean performOutput) throws ContentProcessingException {
        if (this.readOnly) {
            throw new IllegalStateException();
        }
        if (this.pageBox == null) {
            return false;
        }
        if (!this.dirty) {
            return false;
        }
        this.setLastStateKey(null);
        this.setPagebreaks(0);
        if (!this.validateModelStep.isLayoutable(this.pageBox)) {
            return false;
        }
        boolean repeat = true;
        while (repeat) {
            if (handler != null) {
                handler.pageFinished();
            }
            if (this.outputProcessor.getMetaData().isFeatureSupported(OutputProcessorFeature.PAGEBREAKS)) {
                this.createRollbackInformation();
                this.applyRollbackInformation();
                this.performParanoidModelCheck();
            }
            this.staticPropertiesStep.compute(this.pageBox);
            this.paragraphLineBreakStep.compute(this.pageBox);
            this.minorAxisLayoutStep.compute(this.pageBox);
            this.majorAxisLayoutStep.compute(this.pageBox);
            this.canvasMajorAxisLayoutStep.compute(this.pageBox);
            this.revalidateAllAxisLayoutStep.compute(this.pageBox);
            this.applyCachedValuesStep.compute(this.pageBox);
            repeat = this.performPagination(handler, performOutput);
        }
        this.clearDirty();
        return this.pagebreaks > 0;
    }

    protected abstract boolean performPagination(LayoutPagebreakHandler var1, boolean var2) throws ContentProcessingException;

    protected void debugPrint(LogicalPageBox pageBox) {
    }

    public ReportStateKey getLastStateKey() {
        return this.lastStateKey;
    }

    public void setLastStateKey(ReportStateKey lastStateKey) {
        this.lastStateKey = lastStateKey;
    }

    protected void setPagebreaks(int pagebreaks) {
        this.pagebreaks = pagebreaks;
    }

    public int getPagebreaks() {
        return this.pagebreaks;
    }

    public boolean isOpen() {
        if (this.pageBox == null) {
            return false;
        }
        return this.pageBox.isOpen();
    }

    public boolean isValid() {
        return !this.readOnly;
    }

    public Renderer deriveForStorage() {
        try {
            int i;
            AbstractRenderer renderer = (AbstractRenderer)this.clone();
            renderer.readOnly = false;
            renderer.sectionBoxes = new SectionRenderBox[5];
            if (this.pageBox != null) {
                renderer.pageBox = (LogicalPageBox)this.pageBox.derive(true);
                if (this.section != null) {
                    RenderNode nodeById = renderer.pageBox.findNodeById(this.section.getSectionBox().getInstanceId());
                    renderer.section = new Section(this.section.getType(), (SectionRenderBox)nodeById);
                }
            }
            int stackSize = this.groupStack.size();
            Object[] tempList = new Object[stackSize];
            renderer.groupStack = (FastStack)this.groupStack.clone();
            int tempListLength = tempList.length;
            for (i = 0; i < tempListLength; ++i) {
                tempList[i] = renderer.groupStack.pop();
            }
            for (i = tempListLength - 1; i >= 0; --i) {
                RenderBox addBoxClone;
                if (tempList[i] instanceof IgnoredContentIndicator) {
                    renderer.groupStack.push(tempList[i]);
                    continue;
                }
                GroupSection section = (GroupSection)tempList[i];
                RenderBox groupBox = section.getGroupBox();
                InstanceID groupBoxInstanceId = groupBox.getInstanceId();
                RenderBox groupBoxClone = (RenderBox)renderer.pageBox.findNodeById(groupBoxInstanceId);
                if (groupBoxClone == null) {
                    throw new IllegalStateException("The pagebox did no longer contain the stored node.");
                }
                if (groupBoxClone == groupBox) {
                    throw new IllegalStateException("Thought you wanted a groupBoxClone");
                }
                RenderBox addBox = section.getAddBox();
                if (addBox == groupBox) {
                    addBoxClone = groupBoxClone;
                } else {
                    InstanceID addBoxInstanceId = addBox.getInstanceId();
                    addBoxClone = (RenderBox)renderer.pageBox.findNodeById(addBoxInstanceId);
                    if (addBoxClone == null) {
                        throw new IllegalStateException("The pagebox did no longer contain the stored node.");
                    }
                    if (addBoxClone == addBox) {
                        throw new IllegalStateException("Thought you wanted a groupBoxClone");
                    }
                }
                renderer.groupStack.push((Object)new GroupSection(groupBoxClone, addBoxClone, section.getChildCount(), section.getNextBoxStart(), section.getStyleSheet()));
            }
            return renderer;
        }
        catch (CloneNotSupportedException cne) {
            throw new InvalidReportStateException("Failed to derive Renderer", cne);
        }
    }

    public Renderer deriveForPagebreak() {
        try {
            int i;
            AbstractRenderer renderer = (AbstractRenderer)this.clone();
            renderer.readOnly = true;
            if (this.pageBox != null && this.section != null) {
                renderer.section = new Section(this.section.getType(), this.section.getSectionBox());
            }
            int stackSize = this.groupStack.size();
            Object[] tempList = new Object[stackSize];
            renderer.groupStack = (FastStack)this.groupStack.clone();
            int tempListLength = tempList.length;
            for (i = 0; i < tempListLength; ++i) {
                tempList[i] = renderer.groupStack.pop();
            }
            for (i = tempListLength - 1; i >= 0; --i) {
                if (tempList[i] instanceof IgnoredContentIndicator) {
                    renderer.groupStack.push(tempList[i]);
                    continue;
                }
                GroupSection section = (GroupSection)tempList[i];
                RenderBox groupBox = section.getGroupBox();
                RenderBox addBox = section.getAddBox();
                renderer.groupStack.push((Object)new GroupSection(groupBox, addBox, section.getChildCount(), section.getNextBoxStart(), section.getStyleSheet()));
            }
            return renderer;
        }
        catch (CloneNotSupportedException cne) {
            throw new InvalidReportStateException("Failed to derive Renderer", cne);
        }
    }

    public void performParanoidModelCheck() {
        if (this.paranoidChecks) {
            int stackSize = this.groupStack.size();
            for (int i = 0; i < stackSize; ++i) {
                RenderBox addBox;
                Object o = this.groupStack.get(i);
                if (o instanceof IgnoredContentIndicator) continue;
                GroupSection section = (GroupSection)o;
                RenderBox groupBox = section.getGroupBox();
                RenderBox c = addBox = section.getAddBox();
                while (c != groupBox) {
                    if ((c = c.getParent()) != null) continue;
                    throw new IllegalStateException("Failed to locate parent");
                }
                for (c = addBox; c != null; c = c.getParent()) {
                    if (c.isOpen()) continue;
                    throw new IllegalStateException("Add-Box is not open: " + c.isMarkedOpen() + ' ' + c.isMarkedSeen() + ' ' + c);
                }
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void addPagebreak(ReportStateKey stateKey) {
        if (this.readOnly) {
            throw new IllegalStateException();
        }
        if (this.isIgnoreContent()) {
            return;
        }
        if (this.manualBreakBoxStyle == null) {
            ManualBreakIndicatorStyleSheet mbis = new ManualBreakIndicatorStyleSheet(BandDefaultStyleSheet.getBandDefaultStyle());
            this.manualBreakBoxStyle = new SimpleStyleSheet(mbis);
        }
        BreakMarkerRenderBox sectionBox = new BreakMarkerRenderBox(this.manualBreakBoxStyle, new InstanceID(), BoxDefinition.EMPTY, AutoLayoutBoxType.INSTANCE, ReportAttributeMap.EMPTY_MAP, stateKey);
        sectionBox.setName("pagebreak");
        ((RenderBox)sectionBox).close();
        this.addBox(sectionBox);
    }

    public boolean clearPendingPageStart(LayoutPagebreakHandler layoutPagebreakHandler) {
        return false;
    }

    public boolean isCurrentPageEmpty() {
        return false;
    }

    public boolean isPageStartPending() {
        return false;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void createRollbackInformation() {
        if (this.pageBox != null) {
            this.commitStep.compute(this.pageBox);
        }
    }

    public void applyRollbackInformation() {
        if (this.pageBox != null) {
            this.applyCommitStep.compute(this.pageBox);
        }
    }

    public void validateAfterCommit() {
        if (this.paranoidChecks) {
            int stackSize = this.groupStack.size();
            for (int i = 0; i < stackSize; ++i) {
                Object o = this.groupStack.get(i);
                if (o instanceof IgnoredContentIndicator) continue;
                GroupSection section = (GroupSection)o;
                RenderBox groupBox = section.getGroupBox();
                RenderBox addBox = section.getAddBox();
                if (addBox.getParent() == null) {
                    throw new IllegalStateException("No longer there");
                }
                if (!groupBox.isMarkedSeen()) {
                    throw new IllegalStateException("No seen-marker at " + groupBox);
                }
                if (!addBox.isMarkedSeen()) {
                    throw new IllegalStateException("No seen-marker at add-box " + addBox);
                }
                if (addBox.isMarkedOpen()) continue;
                throw new IllegalStateException("No open-marker at " + addBox);
            }
        }
    }

    public void rollback() {
        this.readOnly = false;
        if (this.pageBox != null) {
            this.rollbackStep.compute(this.pageBox);
            this.validateAfterCommit();
        }
    }

    public void applyAutoCommit() {
        if (this.pageBox != null) {
            this.applyAutoCommitStep.compute(this.pageBox);
        }
    }

    public LayoutBuilder createBufferedLayoutBuilder() {
        return this.normalFlowLayoutBuilder.createBufferedLayoutBuilder();
    }

    public boolean isPendingPageHack() {
        return false;
    }

    protected void markDirty() {
        this.dirty = true;
        this.lastValidateResult = null;
    }

    public void print() {
    }

    public void newPageStarted() {
        this.pageBox.getFooterArea().clear();
        this.pageBox.getRepeatFooterArea().clear();
        this.pageBox.getHeaderArea().clear();
        this.pageBox.getWatermarkArea().clear();
    }

    private static class IgnoredContentIndicator {
        private IgnoredContentIndicator() {
        }
    }

    private static class GroupSection {
        private static final double COMMON_GROWTH = 0.5;
        private static final int INITIAL_COMMON_SIZE = 50;
        private static final int MAXIMUM_COMMON_SIZE = 5000;
        private RenderBox addBox;
        private RenderBox groupBox;
        private int childCount;
        private int nextBoxStart;
        private StyleSheet styleSheet;

        protected GroupSection(RenderBox groupBox, StyleSheet styleSheet) {
            if (groupBox == null) {
                throw new NullPointerException();
            }
            this.styleSheet = styleSheet;
            this.groupBox = groupBox;
            this.childCount = 0;
            this.nextBoxStart = 50;
            this.addBox = groupBox;
        }

        protected GroupSection(RenderBox groupBox, RenderBox addBox, int childCount, int nextBoxStart, StyleSheet styleSheet) {
            if (groupBox == null) {
                throw new NullPointerException();
            }
            this.groupBox = groupBox;
            this.addBox = addBox;
            this.childCount = childCount;
            this.nextBoxStart = nextBoxStart;
            this.styleSheet = styleSheet;
        }

        public RenderBox getAddBox() {
            return this.addBox;
        }

        public RenderBox getGroupBox() {
            return this.groupBox;
        }

        public boolean mergeSection(ReportStateKey stateKey) {
            RenderNode lastSection = this.addBox.getLastChild();
            if (lastSection == null) {
                return false;
            }
            if ((lastSection.getNodeType() & 2) != 2) {
                return false;
            }
            RenderBox lastSectionBox = (RenderBox)lastSection;
            RenderNode maybeMarker = lastSectionBox.getLastChild();
            if (maybeMarker == null) {
                return false;
            }
            int nodeType = maybeMarker.getNodeType();
            if (nodeType == 16777282) {
                InlineProgressMarkerRenderBox markerRenderBox = (InlineProgressMarkerRenderBox)maybeMarker;
                markerRenderBox.setStateKey(stateKey);
                return true;
            }
            if (nodeType == 0x1000012) {
                ProgressMarkerRenderBox markerRenderBox = (ProgressMarkerRenderBox)maybeMarker;
                markerRenderBox.setStateKey(stateKey);
                return true;
            }
            return false;
        }

        public void addedSection(RenderNode node) {
            ++this.childCount;
            if (this.childCount == this.nextBoxStart) {
                if (this.addBox != this.groupBox) {
                    this.addBox.close();
                }
                BlockRenderBox commonBox = new BlockRenderBox(this.styleSheet, new InstanceID(), BoxDefinition.EMPTY, AutoLayoutBoxType.INSTANCE, ReportAttributeMap.EMPTY_MAP, null);
                commonBox.setName("Common-Section");
                this.groupBox.addChild(commonBox);
                this.addBox = commonBox;
                this.nextBoxStart += (int)Math.min(5000.0, (double)this.nextBoxStart * 0.5);
            }
            this.addBox.addChild(node);
        }

        public void close() {
            if (this.addBox != this.groupBox) {
                this.addBox.close();
            }
            this.groupBox.close();
        }

        public int getChildCount() {
            return this.childCount;
        }

        public int getNextBoxStart() {
            return this.nextBoxStart;
        }

        public StyleSheet getStyleSheet() {
            return this.styleSheet;
        }
    }

    private static class Section {
        private int type;
        private SectionRenderBox sectionBox;

        protected Section(int type, SectionRenderBox sectionBox) {
            this.type = type;
            this.sectionBox = sectionBox;
        }

        public int getType() {
            return this.type;
        }

        public SectionRenderBox getSectionBox() {
            return this.sectionBox;
        }
    }
}

