/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout;

import java.awt.Shape;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.Anchor;
import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.ImageContainer;
import org.pentaho.reporting.engine.classic.core.ReportAttributeMap;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.RootLevelBand;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.filter.RawDataSource;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.function.ProcessingContext;
import org.pentaho.reporting.engine.classic.core.layout.BufferedLayoutBuilder;
import org.pentaho.reporting.engine.classic.core.layout.InlineSubreportMarker;
import org.pentaho.reporting.engine.classic.core.layout.LayoutBuilder;
import org.pentaho.reporting.engine.classic.core.layout.StyleCache;
import org.pentaho.reporting.engine.classic.core.layout.TextCache;
import org.pentaho.reporting.engine.classic.core.layout.model.BlockRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.CanvasRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.ContentPlaceholderRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.InlineRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.ParagraphRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.ProgressMarkerRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderLength;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableReplacedContent;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableReplacedContentBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RowRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.context.BoxDefinition;
import org.pentaho.reporting.engine.classic.core.layout.model.context.BoxDefinitionFactory;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorFeature;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.richtext.RichTextConverter;
import org.pentaho.reporting.engine.classic.core.layout.richtext.RichTextConverterRegistry;
import org.pentaho.reporting.engine.classic.core.layout.richtext.RichTextConverterUtilities;
import org.pentaho.reporting.engine.classic.core.layout.style.AnchorStyleSheet;
import org.pentaho.reporting.engine.classic.core.layout.style.CanvasMinWidthStyleSheet;
import org.pentaho.reporting.engine.classic.core.layout.style.DynamicHeightWrapperStyleSheet;
import org.pentaho.reporting.engine.classic.core.layout.style.NonDynamicHeightWrapperStyleSheet;
import org.pentaho.reporting.engine.classic.core.layout.style.ParagraphPoolboxStyleSheet;
import org.pentaho.reporting.engine.classic.core.layout.style.SimpleStyleSheet;
import org.pentaho.reporting.engine.classic.core.layout.text.DefaultRenderableTextFactory;
import org.pentaho.reporting.engine.classic.core.metadata.ElementType;
import org.pentaho.reporting.engine.classic.core.states.ReportStateKey;
import org.pentaho.reporting.engine.classic.core.states.process.SubReportProcessType;
import org.pentaho.reporting.engine.classic.core.style.BandStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.BorderStyle;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.style.TextStyleKeys;
import org.pentaho.reporting.engine.classic.core.util.ReportDrawable;
import org.pentaho.reporting.engine.classic.core.util.ShapeDrawable;
import org.pentaho.reporting.libraries.fonts.encoding.CodePointBuffer;
import org.pentaho.reporting.libraries.fonts.encoding.manual.Utf16LE;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.factory.drawable.DrawableWrapper;

public class DefaultLayoutBuilder
implements Cloneable,
BufferedLayoutBuilder {
    private static final InlineSubreportMarker[] EMPTY_ARRAY = new InlineSubreportMarker[0];
    private static final Log logger = LogFactory.getLog(DefaultLayoutBuilder.class);
    private static final String STRING_CLASSNAME = "java.lang.String";
    private OutputProcessorMetaData metaData;
    private CodePointBuffer buffer;
    private DefaultRenderableTextFactory textFactory;
    private TextCache textCache;
    private StyleCache bandCache;
    private StyleCache styleCache;
    private StyleCache textStyleCache;
    private BoxDefinitionFactory boxDefinitionFactory;
    private boolean limitedSubReports;
    private ArrayList<InlineSubreportMarker> collectedReports = new ArrayList();
    private int[] bufferArray;
    private StyleKey[] definedStyleKeys;
    private boolean collapseProgressMarker;

    public DefaultLayoutBuilder(OutputProcessorMetaData metaData) {
        this.metaData = metaData;
        this.textFactory = new DefaultRenderableTextFactory(metaData);
        this.textCache = new TextCache(500);
        this.bufferArray = new int[500];
        this.definedStyleKeys = StyleKey.getDefinedStyleKeys();
        boolean paddingsDisabled = metaData.isFeatureSupported(OutputProcessorFeature.DISABLE_PADDING);
        this.bandCache = new StyleCache(paddingsDisabled);
        this.styleCache = new StyleCache(paddingsDisabled);
        this.textStyleCache = new StyleCache(paddingsDisabled);
        this.boxDefinitionFactory = new BoxDefinitionFactory();
        this.collapseProgressMarker = true;
    }

    protected StyleCache getTextStyleCache() {
        return this.textStyleCache;
    }

    protected StyleCache getStyleCache() {
        return this.styleCache;
    }

    protected OutputProcessorMetaData getMetaData() {
        return this.metaData;
    }

    protected BoxDefinitionFactory getBoxDefinitionFactory() {
        return this.boxDefinitionFactory;
    }

    public InlineSubreportMarker[] endSection(RenderBox pageArea, RenderBox sectionBox) {
        if (this.collectedReports.isEmpty()) {
            return EMPTY_ARRAY;
        }
        return this.collectedReports.toArray(new InlineSubreportMarker[this.collectedReports.size()]);
    }

    public void startSection(RenderBox pageArea, boolean limitedSubReports) {
        this.limitedSubReports = limitedSubReports;
        this.collectedReports.clear();
    }

    private String getStyleFromLayoutManager(Band band) {
        return "canvas";
    }

    public void addEmptyRootLevelBand(RenderBox parent, ReportStateKey stateKey) throws ReportProcessingException {
        RenderNode child = parent.getLastChild();
        if (this.isCollapseProgressMarker() && child != null && child.getNodeType() == 0x1000012) {
            ProgressMarkerRenderBox markerRenderBox = (ProgressMarkerRenderBox)child;
            markerRenderBox.setStateKey(stateKey);
        } else {
            ProgressMarkerRenderBox markerBox = new ProgressMarkerRenderBox();
            markerBox.setStateKey(stateKey);
            parent.addChild(markerBox);
            markerBox.close();
        }
    }

    public void setCollapseProgressMarker(boolean collapseProgressMarker) {
        this.collapseProgressMarker = collapseProgressMarker;
    }

    public boolean isCollapseProgressMarker() {
        return this.collapseProgressMarker;
    }

    public void add(RenderBox parent, Band band, ExpressionRuntime runtime, ReportStateKey stateKey) throws ReportProcessingException {
        boolean invConsSpace;
        if (this.isEmpty(band) && !(invConsSpace = parent.getStyleSheet().getBooleanStyleProperty(ElementStyleKeys.INVISIBLE_CONSUMES_SPACE, parent.getNodeType() == 130))) {
            if (this.isControlBand(band)) {
                int parentNodeType = parent.getNodeType();
                boolean parentIsInlineContainer = (parentNodeType & 0x42) == 66 || parentNodeType == 274;
                RenderBox box = this.produceBox(band, stateKey, parentIsInlineContainer);
                parent.addChild(box);
                box.getStaticBoxLayoutProperties().setPlaceholderBox(true);
                box.close();
            } else if (band instanceof RootLevelBand) {
                this.addEmptyRootLevelBand(parent, stateKey);
            } else {
                this.ensureEmptyChildIsAdded(parent, band, stateKey);
            }
            return;
        }
        int parentNodeType = parent.getNodeType();
        boolean parentIsInlineContainer = (parentNodeType & 0x42) == 66 || parentNodeType == 274;
        RenderBox box = this.produceBox(band, stateKey, parentIsInlineContainer);
        ParagraphRenderBox paragraphBox = null;
        if ((box.getNodeType() & 0x42) == 66 && !parentIsInlineContainer) {
            ElementStyleSheet bandStyle = band.getStyle();
            SimpleStyleSheet styleSheet = this.bandCache.getStyleSheet(bandStyle);
            BoxDefinition boxDefinition = this.boxDefinitionFactory.getBoxDefinition(styleSheet);
            paragraphBox = new ParagraphRenderBox(styleSheet, band.getObjectID(), boxDefinition, box.getElementType(), box.getAttributes(), stateKey);
            paragraphBox.setName(band.getName());
            paragraphBox.getBoxDefinition().setPreferredWidth(RenderLength.AUTO);
            paragraphBox.addChild(box);
            parent.addChild(paragraphBox);
        } else {
            parent.addChild(box);
        }
        boolean invConsSpace2 = box.getStyleSheet().getBooleanStyleProperty(ElementStyleKeys.INVISIBLE_CONSUMES_SPACE, box.getNodeType() == 130);
        Element[] elementBuffer = band.unsafeGetElementArray();
        int elementCount = band.getElementCount();
        for (int i = 0; i < elementCount; ++i) {
            Element element = elementBuffer[i];
            if (!element.isVisible() && !invConsSpace2) continue;
            if (element instanceof Band) {
                Band childBand = (Band)element;
                this.add(box, childBand, runtime, stateKey);
                continue;
            }
            if (element instanceof SubReport) {
                this.performAddInlineSubReport(runtime, stateKey, box, (SubReport)element);
                continue;
            }
            Object value = this.computeValue(runtime, element);
            if (value instanceof Element) {
                Band b = RichTextConverterUtilities.convertToBand(this.definedStyleKeys, element, (Element)value);
                this.add(box, b, runtime, stateKey);
                continue;
            }
            this.performRenderValue(runtime, stateKey, box, element, value);
        }
        box.close();
        if (paragraphBox != null) {
            paragraphBox.close();
        }
    }

    private void ensureEmptyChildIsAdded(RenderBox parent, Element element, ReportStateKey stateKey) {
        SimpleStyleSheet styleSheet = this.bandCache.getStyleSheet(element.getStyle());
        BoxDefinition boxDefinition = this.boxDefinitionFactory.getBoxDefinition(styleSheet);
        int parentNodeType = parent.getNodeType();
        boolean parentIsInlineContainer = (parentNodeType & 0x42) == 66 || parentNodeType == 274;
        RenderBox box = parentIsInlineContainer ? new InlineRenderBox(styleSheet, element.getObjectID(), boxDefinition, element.getElementType(), element.getAttributes(), stateKey) : new BlockRenderBox(styleSheet, element.getObjectID(), boxDefinition, element.getElementType(), element.getAttributes(), stateKey);
        box.getStaticBoxLayoutProperties().setPlaceholderBox(true);
        String name = element.getName();
        if (name != null && name.length() != 0 && !name.startsWith("anonymousBand@")) {
            box.setName(name);
        }
        box.close();
        parent.addChild(box);
    }

    protected void performRenderValue(ExpressionRuntime runtime, ReportStateKey stateKey, RenderBox parentRenderBox, Element element, Object initialValue) throws ReportProcessingException {
        Object value;
        if (initialValue == null || !this.metaData.isContentSupported(initialValue)) {
            if ((parentRenderBox.getNodeType() & 0x82) == 130 || this.metaData.isExtraContentElement(element.getStyle(), element.getAttributes())) {
                this.ensureEmptyChildIsAdded(parentRenderBox, element, stateKey);
            }
            return;
        }
        Object richTextType = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "rich-text-type");
        if (richTextType != null) {
            RichTextConverterRegistry registry = RichTextConverterRegistry.getRegistry();
            RichTextConverter converter = registry.getConverter(String.valueOf(richTextType));
            if (converter != null) {
                Object b = converter.convert(element, initialValue);
                if (b instanceof Band) {
                    this.add(parentRenderBox, (Band)b, runtime, stateKey);
                    return;
                }
                value = b;
            } else {
                value = initialValue;
            }
        } else {
            value = initialValue;
        }
        if (value instanceof ReportDrawable) {
            ReportDrawable reportDrawable = (ReportDrawable)value;
            ProcessingContext processingContext = runtime.getProcessingContext();
            reportDrawable.setConfiguration(processingContext.getConfiguration());
            reportDrawable.setResourceBundleFactory(processingContext.getResourceBundleFactory());
            this.processReportDrawableContent(reportDrawable, parentRenderBox, element, stateKey);
        } else if (value instanceof Anchor) {
            logger.warn((Object)"The use of anchor-objects is deprecated and will be removed from future reports. Update your report definition.");
            this.processAnchor((Anchor)value, parentRenderBox, element, stateKey);
        } else {
            Object rawValue;
            ElementType dataSource = element.getElementType();
            if (dataSource instanceof RawDataSource) {
                RawDataSource rds = (RawDataSource)((Object)dataSource);
                rawValue = rds.getRawValue(runtime, element);
            } else {
                rawValue = null;
            }
            if (STRING_CLASSNAME.equals(value.getClass().getName())) {
                this.processText(value, rawValue, parentRenderBox, element, stateKey);
            } else if (value instanceof Shape) {
                Shape shape = (Shape)value;
                ShapeDrawable reportDrawable = new ShapeDrawable(shape, element.getStyle().getBooleanStyleProperty(ElementStyleKeys.KEEP_ASPECT_RATIO));
                ProcessingContext processingContext = runtime.getProcessingContext();
                reportDrawable.setConfiguration(processingContext.getConfiguration());
                reportDrawable.setResourceBundleFactory(processingContext.getResourceBundleFactory());
                this.processReportDrawableContent(reportDrawable, parentRenderBox, element, stateKey);
            } else if (value instanceof ImageContainer || value instanceof DrawableWrapper) {
                this.processReplacedContent(value, rawValue, parentRenderBox, element, stateKey);
            } else if (DrawableWrapper.isDrawable((Object)value)) {
                this.processReplacedContent(new DrawableWrapper(value), rawValue, parentRenderBox, element, stateKey);
            } else {
                this.processText(value, rawValue, parentRenderBox, element, stateKey);
            }
        }
    }

    protected void performAddInlineSubReport(ExpressionRuntime runtime, ReportStateKey stateKey, RenderBox box, SubReport element) throws ReportProcessingException {
        boolean parentIsInlineContainer;
        if (this.limitedSubReports) {
            logger.debug((Object)"Not adding subreport: Subreports in header or footer area are not allowed.");
            return;
        }
        int parentNodeType = box.getNodeType();
        boolean bl = parentIsInlineContainer = (parentNodeType & 0x42) == 66 || parentNodeType == 274;
        if (parentIsInlineContainer) {
            logger.warn((Object)"Not adding subreport: Subreports in inline-contexts are not supported.");
            return;
        }
        RenderBox subreportbox = this.produceSubreportBox(element, stateKey);
        box.addChild(subreportbox);
        this.collectedReports.add(new InlineSubreportMarker(element, subreportbox.getInstanceId(), SubReportProcessType.INLINE));
    }

    public boolean isLimitedSubReports() {
        return this.limitedSubReports;
    }

    protected Object computeValue(ExpressionRuntime runtime, Element element) {
        return element.getElementType().getValue(runtime, element);
    }

    protected boolean isControlBand(Band band) {
        ElementStyleSheet style = band.getStyle();
        if (style.getStyleProperty(BandStyleKeys.COMPUTED_SHEETNAME) != null) {
            return true;
        }
        if (style.getStyleProperty(BandStyleKeys.BOOKMARK) != null) {
            return true;
        }
        if (!"inline".equals(style.getStyleProperty(BandStyleKeys.LAYOUT))) {
            if (Boolean.TRUE.equals(style.getStyleProperty(BandStyleKeys.PAGEBREAK_AFTER))) {
                return true;
            }
            if (Boolean.TRUE.equals(style.getStyleProperty(BandStyleKeys.PAGEBREAK_BEFORE))) {
                return true;
            }
        }
        return false;
    }

    protected boolean isEmpty(Band band) {
        if (!band.isVisible()) {
            return true;
        }
        if (band.getElementCount() > 0) {
            return false;
        }
        return this.isEmptyElement(band);
    }

    protected final boolean isLengthDefined(StyleKey key, ElementStyleSheet styleSheet) {
        if (key.isInheritable() && !styleSheet.isLocalKey(key)) {
            return false;
        }
        Object o = styleSheet.getStyleProperty(key, null);
        if (o == null) {
            return false;
        }
        if (!(o instanceof Number)) {
            return false;
        }
        Number n = (Number)o;
        return n.doubleValue() != 0.0;
    }

    protected boolean isEmptyElement(Element band) {
        ElementStyleSheet style = band.getStyle();
        if (this.isLengthDefined(ElementStyleKeys.HEIGHT, style)) {
            return false;
        }
        if (this.isLengthDefined(ElementStyleKeys.WIDTH, style)) {
            return false;
        }
        if (this.isLengthDefined(ElementStyleKeys.POS_Y, style)) {
            return false;
        }
        if (this.isLengthDefined(ElementStyleKeys.POS_X, style)) {
            return false;
        }
        if (this.isLengthDefined(ElementStyleKeys.MIN_HEIGHT, style)) {
            return false;
        }
        if (this.isLengthDefined(ElementStyleKeys.MIN_WIDTH, style)) {
            return false;
        }
        if (this.isLengthDefined(ElementStyleKeys.PADDING_TOP, style)) {
            return false;
        }
        if (this.isLengthDefined(ElementStyleKeys.PADDING_LEFT, style)) {
            return false;
        }
        if (this.isLengthDefined(ElementStyleKeys.PADDING_BOTTOM, style)) {
            return false;
        }
        if (this.isLengthDefined(ElementStyleKeys.PADDING_RIGHT, style)) {
            return false;
        }
        if (!BorderStyle.NONE.equals(style.getStyleProperty(ElementStyleKeys.BORDER_BOTTOM_STYLE, BorderStyle.NONE))) {
            return false;
        }
        if (!BorderStyle.NONE.equals(style.getStyleProperty(ElementStyleKeys.BORDER_TOP_STYLE, BorderStyle.NONE))) {
            return false;
        }
        if (!BorderStyle.NONE.equals(style.getStyleProperty(ElementStyleKeys.BORDER_LEFT_STYLE, BorderStyle.NONE))) {
            return false;
        }
        if (!BorderStyle.NONE.equals(style.getStyleProperty(ElementStyleKeys.BORDER_RIGHT_STYLE, BorderStyle.NONE))) {
            return false;
        }
        if (style.getStyleProperty(ElementStyleKeys.BACKGROUND_COLOR) != null) {
            return false;
        }
        return !this.metaData.isExtraContentElement(band.getStyle(), band.getAttributes());
    }

    protected void processText(Object value, Object rawValue, RenderBox parentBox, Element element, ReportStateKey stateKey) {
        String text = element.getStyle().getBooleanStyleProperty(TextStyleKeys.TRIM_TEXT_CONTENT) ? String.valueOf(value).trim() : String.valueOf(value);
        ElementStyleSheet style = element.getStyle();
        ReportAttributeMap attrs = element.getAttributes();
        TextCache.Result result = this.textCache.get(style.getId(), style.getChangeTracker(), attrs.getChangeTracker(), text);
        if (result != null) {
            this.addTextNodes(element, rawValue, result.getText(), result.getFinish(), parentBox, result.getStyleSheet(), stateKey);
            return;
        }
        int nodeType = parentBox.getNodeType();
        SimpleStyleSheet elementStyle = (nodeType & 0x22) == 34 ? (!element.isDynamicContent() ? this.textStyleCache.getStyleSheet(new NonDynamicHeightWrapperStyleSheet(style)) : this.styleCache.getStyleSheet(new DynamicHeightWrapperStyleSheet(style))) : this.styleCache.getStyleSheet(style);
        if (this.buffer != null) {
            this.buffer.setCursor(0);
        }
        this.buffer = Utf16LE.getInstance().decodeString(text, this.buffer);
        this.bufferArray = this.buffer.getBuffer(this.bufferArray);
        if (!((nodeType & 0x42) == 66)) {
            this.textFactory.startText();
        }
        RenderNode[] renderNodes = this.textFactory.createText(this.bufferArray, 0, this.buffer.getLength(), elementStyle, element.getElementType(), element.getObjectID(), attrs);
        RenderNode[] finishNodes = this.textFactory.finishText();
        this.addTextNodes(element, rawValue, renderNodes, finishNodes, parentBox, elementStyle, stateKey);
        this.textCache.store(style.getId(), style.getChangeTracker(), attrs.getChangeTracker(), text, elementStyle, attrs, renderNodes, finishNodes);
    }

    protected void processReportDrawableContent(ReportDrawable reportDrawable, RenderBox box, Element element, ReportStateKey stateKey) {
        SimpleStyleSheet elementStyle = !((box.getNodeType() & 0x42) == 66) ? (!element.isDynamicContent() ? this.textStyleCache.getStyleSheet(new NonDynamicHeightWrapperStyleSheet(element.getStyle())) : this.styleCache.getStyleSheet(new DynamicHeightWrapperStyleSheet(element.getStyle()))) : this.styleCache.getStyleSheet(element.getStyle());
        reportDrawable.setStyleSheet(elementStyle);
        DrawableWrapper wrapper = reportDrawable instanceof DrawableWrapper ? (DrawableWrapper)reportDrawable : new DrawableWrapper((Object)reportDrawable);
        RenderableReplacedContent content = new RenderableReplacedContent(elementStyle, wrapper, null, this.metaData);
        BoxDefinition boxDefinition = this.boxDefinitionFactory.getBoxDefinition(elementStyle);
        RenderableReplacedContentBox child = new RenderableReplacedContentBox(elementStyle, element.getObjectID(), boxDefinition, element.getElementType(), element.getAttributes(), stateKey, content);
        child.setName(element.getName());
        box.addChild(child);
    }

    protected void processAnchor(Anchor anchor, RenderBox box, Element element, ReportStateKey stateKey) {
        String anchorName = anchor.getName();
        if ((box.getNodeType() & 0x42) == 66) {
            SimpleStyleSheet styleSheet = this.bandCache.getStyleSheet(new NonDynamicHeightWrapperStyleSheet(new AnchorStyleSheet(anchorName, element.getStyle())));
            BoxDefinition boxDefinition = this.boxDefinitionFactory.getBoxDefinition(styleSheet);
            InlineRenderBox autoParagraphBox = new InlineRenderBox(styleSheet, element.getObjectID(), boxDefinition, element.getElementType(), element.getAttributes(), stateKey);
            autoParagraphBox.setName(element.getName());
            autoParagraphBox.getBoxDefinition().setPreferredWidth(RenderLength.AUTO);
            autoParagraphBox.close();
            box.addChild(autoParagraphBox);
        } else {
            SimpleStyleSheet styleSheet = this.bandCache.getStyleSheet(new NonDynamicHeightWrapperStyleSheet(new AnchorStyleSheet(anchorName, element.getStyle())));
            BoxDefinition boxDefinition = this.boxDefinitionFactory.getBoxDefinition(styleSheet);
            CanvasRenderBox autoParagraphBox = new CanvasRenderBox(styleSheet, element.getObjectID(), boxDefinition, element.getElementType(), element.getAttributes(), stateKey);
            autoParagraphBox.setName(element.getName());
            autoParagraphBox.getBoxDefinition().setPreferredWidth(RenderLength.AUTO);
            autoParagraphBox.close();
            box.addChild(autoParagraphBox);
        }
    }

    protected void processReplacedContent(Object value, Object rawValue, RenderBox box, Element element, ReportStateKey stateKey) {
        SimpleStyleSheet elementStyle = !((box.getNodeType() & 0x42) == 66) ? (!element.isDynamicContent() ? this.textStyleCache.getStyleSheet(new NonDynamicHeightWrapperStyleSheet(element.getStyle())) : this.styleCache.getStyleSheet(new DynamicHeightWrapperStyleSheet(element.getStyle()))) : this.styleCache.getStyleSheet(element.getStyle());
        ResourceKey rawKey = rawValue instanceof ResourceKey ? (ResourceKey)rawValue : null;
        RenderableReplacedContent content = new RenderableReplacedContent(elementStyle, value, rawKey, this.metaData);
        BoxDefinition boxDefinition = this.boxDefinitionFactory.getBoxDefinition(elementStyle);
        RenderableReplacedContentBox child = new RenderableReplacedContentBox(elementStyle, element.getObjectID(), boxDefinition, element.getElementType(), element.getAttributes(), stateKey, content);
        child.setName(element.getName());
        box.addChild(child);
    }

    protected void addTextNodes(Element element, Object rawValue, RenderNode[] renderNodes, RenderNode[] finishNodes, RenderBox parentBox, StyleSheet elementStyle, ReportStateKey stateKey) {
        if ((parentBox.getNodeType() & 0x42) == 66) {
            SimpleStyleSheet styleSheet = this.bandCache.getStyleSheet(elementStyle);
            BoxDefinition boxDefinition = this.boxDefinitionFactory.getBoxDefinition(styleSheet);
            InlineRenderBox autoParagraphBox = new InlineRenderBox(styleSheet, element.getObjectID(), boxDefinition, element.getElementType(), element.getAttributes(), stateKey);
            autoParagraphBox.setName(element.getName());
            autoParagraphBox.getBoxDefinition().setPreferredWidth(RenderLength.AUTO);
            autoParagraphBox.addChilds(renderNodes);
            autoParagraphBox.addChilds(finishNodes);
            autoParagraphBox.close();
            parentBox.addChild(autoParagraphBox);
        } else {
            SimpleStyleSheet styleSheet = this.bandCache.getStyleSheet(elementStyle);
            BoxDefinition boxDefinition = this.boxDefinitionFactory.getBoxDefinition(styleSheet);
            ParagraphRenderBox autoParagraphBox = new ParagraphRenderBox(styleSheet, element.getObjectID(), boxDefinition, element.getElementType(), element.getAttributes(), stateKey);
            autoParagraphBox.setRawValue(rawValue);
            autoParagraphBox.setName(element.getName());
            autoParagraphBox.getBoxDefinition().setPreferredWidth(RenderLength.AUTO);
            autoParagraphBox.addChilds(renderNodes);
            autoParagraphBox.addChilds(finishNodes);
            autoParagraphBox.close();
            parentBox.addChild(autoParagraphBox);
        }
    }

    protected RenderBox produceBox(Band band, ReportStateKey stateKey, boolean parentIsInlineBox) {
        RenderBox box;
        SimpleStyleSheet styleSheet;
        ElementStyleSheet elementStyleSheet = band.getStyle();
        Object layoutType = elementStyleSheet.getStyleProperty(BandStyleKeys.LAYOUT, null);
        if (layoutType == null) {
            layoutType = this.getStyleFromLayoutManager(band);
        }
        if (parentIsInlineBox) {
            layoutType = "inline";
        }
        if ("block".equals(layoutType)) {
            styleSheet = this.bandCache.getStyleSheet(elementStyleSheet);
            BoxDefinition boxDefinition = this.boxDefinitionFactory.getBoxDefinition(styleSheet);
            box = new BlockRenderBox(styleSheet, band.getObjectID(), boxDefinition, band.getElementType(), band.getAttributes(), stateKey);
        } else if ("inline".equals(layoutType)) {
            if (parentIsInlineBox) {
                styleSheet = this.bandCache.getStyleSheet(elementStyleSheet);
                BoxDefinition boxDefinition = this.boxDefinitionFactory.getBoxDefinition(styleSheet);
                box = new InlineRenderBox(styleSheet, band.getObjectID(), boxDefinition, band.getElementType(), band.getAttributes(), stateKey);
            } else {
                styleSheet = this.bandCache.getStyleSheet(new ParagraphPoolboxStyleSheet(elementStyleSheet));
                BoxDefinition boxDefinition = this.boxDefinitionFactory.getBoxDefinition(styleSheet);
                box = new InlineRenderBox(styleSheet, band.getObjectID(), boxDefinition, band.getElementType(), band.getAttributes(), stateKey);
            }
        } else if ("row".equals(layoutType)) {
            styleSheet = this.bandCache.getStyleSheet(elementStyleSheet);
            BoxDefinition boxDefinition = this.boxDefinitionFactory.getBoxDefinition(styleSheet);
            box = new RowRenderBox(styleSheet, band.getObjectID(), boxDefinition, band.getElementType(), band.getAttributes(), stateKey);
        } else {
            styleSheet = elementStyleSheet.getBooleanStyleProperty(ElementStyleKeys.USE_MIN_CHUNKWIDTH) ? this.bandCache.getStyleSheet(elementStyleSheet) : this.bandCache.getStyleSheet(new CanvasMinWidthStyleSheet(elementStyleSheet));
            BoxDefinition boxDefinition = this.boxDefinitionFactory.getBoxDefinition(styleSheet);
            box = new CanvasRenderBox(styleSheet, band.getObjectID(), boxDefinition, band.getElementType(), band.getAttributes(), stateKey);
        }
        String name = band.getName();
        if (name != null && name.length() != 0 && !name.startsWith("anonymousBand@")) {
            box.setName(name);
        }
        return box;
    }

    private RenderBox produceSubreportBox(SubReport report, ReportStateKey stateKey) {
        ElementStyleSheet elementStyleSheet = report.getStyle();
        SimpleStyleSheet styleSheet = this.bandCache.getStyleSheet(elementStyleSheet);
        BoxDefinition boxDefinition = this.boxDefinitionFactory.getBoxDefinition(styleSheet);
        ContentPlaceholderRenderBox box = new ContentPlaceholderRenderBox(styleSheet, report.getObjectID(), boxDefinition, report.getElementType(), report.getAttributes(), stateKey, report.getObjectID());
        box.getStaticBoxLayoutProperties().setPlaceholderBox(true);
        String name = report.getName();
        if (name != null && !name.startsWith("anonymousBand@")) {
            box.setName(name);
        }
        return box;
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultLayoutBuilder o = (DefaultLayoutBuilder)super.clone();
        o.collectedReports = (ArrayList)this.collectedReports.clone();
        o.collectedReports.clear();
        return o;
    }

    public LayoutBuilder createBufferedLayoutBuilder() {
        try {
            return (LayoutBuilder)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Clone must be supported, or I am confused");
        }
    }

    public void dispose() {
    }
}

