/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.layout.SizeCalculator;
import org.pentaho.reporting.engine.classic.core.style.FontDefinition;
import org.pentaho.reporting.libraries.base.config.ExtendedConfiguration;

public strictfp class DefaultSizeCalculator
implements SizeCalculator {
    private static final Log logger = LogFactory.getLog(DefaultSizeCalculator.class);
    private static final boolean VERBOSE_LOGGING = false;
    private static BuggyFontRendererDetector frcDetector;
    private float lineHeight;
    private Font font;
    private char[] chars;

    public static BuggyFontRendererDetector getFrcDetector() {
        if (frcDetector == null) {
            frcDetector = new BuggyFontRendererDetector();
        }
        return frcDetector;
    }

    public static synchronized DefaultSizeCalculator getDefaultSizeCalculator(FontDefinition font, boolean maxLineHeightUsed) {
        return new DefaultSizeCalculator(font.getFont(), maxLineHeightUsed);
    }

    public DefaultSizeCalculator(FontDefinition font, boolean maxLineHeightUsed) {
        this(font.getFont(), maxLineHeightUsed);
    }

    public DefaultSizeCalculator(Font font, boolean maxLineHeightUsed) {
        if (font == null) {
            throw new NullPointerException("Given FontDefinition is null");
        }
        if (font.getSize2D() <= 0.0f) {
            throw new IllegalArgumentException("The given FontSize is <= 0");
        }
        if (maxLineHeightUsed) {
            Rectangle2D rect = font.getMaxCharBounds(DefaultSizeCalculator.getFrcDetector().createFontRenderContext());
            this.lineHeight = (float)rect.getHeight();
        } else {
            this.lineHeight = font.getSize2D();
        }
        this.font = font;
        this.chars = new char[100];
    }

    public float getLineHeight() {
        return this.lineHeight;
    }

    public float getStringWidth(String text, int lineStartPos, int endPos) {
        if (lineStartPos < 0) {
            throw new IllegalArgumentException();
        }
        if (lineStartPos > endPos) {
            throw new IllegalArgumentException("LineStart on: " + lineStartPos + " End on " + endPos);
        }
        if (lineStartPos == endPos) {
            return 0.0f;
        }
        FontRenderContext frc = DefaultSizeCalculator.getFrcDetector().createFontRenderContext();
        if (this.chars.length < text.length()) {
            this.chars = new char[Math.max(this.chars.length + 100, text.length())];
        }
        text.getChars(lineStartPos, endPos, this.chars, 0);
        Rectangle2D textBounds2 = this.font.getStringBounds(this.chars, 0, endPos - lineStartPos, frc);
        return (float)textBounds2.getWidth();
    }

    public String toString() {
        return "DefaultSizeCalculator={font=" + this.font + '}';
    }

    public strictfp static class BuggyFontRendererDetector {
        private boolean isBuggyVersion;
        private final boolean isAliased;
        private FontRenderContext fontRenderContext;

        protected BuggyFontRendererDetector() {
            ExtendedConfiguration extConfiguration = ClassicEngineBoot.getInstance().getExtendedConfig();
            this.isAliased = extConfiguration.getBoolProperty("org.pentaho.reporting.engine.classic.core.layout.fontrenderer.UseAliasing");
            FontRenderContext frcAlias = new FontRenderContext(null, true, false);
            FontRenderContext frcNoAlias = new FontRenderContext(null, false, false);
            Font font = new Font("Serif", 0, 10);
            String myText = "A simple text with some characters to calculate the length.";
            double wAlias = font.getStringBounds("A simple text with some characters to calculate the length.", 0, "A simple text with some characters to calculate the length.".length(), frcAlias).getWidth();
            double wNoAlias = font.getStringBounds("A simple text with some characters to calculate the length.", 0, "A simple text with some characters to calculate the length.".length(), frcNoAlias).getWidth();
            this.isBuggyVersion = wAlias != wNoAlias;
            boolean buggyOverride = extConfiguration.getBoolProperty("org.pentaho.reporting.engine.classic.core.layout.fontrenderer.IsBuggyFRC");
            if (buggyOverride) {
                this.isBuggyVersion = true;
            }
        }

        protected FontRenderContext createFontRenderContext() {
            if (this.fontRenderContext == null) {
                this.fontRenderContext = this.isAliased() ? new FontRenderContext(null, this.isAliased(), true) : new FontRenderContext(null, this.isAliased(), !this.isBuggyVersion());
            }
            return this.fontRenderContext;
        }

        public boolean isAliased() {
            return this.isAliased;
        }

        public boolean isBuggyVersion() {
            return this.isBuggyVersion;
        }
    }
}

