/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.pentaho.reporting.engine.classic.core.layout.model.FinishedRenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.ParagraphRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableText;

public class FileModelPrinter {
    private static final boolean PRINT_LINEBOX_CONTENTS = false;

    private FileModelPrinter() {
    }

    public static void print(RenderBox box) {
        try {
            File file = File.createTempFile("model-dump-", ".txt");
            BufferedWriter writer = new BufferedWriter(new FileWriter(file));
            FileModelPrinter.printBox(writer, box, 0);
            writer.close();
        }
        catch (Exception e) {
            throw new Error();
        }
    }

    public static void printBox(Writer writer, RenderBox box, int level) throws Exception {
        int i;
        StringBuffer b = new StringBuffer();
        for (i = 0; i < level; ++i) {
            b.append("   ");
        }
        b.append(box.getClass().getName());
        b.append('[');
        b.append(';');
        b.append(box.getName());
        b.append(']');
        b.append("={stateKey=");
        b.append(box.getStateKey());
        b.append(", x=");
        b.append(box.getX());
        b.append(", y=");
        b.append(box.getY());
        b.append(", width=");
        b.append(box.getWidth());
        b.append(", height=");
        b.append(box.getHeight());
        b.append(", min-chunk-width=");
        b.append(box.getMinimumChunkWidth());
        b.append(", computed-width=");
        b.append(box.getComputedWidth());
        b.append(", cached-x=");
        b.append(box.getCachedX());
        b.append(", cached-y=");
        b.append(box.getCachedY());
        b.append(", cached-width=");
        b.append(box.getCachedWidth());
        b.append(", cached-height=");
        b.append(box.getCachedHeight());
        b.append('}');
        writer.write(b.toString());
        writer.write("\n");
        b = new StringBuffer();
        for (i = 0; i < level; ++i) {
            b.append("   ");
        }
        b.append("- boxDefinition=");
        b.append(box.getBoxDefinition());
        writer.write(b.toString());
        writer.write("\n");
        b = new StringBuffer();
        for (i = 0; i < level; ++i) {
            b.append("   ");
        }
        b.append("- nodeLayoutProperties=");
        b.append(box.getNodeLayoutProperties());
        writer.write(b.toString());
        writer.write("\n");
        b = new StringBuffer();
        for (i = 0; i < level; ++i) {
            b.append("   ");
        }
        b.append("- staticBoxLayoutProperties=");
        b.append(box.getStaticBoxLayoutProperties());
        writer.write(b.toString());
        writer.write("\n");
        if (box instanceof LogicalPageBox) {
            LogicalPageBox pageBox = (LogicalPageBox)box;
            b = new StringBuffer();
            for (int i2 = 0; i2 < level; ++i2) {
                b.append("   ");
            }
            b.append("- PageBox={PageOffset=");
            b.append(pageBox.getPageOffset());
            b.append(", PageHeight=");
            b.append(pageBox.getPageHeight());
            b.append(", PageEnd=");
            b.append(pageBox.getPageEnd());
            b.append('}');
            writer.write(b.toString());
            writer.write("\n");
        }
        if (box.isOpen()) {
            b = new StringBuffer();
            for (int i3 = 0; i3 < level; ++i3) {
                b.append("   ");
            }
            b.append("- WARNING: THIS BOX IS STILL OPEN");
            writer.write(b.toString());
            writer.write("\n");
        }
        if (box.isFinishedTable() || box.isFinishedPaginate()) {
            b = new StringBuffer();
            for (int i4 = 0; i4 < level; ++i4) {
                b.append("   ");
            }
            b.append("- INFO: THIS BOX IS FINISHED: ");
            if (box.isFinishedTable()) {
                b.append("- TABLE ");
            }
            if (box.isFinishedPaginate()) {
                b.append("- PAGE ");
            }
            writer.write(b.toString());
            writer.write("\n");
        }
        if (box.isCommited()) {
            b = new StringBuffer();
            for (int i5 = 0; i5 < level; ++i5) {
                b.append("   ");
            }
            b.append("- INFO: THIS BOX IS COMMITED");
            writer.write(b.toString());
            writer.write("\n");
        }
        b = new StringBuffer();
        for (int i6 = 0; i6 < level; ++i6) {
            b.append("   ");
        }
        writer.write(b.toString());
        writer.write("\n");
        if (box instanceof ParagraphRenderBox) {
            // empty if block
        }
        if (box instanceof LogicalPageBox) {
            LogicalPageBox lbox = (LogicalPageBox)box;
            FileModelPrinter.printBox(writer, lbox.getHeaderArea(), level + 1);
            FileModelPrinter.printBox(writer, lbox.getWatermarkArea(), level + 1);
        }
        FileModelPrinter.printChilds(writer, box, level);
        if (box instanceof LogicalPageBox) {
            LogicalPageBox lbox = (LogicalPageBox)box;
            FileModelPrinter.printBox(writer, lbox.getRepeatFooterArea(), level + 1);
            FileModelPrinter.printBox(writer, lbox.getFooterArea(), level + 1);
        }
    }

    private static void printChilds(Writer writer, RenderBox box, int level) throws Exception {
        for (RenderNode childs = box.getFirstChild(); childs != null; childs = childs.getNext()) {
            if (childs instanceof RenderBox) {
                FileModelPrinter.printBox(writer, (RenderBox)childs, level + 1);
                continue;
            }
            if (childs instanceof RenderableText) {
                FileModelPrinter.printText(writer, (RenderableText)childs, level + 1);
                continue;
            }
            FileModelPrinter.printNode(writer, childs, level + 1);
        }
    }

    private static void printNode(Writer writer, RenderNode node, int level) throws IOException {
        int i;
        StringBuffer b = new StringBuffer();
        for (i = 0; i < level; ++i) {
            b.append("   ");
        }
        b.append(node.getClass().getName());
        b.append('[');
        b.append(']');
        b.append("={x=");
        b.append(node.getX());
        b.append(", y=");
        b.append(node.getY());
        b.append(", width=");
        b.append(node.getWidth());
        b.append(", height=");
        b.append(node.getHeight());
        b.append(", min-chunk-width=");
        b.append(node.getMinimumChunkWidth());
        b.append(", computed-width=");
        b.append(node.getComputedWidth());
        if (node instanceof FinishedRenderNode) {
            FinishedRenderNode fn = (FinishedRenderNode)node;
            b.append(", layouted-width=");
            b.append(fn.getLayoutedWidth());
            b.append(", layouted-height=");
            b.append(fn.getLayoutedHeight());
        }
        b.append('}');
        writer.write(b.toString());
        writer.write("\n");
        b = new StringBuffer();
        for (i = 0; i < level; ++i) {
            b.append("   ");
        }
        b.append("- nodeLayoutProperties=");
        b.append(node.getNodeLayoutProperties());
        writer.write(b.toString());
        writer.write("\n");
    }

    private static void printText(Writer writer, RenderableText text, int level) throws IOException {
        int i;
        StringBuffer b = new StringBuffer();
        for (i = 0; i < level; ++i) {
            b.append("   ");
        }
        b.append("Text");
        b.append('[');
        b.append(']');
        b.append("={x=");
        b.append(text.getX());
        b.append(", y=");
        b.append(text.getY());
        b.append(", width=");
        b.append(text.getWidth());
        b.append(", height=");
        b.append(text.getHeight());
        b.append(", computed-width=");
        b.append(text.getComputedWidth());
        b.append(", min-chunk-width=");
        b.append(text.getMinimumChunkWidth());
        b.append(", text='");
        b.append(text.getRawText());
        b.append("'}");
        writer.write(b.toString());
        writer.write("\n");
        b = new StringBuffer();
        for (i = 0; i < level; ++i) {
            b.append("   ");
        }
        b.append("- nodeLayoutProperties=");
        b.append(text.getNodeLayoutProperties());
        writer.write(b.toString());
        writer.write("\n");
    }
}

