/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout;

import org.pentaho.reporting.engine.classic.core.ReportDefinition;
import org.pentaho.reporting.engine.classic.core.layout.AbstractRenderer;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.PageBreakPositionList;
import org.pentaho.reporting.engine.classic.core.layout.output.ContentProcessingException;
import org.pentaho.reporting.engine.classic.core.layout.output.IterativeOutputProcessor;
import org.pentaho.reporting.engine.classic.core.layout.output.LayoutPagebreakHandler;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessor;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorFeature;
import org.pentaho.reporting.engine.classic.core.layout.process.ApplyAutoCommitPageHeaderStep;
import org.pentaho.reporting.engine.classic.core.layout.process.ApplyPageShiftValuesStep;
import org.pentaho.reporting.engine.classic.core.layout.process.CleanFlowBoxesStep;
import org.pentaho.reporting.engine.classic.core.layout.process.CleanPaginatedBoxesStep;
import org.pentaho.reporting.engine.classic.core.layout.process.FillFlowPagesStep;
import org.pentaho.reporting.engine.classic.core.layout.process.FlowPaginationStep;
import org.pentaho.reporting.engine.classic.core.layout.process.PaginationResult;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;

public class FlowRenderer
extends AbstractRenderer {
    private FlowPaginationStep paginationStep = new FlowPaginationStep();
    private FillFlowPagesStep fillPhysicalPagesStep = new FillFlowPagesStep();
    private CleanPaginatedBoxesStep cleanPaginatedBoxesStep = new CleanPaginatedBoxesStep();
    private CleanFlowBoxesStep cleanFlowBoxesStep = new CleanFlowBoxesStep();
    private ApplyPageShiftValuesStep applyPageShiftValuesStep = new ApplyPageShiftValuesStep();
    private ApplyAutoCommitPageHeaderStep applyAutoCommitPageHeaderStep = new ApplyAutoCommitPageHeaderStep();
    private int flowCount;
    private boolean pageStartPending;
    private int floodPrevention;

    public FlowRenderer(OutputProcessor outputProcessor) {
        super(outputProcessor);
    }

    public void startReport(ReportDefinition report) {
        this.flowCount = 0;
        super.startReport(report);
    }

    protected boolean isPageFinished() {
        LogicalPageBox pageBox = this.getPageBox();
        PaginationResult pageBreak = this.paginationStep.performPagebreak(pageBox);
        if (pageBreak.isOverflow() || !pageBox.isOpen()) {
            this.setLastStateKey(pageBreak.getLastVisibleState());
            return true;
        }
        return false;
    }

    protected void debugPrint(LogicalPageBox pageBox) {
    }

    public void processIncrementalUpdate(boolean performOutput) throws ContentProcessingException {
        if (!this.isDirty()) {
            return;
        }
        this.clearDirty();
        ++this.floodPrevention;
        if (this.floodPrevention < 50) {
            return;
        }
        this.floodPrevention = 0;
        OutputProcessor outputProcessor = this.getOutputProcessor();
        if (!(outputProcessor instanceof IterativeOutputProcessor) || !outputProcessor.getMetaData().isFeatureSupported(OutputProcessorFeature.ITERATIVE_RENDERING)) {
            return;
        }
        LogicalPageBox pageBox = this.getPageBox();
        pageBox.setPageEnd(pageBox.getHeight());
        if (pageBox.isOpen()) {
            IterativeOutputProcessor io = (IterativeOutputProcessor)outputProcessor;
            if (this.applyAutoCommitPageHeaderStep.compute(pageBox)) {
                io.processIterativeContent(pageBox, performOutput);
                this.cleanFlowBoxesStep.compute(pageBox);
            }
        }
    }

    protected boolean performPagination(LayoutPagebreakHandler layoutPagebreakHandler, boolean performOutput) throws ContentProcessingException {
        OutputProcessor outputProcessor = this.getOutputProcessor();
        LogicalPageBox pageBox = this.getPageBox();
        PaginationResult pageBreak = this.paginationStep.performPagebreak(pageBox);
        if (pageBreak.isOverflow() || !pageBox.isOpen()) {
            boolean repeat;
            this.setLastStateKey(pageBreak.getLastVisibleState());
            this.setPagebreaks(this.getPagebreaks() + 1);
            pageBox.setAllVerticalBreaks(pageBreak.getAllBreaks());
            ++this.flowCount;
            this.debugPrint(pageBox);
            long nextOffset = pageBox.computePageEnd();
            pageBox.setPageEnd(nextOffset);
            long pageOffset = pageBox.getPageOffset();
            if (performOutput) {
                if (outputProcessor.isNeedAlignedPage()) {
                    LogicalPageBox box = this.fillPhysicalPagesStep.compute(pageBox, pageOffset, nextOffset);
                    outputProcessor.processContent(box);
                } else {
                    outputProcessor.processContent(pageBox);
                }
            } else {
                outputProcessor.processRecomputedContent(pageBox);
            }
            boolean bl = repeat = pageBox.isOpen() || pageBreak.isOverflow();
            if (repeat) {
                this.cleanFlowBoxesStep.compute(pageBox);
                long l = this.cleanPaginatedBoxesStep.compute(pageBox);
                if (l > 0L) {
                    InstanceID shiftNode = this.cleanPaginatedBoxesStep.getShiftNode();
                    this.applyPageShiftValuesStep.compute(pageBox, l, shiftNode);
                    this.debugPrint(pageBox);
                }
                pageBox.setPageOffset(nextOffset);
                if (pageBreak.isNextPageContainsContent()) {
                    if (layoutPagebreakHandler != null) {
                        layoutPagebreakHandler.pageStarted();
                    }
                    return true;
                }
                this.pageStartPending = true;
                return false;
            }
            outputProcessor.processingFinished();
            pageBox.setPageOffset(nextOffset);
            return false;
        }
        if (outputProcessor instanceof IterativeOutputProcessor && outputProcessor.getMetaData().isFeatureSupported(OutputProcessorFeature.ITERATIVE_RENDERING)) {
            this.processIncrementalUpdate(performOutput);
        }
        return false;
    }

    public int getPageCount() {
        return this.flowCount;
    }

    public boolean isCurrentPageEmpty() {
        LogicalPageBox logicalPageBox = this.getPageBox();
        PageBreakPositionList breakPositionList = logicalPageBox.getAllVerticalBreaks();
        long masterBreak = breakPositionList.getLastMasterBreak();
        boolean nextPageContainsContent = logicalPageBox.getHeight() > masterBreak;
        return !nextPageContainsContent;
    }

    public boolean clearPendingPageStart(LayoutPagebreakHandler layoutPagebreakHandler) {
        if (!this.pageStartPending) {
            return false;
        }
        if (layoutPagebreakHandler != null) {
            layoutPagebreakHandler.pageStarted();
        }
        this.pageStartPending = false;
        return true;
    }

    public boolean isPageStartPending() {
        return this.pageStartPending;
    }
}

