/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.layout.DefaultLayoutBuilder;
import org.pentaho.reporting.engine.classic.core.layout.InlineSubreportMarker;
import org.pentaho.reporting.engine.classic.core.layout.LayoutBuilder;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.states.ReportStateKey;
import org.pentaho.reporting.engine.classic.core.style.BandStyleKeys;

public class FooterLayoutBuilder
implements LayoutBuilder {
    private static final Log logger = LogFactory.getLog(FooterLayoutBuilder.class);
    private DefaultLayoutBuilder backend;
    private ArrayList<RenderNode> slots;
    private int slotCounter;

    public FooterLayoutBuilder(OutputProcessorMetaData metaData) {
        this.backend = new DefaultLayoutBuilder(metaData);
        this.backend.setCollapseProgressMarker(false);
        this.slots = new ArrayList();
    }

    public void startSection(RenderBox pageArea, boolean limitedSubReports) {
        this.slots.clear();
        this.slotCounter = 0;
        RenderNode firstChild = pageArea.getFirstChild();
        if (firstChild instanceof RenderBox) {
            RenderBox slottedContent = (RenderBox)firstChild;
            RenderNode box = slottedContent.getFirstChild();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Start Section: " + pageArea));
                logger.debug((Object)("      Section: " + slottedContent));
                logger.debug((Object)("      Section: " + box));
            }
            boolean sticky = false;
            while (box != null) {
                if (box.getStyleSheet().getBooleanStyleProperty(BandStyleKeys.STICKY)) {
                    sticky = true;
                }
                if (sticky) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Added Slot[]: " + box));
                        logger.debug((Object)("      Slot[]: " + box.getElementType()));
                        logger.debug((Object)("      Slot[]: " + box.getStateKey()));
                    }
                    this.slots.add(box);
                }
                box = box.getNext();
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Added Reverse Section: " + this.slotCounter + " " + this.slots.size() + " " + firstChild));
        }
        this.backend.startSection(pageArea, limitedSubReports);
    }

    public void add(RenderBox parent, Band band, ExpressionRuntime runtime, ReportStateKey stateKey) throws ReportProcessingException {
        this.backend.add(parent, band, runtime, stateKey);
        ++this.slotCounter;
    }

    public void addEmptyRootLevelBand(RenderBox parent, ReportStateKey stateKey) throws ReportProcessingException {
        this.backend.addEmptyRootLevelBand(parent, stateKey);
        ++this.slotCounter;
    }

    public InlineSubreportMarker[] endSection(RenderBox pageArea, RenderBox sectionBox) {
        InlineSubreportMarker[] retval = this.backend.endSection(pageArea, sectionBox);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Slot counter: " + this.slotCounter + " " + this.slots.size()));
            for (int i = 0; i < this.slots.size(); ++i) {
                logger.debug((Object)("Slots[" + i + "]: " + this.slots.get(i)));
            }
        }
        if (this.slotCounter < this.slots.size()) {
            logger.debug((Object)"Rebuilding footer");
            RenderBox newSectionBox = (RenderBox)sectionBox.derive(false);
            for (int i = this.slots.size() - this.slotCounter - 1; i >= 0; --i) {
                RenderNode node = this.slots.get(i);
                RenderNode derived = node.derive(true);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Rescued[" + i + "]: " + this.slots.get(i)));
                }
                newSectionBox.addGeneratedChild(derived);
            }
            RenderNode child = sectionBox.getFirstChild();
            while (child != null) {
                RenderNode next = child.getNext();
                sectionBox.remove(child);
                newSectionBox.addGeneratedChild(child);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("New[]: " + child));
                }
                child = next;
            }
            sectionBox = newSectionBox;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"CLEAR footer for reslotting!");
        }
        pageArea.clear();
        pageArea.addChild(sectionBox);
        return retval;
    }
}

