/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.layout.model.FinishedRenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.ParagraphRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableText;

public class ModelPrinter {
    private static final Log logger = LogFactory.getLog(ModelPrinter.class);
    private static final boolean PRINT_LINEBOX_CONTENTS = false;

    private ModelPrinter() {
    }

    public static void printParents(RenderNode box) {
        while (box != null) {
            StringBuffer b = new StringBuffer();
            b.append(box.getClass().getName());
            b.append('[');
            b.append(box.getElementType().getClass().getName());
            b.append(';');
            b.append(box.getName());
            b.append(']');
            b.append("={stateKey=");
            b.append(box.getStateKey());
            b.append(", x=");
            b.append(box.getX());
            b.append(", y=");
            b.append(box.getY());
            b.append(", width=");
            b.append(box.getWidth());
            b.append(", height=");
            b.append(box.getHeight());
            b.append(", min-chunk-width=");
            b.append(box.getMinimumChunkWidth());
            b.append(", computed-width=");
            b.append(box.getComputedWidth());
            b.append(", cached-x=");
            b.append(box.getCachedX());
            b.append(", cached-y=");
            b.append(box.getCachedY());
            b.append(", cached-width=");
            b.append(box.getCachedWidth());
            b.append(", cached-height=");
            b.append(box.getCachedHeight());
            b.append('}');
            logger.debug((Object)b);
            box = box.getParent();
        }
    }

    public static void print(RenderBox box) {
        ModelPrinter.printBox(box, 0);
    }

    public static void printBox(RenderBox box, int level) {
        int i;
        StringBuffer b = new StringBuffer();
        for (i = 0; i < level; ++i) {
            b.append("   ");
        }
        b.append(box.getClass().getName());
        b.append('[');
        b.append(box.getElementType().getClass().getName());
        b.append(';');
        b.append(box.getName());
        b.append(']');
        b.append("={stateKey=");
        b.append(box.getStateKey());
        b.append(", pinned=");
        b.append(box.getPinned());
        b.append('}');
        logger.debug((Object)b.toString());
        b = new StringBuffer();
        for (i = 0; i < level; ++i) {
            b.append("   ");
        }
        b.append("-layout x=");
        b.append(box.getX());
        b.append(", y=");
        b.append(box.getY());
        b.append(", width=");
        b.append(box.getWidth());
        b.append(", height=");
        b.append(box.getHeight());
        b.append(", min-chunk-width=");
        b.append(box.getMinimumChunkWidth());
        b.append(", computed-width=");
        b.append(box.getComputedWidth());
        b.append(", cached-x=");
        b.append(box.getCachedX());
        b.append(", cached-y=");
        b.append(box.getCachedY());
        b.append(", cached-width=");
        b.append(box.getCachedWidth());
        b.append(", cached-height=");
        b.append(box.getCachedHeight());
        logger.debug((Object)b.toString());
        b = new StringBuffer();
        for (i = 0; i < level; ++i) {
            b.append("   ");
        }
        b.append("- boxDefinition=");
        b.append(box.getBoxDefinition());
        logger.debug((Object)b.toString());
        b = new StringBuffer();
        for (i = 0; i < level; ++i) {
            b.append("   ");
        }
        b.append("- nodeLayoutProperties=");
        b.append(box.getNodeLayoutProperties());
        logger.debug((Object)b.toString());
        b = new StringBuffer();
        for (i = 0; i < level; ++i) {
            b.append("   ");
        }
        b.append("- staticBoxLayoutProperties=");
        b.append(box.getStaticBoxLayoutProperties());
        logger.debug((Object)b.toString());
        b = new StringBuffer();
        for (i = 0; i < level; ++i) {
            b.append("   ");
        }
        b.append("- breakContext=");
        b.append(box.getBreakContext());
        logger.debug((Object)b.toString());
        if (box instanceof LogicalPageBox) {
            int i2;
            LogicalPageBox pageBox = (LogicalPageBox)box;
            b = new StringBuffer();
            for (i2 = 0; i2 < level; ++i2) {
                b.append("   ");
            }
            b.append("- PageBox={PageOffset=");
            b.append(pageBox.getPageOffset());
            b.append(", PageHeight=");
            b.append(pageBox.getPageHeight());
            b.append(", PageEnd=");
            b.append(pageBox.getPageEnd());
            b.append('}');
            logger.debug((Object)b.toString());
            b = new StringBuffer();
            for (i2 = 0; i2 < level; ++i2) {
                b.append("   ");
            }
            b.append("- PageBreaks={");
            b.append(pageBox.getAllVerticalBreaks());
            b.append('}');
            logger.debug((Object)b.toString());
        }
        if (box.isOpen()) {
            b = new StringBuffer();
            for (int i3 = 0; i3 < level; ++i3) {
                b.append("   ");
            }
            b.append("- WARNING: THIS BOX IS STILL OPEN");
            logger.debug((Object)b.toString());
        }
        if (box.isFinishedTable() || box.isFinishedPaginate()) {
            b = new StringBuffer();
            for (int i4 = 0; i4 < level; ++i4) {
                b.append("   ");
            }
            b.append("- INFO: THIS BOX IS FINISHED: ");
            if (box.isFinishedTable()) {
                b.append("- TABLE ");
            }
            if (box.isFinishedPaginate()) {
                b.append("- PAGE ");
            }
            logger.debug((Object)b.toString());
        }
        if (box.isCommited()) {
            b = new StringBuffer();
            for (int i5 = 0; i5 < level; ++i5) {
                b.append("   ");
            }
            b.append("- INFO: THIS BOX IS COMMITED");
            logger.debug((Object)b.toString());
        }
        b = new StringBuffer();
        for (int i6 = 0; i6 < level; ++i6) {
            b.append("   ");
        }
        logger.debug((Object)b.toString());
        if (box instanceof ParagraphRenderBox) {
            // empty if block
        }
        if (box instanceof LogicalPageBox) {
            LogicalPageBox lbox = (LogicalPageBox)box;
            ModelPrinter.printBox(lbox.getHeaderArea(), level + 1);
            ModelPrinter.printBox(lbox.getWatermarkArea(), level + 1);
        }
        ModelPrinter.printChilds(box, level);
        if (box instanceof LogicalPageBox) {
            LogicalPageBox lbox = (LogicalPageBox)box;
            ModelPrinter.printBox(lbox.getRepeatFooterArea(), level + 1);
            ModelPrinter.printBox(lbox.getFooterArea(), level + 1);
        }
    }

    private static void printChilds(RenderBox box, int level) {
        for (RenderNode childs = box.getFirstChild(); childs != null; childs = childs.getNext()) {
            if (childs instanceof RenderBox) {
                ModelPrinter.printBox((RenderBox)childs, level + 1);
                continue;
            }
            if (childs instanceof RenderableText) {
                ModelPrinter.printText((RenderableText)childs, level + 1);
                continue;
            }
            ModelPrinter.printNode(childs, level + 1);
        }
    }

    private static void printNode(RenderNode node, int level) {
        int i;
        StringBuffer b = new StringBuffer();
        for (i = 0; i < level; ++i) {
            b.append("   ");
        }
        b.append(node.getClass().getName());
        b.append('[');
        b.append(']');
        b.append("={x=");
        b.append(node.getX());
        b.append(", y=");
        b.append(node.getY());
        b.append(", width=");
        b.append(node.getWidth());
        b.append(", height=");
        b.append(node.getHeight());
        b.append(", min-chunk-width=");
        b.append(node.getMinimumChunkWidth());
        b.append(", computed-width=");
        b.append(node.getComputedWidth());
        if (node instanceof FinishedRenderNode) {
            FinishedRenderNode fn = (FinishedRenderNode)node;
            b.append(", layouted-width=");
            b.append(fn.getLayoutedWidth());
            b.append(", layouted-height=");
            b.append(fn.getLayoutedHeight());
        }
        b.append('}');
        logger.debug((Object)b.toString());
        b = new StringBuffer();
        for (i = 0; i < level; ++i) {
            b.append("   ");
        }
        b.append("- cacheSize={x=");
        b.append(node.getCachedX());
        b.append(", y=");
        b.append(node.getCachedY());
        b.append(", width=");
        b.append(node.getCachedWidth());
        b.append(", height=");
        b.append(node.getCachedHeight());
        b.append('}');
        logger.debug((Object)b.toString());
        b = new StringBuffer();
        for (i = 0; i < level; ++i) {
            b.append("   ");
        }
        b.append("- nodeLayoutProperties=");
        b.append(node.getNodeLayoutProperties());
        logger.debug((Object)b.toString());
    }

    private static void printText(RenderableText text, int level) {
        int i;
        StringBuffer b = new StringBuffer();
        for (i = 0; i < level; ++i) {
            b.append("   ");
        }
        b.append("Text");
        b.append('[');
        b.append(']');
        b.append("={x=");
        b.append(text.getX());
        b.append(", y=");
        b.append(text.getY());
        b.append(", width=");
        b.append(text.getWidth());
        b.append(", height=");
        b.append(text.getHeight());
        b.append(", min-chunk-width=");
        b.append(text.getMinimumChunkWidth());
        b.append(", computed-width=");
        b.append(text.getComputedWidth());
        b.append(", text='");
        b.append(text.getRawText());
        b.append("'}");
        logger.debug((Object)b.toString());
        b = new StringBuffer();
        for (i = 0; i < level; ++i) {
            b.append("   ");
        }
        b.append("- cacheSize={x=");
        b.append(text.getCachedX());
        b.append(", y=");
        b.append(text.getCachedY());
        b.append(", width=");
        b.append(text.getCachedWidth());
        b.append(", height=");
        b.append(text.getCachedHeight());
        b.append('}');
        logger.debug((Object)b.toString());
        b = new StringBuffer();
        for (i = 0; i < level; ++i) {
            b.append("   ");
        }
        b.append("- nodeLayoutProperties=");
        b.append(text.getNodeLayoutProperties());
        logger.debug((Object)b.toString());
    }
}

