/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout;

import org.pentaho.reporting.engine.classic.core.ReportDefinition;
import org.pentaho.reporting.engine.classic.core.layout.AbstractRenderer;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.output.ContentProcessingException;
import org.pentaho.reporting.engine.classic.core.layout.output.IterativeOutputProcessor;
import org.pentaho.reporting.engine.classic.core.layout.output.LayoutPagebreakHandler;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessor;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorFeature;
import org.pentaho.reporting.engine.classic.core.layout.process.ApplyAutoCommitPageHeaderStep;
import org.pentaho.reporting.engine.classic.core.layout.process.CleanFlowBoxesStep;
import org.pentaho.reporting.engine.classic.core.layout.process.CountBoxesStep;

public class StreamingRenderer
extends AbstractRenderer {
    private CountBoxesStep countBoxesStep = new CountBoxesStep();
    private CleanFlowBoxesStep cleanBoxesStep = new CleanFlowBoxesStep();
    private ApplyAutoCommitPageHeaderStep applyAutoCommitPageHeaderStep = new ApplyAutoCommitPageHeaderStep();
    private int floodPrevention;
    private int pageCount;

    public StreamingRenderer(OutputProcessor outputProcessor) {
        super(outputProcessor);
    }

    protected boolean isPageFinished() {
        return !this.getPageBox().isOpen();
    }

    public void startReport(ReportDefinition report) {
        this.pageCount = 0;
        super.startReport(report);
    }

    public void processIncrementalUpdate(boolean performOutput) throws ContentProcessingException {
        if (!this.isDirty()) {
            return;
        }
        this.clearDirty();
        ++this.floodPrevention;
        if (this.floodPrevention < 150) {
            return;
        }
        this.floodPrevention = 0;
        OutputProcessor outputProcessor = this.getOutputProcessor();
        if (!(outputProcessor instanceof IterativeOutputProcessor) || !outputProcessor.getMetaData().isFeatureSupported(OutputProcessorFeature.ITERATIVE_RENDERING)) {
            return;
        }
        LogicalPageBox pageBox = this.getPageBox();
        pageBox.setPageOffset(0L);
        pageBox.setPageEnd(pageBox.getHeight());
        if (pageBox.isOpen()) {
            IterativeOutputProcessor io = (IterativeOutputProcessor)outputProcessor;
            if (this.applyAutoCommitPageHeaderStep.compute(pageBox)) {
                io.processIterativeContent(pageBox, performOutput);
                this.countBoxesStep.process(pageBox);
                this.cleanBoxesStep.compute(pageBox);
            }
        }
    }

    protected boolean performPagination(LayoutPagebreakHandler handler, boolean performOutput) throws ContentProcessingException {
        if (!performOutput) {
            return false;
        }
        OutputProcessor outputProcessor = this.getOutputProcessor();
        LogicalPageBox pageBox = this.getPageBox();
        pageBox.setPageOffset(0L);
        pageBox.setPageEnd(pageBox.getHeight());
        if (pageBox.isOpen()) {
            return false;
        }
        this.applyAutoCommitPageHeaderStep.commitAll(pageBox);
        outputProcessor.processContent(pageBox);
        this.countBoxesStep.process(pageBox);
        this.cleanBoxesStep.compute(pageBox);
        this.debugPrint(pageBox);
        outputProcessor.processingFinished();
        this.pageCount = 1;
        this.setPagebreaks(1);
        return false;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    protected void debugPrint(LogicalPageBox pageBox) {
    }

    public void createRollbackInformation() {
        throw new UnsupportedOperationException("Streaming-Renderer do not implement the createRollbackInformation-method.");
    }

    public void applyRollbackInformation() {
        throw new UnsupportedOperationException("Streaming-Renderer do not implement the applyRollbackInformation method.");
    }

    public void rollback() {
        throw new UnsupportedOperationException("Streaming-Renderer do not implement the rollback method.");
    }
}

