/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout;

import org.pentaho.reporting.engine.classic.core.layout.style.NonPaddingWrapperStyleSheet;
import org.pentaho.reporting.engine.classic.core.layout.style.SimpleStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;
import org.pentaho.reporting.libraries.base.util.LFUMap;

public class StyleCache {
    private LFUMap<CacheKey, CacheCarrier> cache;
    private boolean omitPadding;
    private NonPaddingWrapperStyleSheet nonPaddingWrapperStyleSheet;
    private CacheKey lookupKey = new CacheKey();

    public StyleCache(boolean omitPadding) {
        this.omitPadding = omitPadding;
        this.cache = new LFUMap(100);
        this.nonPaddingWrapperStyleSheet = new NonPaddingWrapperStyleSheet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleStyleSheet getStyleSheet(StyleSheet parent) {
        if (this.omitPadding) {
            this.nonPaddingWrapperStyleSheet.setParent(parent);
            try {
                InstanceID id = this.nonPaddingWrapperStyleSheet.getId();
                String styleClass = NonPaddingWrapperStyleSheet.class.getName() + "|" + parent.getClass().getName();
                this.lookupKey.setStyleClass(styleClass);
                this.lookupKey.setInstanceId(id);
                CacheCarrier cc = (CacheCarrier)this.cache.get((Object)this.lookupKey);
                if (cc == null) {
                    CacheKey key = new CacheKey(id, NonPaddingWrapperStyleSheet.class.getName());
                    SimpleStyleSheet styleSheet = new SimpleStyleSheet(this.nonPaddingWrapperStyleSheet);
                    this.cache.put((Object)key, (Object)new CacheCarrier(this.nonPaddingWrapperStyleSheet.getChangeTracker(), styleSheet));
                    SimpleStyleSheet simpleStyleSheet = styleSheet;
                    return simpleStyleSheet;
                }
                if (cc.getChangeTracker() != this.nonPaddingWrapperStyleSheet.getChangeTracker()) {
                    CacheKey key = new CacheKey(id, styleClass);
                    SimpleStyleSheet styleSheet = new SimpleStyleSheet(this.nonPaddingWrapperStyleSheet);
                    this.cache.put((Object)key, (Object)new CacheCarrier(this.nonPaddingWrapperStyleSheet.getChangeTracker(), styleSheet));
                    SimpleStyleSheet simpleStyleSheet = styleSheet;
                    return simpleStyleSheet;
                }
                SimpleStyleSheet key = cc.getStyleSheet();
                return key;
            }
            finally {
                this.nonPaddingWrapperStyleSheet.setParent(null);
            }
        }
        InstanceID id = parent.getId();
        String styleClass = parent.getClass().getName();
        this.lookupKey.setStyleClass(styleClass);
        this.lookupKey.setInstanceId(id);
        CacheCarrier cc = (CacheCarrier)this.cache.get((Object)this.lookupKey);
        if (cc == null) {
            CacheKey key = new CacheKey(id, styleClass);
            SimpleStyleSheet styleSheet = new SimpleStyleSheet(parent);
            this.cache.put((Object)key, (Object)new CacheCarrier(parent.getChangeTracker(), styleSheet));
            return styleSheet;
        }
        if (cc.getChangeTracker() != parent.getChangeTracker()) {
            CacheKey key = new CacheKey(id, styleClass);
            SimpleStyleSheet styleSheet = new SimpleStyleSheet(parent);
            this.cache.put((Object)key, (Object)new CacheCarrier(parent.getChangeTracker(), styleSheet));
            return styleSheet;
        }
        return cc.getStyleSheet();
    }

    private static class CacheCarrier {
        private long changeTracker;
        private SimpleStyleSheet styleSheet;

        protected CacheCarrier(long changeTracker, SimpleStyleSheet styleSheet) {
            this.changeTracker = changeTracker;
            this.styleSheet = styleSheet;
        }

        public long getChangeTracker() {
            return this.changeTracker;
        }

        public SimpleStyleSheet getStyleSheet() {
            return this.styleSheet;
        }
    }

    private static class CacheKey {
        private Object instanceId;
        private String styleClass;

        protected CacheKey() {
        }

        protected CacheKey(Object instanceId, String styleClass) {
            if (instanceId == null) {
                throw new NullPointerException();
            }
            if (styleClass == null) {
                throw new NullPointerException();
            }
            this.instanceId = instanceId;
            this.styleClass = styleClass;
        }

        public Object getInstanceId() {
            return this.instanceId;
        }

        public void setInstanceId(Object instanceId) {
            this.instanceId = instanceId;
        }

        public String getStyleClass() {
            return this.styleClass;
        }

        public void setStyleClass(String styleClass) {
            this.styleClass = styleClass;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (!this.instanceId.equals(cacheKey.instanceId)) {
                return false;
            }
            return this.styleClass.equals(cacheKey.styleClass);
        }

        public int hashCode() {
            int result = this.instanceId.hashCode();
            result = 31 * result + this.styleClass.hashCode();
            return result;
        }

        public String toString() {
            return "CacheKey{instanceId=" + this.instanceId + ", styleClass='" + this.styleClass + '\'' + '}';
        }
    }
}

