/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout;

import org.pentaho.reporting.engine.classic.core.ReportAttributeMap;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;
import org.pentaho.reporting.libraries.base.util.LFUMap;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class TextCache {
    private LFUMap cache;

    public TextCache(int maxEntries) {
        this.cache = new LFUMap(maxEntries);
    }

    public void store(InstanceID instanceID, long styleChangeTracker, long attrChangeTracker, String originalText, StyleSheet styleSheet, ReportAttributeMap attributeMap, RenderNode[] text, RenderNode[] finish) {
        this.cache.put((Object)instanceID, (Object)new InternalResult(text, finish, styleSheet, styleChangeTracker, attributeMap, attrChangeTracker, originalText));
    }

    public Result get(InstanceID instanceID, long styleChangeTracker, long attributeChangeTracker, String originalText) {
        InternalResult o = (InternalResult)this.cache.get((Object)instanceID);
        if (o == null) {
            return null;
        }
        if (!o.isValid(styleChangeTracker, attributeChangeTracker, originalText)) {
            this.cache.remove((Object)instanceID);
            return null;
        }
        return o;
    }

    private static class InternalResult
    extends Result {
        private long changeTracker;
        private long attrChangeTracker;
        private String originalText;

        protected InternalResult(RenderNode[] text, RenderNode[] finish, StyleSheet styleSheet, long styleChangeTracker, ReportAttributeMap attributeMap, long attrChangeTracker, String originalText) {
            super(text, finish, styleSheet, attributeMap);
            this.changeTracker = styleChangeTracker;
            this.attrChangeTracker = attrChangeTracker;
            this.originalText = originalText;
        }

        public boolean isValid(long changeTracker, long attrsChangeTracker, String text) {
            if (changeTracker != this.changeTracker) {
                return false;
            }
            if (attrsChangeTracker != this.attrChangeTracker) {
                return false;
            }
            return ObjectUtilities.equal((Object)text, (Object)this.originalText);
        }
    }

    public static class Result {
        private RenderNode[] text;
        private RenderNode[] finish;
        private StyleSheet styleSheet;
        private ReportAttributeMap attributeMap;

        protected Result(RenderNode[] text, RenderNode[] finish, StyleSheet styleSheet, ReportAttributeMap attributeMap) {
            this.styleSheet = styleSheet;
            this.attributeMap = attributeMap;
            this.text = (RenderNode[])text.clone();
            this.finish = (RenderNode[])finish.clone();
        }

        public ReportAttributeMap getAttributeMap() {
            return this.attributeMap;
        }

        public StyleSheet getStyleSheet() {
            return this.styleSheet;
        }

        public RenderNode[] getText() {
            RenderNode[] nodes = (RenderNode[])this.text.clone();
            int nodeCount = nodes.length;
            for (int i = 0; i < nodeCount; ++i) {
                RenderNode node = nodes[i];
                nodes[i] = node.derive(true);
            }
            return nodes;
        }

        public RenderNode[] getFinish() {
            RenderNode[] nodes = (RenderNode[])this.finish.clone();
            int nodeCount = nodes.length;
            for (int i = 0; i < nodeCount; ++i) {
                RenderNode node = nodes[i];
                nodes[i] = node.derive(true);
            }
            return nodes;
        }
    }
}

