/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.model;

import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.util.TreeSet;
import org.pentaho.reporting.engine.classic.core.PageDefinition;
import org.pentaho.reporting.engine.classic.core.layout.model.PageGrid;
import org.pentaho.reporting.engine.classic.core.layout.model.PhysicalPageBox;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictGeomUtility;

public class DefaultPageGrid
implements PageGrid {
    private long[] horizontalBreaks;
    private long[] verticalBreaks;
    private long[] horizontalBreaksFull;
    private long[] verticalBreaksFull;
    private PageFormat[][] pageMapping;

    public DefaultPageGrid(PageDefinition pageDefinition) {
        Rectangle2D[] pagePositions = pageDefinition.getPagePositions();
        TreeSet<Double> horizontalPositions = new TreeSet<Double>();
        TreeSet<Double> verticalPositions = new TreeSet<Double>();
        int pagePosCount = pagePositions.length;
        for (int i = 0; i < pagePosCount; ++i) {
            Rectangle2D pagePosition = pagePositions[i];
            double minX = pagePosition.getMinX();
            double maxX = pagePosition.getMaxX();
            double minY = pagePosition.getMinY();
            double maxY = pagePosition.getMaxY();
            if (minX == maxX || maxY == minY) {
                throw new IllegalArgumentException("This page format is invalid, it has no imageable area.");
            }
            horizontalPositions.add(new Double(minX));
            horizontalPositions.add(new Double(maxX));
            verticalPositions.add(new Double(minY));
            verticalPositions.add(new Double(maxY));
        }
        this.horizontalBreaksFull = new long[horizontalPositions.size()];
        int pos = 0;
        for (Double value : horizontalPositions) {
            this.horizontalBreaksFull[pos] = StrictGeomUtility.toInternalValue(value);
            ++pos;
        }
        this.verticalBreaksFull = new long[verticalPositions.size()];
        pos = 0;
        for (Double value : verticalPositions) {
            this.verticalBreaksFull[pos] = StrictGeomUtility.toInternalValue(value);
            ++pos;
        }
        horizontalPositions.remove(new Double(0.0));
        verticalPositions.remove(new Double(0.0));
        this.horizontalBreaks = new long[horizontalPositions.size()];
        pos = 0;
        for (Double value : horizontalPositions) {
            this.horizontalBreaks[pos] = StrictGeomUtility.toInternalValue(value);
            ++pos;
        }
        this.verticalBreaks = new long[verticalPositions.size()];
        pos = 0;
        for (Double value : verticalPositions) {
            this.verticalBreaks[pos] = StrictGeomUtility.toInternalValue(value);
            ++pos;
        }
        int hbreakLength = this.horizontalBreaksFull.length;
        int vbreakLength = this.verticalBreaksFull.length;
        this.pageMapping = new PageFormat[vbreakLength - 1][hbreakLength - 1];
        for (int col = 0; col < hbreakLength; ++col) {
            long xPosition = this.horizontalBreaksFull[col];
            for (int row = 0; row < vbreakLength; ++row) {
                long yPosition = this.verticalBreaksFull[row];
                int idx = this.findPageFormat(pagePositions, xPosition, yPosition);
                if (idx < 0) continue;
                this.pageMapping[row][col] = pageDefinition.getPageFormat(idx);
            }
        }
    }

    private int findPageFormat(Rectangle2D[] positions, long xPosition, long yPosition) {
        int posCount = positions.length;
        for (int i = 0; i < posCount; ++i) {
            Rectangle2D rect = positions[i];
            if (StrictGeomUtility.toInternalValue(rect.getMinY()) != yPosition || StrictGeomUtility.toInternalValue(rect.getMinX()) != xPosition) continue;
            return i;
        }
        return -1;
    }

    public PhysicalPageBox getPage(int row, int col) {
        long offsetX = this.horizontalBreaksFull[col];
        long offsetY = this.verticalBreaksFull[row];
        PageFormat format = this.pageMapping[row][col];
        return new PhysicalPageBox(format, offsetX, offsetY);
    }

    public long[] getHorizontalBreaks() {
        return (long[])this.horizontalBreaks.clone();
    }

    public long[] getVerticalBreaks() {
        return (long[])this.verticalBreaks.clone();
    }

    public int getRowCount() {
        return this.verticalBreaks.length;
    }

    public int getColumnCount() {
        return this.horizontalBreaks.length;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public long getMaximumPageWidth() {
        return this.horizontalBreaks[this.horizontalBreaks.length - 1];
    }

    public long getMaximumPageHeight() {
        return this.verticalBreaks[this.verticalBreaks.length - 1];
    }
}

