/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.model;

import org.pentaho.reporting.engine.classic.core.ReportAttributeMap;
import org.pentaho.reporting.engine.classic.core.filter.types.AutoLayoutBoxType;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.context.NodeLayoutProperties;
import org.pentaho.reporting.engine.classic.core.states.ReportStateKey;

public final class FinishedRenderNode
extends RenderNode {
    private long layoutedWidth;
    private long layoutedHeight;
    private long marginsTop;
    private long marginsBottom;
    private boolean breakAfter;
    private ReportStateKey stateKey;

    public FinishedRenderNode(long layoutedWidth, long layoutedHeight, long marginsTop, long marginsBottom, boolean breakAfter) {
        this(layoutedWidth, layoutedHeight, marginsTop, marginsBottom, breakAfter, null);
    }

    public FinishedRenderNode(long layoutedWidth, long layoutedHeight, long marginsTop, long marginsBottom, boolean breakAfter, ReportStateKey stateKey) {
        super(AutoLayoutBoxType.INSTANCE, ReportAttributeMap.EMPTY_MAP, NodeLayoutProperties.GENERIC_PROPERTIES);
        if (layoutedWidth <= 0L) {
            throw new IllegalStateException("Layouted Width is less than zero: " + layoutedWidth);
        }
        if (layoutedHeight < 0L) {
            throw new IllegalStateException("Layouted Height is less than zero: " + layoutedHeight);
        }
        this.stateKey = stateKey;
        this.breakAfter = breakAfter;
        this.layoutedWidth = layoutedWidth;
        this.layoutedHeight = layoutedHeight;
        this.marginsBottom = marginsBottom;
        this.marginsTop = marginsTop;
        this.setFinishedPaginate(true);
        this.setFinishedTable(true);
    }

    public int getNodeType() {
        return 129;
    }

    public boolean isBreakAfter() {
        return this.breakAfter;
    }

    public long getLayoutedWidth() {
        return this.layoutedWidth;
    }

    public long getLayoutedHeight() {
        return this.layoutedHeight;
    }

    public long getMarginsTop() {
        return this.marginsTop;
    }

    public long getMarginsBottom() {
        return this.marginsBottom;
    }

    public boolean isIgnorableForRendering() {
        return false;
    }

    public void updateParent(RenderBox parent) {
        super.setParent(parent);
    }

    public ReportStateKey getStateKey() {
        return this.stateKey;
    }
}

