/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.model;

import org.pentaho.reporting.engine.classic.core.ElementAlignment;
import org.pentaho.reporting.engine.classic.core.ReportAttributeMap;
import org.pentaho.reporting.engine.classic.core.filter.types.AutoLayoutBoxType;
import org.pentaho.reporting.engine.classic.core.layout.model.BlockRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.ParagraphPoolBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderLength;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.context.BoxDefinition;
import org.pentaho.reporting.engine.classic.core.layout.style.ParagraphPoolboxStyleSheet;
import org.pentaho.reporting.engine.classic.core.metadata.ElementType;
import org.pentaho.reporting.engine.classic.core.states.ReportStateKey;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.style.TextStyleKeys;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;

public final class ParagraphRenderBox
extends BlockRenderBox {
    private ParagraphPoolBox pool;
    private LineBoxRenderBox lineboxContainer;
    private ElementAlignment textAlignment;
    private ElementAlignment lastLineAlignment;
    private long lineBoxAge;
    private long minorLayoutAge;
    private int poolSize;
    private Object rawValue;
    private long textIndent;
    private long firstLineIndent;

    public ParagraphRenderBox(StyleSheet styleSheet, InstanceID instanceID, BoxDefinition boxDefinition, ElementType elementType, ReportAttributeMap attributeMap, ReportStateKey stateKey) {
        super(styleSheet, instanceID, boxDefinition, elementType, attributeMap, stateKey);
        this.pool = new ParagraphPoolBox(new ParagraphPoolboxStyleSheet(styleSheet), instanceID, stateKey);
        this.pool.setParent(this);
        this.lastLineAlignment = this.textAlignment = (ElementAlignment)styleSheet.getStyleProperty(ElementStyleKeys.ALIGNMENT, ElementAlignment.LEFT);
        if (this.textAlignment == ElementAlignment.JUSTIFY) {
            this.lastLineAlignment = ElementAlignment.LEFT;
        }
        double rawTextIndent = styleSheet.getDoubleStyleProperty(TextStyleKeys.TEXT_INDENT, 0.0);
        double rawFirstLineIndent = styleSheet.getDoubleStyleProperty(TextStyleKeys.FIRST_LINE_INDENT, rawTextIndent);
        this.textIndent = RenderLength.resolveLength(0L, Math.max(0.0, rawTextIndent));
        this.firstLineIndent = RenderLength.resolveLength(0L, Math.max(0.0, rawFirstLineIndent));
    }

    public RenderNode derive(boolean deepDerive) {
        ParagraphRenderBox box = (ParagraphRenderBox)super.derive(deepDerive);
        box.pool = (ParagraphPoolBox)this.pool.derive(deepDerive);
        box.pool.setParent(box);
        if (this.lineboxContainer != null) {
            box.lineboxContainer = (LineBoxRenderBox)this.lineboxContainer.derive(deepDerive);
            box.lineboxContainer.setParent(box);
        }
        if (!deepDerive) {
            box.lineBoxAge = 0L;
        }
        return box;
    }

    public RenderNode hibernate() {
        ParagraphRenderBox box = (ParagraphRenderBox)super.derive(false);
        box.setHibernated(true);
        box.pool = (ParagraphPoolBox)this.pool.hibernate();
        box.pool.setParent(box);
        if (this.lineboxContainer != null) {
            box.lineboxContainer = (LineBoxRenderBox)this.lineboxContainer.hibernate();
        }
        box.lineBoxAge = 0L;
        return box;
    }

    public final void addChild(RenderNode child) {
        this.pool.addChild(child);
    }

    public final void clear() {
        this.pool.clear();
        if (this.lineboxContainer != null) {
            this.lineboxContainer.clear();
        }
        super.clear();
        this.lineBoxAge = 0L;
    }

    public final void clearLayout() {
        super.clear();
        this.minorLayoutAge = 0L;
    }

    public boolean isAppendable() {
        return this.pool.isAppendable();
    }

    public boolean isEmpty() {
        return this.pool.isEmpty();
    }

    public boolean isDiscardable() {
        return this.pool.isDiscardable();
    }

    public ElementAlignment getLastLineAlignment() {
        return this.lastLineAlignment;
    }

    public ElementAlignment getTextAlignment() {
        return this.textAlignment;
    }

    public RenderBox getLineboxContainer() {
        return this.lineboxContainer;
    }

    public boolean isComplexParagraph() {
        return this.lineboxContainer != null;
    }

    public RenderBox createLineboxContainer() {
        if (this.lineboxContainer == null) {
            this.lineboxContainer = new LineBoxRenderBox(this.pool.getStyleSheet(), this.getStateKey());
            this.lineboxContainer.setParent(this);
        }
        return this.lineboxContainer;
    }

    public RenderBox getEffectiveLineboxContainer() {
        if (this.lineboxContainer == null) {
            return this.pool;
        }
        return this.lineboxContainer;
    }

    public ParagraphPoolBox getPool() {
        return this.pool;
    }

    public long getLineBoxAge() {
        return this.lineBoxAge;
    }

    public void setLineBoxAge(long lineBoxAge) {
        this.lineBoxAge = lineBoxAge;
    }

    public long getMinorLayoutAge() {
        return this.minorLayoutAge;
    }

    public void setMinorLayoutAge(long minorLayoutAge) {
        this.minorLayoutAge = minorLayoutAge;
    }

    public InstanceID getInstanceId() {
        return this.pool.getInstanceId();
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
    }

    public void setRawValue(Object rawValue) {
        this.rawValue = rawValue;
    }

    public Object getRawValue() {
        return this.rawValue;
    }

    public void close() {
        this.pool.close();
        super.close();
    }

    public int getNodeType() {
        return 274;
    }

    protected void increaseContentReferenceCount(int count, RenderNode source) {
        if (source != this.pool) {
            return;
        }
        super.increaseContentReferenceCount(count, source);
    }

    protected void decreaseContentReferenceCount(int count, RenderNode source) {
        if (source != this.pool) {
            return;
        }
        super.decreaseContentReferenceCount(count, source);
    }

    public long getTextIndent() {
        return this.textIndent;
    }

    public long getFirstLineIndent() {
        return this.firstLineIndent;
    }

    private static class LineBoxRenderBox
    extends BlockRenderBox {
        protected LineBoxRenderBox(StyleSheet styleSheet, ReportStateKey stateKey) {
            super(styleSheet, new InstanceID(), BoxDefinition.EMPTY, AutoLayoutBoxType.INSTANCE, ReportAttributeMap.EMPTY_MAP, stateKey);
        }
    }
}

