/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.model;

import org.pentaho.reporting.engine.classic.core.ReportAttributeMap;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.context.BoxDefinition;
import org.pentaho.reporting.engine.classic.core.layout.model.context.StaticBoxLayoutProperties;
import org.pentaho.reporting.engine.classic.core.layout.text.ExtendedBaselineInfo;
import org.pentaho.reporting.engine.classic.core.metadata.ElementType;
import org.pentaho.reporting.engine.classic.core.states.ReportStateKey;
import org.pentaho.reporting.engine.classic.core.style.BandStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;

public abstract class RenderBox
extends RenderNode {
    public static final int NO_MANUAL_BREAK = 0;
    public static final int DIRECT_MANUAL_BREAK = 1;
    public static final int INDIRECT_MANUAL_BREAK = 2;
    private long contentAreaX1;
    private long contentAreaX2;
    private BoxDefinition boxDefinition;
    private StaticBoxLayoutProperties staticBoxLayoutProperties;
    private RenderNode firstChildNode;
    private RenderNode lastChildNode;
    private boolean open;
    private ExtendedBaselineInfo baselineInfo;
    private String name;
    private int manualBreakIndicator;
    private long staticBoxPropertiesAge;
    private ReportStateKey stateKey;
    private RenderBox textEllipseBox;
    private Object tableExportState;
    private boolean markedSeen;
    private boolean markedOpen;
    private int markedContentRefCount;
    private long markedPinPosition;
    private boolean appliedSeen;
    private boolean appliedOpen;
    private int appliedContentRefCount;
    private long appliedPinPosition;
    private long pinned;
    private boolean deepFinished;
    private long contentAge;
    private Boolean contentBox;
    private int contentRefCount;
    private boolean autoGenerated;
    private Object breakContext;

    protected RenderBox(int majorAxis, int minorAxis, StyleSheet styleSheet, InstanceID instanceId, BoxDefinition boxDefinition, ElementType elementType, ReportAttributeMap attributes, ReportStateKey stateKey) {
        super(majorAxis, minorAxis, styleSheet, instanceId, elementType, attributes);
        if (boxDefinition == null) {
            throw new NullPointerException();
        }
        this.pinned = -1L;
        this.boxDefinition = boxDefinition;
        this.open = true;
        this.staticBoxLayoutProperties = new StaticBoxLayoutProperties();
        this.staticBoxPropertiesAge = -1L;
        this.staticBoxLayoutProperties.setBreakAfter(this.getStyleSheet().getBooleanStyleProperty(BandStyleKeys.PAGEBREAK_AFTER));
        this.stateKey = stateKey;
    }

    public boolean isAutoGenerated() {
        return this.autoGenerated;
    }

    public void setAutoGenerated(boolean autoGenerated) {
        this.autoGenerated = autoGenerated;
    }

    public boolean isSizeSpecifiesBorderBox() {
        return this.boxDefinition.isSizeSpecifiesBorderBox();
    }

    public RenderBox getTextEllipseBox() {
        return this.textEllipseBox;
    }

    public void setTextEllipseBox(RenderBox textEllipseBox) {
        this.textEllipseBox = textEllipseBox;
    }

    public ReportStateKey getStateKey() {
        return this.stateKey;
    }

    protected void setStateKey(ReportStateKey stateKey) {
        this.stateKey = stateKey;
    }

    public int getManualBreakIndicator() {
        return this.manualBreakIndicator;
    }

    public void setManualBreakIndicator(int manualBreakIndicator) {
        this.manualBreakIndicator = manualBreakIndicator;
    }

    public BoxDefinition getBoxDefinition() {
        return this.boxDefinition;
    }

    public long getInsets() {
        return this.staticBoxLayoutProperties.getBorderLeft() + this.staticBoxLayoutProperties.getBorderRight() + this.boxDefinition.getPaddingLeft() + this.boxDefinition.getPaddingRight();
    }

    public RenderNode getFirstChild() {
        return this.firstChildNode;
    }

    protected void setFirstChild(RenderNode firstChild) {
        this.firstChildNode = firstChild;
        if (RenderBox.isParanoidChecks() && firstChild != null && firstChild.getPrev() != null) {
            throw new NullPointerException();
        }
    }

    public RenderNode getLastChild() {
        return this.lastChildNode;
    }

    protected void setLastChild(RenderNode lastChild) {
        this.lastChildNode = lastChild;
        if (RenderBox.isParanoidChecks() && lastChild != null && lastChild.getNext() != null) {
            throw new NullPointerException();
        }
    }

    public void addGeneratedChild(RenderNode child) {
        if (child == null) {
            throw new NullPointerException("Child to be added must not be null.");
        }
        if (this.isHibernated()) {
            throw new IllegalStateException("Check your state management, you've messed with an hibernated element.");
        }
        RenderNode oldLastChild = this.getLastChild();
        this.setLastChild(child);
        if (oldLastChild != null) {
            oldLastChild.setNext(child);
        }
        child.setParent(this);
        child.setPrev(oldLastChild);
        child.setNext(null);
        RenderNode oldFirstChild = this.getFirstChild();
        if (oldFirstChild == null) {
            this.setFirstChild(child);
        }
        if (this.isFrozen()) {
            child.freeze();
        }
        child.updateChangeTracker();
        this.increaseContentReferenceCount(child.getContentRefCount(), child);
    }

    public void addChild(RenderNode child) {
        if (child == null) {
            throw new NullPointerException("Child to be added must not be null.");
        }
        if (!this.isOpen()) {
            throw new IllegalStateException("Adding content to an already closed element: " + this);
        }
        if (this.isHibernated()) {
            throw new IllegalStateException("Check your state management. You tried to modify a hibernated element.");
        }
        if (RenderBox.isParanoidChecks() && (this.getNodeType() & 0x12) == 18 && (child.getNodeType() & 0x42) == 66) {
            throw new IllegalStateException("Paranoid Check: A block box cannot contain a inline box directly. They must be wrapped into a paragraph.");
        }
        RenderNode oldLastChild = this.getLastChild();
        this.setLastChild(child);
        if (oldLastChild != null) {
            oldLastChild.setNext(child);
        }
        child.setParent(this);
        child.setPrev(oldLastChild);
        child.setNext(null);
        RenderNode oldFirstChild = this.getFirstChild();
        if (oldFirstChild == null) {
            this.setFirstChild(child);
        }
        if (this.isFrozen()) {
            child.freeze();
        }
        child.updateChangeTracker();
        this.increaseContentReferenceCount(child.getContentRefCount(), child);
    }

    protected void increaseContentReferenceCount(int count, RenderNode source) {
        if (count < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (count == 0) {
            return;
        }
        this.contentRefCount += count;
        RenderBox renderBox = this.getParent();
        if (renderBox != null) {
            renderBox.increaseContentReferenceCount(count, this);
        }
    }

    protected void decreaseContentReferenceCount(int count, RenderNode source) {
        if (count < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (count == 0) {
            return;
        }
        if (this.contentRefCount - count < 0) {
            throw new IndexOutOfBoundsException("New ContentRefCount would be negative");
        }
        this.contentRefCount -= count;
        RenderBox renderBox = this.getParent();
        if (renderBox != null) {
            renderBox.decreaseContentReferenceCount(count, this);
        }
    }

    public int getContentRefCount() {
        return this.contentRefCount;
    }

    public void replaceChild(RenderNode old, RenderNode replacement) {
        RenderNode oldLastChild;
        if (old.getParent() != this) {
            throw new IllegalArgumentException("None of my childs.");
        }
        if (old == replacement) {
            return;
        }
        RenderNode oldFirstChild = this.getFirstChild();
        if (old == oldFirstChild) {
            this.setFirstChild(replacement);
        }
        if (old == (oldLastChild = this.getLastChild())) {
            this.setLastChild(replacement);
        }
        RenderNode prev = old.getPrev();
        RenderNode next = old.getNext();
        replacement.setParent(this);
        replacement.setPrev(prev);
        replacement.setNext(next);
        if (prev != null) {
            prev.setNext(replacement);
        }
        if (next != null) {
            next.setPrev(replacement);
        }
        old.setNext(null);
        old.setPrev(null);
        old.setParent(null);
        old.updateChangeTracker();
        this.decreaseContentReferenceCount(old.getContentRefCount(), old);
        replacement.updateChangeTracker();
        this.increaseContentReferenceCount(replacement.getContentRefCount(), replacement);
        if (RenderBox.isParanoidChecks() && replacement.getNext() == null && this.getLastChild() != replacement) {
            throw new IllegalStateException();
        }
    }

    public void replaceChilds(RenderNode old, RenderNode[] replacement) {
        int i;
        if (old.getParent() != this) {
            throw new IllegalArgumentException("None of my childs.");
        }
        int replacementCount = replacement.length;
        if (replacementCount == 0) {
            throw new IndexOutOfBoundsException("Array is empty ..");
        }
        if (old == replacement[0] && replacementCount == 1) {
            return;
        }
        RenderNode oldPrev = old.getPrev();
        RenderNode oldNext = old.getNext();
        old.setNext(null);
        old.setPrev(null);
        old.setParent(null);
        RenderNode first = null;
        RenderNode last = null;
        for (i = 0; i < replacementCount; ++i) {
            if (last == null) {
                last = replacement[i];
                if (last == null) continue;
                first = last;
                first.setParent(this);
                continue;
            }
            RenderNode node = replacement[i];
            last.setNextUnchecked(node);
            node.setPrevUnchecked(last);
            node.setParent(this);
            last = node;
        }
        if (first == null) {
            throw new IndexOutOfBoundsException("Array is empty (NullValues stripped)..");
        }
        if (old == this.getFirstChild()) {
            this.setFirstChild(first);
        }
        if (old == this.getLastChild()) {
            this.setLastChild(last);
        }
        first.setPrev(oldPrev);
        last.setNext(oldNext);
        if (oldPrev != null) {
            oldPrev.setNext(first);
        }
        if (oldNext != null) {
            oldNext.setPrev(last);
        }
        old.updateChangeTracker();
        this.decreaseContentReferenceCount(old.getContentRefCount(), old);
        for (i = 0; i < replacementCount; ++i) {
            RenderNode renderNode = replacement[i];
            renderNode.updateChangeTracker();
            this.increaseContentReferenceCount(renderNode.getContentRefCount(), renderNode);
        }
    }

    public RenderNode derive(boolean deepDerive) {
        RenderBox box = (RenderBox)super.derive(deepDerive);
        if (deepDerive) {
            RenderNode currentNode = null;
            for (RenderNode node = this.getFirstChild(); node != null; node = node.getNext()) {
                RenderNode previous = currentNode;
                currentNode = node.derive(true);
                currentNode.setParent(box);
                if (previous == null) {
                    if (RenderBox.isParanoidChecks() && currentNode.getPrev() != null) {
                        throw new IllegalStateException();
                    }
                    box.setFirstChild(currentNode);
                    continue;
                }
                previous.setNext(currentNode);
                currentNode.setPrev(previous);
            }
            box.setLastChild(currentNode);
            if (RenderBox.isParanoidChecks() && currentNode != null && currentNode.getNext() != null) {
                throw new IllegalStateException();
            }
        } else {
            box.setLastChild(null);
            box.setFirstChild(null);
            box.contentRefCount = 0;
        }
        return box;
    }

    public RenderNode hibernate() {
        RenderBox box = (RenderBox)super.hibernate();
        RenderNode currentNode = null;
        for (RenderNode node = this.getFirstChild(); node != null; node = node.getNext()) {
            RenderNode previous = currentNode;
            currentNode = node.hibernate();
            currentNode.setParent(box);
            if (previous == null) {
                if (RenderBox.isParanoidChecks() && currentNode.getPrev() != null) {
                    throw new IllegalStateException();
                }
                box.setFirstChild(currentNode);
                continue;
            }
            previous.setNext(currentNode);
            currentNode.setPrev(previous);
        }
        box.setLastChild(currentNode);
        if (RenderBox.isParanoidChecks() && currentNode != null && currentNode.getNext() != null) {
            throw new IllegalStateException();
        }
        return box;
    }

    public RenderNode deriveFrozen(boolean deepDerive) {
        RenderBox box = (RenderBox)super.deriveFrozen(deepDerive);
        if (deepDerive) {
            RenderNode currentNode = null;
            for (RenderNode node = this.getFirstChild(); node != null; node = node.getNext()) {
                RenderNode previous = currentNode;
                currentNode = node.deriveFrozen(true);
                currentNode.setParent(box);
                if (previous == null) {
                    if (RenderBox.isParanoidChecks() && currentNode.getPrev() != null) {
                        throw new IllegalStateException();
                    }
                    box.setFirstChild(currentNode);
                    continue;
                }
                previous.setNext(currentNode);
                currentNode.setPrev(previous);
            }
            box.setLastChild(currentNode);
            if (RenderBox.isParanoidChecks() && currentNode != null && currentNode.getNext() != null) {
                throw new IllegalStateException();
            }
        } else {
            box.setLastChild(null);
            box.setFirstChild(null);
        }
        return box;
    }

    public void addChilds(RenderNode[] nodes) {
        int length = nodes.length;
        for (int i = 0; i < length; ++i) {
            this.addChild(nodes[i]);
        }
    }

    public void addGeneratedChilds(RenderNode[] nodes) {
        int nodeLength = nodes.length;
        for (int i = 0; i < nodeLength; ++i) {
            this.addGeneratedChild(nodes[i]);
        }
    }

    public RenderNode findNodeById(Object instanceId) {
        if (instanceId == this.getInstanceId()) {
            return this;
        }
        for (RenderNode child = this.getLastChild(); child != null; child = child.getPrev()) {
            RenderNode nodeById = child.findNodeById(instanceId);
            if (nodeById == null) continue;
            return nodeById;
        }
        return null;
    }

    public boolean isAppendable() {
        return this.isOpen();
    }

    public void clear() {
        RenderNode child = this.getFirstChild();
        while (child != null) {
            RenderNode nextChild = child.getNext();
            child.setPrev(null);
            child.setNext(null);
            child.setParent(null);
            child = nextChild;
        }
        this.setFirstChild(null);
        this.setLastChild(null);
        this.updateChangeTracker();
    }

    protected void updateChangeTracker() {
        this.tableExportState = null;
        super.updateChangeTracker();
    }

    private RenderNode getFirstNonEmpty() {
        for (RenderNode firstChild = this.getFirstChild(); firstChild != null; firstChild = firstChild.getNext()) {
            if (firstChild.isEmpty()) continue;
            return firstChild;
        }
        return null;
    }

    public boolean isEmpty() {
        if (!this.getBoxDefinition().isEmpty()) {
            return false;
        }
        RenderNode node = this.getFirstNonEmpty();
        return node == null;
    }

    public boolean isDiscardable() {
        if (!this.getBoxDefinition().isEmpty()) {
            return false;
        }
        if (this.getStyleSheet().getStyleProperty(ElementStyleKeys.BACKGROUND_COLOR) != null) {
            return false;
        }
        for (RenderNode node = this.getFirstChild(); node != null; node = node.getNext()) {
            if (node.isDiscardable()) continue;
            return false;
        }
        return true;
    }

    public void close() {
        if (!this.isOpen()) {
            throw new IllegalStateException("Double close..");
        }
        if (this.isHibernated()) {
            throw new IllegalStateException("Check your state management. You tried to mess with an hibernated element.");
        }
        this.open = false;
    }

    public void remove(RenderNode child) {
        this.removeGenerated(child);
        this.decreaseContentReferenceCount(child.getContentRefCount(), child);
    }

    public void removeGenerated(RenderNode child) {
        RenderBox parent = child.getParent();
        if (parent != this) {
            throw new IllegalArgumentException("None of my childs");
        }
        RenderNode prev = child.getPrev();
        RenderNode next = child.getNext();
        if (prev != null) {
            prev.setNext(next);
        }
        if (next != null) {
            next.setPrev(prev);
        }
        child.setNext(null);
        child.setPrev(null);
        child.setParent(null);
        if (this.getFirstChild() == child) {
            this.setFirstChild(next);
        }
        if (this.getLastChild() == child) {
            this.setLastChild(prev);
        }
        child.updateChangeTracker();
        this.updateChangeTracker();
    }

    public boolean isOpen() {
        return this.open || this.contentRefCount > 0;
    }

    public void freeze() {
        if (this.isFrozen()) {
            return;
        }
        super.freeze();
        for (RenderNode node = this.getFirstChild(); node != null; node = node.getNext()) {
            node.freeze();
        }
    }

    public RenderBox split(int axis) {
        RenderBox otherBox = (RenderBox)this.derive(false);
        if (!this.boxDefinition.isEmpty()) {
            BoxDefinition[] boxDefinitions = this.boxDefinition.split(axis);
            this.boxDefinition = boxDefinitions[0];
            otherBox.boxDefinition = boxDefinitions[1];
        }
        return otherBox;
    }

    public long getContentAreaX1() {
        return this.contentAreaX1;
    }

    public void setContentAreaX1(long contentAreaX1) {
        this.contentAreaX1 = contentAreaX1;
    }

    public long getContentAreaX2() {
        return this.contentAreaX2;
    }

    public void setContentAreaX2(long contentAreaX2) {
        this.contentAreaX2 = contentAreaX2;
    }

    public StaticBoxLayoutProperties getStaticBoxLayoutProperties() {
        return this.staticBoxLayoutProperties;
    }

    public ExtendedBaselineInfo getBaselineInfo() {
        return this.baselineInfo;
    }

    public void setBaselineInfo(ExtendedBaselineInfo baselineInfo) {
        this.baselineInfo = baselineInfo;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isBreakAfter() {
        return this.staticBoxLayoutProperties.isBreakAfter();
    }

    public long getStaticBoxPropertiesAge() {
        return this.staticBoxPropertiesAge;
    }

    public void setStaticBoxPropertiesAge(long staticBoxPropertiesAge) {
        if (this.staticBoxLayoutProperties.getNominalBaselineInfo() == null) {
            throw new IllegalStateException("Assertation: Cannot declare static-properties finished without a nominal baseline info");
        }
        this.staticBoxPropertiesAge = staticBoxPropertiesAge;
    }

    public String toString() {
        return this.getClass().getName() + '{' + "name='" + this.name + '\'' + ", x='" + this.getX() + '\'' + ", y='" + this.getY() + '\'' + ", width='" + this.getWidth() + '\'' + ", height='" + this.getHeight() + '\'' + ", hexId='" + System.identityHashCode(this) + '\'' + ", finishedPaginate='" + this.isFinishedPaginate() + '\'' + ", finishedTable='" + this.isFinishedTable() + '\'' + ", commited='" + this.isCommited() + '\'' + '}';
    }

    public void markCacheClean() {
        super.markCacheClean();
        this.staticBoxPropertiesAge = this.getChangeTracker();
    }

    public void commitApplyMark() {
        this.appliedPinPosition = this.markedPinPosition;
        this.appliedOpen = this.markedOpen;
        this.appliedSeen = this.markedSeen;
        this.appliedContentRefCount = this.markedContentRefCount;
    }

    public int getAppliedContentRefCount() {
        return this.appliedContentRefCount;
    }

    public boolean isAppliedOpen() {
        return this.appliedOpen;
    }

    public boolean isAppliedSeen() {
        return this.appliedSeen;
    }

    public boolean isMarkedOpen() {
        return this.markedOpen;
    }

    public boolean isMarkedSeen() {
        return this.markedSeen;
    }

    public void markBoxSeen() {
        this.markedOpen = this.open;
        this.markedContentRefCount = this.contentRefCount;
        this.markedSeen = true;
        this.markedPinPosition = this.pinned;
    }

    public boolean isCommited() {
        return !this.appliedOpen && this.appliedSeen && this.appliedContentRefCount == 0;
    }

    public void reopenAfterRollback(boolean deepDirty) {
        this.open = this.appliedOpen;
        this.contentRefCount = this.appliedContentRefCount;
        this.markedOpen = this.appliedOpen;
        this.markedContentRefCount = this.appliedContentRefCount;
        this.markedPinPosition = this.appliedPinPosition;
        this.resetCacheState(deepDirty);
    }

    protected void makeReusable() {
        this.open = true;
        this.markedContentRefCount = 0;
        this.markedOpen = false;
        this.markedSeen = false;
        this.markedPinPosition = -1L;
        this.appliedContentRefCount = 0;
        this.appliedOpen = false;
        this.appliedSeen = false;
        this.appliedPinPosition = -1L;
        this.resetCacheState(false);
    }

    public void resetCacheState(boolean deepDirty) {
        this.setCachedAge(-1L);
        if (deepDirty) {
            this.updateCacheState(2);
        } else {
            this.updateCacheState(1);
        }
        this.updateChangeTracker();
    }

    public long getComputedWidth() {
        return this.staticBoxLayoutProperties.getComputedWidth();
    }

    public void setComputedWidth(long computedWidth) {
        this.staticBoxLayoutProperties.setComputedWidth(computedWidth);
    }

    public boolean isDeepFinished() {
        return this.deepFinished;
    }

    public void setDeepFinished(boolean deepFinished) {
        this.deepFinished = deepFinished;
    }

    public void setContentAge(long contentAge) {
        this.contentAge = contentAge;
    }

    public long getContentAge() {
        return this.contentAge;
    }

    public Boolean getContentBox() {
        return this.contentBox;
    }

    public void setContentBox(Boolean contentBox) {
        this.contentBox = contentBox;
    }

    public Object getTableExportState() {
        return this.tableExportState;
    }

    public void setTableExportState(Object tableExportState) {
        this.tableExportState = tableExportState;
    }

    public void markPinned(long pinPosition) {
        if (this.isPinned()) {
            return;
        }
        this.pinned = pinPosition;
        RenderBox renderBox = this.getParent();
        if (renderBox != null) {
            renderBox.markPinned(pinPosition);
        }
    }

    public boolean isPinned() {
        return this.pinned != -1L;
    }

    public long getPinned() {
        return this.pinned;
    }

    public void setMinimumChunkWidth(long minimumChunkWidth) {
        super.setMinimumChunkWidth(minimumChunkWidth);
    }

    public boolean isBoxOverflowX() {
        return this.staticBoxLayoutProperties.isOverflowX();
    }

    public boolean isBoxOverflowY() {
        return this.staticBoxLayoutProperties.isOverflowY();
    }

    public Object getBreakContext() {
        return this.breakContext;
    }

    public void setBreakContext(Object breakContext) {
        this.breakContext = breakContext;
    }
}

