/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.model;

import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.ReportAttributeMap;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.context.NodeLayoutProperties;
import org.pentaho.reporting.engine.classic.core.metadata.ElementType;
import org.pentaho.reporting.engine.classic.core.states.ReportStateKey;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.style.VerticalTextAlign;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictBounds;
import org.pentaho.reporting.libraries.base.config.Configuration;

public abstract class RenderNode
implements Cloneable {
    private static Boolean paranoidModelChecks;
    public static final int HORIZONTAL_AXIS = 0;
    public static final int VERTICAL_AXIS = 1;
    public static final int CACHE_CLEAN = 0;
    public static final int CACHE_DIRTY = 1;
    public static final int CACHE_DEEP_DIRTY = 2;
    private long changeTracker;
    private RenderBox parentNode;
    private RenderNode nextNode;
    private RenderNode prevNode;
    private boolean frozen;
    private boolean hibernated;
    private long minimumChunkWidth;
    private long maximumBoxWidth;
    private NodeLayoutProperties nodeLayoutProperties;
    private long cachedAge;
    private long cachedParentWidth;
    private long cachedX;
    private long cachedY;
    private long cachedWidth;
    private long cachedHeight;
    private long x;
    private long y;
    private long width;
    private long height;
    private int cacheState;
    private boolean finishedPaginate;
    private boolean finishedTable;
    private boolean virtualNode;
    private ReportAttributeMap attributes;
    private ElementType elementType;

    protected static boolean isParanoidChecks() {
        if (paranoidModelChecks == null) {
            Configuration configuration = ClassicEngineBoot.getInstance().getGlobalConfig();
            paranoidModelChecks = "true".equals(configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.layout.ParanoidChecks")) ? Boolean.TRUE : Boolean.FALSE;
        }
        return paranoidModelChecks;
    }

    protected RenderNode(int majorAxis, int minorAxis, StyleSheet styleSheet, InstanceID instanceID, ElementType elementType, ReportAttributeMap attributes) {
        this(elementType, attributes, new NodeLayoutProperties(majorAxis, minorAxis, styleSheet, instanceID));
    }

    protected RenderNode(ElementType elementType, ReportAttributeMap attributes, NodeLayoutProperties nodeLayoutProperties) {
        if (attributes == null) {
            throw new NullPointerException();
        }
        if (nodeLayoutProperties == null) {
            throw new NullPointerException();
        }
        if (elementType == null) {
            throw new NullPointerException();
        }
        this.elementType = elementType;
        this.attributes = attributes;
        this.nodeLayoutProperties = nodeLayoutProperties;
        this.cacheState = 2;
    }

    public ElementType getElementType() {
        return this.elementType;
    }

    public ReportAttributeMap getAttributes() {
        return this.attributes;
    }

    public int getContentRefCount() {
        return 0;
    }

    public boolean isSizeSpecifiesBorderBox() {
        return true;
    }

    public abstract int getNodeType();

    public int getMinorAxis() {
        return this.nodeLayoutProperties.getMinorAxis();
    }

    public int getMajorAxis() {
        return this.nodeLayoutProperties.getMajorAxis();
    }

    public final NodeLayoutProperties getNodeLayoutProperties() {
        return this.nodeLayoutProperties;
    }

    public long getComputedWidth() {
        return 0L;
    }

    public final long getX() {
        return this.x;
    }

    public final void setX(long x) {
        this.x = x;
    }

    public final long getY() {
        return this.y;
    }

    public final void shift(long amount) {
        this.y += amount;
        this.updateCacheState(2);
    }

    public final void setY(long y) {
        this.y = y;
        this.updateCacheState(2);
    }

    protected final void updateCacheState(int state) {
        switch (state) {
            case 1: {
                if (this.cacheState != 0) break;
                this.cacheState = 1;
                RenderBox parent = this.getParent();
                if (parent == null) break;
                parent.updateCacheState(1);
                break;
            }
            case 2: {
                if (this.cacheState != 0) break;
                this.cacheState = 2;
                RenderBox parent = this.getParent();
                if (parent == null) break;
                parent.updateCacheState(1);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public final long getWidth() {
        return this.width;
    }

    public final void setWidth(long width) {
        if (width < 0L) {
            throw new IndexOutOfBoundsException("Width cannot be negative");
        }
        this.width = width;
        this.updateCacheState(1);
    }

    public final long getHeight() {
        return this.height;
    }

    public final void setHeight(long height) {
        if (height < 0L) {
            throw new IndexOutOfBoundsException("Height cannot be negative");
        }
        this.height = height;
        this.updateCacheState(1);
    }

    public final StyleSheet getStyleSheet() {
        return this.nodeLayoutProperties.getStyleSheet();
    }

    public InstanceID getInstanceId() {
        return this.nodeLayoutProperties.getInstanceId();
    }

    protected void updateChangeTracker() {
        RenderBox parent;
        ++this.changeTracker;
        if (this.cacheState == 0) {
            this.cacheState = 1;
        }
        if ((parent = this.getParent()) != null) {
            parent.updateChangeTracker();
        }
    }

    public final long getChangeTracker() {
        return this.changeTracker;
    }

    public final RenderBox getParent() {
        return this.parentNode;
    }

    protected final void setParent(RenderBox parent) {
        if (RenderNode.isParanoidChecks()) {
            RenderNode prev = this.getPrev();
            if (parent != null && prev == parent) {
                throw new IllegalStateException("Assertation failed: Cannot have a parent that is the same as a silbling.");
            }
            if (parent == null) {
                RenderNode next = this.getNext();
                if (next != null) {
                    throw new NullPointerException();
                }
                if (prev != null) {
                    throw new NullPointerException();
                }
            }
        }
        this.parentNode = parent;
    }

    public final RenderNode getPrev() {
        return this.prevNode;
    }

    protected final void setPrevUnchecked(RenderNode prev) {
        this.prevNode = prev;
    }

    protected final void setPrev(RenderNode prev) {
        this.prevNode = prev;
        if (RenderNode.isParanoidChecks() && prev != null) {
            RenderBox parent = this.getParent();
            if (prev == parent) {
                throw new IllegalStateException();
            }
            if (parent != null && parent.getFirstChild() == this) {
                throw new NullPointerException("Cannot have a prev node if the parent has me as first child.");
            }
        }
    }

    public final RenderNode getNext() {
        return this.nextNode;
    }

    protected final void setNextUnchecked(RenderNode next) {
        this.nextNode = next;
    }

    protected final void setNext(RenderNode next) {
        this.nextNode = next;
        if (RenderNode.isParanoidChecks() && next != null) {
            RenderBox parent = this.getParent();
            if (next == parent) {
                throw new IllegalStateException();
            }
            if (parent != null && parent.getLastChild() == this) {
                throw new NullPointerException("Cannot have a next-node, if the parent has me as last child.");
            }
        }
    }

    public LogicalPageBox getLogicalPage() {
        for (RenderNode parent = this; parent != null; parent = parent.getParent()) {
            if ((parent.getNodeType() & 0x412) != 1042) continue;
            return (LogicalPageBox)parent;
        }
        return null;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Clone failed for some reason.");
        }
    }

    public RenderNode derive(boolean deep) {
        RenderNode node = (RenderNode)this.clone();
        node.parentNode = null;
        node.nextNode = null;
        node.prevNode = null;
        node.hibernated = false;
        if (deep) {
            node.cachedAge = -1L;
            node.cacheState = 2;
        }
        return node;
    }

    public RenderNode hibernate() {
        RenderNode node = (RenderNode)this.clone();
        node.parentNode = null;
        node.nextNode = null;
        node.prevNode = null;
        node.hibernated = true;
        return node;
    }

    public RenderNode deriveFrozen(boolean deep) {
        RenderNode node = (RenderNode)this.clone();
        node.parentNode = null;
        node.nextNode = null;
        node.prevNode = null;
        node.frozen = true;
        node.hibernated = false;
        return node;
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public boolean isHibernated() {
        return this.hibernated;
    }

    protected void setHibernated(boolean hibernated) {
        this.hibernated = hibernated;
    }

    public RenderNode findNodeById(Object instanceId) {
        if (instanceId == this.getInstanceId()) {
            return this;
        }
        return null;
    }

    public boolean isOpen() {
        return false;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean isDiscardable() {
        return false;
    }

    public boolean isIgnorableForRendering() {
        return this.isEmpty();
    }

    public void freeze() {
        this.frozen = true;
    }

    public long getMaximumBoxWidth() {
        return this.maximumBoxWidth;
    }

    public void setMaximumBoxWidth(long maximumBoxWidth) {
        this.maximumBoxWidth = maximumBoxWidth;
    }

    public long getMinimumChunkWidth() {
        return this.minimumChunkWidth;
    }

    protected void setMinimumChunkWidth(long minimumChunkWidth) {
        if (minimumChunkWidth < 0L) {
            throw new IllegalArgumentException();
        }
        this.minimumChunkWidth = minimumChunkWidth;
    }

    public long getEffectiveMarginTop() {
        return 0L;
    }

    public long getEffectiveMarginBottom() {
        return 0L;
    }

    public VerticalTextAlign getVerticalTextAlignment() {
        return this.nodeLayoutProperties.getVerticalTextAlign();
    }

    public String getName() {
        return null;
    }

    public boolean isBreakAfter() {
        return false;
    }

    public final long getCachedAge() {
        return this.cachedAge;
    }

    public final void setCachedAge(long cachedAge) {
        this.cachedAge = cachedAge;
    }

    public final long getCachedParentWidth() {
        return this.cachedParentWidth;
    }

    public final void setCachedParentWidth(long cachedParentWidth) {
        this.cachedParentWidth = cachedParentWidth;
    }

    public final long getCachedX() {
        return this.cachedX;
    }

    public final void setCachedX(long cachedX) {
        this.cachedX = cachedX;
    }

    public final long getCachedY() {
        return this.cachedY;
    }

    public final void setCachedY(long cachedY) {
        this.cachedY = cachedY;
    }

    public final void shiftCached(long amount) {
        this.cachedY += amount;
    }

    public final long getCachedWidth() {
        return this.cachedWidth;
    }

    public final void setCachedWidth(long cachedWidth) {
        if (cachedWidth < 0L) {
            throw new IndexOutOfBoundsException("'cached width' cannot be negative.");
        }
        this.cachedWidth = cachedWidth;
    }

    public final long getCachedHeight() {
        return this.cachedHeight;
    }

    public final void setCachedHeight(long cachedHeight) {
        if (cachedHeight < 0L) {
            throw new IndexOutOfBoundsException("'cached height' cannot be negative.");
        }
        if (this.cacheState == 0 && this.cachedHeight > 0L && cachedHeight == 0L) {
            throw new IndexOutOfBoundsException("'cached height' cannot be set to null.");
        }
        this.cachedHeight = cachedHeight;
    }

    public void apply() {
        this.x = this.cachedX;
        this.y = this.cachedY;
        this.width = this.cachedWidth;
        this.height = this.cachedHeight;
        this.cachedAge = this.changeTracker;
        this.cacheState = 0;
        RenderBox parent = this.getParent();
        this.cachedParentWidth = parent == null ? 0L : parent.getWidth();
    }

    public final boolean isCacheValid() {
        if (this.cachedAge != this.changeTracker) {
            return false;
        }
        RenderBox parent = this.getParent();
        return !(parent == null ? this.cachedParentWidth != 0L : this.cachedParentWidth != parent.getWidth());
    }

    public boolean isFinishedPaginate() {
        return this.finishedPaginate;
    }

    public void setFinishedPaginate(boolean finished) {
        if (this.finishedPaginate && !finished) {
            throw new IllegalStateException("Cannot undo a finished-marker");
        }
        this.finishedPaginate = finished;
    }

    public boolean isFinishedTable() {
        return this.finishedTable;
    }

    public void setFinishedTable(boolean finished) {
        if (this.finishedTable && !finished) {
            throw new IllegalStateException("Cannot undo a finished-marker");
        }
        this.finishedTable = finished;
    }

    public int getCacheState() {
        return this.cacheState;
    }

    public void markCacheClean() {
        if (this.cachedY != this.y) {
            throw new IllegalStateException();
        }
        this.cacheState = 0;
    }

    public ReportStateKey getStateKey() {
        return null;
    }

    public boolean isBoxOverflowX() {
        return false;
    }

    public boolean isBoxOverflowY() {
        return false;
    }

    public final boolean isNodeVisible(StrictBounds drawArea, boolean overflowX, boolean overflowY) {
        long drawAreaX0 = drawArea.getX();
        long drawAreaY0 = drawArea.getY();
        return this.isNodeVisible(drawAreaX0, drawAreaY0, drawArea.getWidth(), drawArea.getHeight(), overflowX, overflowY);
    }

    public final boolean isNodeVisible(StrictBounds drawArea) {
        long drawAreaX0 = drawArea.getX();
        long drawAreaY0 = drawArea.getY();
        return this.isNodeVisible(drawAreaX0, drawAreaY0, drawArea.getWidth(), drawArea.getHeight());
    }

    public final boolean isNodeVisible(long drawAreaX0, long drawAreaY0, long drawAreaWidth, long drawAreaHeight) {
        return this.isNodeVisible(drawAreaX0, drawAreaY0, drawAreaWidth, drawAreaHeight, this.isBoxOverflowX(), this.isBoxOverflowY());
    }

    public final boolean isNodeVisible(long drawAreaX0, long drawAreaY0, long drawAreaWidth, long drawAreaHeight, boolean overflowX, boolean overflowY) {
        if (!this.getStyleSheet().getBooleanStyleProperty(ElementStyleKeys.VISIBLE)) {
            return false;
        }
        long drawAreaX1 = drawAreaX0 + drawAreaWidth;
        long drawAreaY1 = drawAreaY0 + drawAreaHeight;
        long x2 = this.x + this.width;
        long y2 = this.y + this.height;
        if (this.width == 0L) {
            if (x2 < drawAreaX0) {
                return false;
            }
            if (this.x > drawAreaX1) {
                return false;
            }
        } else if (!overflowX) {
            if (x2 <= drawAreaX0) {
                return false;
            }
            if (this.x >= drawAreaX1) {
                return false;
            }
        }
        if (this.height == 0L) {
            if (y2 < drawAreaY0) {
                return false;
            }
            if (this.y > drawAreaY1) {
                return false;
            }
        } else if (!overflowY) {
            if (y2 <= drawAreaY0) {
                return false;
            }
            if (this.y >= drawAreaY1) {
                return false;
            }
        }
        return true;
    }

    public boolean isVirtualNode() {
        return this.virtualNode;
    }

    public void setVirtualNode(boolean virtualNode) {
        this.virtualNode = virtualNode;
    }

    public final boolean isBoxVisible(StrictBounds drawArea) {
        return this.isBoxVisible(drawArea.getX(), drawArea.getY(), drawArea.getWidth(), drawArea.getHeight());
    }

    public final boolean isBoxVisible(long x, long y, long width, long height) {
        if (!this.isNodeVisible(x, y, width, height)) {
            return false;
        }
        RenderBox parent = this.getParent();
        if (parent == null) {
            return true;
        }
        StyleSheet styleSheet = this.getStyleSheet();
        if (styleSheet.getStyleProperty(ElementStyleKeys.ANCHOR_NAME) != null) {
            return true;
        }
        if (!parent.getStaticBoxLayoutProperties().isOverflowX()) {
            long parentX1 = parent.getX();
            long parentX2 = parentX1 + parent.getWidth();
            if (this.getWidth() == 0L) {
                return true;
            }
            long boxX1 = this.getX();
            long boxX2 = boxX1 + this.getWidth();
            if (boxX2 <= parentX1) {
                return false;
            }
            if (boxX1 >= parentX2) {
                return false;
            }
        }
        if (!parent.getStaticBoxLayoutProperties().isOverflowY()) {
            long parentY1 = parent.getY();
            long parentY2 = parentY1 + parent.getHeight();
            if (this.getHeight() == 0L) {
                return true;
            }
            long boxY1 = this.getY();
            long boxY2 = boxY1 + this.getHeight();
            if (boxY2 <= parentY1) {
                return false;
            }
            if (boxY1 >= parentY2) {
                return false;
            }
        }
        return true;
    }
}

