/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.model;

import java.awt.Dimension;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import org.pentaho.reporting.engine.classic.core.ImageContainer;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderLength;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorFeature;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictGeomUtility;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.factory.drawable.DrawableWrapper;

public final class RenderableReplacedContent {
    private static final long PHYSICAL_LIMIT = (long)StrictMath.pow(2.0, 52.0);
    private transient Object contentCached;
    private Object content;
    private ResourceKey source;
    private boolean imageResolutionMapping;
    private long contentWidth;
    private long contentHeight;
    private boolean keepAspectRatio;
    private RenderLength requestedWidth;
    private RenderLength requestedHeight;
    private RenderLength minimumWidth;
    private RenderLength minimumHeight;
    private RenderLength maximumWidth;
    private RenderLength maximumHeight;

    public RenderableReplacedContent(StyleSheet styleSheet, Object content, ResourceKey source, OutputProcessorMetaData metaData) {
        this.content = content;
        this.source = source;
        this.keepAspectRatio = styleSheet.getBooleanStyleProperty(ElementStyleKeys.KEEP_ASPECT_RATIO);
        this.minimumWidth = RenderLength.createFromRaw(styleSheet.getDoubleStyleProperty(ElementStyleKeys.MIN_WIDTH, 0.0));
        this.minimumHeight = RenderLength.createFromRaw(styleSheet.getDoubleStyleProperty(ElementStyleKeys.MIN_HEIGHT, 0.0));
        this.maximumWidth = RenderLength.createFromRaw(styleSheet.getDoubleStyleProperty(ElementStyleKeys.MAX_WIDTH, PHYSICAL_LIMIT));
        this.maximumHeight = RenderLength.createFromRaw(styleSheet.getDoubleStyleProperty(ElementStyleKeys.MAX_HEIGHT, PHYSICAL_LIMIT));
        Float prefWidth = (Float)styleSheet.getStyleProperty(ElementStyleKeys.WIDTH, null);
        this.requestedWidth = prefWidth != null ? RenderLength.createFromRaw(prefWidth.doubleValue()) : RenderLength.AUTO;
        Float prefHeight = (Float)styleSheet.getStyleProperty(ElementStyleKeys.HEIGHT, null);
        this.requestedHeight = prefHeight != null ? RenderLength.createFromRaw(prefHeight.doubleValue()) : RenderLength.AUTO;
        if (content instanceof ImageContainer) {
            this.imageResolutionMapping = metaData.isFeatureSupported(OutputProcessorFeature.IMAGE_RESOLUTION_MAPPING);
            double displayResolution = metaData.getNumericFeatureValue(OutputProcessorFeature.DEVICE_RESOLUTION);
            double correctionFactorPxToPoint = 72.0 / displayResolution;
            ImageContainer ir = (ImageContainer)content;
            double scaleX = ir.getScaleX();
            double scaleY = ir.getScaleY();
            if (this.imageResolutionMapping) {
                this.contentWidth = StrictGeomUtility.toInternalValue((double)ir.getImageWidth() * scaleX * correctionFactorPxToPoint);
                this.contentHeight = StrictGeomUtility.toInternalValue((double)ir.getImageHeight() * scaleY * correctionFactorPxToPoint);
            } else {
                this.contentWidth = StrictGeomUtility.toInternalValue((double)ir.getImageWidth() * scaleX);
                this.contentHeight = StrictGeomUtility.toInternalValue((double)ir.getImageHeight() * scaleY);
            }
        } else if (content instanceof DrawableWrapper) {
            DrawableWrapper edr = (DrawableWrapper)content;
            Dimension preferredSize = edr.getPreferredSize();
            if (preferredSize != null) {
                this.contentWidth = StrictGeomUtility.toInternalValue(preferredSize.getWidth());
                this.contentHeight = StrictGeomUtility.toInternalValue(preferredSize.getHeight());
            }
        } else if (content instanceof Shape) {
            Shape s = (Shape)content;
            Rectangle2D bounds2D = s.getBounds2D();
            this.contentWidth = StrictGeomUtility.toInternalValue(bounds2D.getWidth());
            this.contentHeight = StrictGeomUtility.toInternalValue(bounds2D.getHeight());
        }
    }

    public ResourceKey getSource() {
        return this.source;
    }

    public Object getRawObject() {
        return this.content;
    }

    public RenderLength getMinimumWidth() {
        return this.minimumWidth;
    }

    public RenderLength getMinimumHeight() {
        return this.minimumHeight;
    }

    public RenderLength getMaximumWidth() {
        return this.maximumWidth;
    }

    public RenderLength getMaximumHeight() {
        return this.maximumHeight;
    }

    public long getContentWidth() {
        return this.contentWidth;
    }

    public long getContentHeight() {
        return this.contentHeight;
    }

    public RenderLength getRequestedWidth() {
        return this.requestedWidth;
    }

    public RenderLength getRequestedHeight() {
        return this.requestedHeight;
    }

    public boolean isImageResolutionMapping() {
        return this.imageResolutionMapping;
    }

    public Object getContentCached() {
        return this.contentCached;
    }

    public void setContentCached(Object contentCached) {
        this.contentCached = contentCached;
    }

    public boolean isKeepAspectRatio() {
        return this.keepAspectRatio;
    }

    public String toString() {
        return "RenderableReplacedContent{, source=" + this.source + ", imageResolutionMapping=" + this.imageResolutionMapping + ", contentWidth=" + this.contentWidth + ", contentHeight=" + this.contentHeight + ", requestedWidth=" + this.requestedWidth + ", requestedHeight=" + this.requestedHeight + ", minimumWidth=" + this.minimumWidth + ", minimumHeight=" + this.minimumHeight + ", maximumWidth=" + this.maximumWidth + ", maximumHeight=" + this.maximumHeight + '}';
    }
}

