/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.model.context;

import org.pentaho.reporting.engine.classic.core.layout.model.Border;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderLength;

public final class BoxDefinition {
    public static final BoxDefinition EMPTY = new BoxDefinition().lock();
    public static final RenderLength DEFAULT_PREFERRED_WIDTH = RenderLength.createFromRaw(-100.0);
    private Boolean empty;
    private long paddingTop;
    private long paddingLeft;
    private long paddingBottom;
    private long paddingRight;
    private Border border = Border.EMPTY_BORDER;
    private RenderLength preferredHeight;
    private RenderLength preferredWidth = RenderLength.AUTO;
    private RenderLength minimumHeight;
    private RenderLength minimumWidth;
    private RenderLength marginTop;
    private RenderLength marginBottom;
    private RenderLength marginLeft;
    private RenderLength marginRight;
    private RenderLength maximumHeight;
    private RenderLength maximumWidth;
    private RenderLength fixedPosition;
    private boolean locked;
    private boolean sizeSpecifiesBorderBox = true;

    public BoxDefinition() {
        this.preferredHeight = RenderLength.AUTO;
        this.minimumHeight = RenderLength.EMPTY;
        this.minimumWidth = RenderLength.EMPTY;
        this.marginTop = RenderLength.EMPTY;
        this.marginLeft = RenderLength.EMPTY;
        this.marginBottom = RenderLength.EMPTY;
        this.marginRight = RenderLength.EMPTY;
        this.maximumWidth = RenderLength.AUTO;
        this.maximumHeight = RenderLength.AUTO;
        this.fixedPosition = RenderLength.AUTO;
    }

    public void setSizeSpecifiesBorderBox(boolean sizeSpecifiesBorderBox) {
        this.sizeSpecifiesBorderBox = sizeSpecifiesBorderBox;
    }

    public boolean isSizeSpecifiesBorderBox() {
        return this.sizeSpecifiesBorderBox;
    }

    public BoxDefinition lock() {
        this.locked = true;
        return this;
    }

    public BoxDefinition derive() {
        BoxDefinition retval = new BoxDefinition();
        retval.border = this.border;
        retval.preferredWidth = this.preferredWidth;
        retval.preferredHeight = this.preferredHeight;
        retval.minimumHeight = this.minimumHeight;
        retval.minimumWidth = this.minimumWidth;
        retval.marginTop = this.marginTop;
        retval.marginLeft = this.marginLeft;
        retval.marginBottom = this.marginBottom;
        retval.marginRight = this.marginRight;
        retval.maximumWidth = this.maximumWidth;
        retval.maximumHeight = this.maximumHeight;
        retval.fixedPosition = this.fixedPosition;
        retval.locked = this.locked;
        retval.empty = this.empty;
        return retval;
    }

    public RenderLength getFixedPosition() {
        return this.fixedPosition;
    }

    public void setFixedPosition(RenderLength fixedPosition) {
        if (this.locked) {
            throw new IllegalStateException();
        }
        if (fixedPosition == null) {
            throw new NullPointerException();
        }
        this.fixedPosition = fixedPosition;
        this.empty = null;
    }

    public Border getBorder() {
        return this.border;
    }

    public void setBorder(Border border) {
        if (this.locked) {
            throw new IllegalStateException();
        }
        if (border == null) {
            throw new NullPointerException();
        }
        this.border = border;
        this.empty = null;
    }

    public long getPaddingTop() {
        return this.paddingTop;
    }

    public void setPaddingTop(long paddingTop) {
        if (this.locked) {
            throw new IllegalStateException();
        }
        this.paddingTop = paddingTop;
        this.empty = null;
    }

    public long getPaddingLeft() {
        return this.paddingLeft;
    }

    public void setPaddingLeft(long paddingLeft) {
        if (this.locked) {
            throw new IllegalStateException();
        }
        this.paddingLeft = paddingLeft;
        this.empty = null;
    }

    public long getPaddingBottom() {
        return this.paddingBottom;
    }

    public void setPaddingBottom(long paddingBottom) {
        if (this.locked) {
            throw new IllegalStateException();
        }
        this.paddingBottom = paddingBottom;
        this.empty = null;
    }

    public long getPaddingRight() {
        return this.paddingRight;
    }

    public void setPaddingRight(long paddingRight) {
        if (this.locked) {
            throw new IllegalStateException();
        }
        this.paddingRight = paddingRight;
        this.empty = null;
    }

    public RenderLength getPreferredHeight() {
        return this.preferredHeight;
    }

    public void setPreferredHeight(RenderLength preferredHeight) {
        if (this.locked) {
            throw new IllegalStateException();
        }
        if (preferredHeight == null) {
            throw new NullPointerException();
        }
        this.preferredHeight = preferredHeight;
    }

    public RenderLength getPreferredWidth() {
        return this.preferredWidth;
    }

    public void setPreferredWidth(RenderLength preferredWidth) {
        if (this.locked) {
            throw new IllegalStateException();
        }
        if (preferredWidth == null) {
            throw new NullPointerException();
        }
        this.preferredWidth = preferredWidth;
    }

    public RenderLength getMinimumHeight() {
        return this.minimumHeight;
    }

    public void setMinimumHeight(RenderLength minimumHeight) {
        if (this.locked) {
            throw new IllegalStateException();
        }
        if (minimumHeight == null) {
            throw new NullPointerException();
        }
        this.minimumHeight = minimumHeight;
    }

    public RenderLength getMinimumWidth() {
        return this.minimumWidth;
    }

    public void setMinimumWidth(RenderLength minimumWidth) {
        if (this.locked) {
            throw new IllegalStateException();
        }
        if (minimumWidth == null) {
            throw new NullPointerException();
        }
        this.minimumWidth = minimumWidth;
    }

    public RenderLength getMaximumHeight() {
        return this.maximumHeight;
    }

    public void setMaximumHeight(RenderLength maximumHeight) {
        if (this.locked) {
            throw new IllegalStateException();
        }
        if (maximumHeight == null) {
            throw new NullPointerException();
        }
        this.maximumHeight = maximumHeight;
    }

    public RenderLength getMaximumWidth() {
        return this.maximumWidth;
    }

    public void setMaximumWidth(RenderLength maximumWidth) {
        if (this.locked) {
            throw new IllegalStateException();
        }
        if (maximumWidth == null) {
            throw new NullPointerException();
        }
        this.maximumWidth = maximumWidth;
    }

    public RenderLength getMarginTop() {
        return this.marginTop;
    }

    public void setMarginTop(RenderLength marginTop) {
        if (this.locked) {
            throw new IllegalStateException();
        }
        if (marginTop == null) {
            throw new NullPointerException();
        }
        this.marginTop = marginTop;
        this.empty = null;
    }

    public RenderLength getMarginBottom() {
        return this.marginBottom;
    }

    public void setMarginBottom(RenderLength marginBottom) {
        if (this.locked) {
            throw new IllegalStateException();
        }
        if (marginBottom == null) {
            throw new NullPointerException();
        }
        this.marginBottom = marginBottom;
        this.empty = null;
    }

    public RenderLength getMarginLeft() {
        return this.marginLeft;
    }

    public void setMarginLeft(RenderLength marginLeft) {
        if (this.locked) {
            throw new IllegalStateException();
        }
        if (marginLeft == null) {
            throw new NullPointerException();
        }
        this.marginLeft = marginLeft;
        this.empty = null;
    }

    public RenderLength getMarginRight() {
        return this.marginRight;
    }

    public void setMarginRight(RenderLength marginRight) {
        if (this.locked) {
            throw new IllegalStateException();
        }
        if (marginRight == null) {
            throw new NullPointerException();
        }
        this.marginRight = marginRight;
        this.empty = null;
    }

    public boolean isEmpty() {
        if (this.empty != null) {
            return this.empty;
        }
        if (this.paddingTop != 0L) {
            this.empty = Boolean.FALSE;
            return false;
        }
        if (this.paddingLeft != 0L) {
            this.empty = Boolean.FALSE;
            return false;
        }
        if (this.paddingBottom != 0L) {
            this.empty = Boolean.FALSE;
            return false;
        }
        if (this.paddingRight != 0L) {
            this.empty = Boolean.FALSE;
            return false;
        }
        if (this.fixedPosition != null && !RenderLength.AUTO.equals(this.fixedPosition)) {
            this.empty = Boolean.FALSE;
            return false;
        }
        if (!this.border.isEmpty()) {
            this.empty = Boolean.FALSE;
            return false;
        }
        this.empty = Boolean.TRUE;
        return true;
    }

    public BoxDefinition[] split(int axis) {
        if (axis == 0) {
            return this.splitVertically();
        }
        return this.splitHorizontally();
    }

    private BoxDefinition[] splitVertically() {
        Border[] borders = this.border.splitVertically(null);
        BoxDefinition first = new BoxDefinition();
        first.marginTop = this.marginTop;
        first.marginLeft = this.marginLeft;
        first.marginBottom = this.marginBottom;
        first.marginRight = RenderLength.EMPTY;
        first.paddingBottom = this.paddingBottom;
        first.paddingTop = this.paddingTop;
        first.paddingLeft = this.paddingLeft;
        first.paddingRight = 0L;
        first.border = borders[0];
        first.preferredHeight = this.preferredHeight;
        first.preferredWidth = this.preferredWidth;
        first.minimumHeight = this.minimumHeight;
        first.minimumWidth = this.minimumWidth;
        first.maximumHeight = this.maximumHeight;
        first.maximumWidth = this.maximumWidth;
        first.fixedPosition = this.fixedPosition;
        BoxDefinition second = new BoxDefinition();
        second.marginTop = this.marginTop;
        second.marginLeft = RenderLength.EMPTY;
        second.marginBottom = this.marginBottom;
        second.marginRight = this.marginRight;
        second.paddingBottom = this.paddingBottom;
        second.paddingTop = this.paddingTop;
        second.paddingLeft = 0L;
        second.paddingRight = this.paddingRight;
        second.border = borders[1];
        second.preferredHeight = this.preferredHeight;
        second.preferredWidth = this.preferredWidth;
        second.minimumHeight = this.minimumHeight;
        second.minimumWidth = this.minimumWidth;
        second.maximumHeight = this.maximumHeight;
        second.maximumWidth = this.maximumWidth;
        second.fixedPosition = RenderLength.AUTO;
        BoxDefinition[] boxes = new BoxDefinition[]{first, second};
        return boxes;
    }

    private BoxDefinition[] splitHorizontally() {
        Border[] borders = this.border.splitHorizontally(null);
        BoxDefinition first = new BoxDefinition();
        first.marginTop = this.marginTop;
        first.marginLeft = this.marginLeft;
        first.marginBottom = RenderLength.EMPTY;
        first.marginRight = this.marginRight;
        first.paddingBottom = 0L;
        first.paddingTop = this.paddingTop;
        first.paddingLeft = this.paddingLeft;
        first.paddingRight = this.paddingRight;
        first.border = borders[0];
        first.preferredHeight = this.preferredHeight;
        first.preferredWidth = this.preferredWidth;
        first.minimumHeight = this.minimumHeight;
        first.minimumWidth = this.minimumWidth;
        first.maximumHeight = this.maximumHeight;
        first.maximumWidth = this.maximumWidth;
        first.fixedPosition = this.fixedPosition;
        BoxDefinition second = new BoxDefinition();
        second.marginTop = RenderLength.EMPTY;
        second.marginLeft = this.marginLeft;
        second.marginBottom = this.marginBottom;
        second.marginRight = this.marginRight;
        second.paddingBottom = this.paddingBottom;
        second.paddingTop = 0L;
        second.paddingLeft = this.paddingLeft;
        second.paddingRight = this.paddingRight;
        second.border = borders[1];
        second.preferredHeight = this.preferredHeight;
        second.preferredWidth = this.preferredWidth;
        second.minimumHeight = this.minimumHeight;
        second.minimumWidth = this.minimumWidth;
        second.maximumHeight = this.maximumHeight;
        second.maximumWidth = this.maximumWidth;
        second.fixedPosition = this.fixedPosition;
        BoxDefinition[] boxes = new BoxDefinition[]{first, second};
        return boxes;
    }

    public String toString() {
        return "BoxDefinition{minimumHeight=" + this.minimumHeight + ", minimumWidth=" + this.minimumWidth + ", preferredHeight=" + this.preferredHeight + ", preferredWidth=" + this.preferredWidth + ", maximumHeight=" + this.maximumHeight + ", maximumWidth=" + this.maximumWidth + ", marginTop=" + this.marginTop + ", marginBottom=" + this.marginBottom + ", marginLeft=" + this.marginLeft + ", marginRight=" + this.marginRight + ", paddingTop=" + this.paddingTop + ", paddingLeft=" + this.paddingLeft + ", paddingBottom=" + this.paddingBottom + ", paddingRight=" + this.paddingRight + ", border=" + this.border + '}';
    }
}

