/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.model.context;

import java.awt.Color;
import org.pentaho.reporting.engine.classic.core.layout.model.Border;
import org.pentaho.reporting.engine.classic.core.layout.model.BorderCorner;
import org.pentaho.reporting.engine.classic.core.layout.model.BorderEdge;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderLength;
import org.pentaho.reporting.engine.classic.core.layout.model.context.BoxDefinition;
import org.pentaho.reporting.engine.classic.core.style.BandStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.BorderStyle;
import org.pentaho.reporting.engine.classic.core.style.BoxSizing;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictGeomUtility;
import org.pentaho.reporting.libraries.base.util.LFUMap;

public final class BoxDefinitionFactory {
    private LFUMap cache = new LFUMap(500);

    public BoxDefinition getBoxDefinition(StyleSheet es) {
        InstanceID id = es.getId();
        CacheKey key = new CacheKey(id, es.getClass().getName());
        CacheCarrier cc = (CacheCarrier)this.cache.get((Object)key);
        if (cc == null) {
            BoxDefinition boxDefinition = this.createBoxDefinition(es);
            this.cache.put((Object)key, (Object)new CacheCarrier(es.getChangeTracker(), boxDefinition));
            return boxDefinition;
        }
        if (cc.getChangeTracker() != es.getChangeTracker()) {
            BoxDefinition boxDefinition = this.createBoxDefinition(es);
            this.cache.put((Object)key, (Object)new CacheCarrier(es.getChangeTracker(), boxDefinition));
            return boxDefinition;
        }
        return cc.getBoxDefinition();
    }

    private BoxDefinition createBoxDefinition(StyleSheet style) {
        BoxDefinition box = new BoxDefinition();
        box.setPreferredWidth(this.produceFromStyle(style, ElementStyleKeys.WIDTH, RenderLength.AUTO));
        box.setPreferredHeight(this.produceFromStyle(style, ElementStyleKeys.HEIGHT, RenderLength.AUTO));
        box.setMinimumWidth(this.produceFromStyle(style, ElementStyleKeys.MIN_WIDTH, RenderLength.EMPTY));
        box.setMinimumHeight(this.produceFromStyle(style, ElementStyleKeys.MIN_HEIGHT, RenderLength.EMPTY));
        box.setSizeSpecifiesBorderBox(BoxSizing.BORDER_BOX.equals(style.getStyleProperty(ElementStyleKeys.BOX_SIZING)));
        box.setMaximumWidth(this.produceFromStyle(style, ElementStyleKeys.MAX_WIDTH, RenderLength.AUTO));
        box.setMaximumHeight(this.produceFromStyle(style, ElementStyleKeys.MAX_HEIGHT, RenderLength.AUTO));
        box.setFixedPosition(this.produceFromStyle(style, BandStyleKeys.FIXED_POSITION, RenderLength.AUTO));
        box.setPaddingTop(Math.max(0L, StrictGeomUtility.toInternalValue(style.getDoubleStyleProperty(ElementStyleKeys.PADDING_TOP, 0.0))));
        box.setPaddingLeft(Math.max(0L, StrictGeomUtility.toInternalValue(style.getDoubleStyleProperty(ElementStyleKeys.PADDING_LEFT, 0.0))));
        box.setPaddingBottom(Math.max(0L, StrictGeomUtility.toInternalValue(style.getDoubleStyleProperty(ElementStyleKeys.PADDING_BOTTOM, 0.0))));
        box.setPaddingRight(Math.max(0L, StrictGeomUtility.toInternalValue(style.getDoubleStyleProperty(ElementStyleKeys.PADDING_RIGHT, 0.0))));
        BorderEdge edgeTop = this.createEdge(style, ElementStyleKeys.BORDER_TOP_STYLE, ElementStyleKeys.BORDER_TOP_COLOR, ElementStyleKeys.BORDER_TOP_WIDTH);
        BorderEdge edgeLeft = this.createEdge(style, ElementStyleKeys.BORDER_LEFT_STYLE, ElementStyleKeys.BORDER_LEFT_COLOR, ElementStyleKeys.BORDER_LEFT_WIDTH);
        BorderEdge edgeBottom = this.createEdge(style, ElementStyleKeys.BORDER_BOTTOM_STYLE, ElementStyleKeys.BORDER_BOTTOM_COLOR, ElementStyleKeys.BORDER_BOTTOM_WIDTH);
        BorderEdge edgeRight = this.createEdge(style, ElementStyleKeys.BORDER_RIGHT_STYLE, ElementStyleKeys.BORDER_RIGHT_COLOR, ElementStyleKeys.BORDER_RIGHT_WIDTH);
        BorderEdge edgeBreak = this.createEdge(style, ElementStyleKeys.BORDER_BREAK_STYLE, ElementStyleKeys.BORDER_BREAK_COLOR, ElementStyleKeys.BORDER_BREAK_WIDTH);
        if (BorderEdge.EMPTY.equals(edgeBottom) && BorderEdge.EMPTY.equals(edgeLeft) && BorderEdge.EMPTY.equals(edgeBreak) && BorderEdge.EMPTY.equals(edgeRight) && BorderEdge.EMPTY.equals(edgeTop)) {
            box.setBorder(Border.EMPTY_BORDER);
        } else {
            BorderCorner topLeftCorner = this.createCorner(style, ElementStyleKeys.BORDER_TOP_LEFT_RADIUS_WIDTH, ElementStyleKeys.BORDER_TOP_LEFT_RADIUS_HEIGHT);
            BorderCorner topRightCorner = this.createCorner(style, ElementStyleKeys.BORDER_TOP_RIGHT_RADIUS_WIDTH, ElementStyleKeys.BORDER_TOP_RIGHT_RADIUS_HEIGHT);
            BorderCorner bottmLeftCorner = this.createCorner(style, ElementStyleKeys.BORDER_BOTTOM_LEFT_RADIUS_WIDTH, ElementStyleKeys.BORDER_BOTTOM_LEFT_RADIUS_HEIGHT);
            BorderCorner bottomRightCorner = this.createCorner(style, ElementStyleKeys.BORDER_BOTTOM_RIGHT_RADIUS_WIDTH, ElementStyleKeys.BORDER_BOTTOM_RIGHT_RADIUS_HEIGHT);
            box.setBorder(new Border(edgeTop, edgeLeft, edgeBottom, edgeRight, edgeBreak, topLeftCorner, topRightCorner, bottmLeftCorner, bottomRightCorner));
        }
        return box;
    }

    private BorderCorner createCorner(StyleSheet style, StyleKey radiusKeyX, StyleKey radiusKeyY) {
        float dimX = (float)style.getDoubleStyleProperty(radiusKeyX, 0.0);
        float dimY = (float)style.getDoubleStyleProperty(radiusKeyY, 0.0);
        if (dimX <= 0.0f || dimY <= 0.0f) {
            return BorderCorner.EMPTY;
        }
        return new BorderCorner(StrictGeomUtility.toInternalValue(dimX), StrictGeomUtility.toInternalValue(dimY));
    }

    private BorderEdge createEdge(StyleSheet style, StyleKey borderStyleKey, StyleKey borderColorKey, StyleKey borderWidthKey) {
        BorderStyle styleRight = (BorderStyle)style.getStyleProperty(borderStyleKey);
        if (styleRight == null || BorderStyle.NONE.equals(styleRight)) {
            return BorderEdge.EMPTY;
        }
        Color color = (Color)style.getStyleProperty(borderColorKey);
        double width = style.getDoubleStyleProperty(borderWidthKey, 0.0);
        if (color == null || width <= 0.0) {
            return BorderEdge.EMPTY;
        }
        return new BorderEdge(styleRight, color, StrictGeomUtility.toInternalValue(width));
    }

    private RenderLength produceFromStyle(StyleSheet styleSheet, StyleKey key, RenderLength retval) {
        Float value = (Float)styleSheet.getStyleProperty(key);
        if (value == null) {
            return retval;
        }
        return RenderLength.createFromRaw(value.doubleValue());
    }

    private static class CacheCarrier {
        private long changeTracker;
        private BoxDefinition boxDefinition;

        protected CacheCarrier(long changeTracker, BoxDefinition border) {
            this.changeTracker = changeTracker;
            this.boxDefinition = border;
        }

        public long getChangeTracker() {
            return this.changeTracker;
        }

        public BoxDefinition getBoxDefinition() {
            return this.boxDefinition;
        }
    }

    private static class CacheKey {
        private Object instanceId;
        private String styleClass;

        protected CacheKey() {
        }

        protected CacheKey(Object instanceId, String styleClass) {
            if (instanceId == null) {
                throw new NullPointerException();
            }
            if (styleClass == null) {
                throw new NullPointerException();
            }
            this.instanceId = instanceId;
            this.styleClass = styleClass;
        }

        public Object getInstanceId() {
            return this.instanceId;
        }

        public void setInstanceId(Object instanceId) {
            this.instanceId = instanceId;
        }

        public String getStyleClass() {
            return this.styleClass;
        }

        public void setStyleClass(String styleClass) {
            this.styleClass = styleClass;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (!this.instanceId.equals(cacheKey.instanceId)) {
                return false;
            }
            return this.styleClass.equals(cacheKey.styleClass);
        }

        public int hashCode() {
            int result = this.instanceId.hashCode();
            result = 31 * result + this.styleClass.hashCode();
            return result;
        }

        public String toString() {
            return "CacheKey{instanceId=" + this.instanceId + ", styleClass='" + this.styleClass + '\'' + '}';
        }
    }
}

