/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.model.context;

import java.io.Serializable;
import org.pentaho.reporting.engine.classic.core.ElementAlignment;
import org.pentaho.reporting.engine.classic.core.layout.style.SimpleStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.style.TextStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.VerticalTextAlign;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;

public final class NodeLayoutProperties
implements Serializable,
Cloneable {
    private static final Float ZERO = new Float(0.0f);
    public static final InstanceID SIMPLE_NODE_ID = new InstanceID();
    public static final NodeLayoutProperties GENERIC_PROPERTIES = new NodeLayoutProperties(SimpleStyleSheet.EMPTY_STYLE);
    private VerticalTextAlign verticalTextAlign;
    private ElementAlignment verticalAlignment;
    private int majorAxis;
    private int minorAxis;
    private StyleSheet styleSheet;
    private InstanceID instanceId;
    private Float posY;
    private Float posX;

    public NodeLayoutProperties(StyleSheet styleSheet) {
        this(styleSheet, SIMPLE_NODE_ID);
    }

    public NodeLayoutProperties(StyleSheet styleSheet, InstanceID instanceID) {
        if (instanceID == null) {
            throw new NullPointerException();
        }
        if (styleSheet == null) {
            throw new NullPointerException();
        }
        this.majorAxis = 1;
        this.minorAxis = 0;
        this.instanceId = instanceID;
        this.styleSheet = styleSheet;
        Object vTextAlign = styleSheet.getStyleProperty(TextStyleKeys.VERTICAL_TEXT_ALIGNMENT);
        this.verticalTextAlign = vTextAlign != null ? (VerticalTextAlign)vTextAlign : VerticalTextAlign.BASELINE;
    }

    public NodeLayoutProperties(int majorAxis, int minorAxis, StyleSheet styleSheet, InstanceID instanceID) {
        if (instanceID == null) {
            throw new NullPointerException();
        }
        if (styleSheet == null) {
            throw new NullPointerException();
        }
        this.majorAxis = majorAxis;
        this.minorAxis = minorAxis;
        this.instanceId = instanceID;
        this.styleSheet = styleSheet;
        Object vTextAlign = styleSheet.getStyleProperty(TextStyleKeys.VERTICAL_TEXT_ALIGNMENT);
        this.verticalTextAlign = vTextAlign != null ? (VerticalTextAlign)vTextAlign : VerticalTextAlign.BASELINE;
    }

    public VerticalTextAlign getVerticalTextAlign() {
        return this.verticalTextAlign;
    }

    public StyleSheet getStyleSheet() {
        return this.styleSheet;
    }

    public InstanceID getInstanceId() {
        return this.instanceId;
    }

    public int getMajorAxis() {
        return this.majorAxis;
    }

    public int getMinorAxis() {
        return this.minorAxis;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public ElementAlignment getVerticalAlignment() {
        if (this.verticalAlignment == null) {
            this.verticalAlignment = (ElementAlignment)this.styleSheet.getStyleProperty(ElementStyleKeys.VALIGNMENT);
        }
        return this.verticalAlignment;
    }

    public double getPosY() {
        if (this.posY == null) {
            Object o = this.styleSheet.getStyleProperty(ElementStyleKeys.POS_Y);
            this.posY = o == null ? ZERO : (Float)o;
        }
        return this.posY.doubleValue();
    }

    public double getPosX() {
        if (this.posX == null) {
            Object o = this.styleSheet.getStyleProperty(ElementStyleKeys.POS_X);
            this.posX = o == null ? ZERO : (Float)o;
        }
        return this.posX.doubleValue();
    }

    public String toString() {
        return "NodeLayoutProperties{verticalAlignment=" + this.getVerticalAlignment() + ", majorAxis=" + this.majorAxis + ", minorAxis=" + this.minorAxis + '}';
    }
}

