/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.output;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.PageGrid;
import org.pentaho.reporting.engine.classic.core.layout.output.ContentProcessingException;
import org.pentaho.reporting.engine.classic.core.layout.output.LogicalPageKey;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessor;

public abstract class AbstractOutputProcessor
implements OutputProcessor {
    protected static final int PROCESSING_PAGES = 0;
    protected static final int PROCESSING_CONTENT = 2;
    private int processingState;
    private List logicalPages = new ArrayList();
    private int pageCursor;

    protected AbstractOutputProcessor() {
    }

    public final int getLogicalPageCount() {
        return this.logicalPages.size();
    }

    protected void reset() {
        this.logicalPages = new ArrayList();
        this.pageCursor = 0;
        this.processingState = 0;
    }

    public final LogicalPageKey getLogicalPage(int page) {
        if (!this.isPaginationFinished()) {
            throw new IllegalStateException();
        }
        return (LogicalPageKey)this.logicalPages.get(page);
    }

    public final boolean isPaginationFinished() {
        return this.processingState == 2;
    }

    public final void processingFinished() {
        this.pageCursor = 0;
        if (this.processingState == 0) {
            this.processingPagesFinished();
            this.processingState = 2;
        } else {
            this.processingContentFinished();
        }
    }

    protected void processingContentFinished() {
    }

    protected void processingPagesFinished() {
        this.logicalPages = Collections.unmodifiableList(this.logicalPages);
    }

    protected LogicalPageKey createLogicalPage(int width, int height) {
        return new LogicalPageKey(this.logicalPages.size(), width, height);
    }

    public final int getPageCursor() {
        return this.pageCursor;
    }

    public final void setPageCursor(int pageCursor) {
        this.pageCursor = pageCursor;
    }

    protected boolean isContentGeneratable() {
        return this.processingState == 2;
    }

    public void processRecomputedContent(LogicalPageBox pageBox) throws ContentProcessingException {
        this.setPageCursor(this.pageCursor + 1);
    }

    public final void processContent(LogicalPageBox logicalPage) throws ContentProcessingException {
        if (!this.isContentGeneratable()) {
            PageGrid pageGrid = logicalPage.getPageGrid();
            int rowCount = pageGrid.getRowCount();
            int colCount = pageGrid.getColumnCount();
            LogicalPageKey key = this.createLogicalPage(colCount, rowCount);
            this.logicalPages.add(key);
            int pageCursor = this.getPageCursor();
            if (key.getPosition() != pageCursor) {
                throw new IllegalStateException("Expected position " + pageCursor + " is not the key's position " + key.getPosition());
            }
            this.processPaginationContent(key, logicalPage);
            this.setPageCursor(pageCursor + 1);
        } else {
            int pageCursor = this.getPageCursor();
            LogicalPageKey logicalPageKey = this.getLogicalPage(pageCursor);
            this.processPageContent(logicalPageKey, logicalPage);
            this.setPageCursor(pageCursor + 1);
        }
    }

    public boolean isNeedAlignedPage() {
        return this.isContentGeneratable();
    }

    protected void processPaginationContent(LogicalPageKey logicalPageKey, LogicalPageBox logicalPage) throws ContentProcessingException {
    }

    protected abstract void processPageContent(LogicalPageKey var1, LogicalPageBox var2) throws ContentProcessingException;

    public int getPhysicalPageCount() {
        return this.getLogicalPageCount();
    }
}

