/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.output;

import java.util.ArrayList;
import org.pentaho.reporting.engine.classic.core.layout.model.BlockRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.CanvasRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.InlineRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.ParagraphRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableReplacedContentBox;
import org.pentaho.reporting.engine.classic.core.layout.process.IterateStructuralProcessStep;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictBounds;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class CollectSelectedNodesStep
extends IterateStructuralProcessStep {
    private static final RenderNode[] EMPTY = new RenderNode[0];
    private ArrayList resultList = new ArrayList();
    private StrictBounds bounds;
    private StrictBounds nodebounds = new StrictBounds();
    private String namespace;
    private String name;
    private boolean strictSelection = true;

    public boolean isStrictSelection() {
        return this.strictSelection;
    }

    public void setStrictSelection(boolean strictSelection) {
        this.strictSelection = strictSelection;
    }

    public RenderNode[] getNodesAt(LogicalPageBox logicalPageBox, StrictBounds bounds, String namespace, String name) {
        if (logicalPageBox == null) {
            throw new NullPointerException();
        }
        if (bounds == null) {
            throw new NullPointerException();
        }
        if (ObjectUtilities.equal((Object)bounds, (Object)this.bounds) && ObjectUtilities.equal((Object)namespace, (Object)this.namespace) && ObjectUtilities.equal((Object)name, (Object)this.name)) {
            if (this.resultList.isEmpty()) {
                return EMPTY;
            }
            return this.resultList.toArray(new RenderNode[this.resultList.size()]);
        }
        this.namespace = namespace;
        this.name = name;
        this.bounds = bounds;
        this.resultList.clear();
        this.startProcessing(logicalPageBox);
        if (this.resultList.isEmpty()) {
            return EMPTY;
        }
        return this.resultList.toArray(new RenderNode[this.resultList.size()]);
    }

    protected boolean startCanvasBox(CanvasRenderBox box) {
        return this.handleNode(box);
    }

    protected void processOtherNode(RenderNode node) {
        this.handleNode(node);
    }

    protected boolean startBlockBox(BlockRenderBox box) {
        return this.handleNode(box);
    }

    protected boolean startInlineBox(InlineRenderBox box) {
        return this.handleNode(box);
    }

    protected void processRenderableContent(RenderableReplacedContentBox box) {
        this.handleNode(box);
    }

    private boolean handleNode(RenderNode box) {
        if (this.strictSelection) {
            if (!box.isBoxVisible(this.bounds)) {
                return false;
            }
        } else {
            this.nodebounds.setRect(box.getX(), box.getY(), box.getWidth(), box.getHeight());
            if (!StrictBounds.intersects(this.nodebounds, this.bounds)) {
                return false;
            }
        }
        if (this.name != null && this.namespace != null) {
            Object attribute = box.getAttributes().getAttribute(this.namespace, this.name);
            if (attribute != null) {
                this.resultList.add(box);
            }
        } else {
            this.resultList.add(box);
        }
        return true;
    }

    protected boolean startOtherBox(RenderBox box) {
        return this.handleNode(box);
    }

    protected boolean startRowBox(RenderBox box) {
        return this.handleNode(box);
    }

    protected void processParagraphChilds(ParagraphRenderBox box) {
        this.processBoxChilds(box);
    }
}

