/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.output;

import org.pentaho.reporting.engine.classic.core.CrosstabColumnGroup;
import org.pentaho.reporting.engine.classic.core.ItemBand;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.layout.LayoutBuilder;
import org.pentaho.reporting.engine.classic.core.layout.Renderer;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.output.CrosstabLayoutUtil;
import org.pentaho.reporting.engine.classic.core.layout.output.DefaultOutputFunction;
import org.pentaho.reporting.engine.classic.core.layout.output.GroupOutputHandler;
import org.pentaho.reporting.engine.classic.core.layout.output.PreparedCrosstabLayout;

public class CrosstabColumnOutputHandler
implements GroupOutputHandler {
    private int beginOfGroup;
    private int slotNumber;

    public CrosstabColumnOutputHandler(int beginOfGroup, int slotNumber) {
        this.beginOfGroup = beginOfGroup;
        this.slotNumber = slotNumber;
    }

    public int getSlotNumber() {
        return this.slotNumber;
    }

    public int getBeginOfGroup() {
        return this.beginOfGroup;
    }

    public void groupStarted(DefaultOutputFunction outputFunction, ReportEvent event) throws ReportProcessingException {
        PreparedCrosstabLayout preparedCrosstabLayout = outputFunction.getCurrentCrosstabLayout();
        int columnSlotNumber = event.getState().getCurrentDataItem() - this.beginOfGroup;
        Renderer renderer = outputFunction.getRenderer();
        LayoutBuilder builder = renderer.createBufferedLayoutBuilder();
        int gidx = event.getState().getCurrentGroupIndex();
        CrosstabColumnGroup g = (CrosstabColumnGroup)event.getReport().getGroup(gidx);
        RenderBox titleBox = preparedCrosstabLayout.getColumnHeaderTitleBox();
        RenderBox titleColumnSlot = CrosstabLayoutUtil.getSlot(titleBox, columnSlotNumber);
        RenderBox titleSlot = CrosstabLayoutUtil.getSlot(titleColumnSlot, this.slotNumber);
        titleSlot.clear();
        builder.startSection(titleSlot, true);
        builder.add(titleSlot, g.getTitleHeader(), outputFunction.getRuntime(), event.getState().getProcessKey());
        outputFunction.addSubReportMarkers(builder.endSection(titleSlot, titleSlot));
        RenderBox headerBox = preparedCrosstabLayout.getColumnHeaderBox();
        RenderBox headerColumnSlot = CrosstabLayoutUtil.getSlot(headerBox, columnSlotNumber);
        RenderBox headerSlot = CrosstabLayoutUtil.getSlot(headerColumnSlot, this.slotNumber);
        headerSlot.clear();
        builder.startSection(headerSlot, true);
        builder.add(headerSlot, g.getHeader(), outputFunction.getRuntime(), event.getState().getProcessKey());
        outputFunction.addSubReportMarkers(builder.endSection(headerSlot, headerSlot));
    }

    public void itemsStarted(DefaultOutputFunction outputFunction, ReportEvent event) throws ReportProcessingException {
    }

    public void itemsAdvanced(DefaultOutputFunction outputFunction, ReportEvent event) throws ReportProcessingException {
        PreparedCrosstabLayout preparedCrosstabLayout = outputFunction.getCurrentCrosstabLayout();
        Renderer renderer = outputFunction.getRenderer();
        LayoutBuilder builder = renderer.createBufferedLayoutBuilder();
        ItemBand g = event.getReport().getItemBand();
        int columnSlotNumber = event.getState().getCurrentDataItem() - this.beginOfGroup;
        RenderBox dataBox = preparedCrosstabLayout.getCellDataBox();
        RenderBox dataSlot = CrosstabLayoutUtil.getSlot(dataBox, columnSlotNumber);
        dataSlot.clear();
        builder.startSection(dataSlot, true);
        builder.add(dataSlot, g, outputFunction.getRuntime(), event.getState().getProcessKey());
        outputFunction.addSubReportMarkers(builder.endSection(dataSlot, dataSlot));
    }

    public void itemsFinished(DefaultOutputFunction outputFunction, ReportEvent event) throws ReportProcessingException {
    }

    public void groupFinished(DefaultOutputFunction outputFunction, ReportEvent event) throws ReportProcessingException {
    }
}

