/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.output;

import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.layout.Renderer;
import org.pentaho.reporting.engine.classic.core.layout.model.BlockRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.output.DefaultOutputFunction;
import org.pentaho.reporting.engine.classic.core.layout.output.PreparedCrosstabLayout;
import org.pentaho.reporting.engine.classic.core.layout.style.CrosstabBoxStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;

public class CrosstabLayoutUtil {
    private static StyleSheet boxStyle;

    private static StyleSheet getBoxStyle() {
        if (boxStyle == null) {
            boxStyle = new CrosstabBoxStyleSheet();
        }
        return boxStyle;
    }

    private CrosstabLayoutUtil() {
    }

    public static void handleFinishPending(DefaultOutputFunction outputFunction, ReportEvent event) throws ReportProcessingException {
        PreparedCrosstabLayout preparedCrosstabLayout = outputFunction.getCurrentCrosstabLayout();
        if (preparedCrosstabLayout.isFinishPending()) {
            Renderer renderer = outputFunction.getRenderer();
            outputFunction.updateFooterArea(event);
            if (preparedCrosstabLayout.getRowCount() == 0) {
                renderer.startSection(0);
                renderer.add(preparedCrosstabLayout.getPrintableHeaderBox());
                renderer.endSection();
                outputFunction.addSubReportMarkers(preparedCrosstabLayout.getHeaderSubReportMarker());
            }
            renderer.startSection(0);
            renderer.add(preparedCrosstabLayout.getPrintableDataBox());
            renderer.endSection();
            outputFunction.addSubReportMarkers(preparedCrosstabLayout.getDataSubReportMarker());
            preparedCrosstabLayout.setFinishPending(false);
            preparedCrosstabLayout.setRowCount(preparedCrosstabLayout.getRowCount() + 1);
        }
    }

    public static RenderBox getSlot(RenderBox container, int position) {
        int runPosition = 0;
        RenderBox child = (RenderBox)container.getFirstChild();
        while (child != null) {
            if (runPosition == position) {
                return child;
            }
            child = (RenderBox)child.getNext();
            ++runPosition;
        }
        for (int i = runPosition; i <= position; ++i) {
            BlockRenderBox slotBox = new BlockRenderBox(CrosstabLayoutUtil.getBoxStyle());
            slotBox.setName("Slot-" + i);
            container.addChild(slotBox);
            if (i != position) continue;
            return slotBox;
        }
        throw new IllegalArgumentException("You should never end up here");
    }
}

