/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.output;

import org.pentaho.reporting.engine.classic.core.CrosstabRowGroup;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.layout.LayoutBuilder;
import org.pentaho.reporting.engine.classic.core.layout.Renderer;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.output.CrosstabLayoutUtil;
import org.pentaho.reporting.engine.classic.core.layout.output.DefaultOutputFunction;
import org.pentaho.reporting.engine.classic.core.layout.output.GroupOutputHandler;
import org.pentaho.reporting.engine.classic.core.layout.output.PreparedCrosstabLayout;

public class CrosstabRowOutputHandler
implements GroupOutputHandler {
    private int slotNumber;

    public CrosstabRowOutputHandler(int slotNumber) {
        this.slotNumber = slotNumber;
    }

    public int getSlotNumber() {
        return this.slotNumber;
    }

    public void groupStarted(DefaultOutputFunction outputFunction, ReportEvent event) throws ReportProcessingException {
        CrosstabLayoutUtil.handleFinishPending(outputFunction, event);
        PreparedCrosstabLayout preparedCrosstabLayout = outputFunction.getCurrentCrosstabLayout();
        Renderer renderer = outputFunction.getRenderer();
        int gidx = event.getState().getCurrentGroupIndex();
        CrosstabRowGroup g = (CrosstabRowGroup)event.getReport().getGroup(gidx);
        LayoutBuilder builder = renderer.createBufferedLayoutBuilder();
        RenderBox titleBox = preparedCrosstabLayout.getRowHeaderTitleBox();
        RenderBox titleSlot = CrosstabLayoutUtil.getSlot(titleBox, this.slotNumber);
        titleSlot.clear();
        builder.startSection(titleSlot, true);
        builder.add(titleSlot, g.getTitleHeader(), outputFunction.getRuntime(), event.getState().getProcessKey());
        outputFunction.addSubReportMarkers(builder.endSection(titleSlot, titleSlot));
        RenderBox headerBox = preparedCrosstabLayout.getRowHeaderBox();
        RenderBox headerSlot = CrosstabLayoutUtil.getSlot(headerBox, this.slotNumber);
        headerSlot.clear();
        builder.startSection(headerSlot, true);
        builder.add(headerSlot, g.getHeader(), outputFunction.getRuntime(), event.getState().getProcessKey());
        outputFunction.addSubReportMarkers(builder.endSection(headerSlot, headerSlot));
    }

    public void groupFinished(DefaultOutputFunction outputFunction, ReportEvent event) throws ReportProcessingException {
        PreparedCrosstabLayout preparedCrosstabLayout = outputFunction.getCurrentCrosstabLayout();
        Renderer renderer = outputFunction.getRenderer();
        LayoutBuilder builder = renderer.createBufferedLayoutBuilder();
        int gidx = event.getState().getCurrentGroupIndex();
        CrosstabRowGroup g = (CrosstabRowGroup)event.getReport().getGroup(gidx);
        RenderBox titleBox = preparedCrosstabLayout.getRowFooterTitleBox();
        RenderBox titleSlot = CrosstabLayoutUtil.getSlot(titleBox, this.slotNumber);
        titleSlot.clear();
        builder.startSection(titleSlot, true);
        builder.add(titleSlot, g.getTitleFooter(), outputFunction.getRuntime(), event.getState().getProcessKey());
        outputFunction.addSubReportMarkers(builder.endSection(titleSlot, titleSlot));
        RenderBox footerBox = preparedCrosstabLayout.getRowFooterBox();
        RenderBox footerSlot = CrosstabLayoutUtil.getSlot(footerBox, this.slotNumber);
        footerSlot.clear();
        builder.startSection(footerSlot, true);
        builder.add(footerSlot, g.getFooter(), outputFunction.getRuntime(), event.getState().getProcessKey());
        outputFunction.addSubReportMarkers(builder.endSection(footerSlot, footerSlot));
        preparedCrosstabLayout.setFinishPending(true);
    }

    public void itemsStarted(DefaultOutputFunction outputFunction, ReportEvent event) throws ReportProcessingException {
        throw new ReportProcessingException("A crosstab-row cannot contain a detail band. Never.");
    }

    public void itemsAdvanced(DefaultOutputFunction outputFunction, ReportEvent event) throws ReportProcessingException {
        throw new ReportProcessingException("A crosstab-row cannot contain a detail band. Never.");
    }

    public void itemsFinished(DefaultOutputFunction outputFunction, ReportEvent event) throws ReportProcessingException {
        throw new ReportProcessingException("A crosstab-row cannot contain a detail band. Never.");
    }
}

