/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.output;

import java.util.ArrayList;
import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.CrosstabColumnGroup;
import org.pentaho.reporting.engine.classic.core.CrosstabRowGroup;
import org.pentaho.reporting.engine.classic.core.DetailsFooter;
import org.pentaho.reporting.engine.classic.core.DetailsHeader;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.GroupFooter;
import org.pentaho.reporting.engine.classic.core.GroupHeader;
import org.pentaho.reporting.engine.classic.core.PageFooter;
import org.pentaho.reporting.engine.classic.core.PageHeader;
import org.pentaho.reporting.engine.classic.core.ReportDefinition;
import org.pentaho.reporting.engine.classic.core.ReportFooter;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.Watermark;
import org.pentaho.reporting.engine.classic.core.event.PageEventListener;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.AbstractFunction;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.function.FunctionProcessingException;
import org.pentaho.reporting.engine.classic.core.function.OutputFunction;
import org.pentaho.reporting.engine.classic.core.function.ProcessingContext;
import org.pentaho.reporting.engine.classic.core.layout.InlineSubreportMarker;
import org.pentaho.reporting.engine.classic.core.layout.Renderer;
import org.pentaho.reporting.engine.classic.core.layout.output.ContentProcessingException;
import org.pentaho.reporting.engine.classic.core.layout.output.CrosstabColumnOutputHandler;
import org.pentaho.reporting.engine.classic.core.layout.output.CrosstabOtherOutputHandler;
import org.pentaho.reporting.engine.classic.core.layout.output.CrosstabOutputHandler;
import org.pentaho.reporting.engine.classic.core.layout.output.CrosstabRowOutputHandler;
import org.pentaho.reporting.engine.classic.core.layout.output.DefaultLayoutPagebreakHandler;
import org.pentaho.reporting.engine.classic.core.layout.output.GroupOutputHandler;
import org.pentaho.reporting.engine.classic.core.layout.output.LayoutExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.layout.output.LayouterLevel;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorFeature;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.output.PreparedCrosstabLayout;
import org.pentaho.reporting.engine.classic.core.layout.output.RelationalGroupOutputHandler;
import org.pentaho.reporting.engine.classic.core.states.ReportState;
import org.pentaho.reporting.engine.classic.core.states.datarow.MasterDataRow;
import org.pentaho.reporting.engine.classic.core.states.datarow.ReportDataRow;
import org.pentaho.reporting.engine.classic.core.states.process.SubReportProcessType;
import org.pentaho.reporting.engine.classic.core.style.BandStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.libraries.base.util.FastStack;

public class DefaultOutputFunction
extends AbstractFunction
implements OutputFunction,
PageEventListener {
    private static final Log logger = LogFactory.getLog(DefaultOutputFunction.class);
    private static final LayouterLevel[] EMPTY_LAYOUTER_LEVEL = new LayouterLevel[0];
    private ReportEvent currentEvent;
    private Renderer renderer;
    private boolean lastPagebreak;
    private DefaultLayoutPagebreakHandler pagebreakHandler = new DefaultLayoutPagebreakHandler();
    private ArrayList<InlineSubreportMarker> inlineSubreports = new ArrayList();
    private FastStack<GroupOutputHandler> outputHandlers = new FastStack();
    private FastStack<PreparedCrosstabLayout> crosstabLayouts = new FastStack();
    private int beginOfRow;

    public Object getValue() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportInitialized(ReportEvent event) {
        block11: {
            if (event.getState().getParentSubReportState() != null) {
                this.clearPendingPageStart(event);
            }
            this.setCurrentEvent(event);
            try {
                ReportDefinition report = event.getReport();
                if (!event.getState().isSubReportEvent()) {
                    this.renderer.startReport(report);
                    ReportState reportState = event.getState();
                    ExpressionRuntime runtime = this.getRuntime();
                    try {
                        reportState.firePageStartedEvent(reportState.getEventCode());
                        break block11;
                    }
                    finally {
                        this.setRuntime(runtime);
                        this.setCurrentEvent(event);
                    }
                }
                this.renderer.startSubReport(report, event.getState().getCurrentSubReportMarker().getInsertationPointId());
            }
            catch (FunctionProcessingException fe) {
                throw fe;
            }
            catch (Exception e) {
                throw new FunctionProcessingException("ReportInitialized failed", e);
            }
            finally {
                this.clearCurrentEvent();
            }
        }
    }

    public void reportStarted(ReportEvent event) {
        this.clearPendingPageStart(event);
        this.setCurrentEvent(event);
        try {
            this.updateFooterArea(event);
            this.renderer.startSection(0);
            ReportDefinition report = event.getReport();
            this.print(this.getRuntime(), report.getReportHeader());
            this.addSubReportMarkers(this.renderer.endSection());
        }
        catch (FunctionProcessingException fe) {
            throw fe;
        }
        catch (Exception e) {
            throw new FunctionProcessingException("ReportStarted failed", e);
        }
        finally {
            this.clearCurrentEvent();
        }
    }

    public void addSubReportMarkers(InlineSubreportMarker[] markers) {
        for (int i = 0; i < markers.length; ++i) {
            InlineSubreportMarker marker = markers[i];
            this.inlineSubreports.add(marker);
        }
    }

    public void groupStarted(ReportEvent event) {
        GroupOutputHandler handler;
        int type = event.getType();
        if ((type & 0x110000) == 0x110000) {
            handler = new CrosstabOutputHandler();
            this.outputHandlers.push((Object)handler);
        } else if ((type & 0x210000) == 0x210000) {
            handler = new CrosstabOtherOutputHandler();
            this.outputHandlers.push((Object)handler);
        } else if ((type & 0x410000) == 0x410000) {
            handler = new CrosstabRowOutputHandler(this.computeRowPosition(event));
            this.outputHandlers.push((Object)handler);
            this.beginOfRow = event.getState().getCurrentDataItem();
        } else if ((type & 0x810000) == 0x810000) {
            handler = new CrosstabColumnOutputHandler(this.beginOfRow, this.computeColumnPosition(event));
            this.outputHandlers.push((Object)handler);
        } else {
            handler = new RelationalGroupOutputHandler();
            this.outputHandlers.push((Object)handler);
        }
        this.clearPendingPageStart(event);
        this.setCurrentEvent(event);
        try {
            handler = (GroupOutputHandler)this.outputHandlers.peek();
            handler.groupStarted(this, event);
        }
        catch (FunctionProcessingException fe) {
            throw fe;
        }
        catch (Exception e) {
            throw new FunctionProcessingException("GroupStarted failed", e);
        }
        finally {
            this.clearCurrentEvent();
        }
    }

    private int computeRowPosition(ReportEvent event) {
        ReportState state = event.getState();
        int groupIndex = state.getCurrentGroupIndex();
        Group group = event.getReport().getGroup(groupIndex);
        int retval = -1;
        while (group instanceof CrosstabRowGroup) {
            ++retval;
            Section body = group.getParentSection();
            if (body == null) {
                throw new IllegalStateException("Invalid report model: Inner Crosstab-group without parent-body");
            }
            group = (Group)body.getParentSection();
        }
        return retval;
    }

    private int computeColumnPosition(ReportEvent event) {
        ReportState state = event.getState();
        int groupIndex = state.getCurrentGroupIndex();
        Group group = event.getReport().getGroup(groupIndex);
        int retval = -1;
        while (group instanceof CrosstabColumnGroup) {
            ++retval;
            Section body = group.getParentSection();
            if (body == null) {
                throw new IllegalStateException("Invalid report model: Inner Crosstab-group without parent-body");
            }
            group = (Group)body.getParentSection();
        }
        return retval;
    }

    public void itemsStarted(ReportEvent event) {
        this.clearPendingPageStart(event);
        this.setCurrentEvent(event);
        try {
            GroupOutputHandler handler = (GroupOutputHandler)this.outputHandlers.peek();
            handler.itemsStarted(this, event);
        }
        catch (FunctionProcessingException fe) {
            throw fe;
        }
        catch (Exception e) {
            throw new FunctionProcessingException("ItemsStarted failed", e);
        }
        finally {
            this.clearCurrentEvent();
        }
    }

    public void itemsAdvanced(ReportEvent event) {
        this.clearPendingPageStart(event);
        this.setCurrentEvent(event);
        try {
            GroupOutputHandler handler = (GroupOutputHandler)this.outputHandlers.peek();
            handler.itemsAdvanced(this, event);
        }
        catch (FunctionProcessingException fe) {
            throw fe;
        }
        catch (Exception e) {
            throw new FunctionProcessingException("ItemsAdvanced failed", e);
        }
        finally {
            this.clearCurrentEvent();
        }
    }

    public void itemsFinished(ReportEvent event) {
        this.clearPendingPageStart(event);
        this.setCurrentEvent(event);
        try {
            GroupOutputHandler handler = (GroupOutputHandler)this.outputHandlers.peek();
            handler.itemsFinished(this, event);
        }
        catch (FunctionProcessingException fe) {
            throw fe;
        }
        catch (Exception e) {
            throw new FunctionProcessingException("ItemsFinished failed", e);
        }
        finally {
            this.clearCurrentEvent();
        }
    }

    public void groupFinished(ReportEvent event) {
        this.clearPendingPageStart(event);
        this.setCurrentEvent(event);
        try {
            GroupOutputHandler handler = (GroupOutputHandler)this.outputHandlers.pop();
            handler.groupFinished(this, event);
        }
        catch (FunctionProcessingException fe) {
            throw fe;
        }
        catch (Exception e) {
            throw new FunctionProcessingException("GroupFinished failed", e);
        }
        finally {
            this.clearCurrentEvent();
        }
    }

    public void reportFinished(ReportEvent event) {
        this.clearPendingPageStart(event);
        this.setCurrentEvent(event);
        try {
            ReportFooter b = event.getReport().getReportFooter();
            this.renderer.startSection(0);
            this.print(this.getRuntime(), b);
            this.addSubReportMarkers(this.renderer.endSection());
            if (!event.isDeepTraversing()) {
                this.lastPagebreak = true;
            }
            this.updateFooterArea(event);
        }
        catch (FunctionProcessingException fe) {
            throw fe;
        }
        catch (Exception e) {
            throw new FunctionProcessingException("ReportFinished failed", e);
        }
        finally {
            this.clearCurrentEvent();
        }
    }

    public void reportDone(ReportEvent event) {
        if (!event.getState().isSubReportEvent()) {
            this.renderer.endReport();
        } else {
            this.renderer.endSubReport();
        }
    }

    private static LayoutExpressionRuntime createRuntime(MasterDataRow masterRow, ReportState state, ProcessingContext processingContext) {
        ReportDataRow reportDataRow = masterRow.getReportDataRow();
        TableModel reportDataModel = reportDataRow.getReportData();
        return new LayoutExpressionRuntime(masterRow.getGlobalView(), masterRow.getDataSchema(), state, reportDataModel, processingContext);
    }

    private static LayouterLevel[] collectSubReportStates(ReportState state, ProcessingContext processingContext) {
        if (processingContext == null) {
            throw new NullPointerException();
        }
        ReportState parentState = state.getParentSubReportState();
        if (parentState == null) {
            return EMPTY_LAYOUTER_LEVEL;
        }
        MasterDataRow dataRow = state.getFlowController().getMasterRow();
        if ((dataRow = dataRow.getParentDataRow()) == null) {
            throw new IllegalStateException("Parent-DataRow in a subreport-state must be defined.");
        }
        ArrayList<LayouterLevel> stack = new ArrayList<LayouterLevel>();
        while (parentState != null) {
            if (!parentState.isInlineProcess()) {
                LayoutExpressionRuntime runtime = DefaultOutputFunction.createRuntime(dataRow, parentState, processingContext);
                stack.add(new LayouterLevel(parentState.getReport(), parentState.getPresentationGroupIndex(), runtime, parentState.isInItemGroup()));
            }
            parentState = parentState.getParentSubReportState();
            if ((dataRow = dataRow.getParentDataRow()) != null) continue;
            throw new IllegalStateException("Parent-DataRow in a subreport-state must be defined.");
        }
        return stack.toArray(new LayouterLevel[stack.size()]);
    }

    private int computeCurrentPage() {
        return this.renderer.getPageCount() + 1;
    }

    private boolean isPageHeaderPrinting(Band b) {
        boolean displayOnFirstPage = b.getStyle().getBooleanStyleProperty(BandStyleKeys.DISPLAY_ON_FIRSTPAGE);
        if (this.computeCurrentPage() == 1 && !displayOnFirstPage) {
            return false;
        }
        boolean displayOnLastPage = b.getStyle().getBooleanStyleProperty(BandStyleKeys.DISPLAY_ON_LASTPAGE);
        return !this.isLastPagebreak() || displayOnLastPage;
    }

    protected boolean isLastPagebreak() {
        return this.lastPagebreak;
    }

    public void pageStarted(ReportEvent event) {
        this.setCurrentEvent(event);
        try {
            int mask = 0x8000001;
            if (event.getState().isSubReportEvent() && (event.getType() & 0x8000001) == 0x8000001 && (!this.renderer.isCurrentPageEmpty() || this.renderer.validatePages() == Renderer.LayoutResult.LAYOUT_UNVALIDATABLE)) {
                return;
            }
            this.renderer.newPageStarted();
            this.updateHeaderArea(event.getState());
        }
        catch (FunctionProcessingException fe) {
            throw fe;
        }
        catch (Exception e) {
            throw new FunctionProcessingException("PageStarted failed", e);
        }
        finally {
            this.clearCurrentEvent();
        }
    }

    protected void updateHeaderArea(ReportState givenState) throws ReportProcessingException {
        ReportDefinition def;
        LayouterLevel level;
        ReportState state;
        for (state = givenState; state != null && state.isInlineProcess(); state = state.getParentSubReportState()) {
        }
        if (state == null) {
            return;
        }
        ProcessingContext processingContext = this.getRuntime().getProcessingContext();
        ReportDefinition report = state.getReport();
        LayouterLevel[] levels = null;
        LayoutExpressionRuntime runtime = null;
        OutputProcessorMetaData metaData = this.renderer.getOutputProcessor().getMetaData();
        if (metaData.isFeatureSupported(OutputProcessorFeature.WATERMARK_SECTION)) {
            this.renderer.startSection(4);
            levels = DefaultOutputFunction.collectSubReportStates(state, processingContext);
            for (int i = levels.length - 1; i >= 0; --i) {
                level = levels[i];
                def = level.getReportDefinition();
                Watermark watermark = def.getWatermark();
                if (!watermark.isSticky()) continue;
                if (this.isPageHeaderPrinting(watermark)) {
                    this.print(level.getRuntime(), watermark);
                    continue;
                }
                this.printEmptyRootLevelBand();
            }
            Watermark watermark = report.getWatermark();
            if (this.isPageHeaderPrinting(watermark)) {
                runtime = DefaultOutputFunction.createRuntime(state.getFlowController().getMasterRow(), state, processingContext);
                this.print(runtime, watermark);
            }
            this.addSubReportMarkers(this.renderer.endSection());
        }
        if (metaData.isFeatureSupported(OutputProcessorFeature.PAGE_SECTIONS)) {
            DetailsHeader detailsHeader;
            this.renderer.startSection(1);
            if (levels == null) {
                levels = DefaultOutputFunction.collectSubReportStates(state, processingContext);
            }
            for (int i = levels.length - 1; i >= 0; --i) {
                level = levels[i];
                def = level.getReportDefinition();
                PageHeader header = def.getPageHeader();
                if (!header.isSticky()) continue;
                if (this.isPageHeaderPrinting(header)) {
                    this.print(level.getRuntime(), header);
                    continue;
                }
                this.printEmptyRootLevelBand();
            }
            PageHeader b = report.getPageHeader();
            if (this.isPageHeaderPrinting(b)) {
                if (runtime == null) {
                    runtime = DefaultOutputFunction.createRuntime(state.getFlowController().getMasterRow(), state, processingContext);
                }
                this.print(runtime, b);
            }
            for (int i = levels.length - 1; i >= 0; --i) {
                DetailsHeader detailsHeader2;
                LayouterLevel level2 = levels[i];
                ReportDefinition def2 = level2.getReportDefinition();
                for (int gidx = 0; gidx <= level2.getGroupIndex(); ++gidx) {
                    Group g = def2.getGroup(gidx);
                    GroupHeader header = g.getHeader();
                    if (!header.isSticky()) continue;
                    if (header.isRepeat()) {
                        this.print(level2.getRuntime(), header);
                        continue;
                    }
                    this.printEmptyRootLevelBand();
                }
                if (!level2.isInItemGroup() || !(detailsHeader2 = def2.getDetailsHeader()).isRepeat()) continue;
                this.print(level2.getRuntime(), detailsHeader2);
            }
            int groupsPrinted = state.getPresentationGroupIndex();
            for (int gidx = 0; gidx <= groupsPrinted; ++gidx) {
                Group g = report.getGroup(gidx);
                GroupHeader header = g.getHeader();
                if (!header.isRepeat()) continue;
                this.print(runtime, header);
            }
            if (state.isInItemGroup() && (detailsHeader = report.getDetailsHeader()).isRepeat()) {
                this.print(runtime, detailsHeader);
            }
            this.addSubReportMarkers(this.renderer.endSection());
        }
    }

    public void pageFinished(ReportEvent event) {
        this.setCurrentEvent(event);
        try {
            this.updateFooterArea(event);
        }
        catch (FunctionProcessingException fe) {
            throw fe;
        }
        catch (Exception e) {
            throw new FunctionProcessingException("PageFinished failed", e);
        }
        finally {
            this.clearCurrentEvent();
        }
    }

    public void updateFooterArea(ReportEvent event) throws ReportProcessingException {
        int groupsPrinted;
        DetailsFooter detailsFooter;
        OutputProcessorMetaData metaData = this.renderer.getOutputProcessor().getMetaData();
        if (!metaData.isFeatureSupported(OutputProcessorFeature.PAGE_SECTIONS)) {
            return;
        }
        if (event.getState().isInlineProcess()) {
            return;
        }
        this.renderer.startSection(3);
        ReportDefinition report = event.getReport();
        ReportState state = event.getState();
        if (state.isInItemGroup() && (detailsFooter = report.getDetailsFooter()).isRepeat()) {
            this.print(this.getRuntime(), detailsFooter);
        }
        for (int gidx = groupsPrinted = state.getPresentationGroupIndex(); gidx >= 0; --gidx) {
            Group g = report.getGroup(gidx);
            GroupFooter footer = g.getFooter();
            if (!footer.isRepeat()) continue;
            this.print(this.getRuntime(), footer);
        }
        LayouterLevel[] levels = DefaultOutputFunction.collectSubReportStates(event.getState(), this.getRuntime().getProcessingContext());
        int levelCount = levels.length;
        for (int i = 0; i < levelCount; ++i) {
            DetailsFooter subDetailsFooter;
            LayouterLevel level = levels[i];
            ReportDefinition def = level.getReportDefinition();
            if (level.isInItemGroup() && (subDetailsFooter = report.getDetailsFooter()).isSticky() && subDetailsFooter.isRepeat()) {
                this.print(level.getRuntime(), subDetailsFooter);
            }
            for (int gidx = level.getGroupIndex(); gidx >= 0; --gidx) {
                Group g = def.getGroup(gidx);
                GroupFooter footer = g.getFooter();
                if (!footer.isSticky() || !footer.isRepeat()) continue;
                this.print(level.getRuntime(), footer);
            }
        }
        this.addSubReportMarkers(this.renderer.endSection());
        this.renderer.startSection(2);
        PageFooter pageFooter = report.getPageFooter();
        ElementStyleSheet pageFooterStyle = pageFooter.getStyle();
        if (this.computeCurrentPage() == 1) {
            if (pageFooterStyle.getBooleanStyleProperty(BandStyleKeys.DISPLAY_ON_FIRSTPAGE)) {
                this.print(this.getRuntime(), pageFooter);
            } else {
                this.printEmptyRootLevelBand();
            }
        } else if (this.isLastPagebreak()) {
            if (pageFooterStyle.getBooleanStyleProperty(BandStyleKeys.DISPLAY_ON_LASTPAGE, false)) {
                this.print(this.getRuntime(), pageFooter);
            } else {
                this.printEmptyRootLevelBand();
            }
        } else {
            this.print(this.getRuntime(), pageFooter);
        }
        for (int i = 0; i < levelCount; ++i) {
            LayouterLevel level = levels[i];
            ReportDefinition def = level.getReportDefinition();
            PageFooter b = def.getPageFooter();
            if (!b.isSticky()) {
                this.printEmptyRootLevelBand();
                continue;
            }
            ElementStyleSheet style = b.getStyle();
            if (this.computeCurrentPage() == 1) {
                if (style.getBooleanStyleProperty(BandStyleKeys.DISPLAY_ON_FIRSTPAGE)) {
                    this.print(level.getRuntime(), b);
                    continue;
                }
                this.printEmptyRootLevelBand();
                continue;
            }
            if (this.isLastPagebreak()) {
                if (style.getBooleanStyleProperty(BandStyleKeys.DISPLAY_ON_LASTPAGE)) {
                    this.print(level.getRuntime(), b);
                    continue;
                }
                this.printEmptyRootLevelBand();
                continue;
            }
            this.print(level.getRuntime(), b);
        }
        this.addSubReportMarkers(this.renderer.endSection());
    }

    protected ReportEvent getCurrentEvent() {
        return this.currentEvent;
    }

    protected void setCurrentEvent(ReportEvent currentEvent) {
        if (currentEvent == null) {
            throw new NullPointerException("Event must not be null.");
        }
        this.currentEvent = currentEvent;
        this.pagebreakHandler.setReportState(currentEvent.getState());
        this.renderer.setStateKey(currentEvent.getState().getProcessKey());
    }

    protected void clearCurrentEvent() {
        if (this.currentEvent == null) {
            throw new IllegalStateException("ClearCurrentEvent called without Event set:");
        }
        this.currentEvent = null;
        this.pagebreakHandler.setReportState(null);
        this.renderer.setStateKey(null);
    }

    public final Object clone() throws CloneNotSupportedException {
        DefaultOutputFunction sl = (DefaultOutputFunction)super.clone();
        sl.currentEvent = null;
        sl.inlineSubreports = (ArrayList)this.inlineSubreports.clone();
        sl.outputHandlers = (FastStack)this.outputHandlers.clone();
        sl.crosstabLayouts = (FastStack)this.crosstabLayouts.clone();
        sl.crosstabLayouts.clear();
        int clSize = this.crosstabLayouts.size();
        for (int i = 0; i < clSize; ++i) {
            PreparedCrosstabLayout o = (PreparedCrosstabLayout)this.crosstabLayouts.get(i);
            sl.crosstabLayouts.push((Object)((PreparedCrosstabLayout)o.clone()));
        }
        return sl;
    }

    public Expression getInstance() {
        return this.deriveForStorage();
    }

    public OutputFunction deriveForStorage() {
        try {
            DefaultOutputFunction sl = (DefaultOutputFunction)super.clone();
            sl.renderer = this.renderer.deriveForStorage();
            sl.inlineSubreports = (ArrayList)this.inlineSubreports.clone();
            sl.currentEvent = null;
            sl.pagebreakHandler = (DefaultLayoutPagebreakHandler)this.pagebreakHandler.clone();
            sl.pagebreakHandler.setReportState(null);
            sl.outputHandlers = (FastStack)this.outputHandlers.clone();
            sl.crosstabLayouts = (FastStack)this.crosstabLayouts.clone();
            sl.crosstabLayouts.clear();
            int clSize = this.crosstabLayouts.size();
            for (int i = 0; i < clSize; ++i) {
                PreparedCrosstabLayout o = (PreparedCrosstabLayout)this.crosstabLayouts.get(i);
                sl.crosstabLayouts.push((Object)o.derive());
            }
            return sl;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
    }

    public OutputFunction deriveForPagebreak() {
        try {
            DefaultOutputFunction sl = (DefaultOutputFunction)super.clone();
            sl.renderer = this.renderer.deriveForPagebreak();
            sl.inlineSubreports = (ArrayList)this.inlineSubreports.clone();
            sl.currentEvent = null;
            sl.pagebreakHandler = (DefaultLayoutPagebreakHandler)this.pagebreakHandler.clone();
            sl.outputHandlers = (FastStack)this.outputHandlers.clone();
            sl.crosstabLayouts = (FastStack)this.crosstabLayouts.clone();
            sl.crosstabLayouts.clear();
            int clSize = this.crosstabLayouts.size();
            for (int i = 0; i < clSize; ++i) {
                PreparedCrosstabLayout o = (PreparedCrosstabLayout)this.crosstabLayouts.get(i);
                sl.crosstabLayouts.push((Object)o.derive());
            }
            return sl;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
    }

    public void setRenderer(Renderer renderer) {
        this.renderer = renderer;
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    protected void print(ExpressionRuntime dataRow, Band band) throws ReportProcessingException {
        this.renderer.add(band, dataRow, this.getCurrentEvent().getState().getProcessKey());
    }

    protected void printEmptyRootLevelBand() throws ReportProcessingException {
        this.renderer.addEmptyRootLevelBand(this.getCurrentEvent().getState().getProcessKey());
    }

    private void clearPendingPageStart(ReportEvent event) {
        this.clearPendingPageStart(event, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearPendingPageStart(ReportEvent event, boolean force) {
        this.pagebreakHandler.setReportState(event.getState());
        try {
            if (this.renderer.clearPendingPageStart(this.pagebreakHandler)) {
                return;
            }
            if (!force) {
                boolean validateResult;
                boolean currentPageEmpty = this.renderer.isCurrentPageEmpty();
                if (!currentPageEmpty) {
                    return;
                }
                boolean bl = validateResult = this.renderer.validatePages() != Renderer.LayoutResult.LAYOUT_UNVALIDATABLE;
                if (!validateResult) {
                    return;
                }
            }
            try {
                this.setCurrentEvent(event);
                this.renderer.newPageStarted();
                this.updateHeaderArea(event.getState());
            }
            finally {
                this.clearCurrentEvent();
            }
        }
        catch (ReportProcessingException e) {
            throw new FunctionProcessingException("Failed to update the page-header", (Exception)((Object)e));
        }
        catch (ContentProcessingException e) {
            throw new FunctionProcessingException("Failed to update the page-header", (Exception)((Object)e));
        }
        finally {
            this.pagebreakHandler.setReportState(null);
        }
    }

    public InlineSubreportMarker[] getInlineSubreports() {
        return this.inlineSubreports.toArray(new InlineSubreportMarker[this.inlineSubreports.size()]);
    }

    public void clearInlineSubreports(SubReportProcessType inlineExecution) {
        InlineSubreportMarker[] subreports = this.getInlineSubreports();
        for (int i = subreports.length - 1; i >= 0; --i) {
            InlineSubreportMarker subreport = subreports[i];
            if (inlineExecution != subreport.getProcessType()) continue;
            this.inlineSubreports.remove(i);
        }
    }

    public PreparedCrosstabLayout startCrosstabLayout() {
        PreparedCrosstabLayout layout = new PreparedCrosstabLayout();
        this.crosstabLayouts.push((Object)layout);
        return layout;
    }

    public PreparedCrosstabLayout getCurrentCrosstabLayout() {
        return (PreparedCrosstabLayout)this.crosstabLayouts.peek();
    }

    public void endCrosstabLayout() {
        this.crosstabLayouts.pop();
    }

    public void restart(ReportState state) throws ReportProcessingException {
        ReportEvent event = new ReportEvent(state, state.getEventCode());
        this.clearPendingPageStart(event, true);
    }

    public boolean createRollbackInformation() {
        Renderer commitableRenderer = this.getRenderer();
        commitableRenderer.createRollbackInformation();
        return true;
    }
}

