/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.output;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.layout.output.PageState;
import org.pentaho.reporting.engine.classic.core.layout.output.PageStateList;
import org.pentaho.reporting.engine.classic.core.layout.output.ReportProcessor;
import org.pentaho.reporting.engine.classic.core.util.WeakReferenceList;
import org.pentaho.reporting.libraries.base.config.ExtendedConfigurationWrapper;

public class DefaultPageStateList
implements PageStateList {
    private static final Log logger = LogFactory.getLog(DefaultPageStateList.class);
    private static final int MASTERPOSITIONS_MAX = 10;
    private static final int MASTERPOSITIONS_MED = 4;
    private static final int PRIMARY_MAX = 20;
    private static final int MASTER4_MAX = 100;
    private ArrayList<MasterList> masterStates10;
    private ArrayList<MasterList> masterStates4;
    private ArrayList<InternalStorageState> primaryStates;
    private int size;
    private ReportProcessor pageProcess;
    private int primaryPoolSize;
    private int secondaryPoolSize;
    private int secondaryPoolFrequency;
    private int tertiaryPoolFrequency;
    private int lastSafePosition;

    public DefaultPageStateList(ReportProcessor proc) {
        if (proc == null) {
            throw new NullPointerException("ReportProcessor null");
        }
        this.pageProcess = proc;
        ExtendedConfigurationWrapper config = new ExtendedConfigurationWrapper(proc.getConfiguration());
        this.primaryPoolSize = config.getIntProperty("org.pentaho.reporting.engine.classic.core.performance.pagestates.PrimaryPoolSize", 20);
        this.secondaryPoolFrequency = config.getIntProperty("org.pentaho.reporting.engine.classic.core.performance.pagestates.SecondaryPoolFrequency", 4);
        this.secondaryPoolSize = config.getIntProperty("org.pentaho.reporting.engine.classic.core.performance.pagestates.SecondaryPoolSize", 100) + this.primaryPoolSize;
        this.tertiaryPoolFrequency = config.getIntProperty("org.pentaho.reporting.engine.classic.core.performance.pagestates.TertiaryPoolFrequency", 10);
        if (this.primaryPoolSize < 1) {
            throw new IllegalStateException("Invalid configuration: Primary pool must be >= 1");
        }
        if (this.secondaryPoolSize < this.primaryPoolSize) {
            throw new IllegalStateException("Invalid configuration: Secondary pool must be >= primary pool");
        }
        if (this.secondaryPoolFrequency < 1) {
            throw new IllegalStateException("Invalid configuration: Secondary pool frequency must be >= 1");
        }
        if (this.tertiaryPoolFrequency < 1) {
            throw new IllegalStateException("Invalid configuration: Tertiary pool frequency must be >= 1");
        }
        this.primaryStates = new ArrayList(this.primaryPoolSize);
        this.masterStates4 = new ArrayList(this.secondaryPoolSize);
        this.masterStates10 = new ArrayList();
    }

    private int getMasterPos(int pos, int maxListSize) {
        return pos / maxListSize;
    }

    protected ReportProcessor getPageProcess() {
        return this.pageProcess;
    }

    public int size() {
        return this.size;
    }

    public void add(PageState pageState) {
        InternalStorageState state;
        if (pageState == null) {
            throw new NullPointerException();
        }
        int size = this.size();
        if (!pageState.isSafeToStoreEarly()) {
            state = new InternalStorageState(null, size, this.lastSafePosition);
        } else {
            this.lastSafePosition = size;
            pageState.prepareStorage();
            state = new InternalStorageState(pageState, size, this.lastSafePosition);
        }
        if (size < this.primaryPoolSize) {
            this.primaryStates.add(state);
            ++this.size;
        } else if (size < this.secondaryPoolSize) {
            int secPos = size - this.primaryPoolSize;
            int masterPos = this.getMasterPos(secPos, this.secondaryPoolFrequency);
            if (masterPos >= this.masterStates4.size()) {
                MasterList master = new MasterList(this, this.secondaryPoolFrequency);
                this.masterStates4.add(master);
                master.add(state);
            } else {
                MasterList master = this.masterStates4.get(masterPos);
                master.add(state);
            }
            ++this.size;
        } else {
            int thirdPos = size - this.secondaryPoolSize;
            int masterPos = this.getMasterPos(thirdPos, this.tertiaryPoolFrequency);
            if (masterPos >= this.masterStates10.size()) {
                MasterList master = new MasterList(this, this.tertiaryPoolFrequency);
                this.masterStates10.add(master);
                master.add(state);
            } else {
                MasterList master = this.masterStates10.get(masterPos);
                master.add(state);
            }
            ++this.size;
        }
    }

    protected void set(int index, InternalStorageState state) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        if (index != state.getStorePosition()) {
            throw new IllegalArgumentException();
        }
        if (index < this.primaryPoolSize) {
            InternalStorageState o = this.primaryStates.get(index);
            if (o.isValidRestorePoint()) {
                throw new IllegalArgumentException();
            }
            this.primaryStates.set(index, state);
        } else if (index < this.secondaryPoolSize) {
            int secPos = index - this.primaryPoolSize;
            int masterPos = this.getMasterPos(secPos, this.secondaryPoolFrequency);
            if (masterPos >= this.masterStates4.size()) {
                throw new IllegalStateException("Replacing an existing entry must not generate a new list slot.");
            }
            MasterList master = this.masterStates4.get(masterPos);
            InternalStorageState o = (InternalStorageState)master.getRaw(secPos);
            if (o != null && o.isValidRestorePoint()) {
                throw new IllegalArgumentException();
            }
            master.set(state, secPos);
        } else {
            int thirdPos = index - this.secondaryPoolSize;
            int masterPos = this.getMasterPos(thirdPos, this.tertiaryPoolFrequency);
            if (masterPos >= this.masterStates10.size()) {
                throw new IllegalStateException("Replacing an existing entry must not generate a new list slot.");
            }
            MasterList master = this.masterStates10.get(masterPos);
            InternalStorageState o = (InternalStorageState)master.getRaw(thirdPos);
            if (o != null && o.isValidRestorePoint()) {
                throw new IllegalArgumentException();
            }
            master.set(state, thirdPos);
        }
    }

    public void clear() {
        this.masterStates10.clear();
        this.masterStates4.clear();
        this.primaryStates.clear();
        this.size = 0;
    }

    public PageState get(int index) {
        if (index >= this.size() || index < 0) {
            throw new IndexOutOfBoundsException("Index is invalid. Index was " + index + "; size was " + this.size());
        }
        InternalStorageState internal = this.getInternal(index);
        if (!internal.isValidRestorePoint()) {
            try {
                int targetPageCursor = internal.getStorePosition();
                int stateCounter = internal.getLastSavePosition();
                for (int i = targetPageCursor - 1; i >= stateCounter; --i) {
                    InternalStorageState startState = this.getInternal(i);
                    if (!startState.isValidRestorePoint()) continue;
                    InternalStorageState internalStorageState = this.restoreState(targetPageCursor, i, startState);
                    return internalStorageState.getPageState();
                }
                throw new IllegalStateException();
            }
            catch (ReportProcessingException e) {
                throw new IllegalStateException((Throwable)((Object)e));
            }
        }
        return internal.getPageState();
    }

    private InternalStorageState restoreState(int pageCursor, int lastSaveState, InternalStorageState rootstate) throws ReportProcessingException {
        logger.info((Object)("Restoring global state " + pageCursor + " from " + lastSaveState));
        if (rootstate == null) {
            throw new NullPointerException("Master is null");
        }
        if (!rootstate.isValidRestorePoint()) {
            throw new IllegalArgumentException();
        }
        InternalStorageState state = rootstate;
        for (int i = lastSaveState; i < pageCursor; ++i) {
            ReportProcessor pageProcess = this.getPageProcess();
            PageState pageState = pageProcess.processPage(state.getPageState(), false);
            if (pageState == null) {
                throw new IllegalStateException("State returned is null: Report processing reached premature end-point.");
            }
            state = new InternalStorageState(pageState, i + 1, rootstate.getLastSavePosition());
            if (!pageState.isSafeToStoreEarly()) continue;
            this.set(i + 1, state);
        }
        return state;
    }

    private InternalStorageState getInternal(int index) {
        if (index < this.primaryPoolSize) {
            return this.primaryStates.get(index);
        }
        if (index < this.secondaryPoolSize) {
            MasterList master = this.masterStates4.get(this.getMasterPos(index -= this.primaryPoolSize, this.secondaryPoolFrequency));
            return (InternalStorageState)master.get(index);
        }
        MasterList master = this.masterStates10.get(this.getMasterPos(index -= this.secondaryPoolSize, this.tertiaryPoolFrequency));
        return (InternalStorageState)master.get(index);
    }

    private static class InternalStorageState {
        private PageState pageState;
        private int storePosition;
        private int lastSavePosition;

        private InternalStorageState(PageState pageState, int storePosition, int lastSavePosition) {
            this.pageState = pageState;
            this.storePosition = storePosition;
            this.lastSavePosition = lastSavePosition;
        }

        public PageState getPageState() {
            return this.pageState;
        }

        public int getStorePosition() {
            return this.storePosition;
        }

        public int getLastSavePosition() {
            return this.lastSavePosition;
        }

        public boolean isValidRestorePoint() {
            if (this.pageState == null) {
                return false;
            }
            return this.pageState.isSafeToStoreEarly();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MasterList
    extends WeakReferenceList<InternalStorageState> {
        private final DefaultPageStateList master;

        private MasterList(DefaultPageStateList list, int maxChildCount) {
            super(maxChildCount);
            this.master = list;
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }

        @Override
        protected InternalStorageState restoreChild(int index) {
            InternalStorageState master = (InternalStorageState)this.getMaster();
            if (master == null) {
                throw new IllegalStateException("We cannot have a master list without a master state");
            }
            try {
                int max = this.getChildPos(index);
                logger.info((Object)("Restoring weak state " + master.getStorePosition() + " for # " + max));
                if (!master.isValidRestorePoint()) {
                    InternalStorageState state = DefaultPageStateList.this.restoreState(master.getStorePosition(), master.getLastSavePosition(), DefaultPageStateList.this.getInternal(master.getLastSavePosition()));
                    this.setMaster(state);
                    master = state;
                }
                return this.restoreState(max, master);
            }
            catch (Exception rpe) {
                logger.debug((Object)"Caught exception while restoring a saved page-state", (Throwable)rpe);
                throw new IllegalStateException("Something went wrong while trying to restore the child #" + index);
            }
        }

        private InternalStorageState restoreState(int count, InternalStorageState rootstate) throws ReportProcessingException {
            if (rootstate == null) {
                throw new NullPointerException("Master is null");
            }
            InternalStorageState state = rootstate;
            for (int i = 0; i <= count; ++i) {
                ReportProcessor pageProcess = this.master.getPageProcess();
                PageState pageState = pageProcess.processPage(state.getPageState(), false);
                if (pageState == null) {
                    throw new IllegalStateException("State returned is null: Report processing reached premature end-point.");
                }
                state = new InternalStorageState(pageState, rootstate.getStorePosition() + i, rootstate.getLastSavePosition());
                if (!state.isValidRestorePoint()) continue;
                this.set(state, i + 1);
            }
            return state;
        }
    }
}

