/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.output;

import java.io.File;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.DefaultReportEnvironment;
import org.pentaho.reporting.engine.classic.core.DefaultResourceBundleFactory;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportEnvironment;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.ResourceBundleFactory;
import org.pentaho.reporting.engine.classic.core.function.ProcessingContext;
import org.pentaho.reporting.engine.classic.core.layout.DefaultLayoutSupport;
import org.pentaho.reporting.engine.classic.core.layout.LayoutSupport;
import org.pentaho.reporting.engine.classic.core.layout.output.GenericOutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.docbundle.DocumentMetaData;
import org.pentaho.reporting.libraries.docbundle.MemoryDocumentMetaData;
import org.pentaho.reporting.libraries.formula.DefaultFormulaContext;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class DefaultProcessingContext
implements ProcessingContext {
    private FormulaContext formulaContext;
    private boolean prepareRun;
    private LayoutSupport layoutSupport;
    private int processingLevel;
    private OutputProcessorMetaData outputProcessorMetaData;
    private ResourceBundleFactory resourceBundleFactory;
    private Configuration configuration;
    private int progressLevelCount;
    private int progressLevel;
    private ResourceManager resourceManager;
    private ResourceKey contentBase;
    private DocumentMetaData metaData;
    private ReportEnvironment reportEnvironment;
    private int compatibilityLevel;

    public DefaultProcessingContext() {
        this.outputProcessorMetaData = new GenericOutputProcessorMetaData();
        this.layoutSupport = new DefaultLayoutSupport(true, true);
        this.resourceBundleFactory = new DefaultResourceBundleFactory();
        this.configuration = ClassicEngineBoot.getInstance().getGlobalConfig();
        this.resourceManager = new ResourceManager();
        this.resourceManager.registerDefaults();
        this.reportEnvironment = new DefaultReportEnvironment(this.configuration);
        try {
            this.contentBase = this.resourceManager.createKey((Object)new File("."));
        }
        catch (ResourceKeyCreationException rkce) {
            this.contentBase = null;
        }
        this.metaData = new MemoryDocumentMetaData();
        this.compatibilityLevel = -1;
    }

    @Deprecated
    public DefaultProcessingContext(ResourceKey contentBase) {
        this();
        if (contentBase != null) {
            this.contentBase = contentBase;
        }
    }

    @Deprecated
    public DefaultProcessingContext(Configuration configuration, ReportEnvironment reportEnvironment) {
        this();
        if (configuration == null) {
            throw new NullPointerException();
        }
        if (reportEnvironment == null) {
            throw new NullPointerException();
        }
        this.configuration = configuration;
        this.reportEnvironment = reportEnvironment;
    }

    @Deprecated
    public DefaultProcessingContext(ResourceBundleFactory resourceBundleFactory, Configuration configuration) {
        this();
        if (resourceBundleFactory == null) {
            throw new NullPointerException();
        }
        if (configuration == null) {
            throw new NullPointerException();
        }
        this.resourceBundleFactory = resourceBundleFactory;
        this.configuration = configuration;
        this.reportEnvironment = new DefaultReportEnvironment(configuration);
    }

    public DefaultProcessingContext(MasterReport report) throws ReportProcessingException {
        this(new GenericOutputProcessorMetaData(report.getConfiguration()), new DefaultLayoutSupport(true, true), report.getResourceBundleFactory(), report.getConfiguration(), report.getResourceManager(), report.getContentBase(), report.getBundle().getMetaData(), report.getReportEnvironment(), -1);
        Integer comLev = report.getCompatibilityLevel();
        if (comLev != null) {
            this.compatibilityLevel = comLev;
        }
    }

    @Deprecated
    public DefaultProcessingContext(ResourceBundleFactory resourceBundleFactory, Configuration configuration, ResourceManager resourceManager, ResourceKey contentBase, DocumentMetaData metaData, ReportEnvironment environment) throws ReportProcessingException {
        this(new GenericOutputProcessorMetaData(configuration), new DefaultLayoutSupport(true, true), resourceBundleFactory, configuration, resourceManager, contentBase, metaData, environment, -1);
    }

    public DefaultProcessingContext(OutputProcessorMetaData outputProcessorMetaData, LayoutSupport layoutSupport, ResourceBundleFactory resourceBundleFactory, Configuration configuration, ResourceManager resourceManager, ResourceKey contentBase, DocumentMetaData metaData, ReportEnvironment environment, int compatibilityLevel) throws ReportProcessingException {
        if (environment == null) {
            throw new NullPointerException();
        }
        if (configuration == null) {
            throw new NullPointerException();
        }
        if (outputProcessorMetaData == null) {
            throw new NullPointerException();
        }
        if (layoutSupport == null) {
            throw new NullPointerException();
        }
        if (resourceBundleFactory == null) {
            throw new NullPointerException();
        }
        if (resourceManager == null) {
            throw new NullPointerException();
        }
        this.contentBase = contentBase;
        this.resourceManager = resourceManager;
        this.formulaContext = new DefaultFormulaContext();
        this.outputProcessorMetaData = outputProcessorMetaData;
        this.resourceBundleFactory = MasterReport.computeAndInitResourceBundleFactory(resourceBundleFactory, environment);
        this.configuration = configuration;
        this.layoutSupport = layoutSupport;
        this.metaData = metaData == null ? new MemoryDocumentMetaData() : metaData;
        this.reportEnvironment = environment;
        this.compatibilityLevel = compatibilityLevel;
    }

    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public ResourceKey getContentBase() {
        return this.contentBase;
    }

    public int getProgressLevel() {
        return this.progressLevel;
    }

    public void setProgressLevel(int progressLevel) {
        this.progressLevel = progressLevel;
    }

    public int getProgressLevelCount() {
        return this.progressLevelCount;
    }

    public void setProgressLevelCount(int progressLevelCount) {
        this.progressLevelCount = progressLevelCount;
    }

    public void setProcessingLevel(int processingLevel) {
        this.processingLevel = processingLevel;
    }

    public int getProcessingLevel() {
        return this.processingLevel;
    }

    public FormulaContext getFormulaContext() {
        return this.formulaContext;
    }

    public void setPrepareRun(boolean prepareRun) {
        this.prepareRun = prepareRun;
    }

    public boolean isPrepareRun() {
        return this.prepareRun;
    }

    public String getExportDescriptor() {
        return this.outputProcessorMetaData.getExportDescriptor();
    }

    public OutputProcessorMetaData getOutputProcessorMetaData() {
        return this.outputProcessorMetaData;
    }

    public LayoutSupport getLayoutSupport() {
        return this.layoutSupport;
    }

    public ResourceBundleFactory getResourceBundleFactory() {
        return this.resourceBundleFactory;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public DocumentMetaData getDocumentMetaData() {
        return this.metaData;
    }

    public ReportEnvironment getEnvironment() {
        return this.reportEnvironment;
    }

    public int getCompatibilityLevel() {
        return this.compatibilityLevel;
    }
}

