/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.output;

import javax.swing.table.TableModel;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ResourceBundleFactory;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.function.ProcessingContext;
import org.pentaho.reporting.engine.classic.core.states.GroupingState;
import org.pentaho.reporting.engine.classic.core.states.ReportState;
import org.pentaho.reporting.engine.classic.core.wizard.DataSchema;
import org.pentaho.reporting.libraries.base.config.Configuration;

public class LayoutExpressionRuntime
implements ExpressionRuntime {
    private DataRow dataRow;
    private TableModel data;
    private DataSchema dataSchema;
    private ProcessingContext processingContext;
    private ReportState state;
    private GroupingState groupingState;

    public LayoutExpressionRuntime(DataRow dataRow, DataSchema dataSchema, ReportState state, TableModel data, ProcessingContext processingContext) {
        if (dataSchema == null) {
            throw new NullPointerException();
        }
        if (processingContext == null) {
            throw new NullPointerException();
        }
        if (dataRow == null) {
            throw new NullPointerException();
        }
        if (state == null) {
            throw new NullPointerException();
        }
        this.state = state;
        this.groupingState = state.createGroupingState();
        this.dataSchema = dataSchema;
        this.processingContext = processingContext;
        this.dataRow = dataRow;
        this.data = data;
    }

    public DataFactory getDataFactory() {
        return this.state.getFlowController().getDataFactory();
    }

    public DataSchema getDataSchema() {
        return this.dataSchema;
    }

    public ProcessingContext getProcessingContext() {
        return this.processingContext;
    }

    public Configuration getConfiguration() {
        return this.getProcessingContext().getConfiguration();
    }

    public DataRow getDataRow() {
        return this.dataRow;
    }

    public TableModel getData() {
        return this.data;
    }

    public int getCurrentRow() {
        return this.state.getCurrentDataItem();
    }

    public int getCurrentGroup() {
        return this.groupingState.getCurrentGroup();
    }

    public int getGroupStartRow(String groupName) {
        return this.groupingState.getGroupStartRow(groupName);
    }

    public int getGroupStartRow(int groupIndex) {
        return this.groupingState.getGroupStartRow(groupIndex);
    }

    public ResourceBundleFactory getResourceBundleFactory() {
        return this.getProcessingContext().getResourceBundleFactory();
    }

    public String getExportDescriptor() {
        return this.getProcessingContext().getExportDescriptor();
    }
}

