/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.output;

import java.util.ArrayList;
import org.pentaho.reporting.engine.classic.core.layout.InlineSubreportMarker;
import org.pentaho.reporting.engine.classic.core.layout.model.BlockRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RowRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.style.CrosstabHeaderStyleSheet;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;

public class PreparedCrosstabLayout
implements Cloneable {
    private InstanceID columnHeaderTitleBoxId;
    private InstanceID columnHeaderBoxId;
    private InstanceID rowHeaderTitleBoxId;
    private InstanceID rowFooterTitleBoxId;
    private InstanceID rowHeaderBoxId;
    private InstanceID rowFooterBoxId;
    private InstanceID cellDataBoxId;
    private RowRenderBox headerBox;
    private RowRenderBox dataBox;
    private ArrayList headerSubReports = new ArrayList();
    private ArrayList dataSubReports = new ArrayList();
    private boolean finishPending;
    private int rowCount;

    public PreparedCrosstabLayout() {
        CrosstabHeaderStyleSheet styleSheet = new CrosstabHeaderStyleSheet();
        RowRenderBox rowFooterTitleBox = new RowRenderBox(styleSheet);
        rowFooterTitleBox.setName("rowFooterTitleBox");
        RowRenderBox rowHeaderTitleBox = new RowRenderBox(styleSheet);
        rowHeaderTitleBox.setName("rowHeaderTitleBox");
        RowRenderBox columnHeaderTitleBox = new RowRenderBox(styleSheet);
        columnHeaderTitleBox.setName("columnHeaderTitleBox");
        RowRenderBox columnHeaderBox = new RowRenderBox(styleSheet);
        columnHeaderBox.setName("columnHeaderBox");
        this.rowFooterTitleBoxId = rowFooterTitleBox.getInstanceId();
        this.rowHeaderTitleBoxId = rowHeaderTitleBox.getInstanceId();
        this.columnHeaderTitleBoxId = columnHeaderTitleBox.getInstanceId();
        this.columnHeaderBoxId = columnHeaderBox.getInstanceId();
        RowRenderBox rowHeaderBox = new RowRenderBox(styleSheet);
        rowHeaderBox.setName("rowHeaderBox");
        RowRenderBox rowFooterBox = new RowRenderBox(styleSheet);
        rowFooterBox.setName("rowFooterBox");
        RowRenderBox cellDataBox = new RowRenderBox(styleSheet);
        cellDataBox.setName("cellDataBox");
        this.rowHeaderBoxId = rowHeaderBox.getInstanceId();
        this.rowFooterBoxId = rowFooterBox.getInstanceId();
        this.cellDataBoxId = cellDataBox.getInstanceId();
        BlockRenderBox columnHeaderArea = new BlockRenderBox(styleSheet);
        columnHeaderArea.setName("columnHeaderArea");
        columnHeaderArea.addChild(columnHeaderTitleBox);
        columnHeaderArea.addChild(columnHeaderBox);
        columnHeaderArea.close();
        this.headerBox = new RowRenderBox(styleSheet);
        this.headerBox.setName("headerBox");
        this.headerBox.addChild(rowHeaderTitleBox);
        this.headerBox.addChild(columnHeaderArea);
        this.headerBox.addChild(rowFooterTitleBox);
        this.headerBox.close();
        this.dataBox = new RowRenderBox(styleSheet);
        this.dataBox.setName("dataBox");
        this.dataBox.addChild(rowHeaderBox);
        this.dataBox.addChild(cellDataBox);
        this.dataBox.addChild(rowFooterBox);
        this.dataBox.close();
    }

    public RenderBox getColumnHeaderTitleBox() {
        RenderBox renderBox = (RenderBox)this.headerBox.findNodeById(this.columnHeaderTitleBoxId);
        if (renderBox == null) {
            throw new IllegalStateException();
        }
        return renderBox;
    }

    public RenderBox getColumnHeaderBox() {
        RenderBox renderBox = (RenderBox)this.headerBox.findNodeById(this.columnHeaderBoxId);
        if (renderBox == null) {
            throw new IllegalStateException();
        }
        return renderBox;
    }

    public RenderBox getRowHeaderTitleBox() {
        RenderBox renderBox = (RenderBox)this.headerBox.findNodeById(this.rowHeaderTitleBoxId);
        if (renderBox == null) {
            throw new IllegalStateException();
        }
        return renderBox;
    }

    public RenderBox getRowFooterTitleBox() {
        RenderBox renderBox = (RenderBox)this.headerBox.findNodeById(this.rowFooterTitleBoxId);
        if (renderBox == null) {
            throw new IllegalStateException();
        }
        return renderBox;
    }

    public RenderBox getRowHeaderBox() {
        RenderBox renderBox = (RenderBox)this.dataBox.findNodeById(this.rowHeaderBoxId);
        if (renderBox == null) {
            throw new IllegalStateException();
        }
        return renderBox;
    }

    public RenderBox getRowFooterBox() {
        RenderBox renderBox = (RenderBox)this.dataBox.findNodeById(this.rowFooterBoxId);
        if (renderBox == null) {
            throw new IllegalStateException();
        }
        return renderBox;
    }

    public RenderBox getCellDataBox() {
        RenderBox renderBox = (RenderBox)this.dataBox.findNodeById(this.cellDataBoxId);
        if (renderBox == null) {
            throw new IllegalStateException();
        }
        return renderBox;
    }

    public PreparedCrosstabLayout derive() throws CloneNotSupportedException {
        PreparedCrosstabLayout layout = (PreparedCrosstabLayout)super.clone();
        layout.dataBox = (RowRenderBox)this.dataBox.derive(true);
        layout.headerBox = (RowRenderBox)this.headerBox.derive(true);
        return layout;
    }

    public Object clone() throws CloneNotSupportedException {
        PreparedCrosstabLayout o = (PreparedCrosstabLayout)super.clone();
        o.dataBox = (RowRenderBox)this.dataBox.clone();
        o.headerBox = (RowRenderBox)this.headerBox.clone();
        return o;
    }

    public boolean isFinishPending() {
        return this.finishPending;
    }

    public void setFinishPending(boolean finishPending) {
        this.finishPending = finishPending;
    }

    public InlineSubreportMarker[] getHeaderSubReportMarker() {
        return this.headerSubReports.toArray(new InlineSubreportMarker[this.headerSubReports.size()]);
    }

    public InlineSubreportMarker[] getDataSubReportMarker() {
        return this.dataSubReports.toArray(new InlineSubreportMarker[this.dataSubReports.size()]);
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public void setRowCount(int rowCount) {
        this.rowCount = rowCount;
    }

    public RenderBox getPrintableDataBox() {
        RowRenderBox dataBox = (RowRenderBox)this.dataBox.derive(true);
        RenderBox cellDataBox = (RenderBox)dataBox.findNodeById(this.cellDataBoxId);
        RenderBox rowFooterBox = (RenderBox)dataBox.findNodeById(this.rowFooterBoxId);
        RenderBox rowHeaderBox = (RenderBox)dataBox.findNodeById(this.rowHeaderBoxId);
        this.closeBoxAndChilds(rowFooterBox, false);
        this.closeBoxAndChilds(rowHeaderBox, false);
        this.closeBoxAndChilds(cellDataBox, false);
        return dataBox;
    }

    public RenderBox getPrintableHeaderBox() {
        RowRenderBox headerBox = (RowRenderBox)this.headerBox.derive(true);
        RenderBox rowFooterTitleBox = (RenderBox)headerBox.findNodeById(this.rowFooterTitleBoxId);
        RenderBox rowHeaderTitleBox = (RenderBox)headerBox.findNodeById(this.rowHeaderTitleBoxId);
        RenderBox columnHeaderTitleBox = (RenderBox)headerBox.findNodeById(this.columnHeaderTitleBoxId);
        RenderBox columnHeaderBox = (RenderBox)headerBox.findNodeById(this.columnHeaderBoxId);
        this.closeBoxAndChilds(rowFooterTitleBox, false);
        this.closeBoxAndChilds(rowHeaderTitleBox, false);
        this.closeBoxAndChilds(columnHeaderTitleBox, true);
        this.closeBoxAndChilds(columnHeaderBox, true);
        return headerBox;
    }

    private void closeBoxAndChilds(RenderBox box, boolean secondLevel) {
        box.close();
        for (RenderBox child = (RenderBox)box.getFirstChild(); child != null; child = (RenderBox)child.getNext()) {
            if (secondLevel) {
                this.closeBoxAndChilds(child, false);
                continue;
            }
            child.close();
        }
    }
}

