/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.output;

import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.GroupFooter;
import org.pentaho.reporting.engine.classic.core.GroupHeader;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.layout.Renderer;
import org.pentaho.reporting.engine.classic.core.layout.output.DefaultOutputFunction;
import org.pentaho.reporting.engine.classic.core.layout.output.GroupOutputHandler;

public class RelationalGroupOutputHandler
implements GroupOutputHandler {
    public void groupStarted(DefaultOutputFunction outputFunction, ReportEvent event) throws ReportProcessingException {
        outputFunction.updateFooterArea(event);
        Renderer renderer = outputFunction.getRenderer();
        int gidx = event.getState().getCurrentGroupIndex();
        Group g = event.getReport().getGroup(gidx);
        GroupHeader b = g.getHeader();
        renderer.startGroup(g);
        renderer.startSection(0);
        outputFunction.print(outputFunction.getRuntime(), b);
        outputFunction.addSubReportMarkers(renderer.endSection());
        renderer.startGroupBody(g.getBody());
    }

    public void itemsStarted(DefaultOutputFunction outputFunction, ReportEvent event) throws ReportProcessingException {
        int numberOfRows = event.getState().getNumberOfRows();
        Renderer renderer = outputFunction.getRenderer();
        outputFunction.updateFooterArea(event);
        renderer.startSection(0);
        outputFunction.print(outputFunction.getRuntime(), event.getReport().getDetailsHeader());
        outputFunction.addSubReportMarkers(renderer.endSection());
        if (numberOfRows == 0) {
            renderer.startSection(0);
            outputFunction.print(outputFunction.getRuntime(), event.getReport().getNoDataBand());
            outputFunction.addSubReportMarkers(renderer.endSection());
        }
    }

    public void itemsAdvanced(DefaultOutputFunction outputFunction, ReportEvent event) throws ReportProcessingException {
        Renderer renderer = outputFunction.getRenderer();
        outputFunction.updateFooterArea(event);
        renderer.startSection(0);
        outputFunction.print(outputFunction.getRuntime(), event.getReport().getItemBand());
        outputFunction.addSubReportMarkers(renderer.endSection());
    }

    public void itemsFinished(DefaultOutputFunction outputFunction, ReportEvent event) throws ReportProcessingException {
        Renderer renderer = outputFunction.getRenderer();
        outputFunction.updateFooterArea(event);
        renderer.startSection(0);
        outputFunction.print(outputFunction.getRuntime(), event.getReport().getDetailsFooter());
        outputFunction.addSubReportMarkers(renderer.endSection());
    }

    public void groupFinished(DefaultOutputFunction outputFunction, ReportEvent event) throws ReportProcessingException {
        Renderer renderer = outputFunction.getRenderer();
        outputFunction.updateFooterArea(event);
        int gidx = event.getState().getCurrentGroupIndex();
        Group g = event.getReport().getGroup(gidx);
        GroupFooter b = g.getFooter();
        renderer.endGroupBody();
        renderer.startSection(0);
        outputFunction.print(outputFunction.getRuntime(), b);
        outputFunction.addSubReportMarkers(renderer.endSection());
        renderer.endGroup();
    }
}

