/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process;

import org.pentaho.reporting.engine.classic.core.layout.model.BlockRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.CanvasRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.InlineRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.ParagraphRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableReplacedContentBox;
import org.pentaho.reporting.engine.classic.core.layout.process.CacheBoxShifter;
import org.pentaho.reporting.engine.classic.core.layout.process.IterateStructuralProcessStep;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;

public final class ApplyPageShiftValuesStep
extends IterateStructuralProcessStep {
    private long shift;
    private InstanceID triggerId;
    private boolean found;

    public void compute(LogicalPageBox logicalPageBox, long shift, InstanceID triggerId) {
        if (shift <= 0L) {
            throw new IllegalArgumentException("Why are you calling me with nothing to do?");
        }
        if (triggerId == null) {
            throw new IllegalArgumentException("Without a trigger I cannot fire up a shift");
        }
        this.shift = shift;
        this.triggerId = triggerId;
        this.found = false;
        this.startProcessing(logicalPageBox);
    }

    public boolean startCanvasBox(CanvasRenderBox box) {
        return this.processBox(box);
    }

    private boolean processBox(RenderNode box) {
        if (!this.found && box.getInstanceId() == this.triggerId) {
            this.found = true;
            CacheBoxShifter.extendHeight(box, this.shift);
        }
        if (this.found) {
            box.shiftCached(this.shift);
        }
        return true;
    }

    protected boolean startBlockBox(BlockRenderBox box) {
        return this.processBox(box);
    }

    protected boolean startInlineBox(InlineRenderBox box) {
        return this.processBox(box);
    }

    protected void processRenderableContent(RenderableReplacedContentBox box) {
        this.processBox(box);
    }

    protected boolean startRowBox(RenderBox box) {
        return this.processBox(box);
    }

    protected void processOtherNode(RenderNode node) {
        if (this.found) {
            node.shiftCached(this.shift);
        }
    }

    protected boolean startOtherBox(RenderBox box) {
        return this.processBox(box);
    }

    protected void processParagraphChilds(ParagraphRenderBox box) {
        this.processBoxChilds(box);
    }
}

