/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process;

import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;

public final class BoxShifter {
    private BoxShifter() {
    }

    public static void shiftBox(RenderNode box, long amount) {
        if (amount == 0L) {
            return;
        }
        if (amount < 0L) {
            throw new IllegalArgumentException("Cannot shift upwards: " + amount);
        }
        box.shift(amount);
        if ((box.getNodeType() & 2) == 2) {
            BoxShifter.shiftBoxInternal((RenderBox)box, amount);
        }
    }

    public static void shiftBoxUnchecked(RenderNode box, long amount) {
        if (amount == 0L) {
            return;
        }
        box.shift(amount);
        if ((box.getNodeType() & 2) == 2) {
            BoxShifter.shiftBoxInternal((RenderBox)box, amount);
        }
    }

    private static void shiftBoxInternal(RenderBox box, long amount) {
        for (RenderNode node = box.getFirstChild(); node != null; node = node.getNext()) {
            node.shift(amount);
            if ((node.getNodeType() & 2) != 2) continue;
            BoxShifter.shiftBoxInternal((RenderBox)node, amount);
        }
    }

    public static void extendHeight(RenderBox parent, long amount) {
        if (amount < 0L) {
            throw new IllegalArgumentException("Cannot shrink elements: " + parent + " + " + amount);
        }
        if (parent == null || amount == 0L) {
            return;
        }
        while (parent != null) {
            parent.setHeight(parent.getHeight() + amount);
            parent = parent.getParent();
        }
    }
}

