/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process;

import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;

public final class CacheBoxShifter {
    private CacheBoxShifter() {
    }

    public static void shiftBox(RenderNode box, long amount) {
        if (amount == 0L) {
            return;
        }
        if (amount < 0L) {
            throw new IllegalArgumentException("Cannot shift upwards: " + amount);
        }
        box.shiftCached(amount);
        if ((box.getNodeType() & 2) == 2) {
            CacheBoxShifter.shiftBoxInternal((RenderBox)box, amount);
        }
    }

    public static void shiftBoxUnchecked(RenderNode box, long amount) {
        if (amount == 0L) {
            return;
        }
        box.shiftCached(amount);
        if ((box.getNodeType() & 2) == 2) {
            CacheBoxShifter.shiftBoxInternal((RenderBox)box, amount);
        }
    }

    public static void shiftBoxChilds(RenderBox box, long amount) {
        if (amount == 0L) {
            return;
        }
        CacheBoxShifter.shiftBoxInternal(box, amount);
    }

    private static void shiftBoxInternal(RenderBox box, long amount) {
        for (RenderNode node = box.getFirstChild(); node != null; node = node.getNext()) {
            node.shiftCached(amount);
            if ((node.getNodeType() & 2) != 2) continue;
            CacheBoxShifter.shiftBoxInternal((RenderBox)node, amount);
        }
    }

    public static void extendHeight(RenderNode node, long amount) {
        if (amount < 0L) {
            throw new IllegalArgumentException("Cannot shrink elements.");
        }
        if (node == null || amount == 0L) {
            return;
        }
        node.setCachedHeight(node.getCachedHeight() + amount);
        for (RenderBox parent = node.getParent(); parent != null; parent = parent.getParent()) {
            parent.setCachedHeight(parent.getCachedHeight() + amount);
        }
    }
}

