/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.ElementAlignment;
import org.pentaho.reporting.engine.classic.core.layout.model.FinishedRenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.ParagraphRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderLength;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableReplacedContentBox;
import org.pentaho.reporting.engine.classic.core.layout.model.WatermarkAreaBox;
import org.pentaho.reporting.engine.classic.core.layout.model.context.BoxDefinition;
import org.pentaho.reporting.engine.classic.core.layout.model.context.StaticBoxLayoutProperties;
import org.pentaho.reporting.engine.classic.core.layout.process.CacheBoxShifter;
import org.pentaho.reporting.engine.classic.core.layout.process.IterateVisualProcessStep;
import org.pentaho.reporting.engine.classic.core.layout.process.ProcessUtility;
import org.pentaho.reporting.engine.classic.core.layout.process.ReplacedContentUtil;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictGeomUtility;

public final class CanvasMajorAxisLayoutStep
extends IterateVisualProcessStep {
    private static final Log logger = LogFactory.getLog(CanvasMajorAxisLayoutStep.class);
    private static final long MAX_AUTO = StrictGeomUtility.toInternalValue(8.796093022208E12);
    private boolean paranoidChecks = "true".equals(ClassicEngineBoot.getInstance().getGlobalConfig().getConfigProperty("org.pentaho.reporting.engine.classic.core.layout.process.ParanoidChecks"));

    public void compute(LogicalPageBox pageBox) {
        this.startProcessing(pageBox);
    }

    private long resolveParentHeight(RenderNode node) {
        RenderBox parent = node.getParent();
        if (parent == null) {
            LogicalPageBox box;
            if (node.getNodeType() == 133138 && (box = node.getLogicalPage()) != null) {
                return box.getPageHeight();
            }
            return 0L;
        }
        return parent.getCachedHeight();
    }

    protected boolean startBlockLevelBox(RenderBox box) {
        if (box.isCacheValid()) {
            return false;
        }
        long oldPosition = box.getCachedY();
        long newYPosition = this.computeVerticalBlockPosition(box);
        CacheBoxShifter.shiftBox(box, Math.max(0L, newYPosition - oldPosition));
        int nodeType = box.getNodeType();
        if (nodeType == 133138) {
            WatermarkAreaBox watermarkAreaBox = (WatermarkAreaBox)box;
            box.setCachedHeight(watermarkAreaBox.getLogicalPage().getPageHeight());
        } else {
            RenderBox watermark = this.isWatermark(box);
            if (watermark != null) {
                WatermarkAreaBox watermarkAreaBox = (WatermarkAreaBox)watermark;
                box.setCachedHeight(watermarkAreaBox.getLogicalPage().getPageHeight());
            } else if ((nodeType & 0x12) == 18) {
                long blockHeight = this.computeBlockHeightAndAlign(box, 0L, false);
                box.setCachedHeight(blockHeight);
            } else if ((nodeType & 0x82) == 130) {
                long blockHeight = this.computeRowHeightAndAlign(box, 0L, false);
                box.setCachedHeight(blockHeight);
            } else if (nodeType == 258) {
                RenderableReplacedContentBox rpc = (RenderableReplacedContentBox)box;
                box.setCachedHeight(ReplacedContentUtil.computeHeight(rpc, 0L, box.getCachedWidth()));
            } else {
                long cachedHeight = this.computeCanvasHeight(box, true);
                box.setCachedHeight(cachedHeight);
            }
        }
        return true;
    }

    private RenderBox isWatermark(RenderBox box) {
        RenderBox parent = box.getParent();
        if (parent == null) {
            return null;
        }
        if (parent.getNodeType() == 133138) {
            return parent;
        }
        RenderBox parent2 = parent.getParent();
        if (parent2 == null) {
            return null;
        }
        if (parent2.getNodeType() == 133138) {
            return parent2;
        }
        return null;
    }

    protected void processBlockLevelNode(RenderNode node) {
        node.setCachedY(this.computeVerticalBlockPosition(node));
        int type = node.getNodeType();
        if (type == 129) {
            FinishedRenderNode fnode = (FinishedRenderNode)node;
            node.setCachedHeight(fnode.getLayoutedHeight());
        } else if ((type & 0x42) == 66) {
            throw new IllegalStateException("A Inline-Box must be contained in a paragraph.");
        }
    }

    protected void finishBlockLevelBox(RenderBox box) {
        if (box.isCacheValid()) {
            return;
        }
        int nodeType = box.getNodeType();
        if (nodeType == 133138) {
            WatermarkAreaBox watermarkAreaBox = (WatermarkAreaBox)box;
            box.setCachedHeight(watermarkAreaBox.getLogicalPage().getPageHeight());
        } else {
            RenderBox watermark = this.isWatermark(box);
            if (watermark != null) {
                WatermarkAreaBox watermarkAreaBox = (WatermarkAreaBox)watermark;
                box.setCachedHeight(watermarkAreaBox.getLogicalPage().getPageHeight());
            } else if ((nodeType & 0x12) == 18) {
                long blockHeight = this.computeBlockHeightAndAlign(box, 0L, true);
                box.setCachedHeight(blockHeight);
            } else if ((nodeType & 0x82) == 130) {
                long blockHeight = this.computeRowHeightAndAlign(box, 0L, true);
                box.setCachedHeight(blockHeight);
            } else if (nodeType != 258) {
                box.setCachedHeight(this.computeCanvasHeight(box, true));
            }
        }
    }

    private long computeVerticalBlockPosition(RenderNode node) {
        long marginTop = 0L;
        RenderBox parent = node.getParent();
        if (parent == null) {
            return 0L;
        }
        if ((parent.getNodeType() & 0x12) == 18) {
            RenderNode prev = node.getPrev();
            if (prev != null) {
                return 0L + prev.getCachedY() + prev.getCachedHeight();
            }
            StaticBoxLayoutProperties blp = parent.getStaticBoxLayoutProperties();
            BoxDefinition bdef = parent.getBoxDefinition();
            long insetTop = blp.getBorderTop() + bdef.getPaddingTop();
            return 0L + insetTop + parent.getCachedY();
        }
        return 0L;
    }

    private long computeBlockHeightAndAlign(RenderBox box, long resolveSize, boolean alignChilds) {
        long computedContentHeight;
        long rprefH;
        long usedHeight;
        long childY2;
        long childY1;
        if (resolveSize < 0L) {
            throw new IllegalArgumentException("ResovleSize cannot be negative");
        }
        BoxDefinition boxDefinition = box.getBoxDefinition();
        RenderLength preferredHeight = boxDefinition.getPreferredHeight();
        RenderLength minimumHeight = boxDefinition.getMinimumHeight();
        RenderLength maximumHeight = boxDefinition.getMaximumHeight();
        RenderNode lastChildNode = box.getLastChild();
        if (lastChildNode != null) {
            childY1 = box.getFirstChild().getCachedY();
            childY2 = lastChildNode.getCachedY() + lastChildNode.getCachedHeight() + lastChildNode.getEffectiveMarginBottom();
            usedHeight = childY2 - childY1;
        } else {
            usedHeight = 0L;
            childY2 = 0L;
            childY1 = 0L;
        }
        long rminH = minimumHeight.resolve(resolveSize, 0L);
        long rmaxH = maximumHeight.resolve(resolveSize, MAX_AUTO);
        StaticBoxLayoutProperties blp = box.getStaticBoxLayoutProperties();
        long insetBottom = blp.getBorderBottom() + boxDefinition.getPaddingBottom();
        long insetTop = blp.getBorderTop() + boxDefinition.getPaddingTop();
        if (boxDefinition.isSizeSpecifiesBorderBox()) {
            rprefH = preferredHeight.resolve(resolveSize, usedHeight + insetTop + insetBottom);
            long specifiedHeight = ProcessUtility.computeLength(rminH, rmaxH, rprefH);
            computedContentHeight = specifiedHeight - insetTop - insetBottom;
        } else {
            rprefH = preferredHeight.resolve(resolveSize, usedHeight);
            computedContentHeight = ProcessUtility.computeLength(rminH, rmaxH, rprefH);
        }
        if (alignChilds && lastChildNode != null && computedContentHeight > usedHeight) {
            ElementAlignment valign = box.getNodeLayoutProperties().getVerticalAlignment();
            if (ElementAlignment.BOTTOM.equals(valign)) {
                long boxBottom = box.getCachedY() + computedContentHeight - insetBottom;
                long delta = boxBottom - childY2;
                CacheBoxShifter.shiftBoxChilds(box, delta);
            } else if (ElementAlignment.MIDDLE.equals(valign)) {
                long extraHeight = computedContentHeight - usedHeight;
                long boxTop = box.getCachedY() + insetTop + extraHeight / 2L;
                long delta = boxTop - childY1;
                CacheBoxShifter.shiftBoxChilds(box, delta);
            }
        }
        long retval = Math.max(0L, computedContentHeight + insetTop + insetBottom);
        if (box.getNodeType() == 133138) {
            WatermarkAreaBox watermarkAreaBox = (WatermarkAreaBox)box;
            LogicalPageBox lpb = watermarkAreaBox.getLogicalPage();
            return Math.max(retval, Math.max(0L, lpb.getPageHeight() - insetTop - insetBottom));
        }
        return retval;
    }

    private long computeRowHeightAndAlign(RenderBox box, long resolveSize, boolean align) {
        long retval;
        long computedContentHeight;
        long rprefH;
        long usedHeight;
        RenderNode child;
        if (resolveSize < 0L) {
            throw new IllegalArgumentException("ResovleSize cannot be negative");
        }
        if (box.getNodeType() == 133138) {
            WatermarkAreaBox watermarkAreaBox = (WatermarkAreaBox)box;
            LogicalPageBox lpb = watermarkAreaBox.getLogicalPage();
            return lpb.getPageHeight();
        }
        BoxDefinition boxDefinition = box.getBoxDefinition();
        RenderLength preferredHeight = boxDefinition.getPreferredHeight();
        RenderLength minimumHeight = boxDefinition.getMinimumHeight();
        RenderLength maximumHeight = boxDefinition.getMaximumHeight();
        StaticBoxLayoutProperties blp = box.getStaticBoxLayoutProperties();
        long insetBottom = blp.getBorderBottom() + boxDefinition.getPaddingBottom();
        long insetTop = blp.getBorderTop() + boxDefinition.getPaddingTop();
        long maxChildY2 = box.getCachedY() + box.getCachedHeight();
        if (child != null) {
            for (child = box.getFirstChild(); child != null; child = child.getNext()) {
                maxChildY2 = Math.max(child.getCachedY() + child.getCachedHeight() + child.getEffectiveMarginBottom(), maxChildY2);
            }
            usedHeight = maxChildY2 - (box.getCachedY() + insetTop);
        } else {
            usedHeight = 0L;
        }
        long rminH = minimumHeight.resolve(resolveSize, 0L);
        long rmaxH = maximumHeight.resolve(resolveSize, MAX_AUTO);
        if (boxDefinition.isSizeSpecifiesBorderBox()) {
            rprefH = preferredHeight.resolve(resolveSize, usedHeight + insetTop + insetBottom);
            long specifiedHeight = ProcessUtility.computeLength(rminH, rmaxH, rprefH);
            computedContentHeight = specifiedHeight - insetTop - insetBottom;
        } else {
            rprefH = preferredHeight.resolve(resolveSize, usedHeight);
            computedContentHeight = ProcessUtility.computeLength(rminH, rmaxH, rprefH);
        }
        if (align) {
            ElementAlignment valign = box.getNodeLayoutProperties().getVerticalAlignment();
            long boxY1 = box.getCachedY() + insetTop;
            long boxY2 = boxY1 + computedContentHeight;
            for (child = box.getFirstChild(); child != null; child = child.getNext()) {
                long childY1 = child.getCachedY();
                long childY2 = childY1 + child.getCachedHeight();
                if (ElementAlignment.BOTTOM.equals(valign)) {
                    long boxBottom = boxY2 - insetBottom;
                    long delta = boxBottom - childY2;
                    CacheBoxShifter.shiftBox(child, delta);
                    continue;
                }
                if (!ElementAlignment.MIDDLE.equals(valign)) continue;
                long extraHeight = computedContentHeight - (childY2 - childY1);
                long boxTop = boxY1 + extraHeight / 2L;
                long delta = boxTop - childY1;
                CacheBoxShifter.shiftBox(child, delta);
            }
        }
        if ((retval = Math.max(0L, computedContentHeight + insetTop + insetBottom)) < 0L) {
            throw new IllegalStateException("A child cannot exceed the area of the parent.");
        }
        if (retval == 0L && box.getCachedHeight() > 0L) {
            throw new IllegalStateException("A child cannot exceed the area of the parent.");
        }
        return retval;
    }

    protected void processParagraphChilds(ParagraphRenderBox box) {
    }

    protected boolean startCanvasLevelBox(RenderBox box) {
        if (box.isCacheValid()) {
            return false;
        }
        long oldPosition = box.getCachedY();
        long newYPosition = this.computeVerticalCanvasPosition(box);
        CacheBoxShifter.shiftBox(box, Math.max(0L, newYPosition - oldPosition));
        int nodeType = box.getNodeType();
        if ((nodeType & 0x12) == 18) {
            long resolveSize = this.resolveParentHeight(box);
            long blockHeight = this.computeBlockHeightAndAlign(box, resolveSize, false);
            box.setCachedHeight(blockHeight);
        } else if ((nodeType & 0x82) == 130) {
            long resolveSize = this.resolveParentHeight(box);
            long blockHeight = this.computeRowHeightAndAlign(box, resolveSize, false);
            box.setCachedHeight(blockHeight);
        } else if (nodeType == 258) {
            long resolveSize = this.resolveUseableParentHeight(box);
            RenderableReplacedContentBox rpc = (RenderableReplacedContentBox)box;
            long computedHeight = ReplacedContentUtil.computeHeight(rpc, resolveSize, box.getCachedWidth());
            box.setCachedHeight(computedHeight);
        } else {
            box.setCachedHeight(this.computeCanvasHeight(box, false));
        }
        return true;
    }

    protected void processCanvasLevelNode(RenderNode node) {
        node.setCachedY(this.computeVerticalCanvasPosition(node));
        if (node.getNodeType() == 129) {
            FinishedRenderNode fnode = (FinishedRenderNode)node;
            node.setCachedHeight(fnode.getLayoutedHeight());
        } else {
            node.setCachedHeight(0L);
        }
    }

    protected void finishCanvasLevelBox(RenderBox box) {
        if (box.isCacheValid()) {
            return;
        }
        int type = box.getNodeType();
        if ((type & 0x12) == 18) {
            long resolveSize = this.resolveParentHeight(box);
            long blockHeight = this.computeBlockHeightAndAlign(box, resolveSize, true);
            box.setCachedHeight(blockHeight);
        } else if ((type & 0x82) == 130) {
            long resolveSize = this.resolveParentHeight(box);
            long blockHeight = this.computeRowHeightAndAlign(box, resolveSize, true);
            box.setCachedHeight(blockHeight);
        } else if (type != 258) {
            box.setCachedHeight(this.computeCanvasHeight(box, false));
        }
    }

    private long computeVerticalCanvasPosition(RenderNode node) {
        long insetsTop;
        long parentPosition;
        RenderBox parent = node.getParent();
        if (parent == null) {
            parentPosition = 0L;
        } else {
            StaticBoxLayoutProperties blp = parent.getStaticBoxLayoutProperties();
            BoxDefinition bdef = parent.getBoxDefinition();
            insetsTop = blp.getBorderTop() + bdef.getPaddingTop();
            parentPosition = parent.getCachedY() + insetsTop;
        }
        double posY = node.getStyleSheet().getDoubleStyleProperty(ElementStyleKeys.POS_Y, 0.0);
        if (node.isSizeSpecifiesBorderBox()) {
            return parentPosition + RenderLength.resolveLength(this.resolveParentHeight(node), posY);
        }
        if ((node.getNodeType() & 2) == 2) {
            RenderBox box = (RenderBox)node;
            StaticBoxLayoutProperties blp = box.getStaticBoxLayoutProperties();
            BoxDefinition bdef = box.getBoxDefinition();
            insetsTop = blp.getBorderTop() + bdef.getPaddingTop();
        } else {
            insetsTop = 0L;
        }
        return parentPosition + RenderLength.resolveLength(this.resolveParentHeight(node), posY) - insetsTop;
    }

    private long resolveUseableParentHeight(RenderNode node) {
        long childConsumedHeight;
        RenderLength maxHeight;
        RenderBox parent = node.getParent();
        if (parent == null) {
            return node.getCachedHeight();
        }
        long height = parent.getCachedHeight();
        BoxDefinition bdef = parent.getBoxDefinition();
        StaticBoxLayoutProperties blp = parent.getStaticBoxLayoutProperties();
        long insetsBottom = blp.getBorderBottom() + bdef.getPaddingBottom();
        long parentAvailableHeight = parent.getCachedY() + height - insetsBottom - node.getCachedY();
        if (this.paranoidChecks && this.isWatermark(parent) == null && RenderLength.AUTO.equals(bdef.getPreferredHeight()) && RenderLength.AUTO.equals(maxHeight = bdef.getMaximumHeight()) && (childConsumedHeight = parentAvailableHeight - node.getCachedHeight()) < 0L) {
            logger.warn((Object)("A child cannot exceed the area of the parent: " + node.getName() + " Parent: " + parentAvailableHeight + " Child: " + childConsumedHeight));
        }
        return parentAvailableHeight;
    }

    private long computeCanvasHeight(RenderBox box, boolean heightResolvesToZero) {
        long usableParentHeight;
        long parentHeight;
        StaticBoxLayoutProperties blp = box.getStaticBoxLayoutProperties();
        BoxDefinition bdef = box.getBoxDefinition();
        BoxDefinition boxDefinition = box.getBoxDefinition();
        RenderLength minHeight = boxDefinition.getMinimumHeight();
        RenderLength preferredHeight = boxDefinition.getPreferredHeight();
        RenderLength maxHeight = boxDefinition.getMaximumHeight();
        long insetsTop = blp.getBorderTop() + bdef.getPaddingTop();
        long insetsBottom = blp.getBorderBottom() + bdef.getPaddingBottom();
        long insets = insetsTop + insetsBottom;
        if (heightResolvesToZero) {
            parentHeight = 0L;
            usableParentHeight = 0L;
        } else {
            parentHeight = Math.max(this.resolveParentHeight(box), box.getCachedHeight());
            usableParentHeight = this.resolveUseableParentHeight(box);
        }
        long consumedHeight = Math.max(box.getCachedHeight(), Math.min(minHeight.resolve(parentHeight), usableParentHeight));
        long minHeightResolved = minHeight.resolve(parentHeight);
        long maxHeightResolved = maxHeight.resolve(parentHeight, MAX_AUTO);
        if (box.isSizeSpecifiesBorderBox()) {
            long prefHeightResolved = RenderLength.AUTO.equals(preferredHeight) ? consumedHeight : preferredHeight.resolve(parentHeight);
            long height = ProcessUtility.computeLength(minHeightResolved, maxHeightResolved, prefHeightResolved);
            if (heightResolvesToZero) {
                return height;
            }
            return Math.min(height, usableParentHeight);
        }
        consumedHeight = Math.max(0L, consumedHeight - insets);
        long prefHeightResolved = RenderLength.AUTO.equals(preferredHeight) ? consumedHeight : preferredHeight.resolve(parentHeight);
        long height = ProcessUtility.computeLength(minHeightResolved, maxHeightResolved, prefHeightResolved);
        if (heightResolvesToZero) {
            return height;
        }
        return Math.min(height + insets, usableParentHeight);
    }

    protected boolean startRowLevelBox(RenderBox box) {
        if (box.isCacheValid()) {
            return false;
        }
        long oldPosition = box.getCachedY();
        long newYPosition = this.computeVerticalRowPosition(box);
        CacheBoxShifter.shiftBox(box, Math.max(0L, newYPosition - oldPosition));
        int nodeType = box.getNodeType();
        if ((nodeType & 0x12) == 18) {
            long resolveSize = this.resolveParentHeight(box);
            long blockHeight = this.computeBlockHeightAndAlign(box, resolveSize, false);
            box.setCachedHeight(blockHeight);
        } else if ((nodeType & 0x82) == 130) {
            long resolveSize = this.resolveParentHeight(box);
            long blockHeight = this.computeRowHeightAndAlign(box, resolveSize, false);
            box.setCachedHeight(blockHeight);
        } else if (nodeType == 258) {
            RenderableReplacedContentBox rpc = (RenderableReplacedContentBox)box;
            long resolveSize = this.resolveParentHeight(box);
            box.setCachedHeight(ReplacedContentUtil.computeHeight(rpc, resolveSize, box.getCachedWidth()));
        } else {
            long cachedHeight = this.computeCanvasHeight(box, false);
            box.setCachedHeight(cachedHeight);
        }
        return true;
    }

    protected void processRowLevelNode(RenderNode node) {
        node.setCachedY(this.computeVerticalRowPosition(node));
        int type = node.getNodeType();
        if (type == 129) {
            FinishedRenderNode fnode = (FinishedRenderNode)node;
            node.setCachedHeight(fnode.getLayoutedHeight());
        } else if ((type & 0x42) == 66) {
            throw new IllegalStateException("A Inline-Box must be contained in a paragraph.");
        }
    }

    protected void finishRowLevelBox(RenderBox box) {
        if (box.isCacheValid()) {
            return;
        }
        int nodeType = box.getNodeType();
        if ((nodeType & 0x12) == 18) {
            long resolveSize = this.resolveParentHeight(box);
            long blockHeight = this.computeBlockHeightAndAlign(box, resolveSize, true);
            box.setCachedHeight(blockHeight);
        } else if ((nodeType & 0x82) == 130) {
            long resolveSize = this.resolveParentHeight(box);
            long blockHeight = this.computeRowHeightAndAlign(box, resolveSize, true);
            box.setCachedHeight(blockHeight);
        } else if (nodeType != 258) {
            box.setCachedHeight(this.computeCanvasHeight(box, false));
        }
    }

    private long computeVerticalRowPosition(RenderNode node) {
        RenderBox parent = node.getParent();
        if (parent != null) {
            StaticBoxLayoutProperties blp = parent.getStaticBoxLayoutProperties();
            BoxDefinition bdef = parent.getBoxDefinition();
            long insetTop = blp.getBorderTop() + bdef.getPaddingTop();
            return insetTop + parent.getCachedY();
        }
        return 0L;
    }
}

