/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process;

import java.util.HashMap;
import org.pentaho.reporting.engine.classic.core.layout.model.BlockRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.CanvasRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.FinishedRenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.ParagraphRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.process.IterateStructuralProcessStep;
import org.pentaho.reporting.engine.classic.core.states.ReportStateKey;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;
import org.pentaho.reporting.libraries.base.util.FastStack;

public final class CleanFlowBoxesStep
extends IterateStructuralProcessStep {
    private HashMap<InstanceID, Boolean> finishContexts = new HashMap();
    private InstanceID canvasProcessingId;
    private FastStack blockContexts = new FastStack(50);
    private ReportStateKey lastSeenStateKey;

    public void compute(LogicalPageBox pageBox) {
        this.canvasProcessingId = null;
        this.finishContexts.clear();
        this.blockContexts.clear();
        if (this.startBlockBox(pageBox)) {
            this.processBoxChilds(pageBox);
        }
        this.finishBlockBox(pageBox);
        this.finishContexts.clear();
        this.blockContexts.clear();
    }

    protected void processParagraphChilds(ParagraphRenderBox box) {
    }

    protected boolean startRowBox(RenderBox box) {
        ReportStateKey stateKey;
        if (!box.isFinishedTable() || !box.isCommited()) {
            this.finishContexts.put(box.getInstanceId(), Boolean.FALSE);
        } else {
            this.finishContexts.put(box.getInstanceId(), Boolean.TRUE);
        }
        if (this.canvasProcessingId == null) {
            this.canvasProcessingId = box.getInstanceId();
        }
        if ((stateKey = box.getStateKey()) != null) {
            this.lastSeenStateKey = stateKey;
        }
        return true;
    }

    protected void finishRowBox(RenderBox box) {
        if (this.canvasProcessingId == box.getInstanceId()) {
            this.canvasProcessingId = null;
        }
        if (!box.isFinishedTable() || !box.isCommited()) {
            this.finishContexts.remove(box.getInstanceId());
            return;
        }
        Boolean finishedFlag = this.finishContexts.get(box.getInstanceId());
        if (Boolean.FALSE.equals(finishedFlag)) {
            if (box.getParent() != null) {
                this.finishContexts.put(box.getParent().getInstanceId(), Boolean.FALSE);
            }
        } else {
            box.setDeepFinished(true);
        }
        this.finishContexts.remove(box.getInstanceId());
    }

    protected boolean startCanvasBox(CanvasRenderBox box) {
        ReportStateKey stateKey;
        if (!box.isFinishedTable() || !box.isCommited()) {
            this.finishContexts.put(box.getInstanceId(), Boolean.FALSE);
        } else {
            this.finishContexts.put(box.getInstanceId(), Boolean.TRUE);
        }
        if (this.canvasProcessingId == null) {
            this.canvasProcessingId = box.getInstanceId();
        }
        if ((stateKey = box.getStateKey()) != null) {
            this.lastSeenStateKey = stateKey;
        }
        return true;
    }

    protected void finishCanvasBox(CanvasRenderBox box) {
        if (this.canvasProcessingId == box.getInstanceId()) {
            this.canvasProcessingId = null;
        }
        if (!box.isFinishedTable() || !box.isCommited()) {
            this.finishContexts.remove(box.getInstanceId());
            return;
        }
        Boolean finishedFlag = this.finishContexts.get(box.getInstanceId());
        if (Boolean.FALSE.equals(finishedFlag)) {
            if (box.getParent() != null) {
                this.finishContexts.put(box.getParent().getInstanceId(), Boolean.FALSE);
            }
        } else {
            box.setDeepFinished(true);
        }
        this.finishContexts.remove(box.getInstanceId());
    }

    protected boolean startBlockBox(BlockRenderBox box) {
        if (box.isDeepFinished()) {
            return false;
        }
        if (!box.isFinishedTable()) {
            this.finishContexts.put(box.getInstanceId(), Boolean.FALSE);
        } else {
            this.finishContexts.put(box.getInstanceId(), Boolean.TRUE);
        }
        ReportStateKey stateKey = box.getStateKey();
        if (stateKey != null) {
            this.lastSeenStateKey = stateKey;
        }
        return true;
    }

    protected void finishBlockBox(BlockRenderBox box) {
        RenderNode next;
        RenderBox nextBox;
        Boolean finishedFlag = this.finishContexts.get(box.getInstanceId());
        if (Boolean.FALSE.equals(finishedFlag)) {
            if (box.getParent() != null) {
                this.finishContexts.put(box.getParent().getInstanceId(), Boolean.FALSE);
            }
            box.setDeepFinished(false);
        } else {
            box.setDeepFinished(true);
        }
        this.finishContexts.remove(box.getInstanceId());
        if (this.canvasProcessingId != null) {
            return;
        }
        RenderNode first = box.getFirstChild();
        if (first == null) {
            return;
        }
        if (!first.isFinishedTable()) {
            return;
        }
        int firstNodeType = first.getNodeType();
        if ((firstNodeType & 2) == 2 && !(nextBox = (RenderBox)first).isDeepFinished()) {
            return;
        }
        RenderNode last = first;
        while ((next = last.getNext()) != null) {
            int nodeType = next.getNodeType();
            if ((nodeType & 2) == 2 && (nodeType & 0x42) != 66) {
                RenderBox nextBox2 = (RenderBox)next;
                if (!next.isFinishedTable() && !nextBox2.isDeepFinished()) break;
            }
            if (next.isBreakAfter()) break;
            last = next;
        }
        if (last == first && firstNodeType == 129) {
            return;
        }
        long nodeY = first.getY();
        long width = box.getContentAreaX2() - box.getContentAreaX1();
        long lastY2 = last.getY() + last.getHeight();
        long height = lastY2 - nodeY;
        long marginsTop = first.getEffectiveMarginTop();
        long marginsBottom = last.getEffectiveMarginBottom();
        boolean breakAfter = last.isBreakAfter();
        FinishedRenderNode replacement = new FinishedRenderNode(width, height, marginsTop, marginsBottom, breakAfter, this.lastSeenStateKey);
        int counter = 0;
        RenderNode removeNode = first;
        while (removeNode != last) {
            RenderNode next2 = removeNode.getNext();
            if (removeNode.isOpen()) {
                throw new IllegalStateException("A node is still open. We should not have come that far.");
            }
            box.remove(removeNode);
            removeNode = next2;
            ++counter;
        }
        if (last.isOpen()) {
            throw new IllegalStateException("The last node is still open. We should not have come that far.");
        }
        ++counter;
        box.replaceChild(last, replacement);
        if (replacement.getParent() != box) {
            throw new IllegalStateException("The replacement did not work.");
        }
    }

    protected void processOtherNode(RenderNode node) {
        ReportStateKey stateKey;
        if (node.getNodeType() == 129 && (stateKey = node.getStateKey()) != null) {
            this.lastSeenStateKey = stateKey;
        }
    }
}

