/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process;

import org.pentaho.reporting.engine.classic.core.layout.model.BlockRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.CanvasRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.FinishedRenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.InlineRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.ParagraphRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.context.StaticBoxLayoutProperties;
import org.pentaho.reporting.engine.classic.core.layout.process.IterateStructuralProcessStep;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;

public final class CleanPaginatedBoxesStep
extends IterateStructuralProcessStep {
    private long pageOffset;
    private long shiftOffset;
    private InstanceID shiftNode;

    public long compute(LogicalPageBox pageBox) {
        this.shiftOffset = 0L;
        this.pageOffset = pageBox.getPageOffset();
        if (this.startBlockBox(pageBox)) {
            this.processBoxChilds(pageBox);
        }
        this.finishBlockBox(pageBox);
        return this.shiftOffset;
    }

    public InstanceID getShiftNode() {
        return this.shiftNode;
    }

    protected void processParagraphChilds(ParagraphRenderBox box) {
    }

    public boolean startCanvasBox(CanvasRenderBox box) {
        return false;
    }

    protected boolean startRowBox(RenderBox box) {
        return false;
    }

    protected boolean startBlockBox(BlockRenderBox box) {
        RenderNode next;
        int nodeType = box.getNodeType();
        if (nodeType == 274) {
            return false;
        }
        if (nodeType == 530) {
            long y2;
            long y;
            RenderBox parent = box.getParent();
            if (parent == null) {
                throw new IllegalStateException("Encountered a render-node that has no parent. How can that be?");
            }
            long width = box.getContentAreaX2() - box.getContentAreaX1();
            RenderNode prevSilbling = box.getPrev();
            if (prevSilbling == null) {
                y = parent.getY();
                y2 = Math.max(this.pageOffset, box.getY() + box.getHeight());
                parent.replaceChild(box, new FinishedRenderNode(width, y2 - y, 0L, 0L, true));
            } else {
                y = prevSilbling.getY() + prevSilbling.getHeight();
                y2 = Math.max(this.pageOffset, box.getY() + box.getHeight());
                parent.replaceChild(box, new FinishedRenderNode(width, y2 - y, 0L, 0L, true));
            }
        }
        if (!box.isFinishedPaginate()) {
            return true;
        }
        RenderNode firstNode = box.getFirstChild();
        if (firstNode == null) {
            return false;
        }
        long nodeY = firstNode.getY();
        if (nodeY > this.pageOffset) {
            return false;
        }
        if (firstNode.isOpen()) {
            return true;
        }
        if (nodeY + firstNode.getHeight() > this.pageOffset) {
            return true;
        }
        RenderNode last = firstNode;
        while ((next = last.getNext()) != null && !next.isOpen() && next.getY() + next.getHeight() <= this.pageOffset) {
            last = next;
        }
        if (last == firstNode && last.getNodeType() == 129) {
            return true;
        }
        StaticBoxLayoutProperties sblp = box.getStaticBoxLayoutProperties();
        long insetsTop = sblp.getBorderTop() + box.getBoxDefinition().getPaddingTop();
        long width = box.getContentAreaX2() - box.getContentAreaX1();
        long lastY2 = last.getNext() == null ? last.getY() + last.getHeight() : last.getNext().getY();
        long startOfBox = box.getY() + insetsTop;
        long height = lastY2 - startOfBox;
        long marginsTop = firstNode.getEffectiveMarginTop();
        long marginsBottom = last.getEffectiveMarginBottom();
        boolean breakAfter = this.isBreakAfter(last);
        FinishedRenderNode replacement = new FinishedRenderNode(width, height, marginsTop, marginsBottom, breakAfter);
        RenderNode removeNode = firstNode;
        while (removeNode != last) {
            RenderNode next2 = removeNode.getNext();
            if (removeNode.isOpen()) {
                throw new IllegalStateException("A node is still open. We should not have come that far.");
            }
            box.remove(removeNode);
            removeNode = next2;
        }
        if (last.isOpen()) {
            throw new IllegalStateException("The last node is still open. We should not have come that far.");
        }
        box.replaceChild(last, replacement);
        if (replacement.getParent() != box) {
            throw new IllegalStateException("The replacement did not work.");
        }
        long cachedY2 = last.getNext() == null ? last.getCachedY() + last.getCachedHeight() : last.getNext().getCachedY();
        long newShift = lastY2 - cachedY2;
        if (newShift > this.shiftOffset) {
            this.shiftOffset = newShift;
            this.shiftNode = box.getInstanceId();
        }
        return box.getLastChild() != replacement;
    }

    private boolean isBreakAfter(RenderNode node) {
        RenderBox box;
        RenderNode lastChild;
        if (node.isBreakAfter()) {
            return true;
        }
        if ((node.getNodeType() & 0x12) == 18 && (lastChild = (box = (RenderBox)node).getLastChild()) != null) {
            return this.isBreakAfter(lastChild);
        }
        return false;
    }

    protected boolean startInlineBox(InlineRenderBox box) {
        return false;
    }
}

