/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process;

import org.pentaho.reporting.engine.classic.core.layout.model.Border;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.ParagraphRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderLength;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.context.BoxDefinition;
import org.pentaho.reporting.engine.classic.core.layout.model.context.StaticBoxLayoutProperties;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorFeature;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.process.IterateVisualProcessStep;
import org.pentaho.reporting.engine.classic.core.layout.process.ProcessUtility;
import org.pentaho.reporting.engine.classic.core.layout.text.ExtendedBaselineInfo;
import org.pentaho.reporting.engine.classic.core.style.BandStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.style.TextStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.WhitespaceCollapse;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictGeomUtility;

public final class ComputeStaticPropertiesProcessStep
extends IterateVisualProcessStep {
    public static final long MAX_AUTO = StrictGeomUtility.toInternalValue(8.796093022208E12);
    private OutputProcessorMetaData metaData;
    private boolean overflowXSupported;
    private boolean overflowYSupported;
    public static int callCount;

    public ComputeStaticPropertiesProcessStep(OutputProcessorMetaData metaData) {
        this.metaData = metaData;
        this.overflowXSupported = metaData.isFeatureSupported(OutputProcessorFeature.ASSUME_OVERFLOW_X);
        this.overflowYSupported = metaData.isFeatureSupported(OutputProcessorFeature.ASSUME_OVERFLOW_Y);
    }

    public void compute(LogicalPageBox root) {
        ++callCount;
        this.startProcessing(root);
    }

    protected void processParagraphChilds(ParagraphRenderBox box) {
        ExtendedBaselineInfo extendedBaselineInfo = box.getStaticBoxLayoutProperties().getNominalBaselineInfo();
        if (extendedBaselineInfo == null) {
            throw new IllegalStateException("Baseline info must not be null at this point");
        }
        StyleSheet styleSheet = box.getNodeLayoutProperties().getStyleSheet();
        double value = styleSheet.getDoubleStyleProperty(TextStyleKeys.LINEHEIGHT, 0.0);
        long afterEdge = extendedBaselineInfo.getBaseline(9);
        if (value <= 0.0) {
            box.getPool().setLineHeight(afterEdge);
        } else {
            box.getPool().setLineHeight(RenderLength.resolveLength(afterEdge, value));
        }
        this.startProcessing(box.getEffectiveLineboxContainer());
    }

    private void computeBreakIndicator(RenderBox box) {
        boolean fixedPosition;
        StyleSheet styleSheet = box.getStyleSheet();
        RenderBox parent = box.getParent();
        if (parent != null) {
            boolean breakBefore = styleSheet.getBooleanStyleProperty(BandStyleKeys.PAGEBREAK_BEFORE);
            boolean breakAfter = box.isBreakAfter();
            int parentNodeType = parent.getNodeType();
            if (breakBefore && parentNodeType != 274) {
                box.setManualBreakIndicator(1);
                this.applyIndirectManualBreakIndicator(parent);
                return;
            }
            if (breakAfter && parentNodeType != 274) {
                this.applyIndirectManualBreakIndicator(parent);
            }
        }
        boolean bl = fixedPosition = !RenderLength.AUTO.equals(styleSheet.getStyleProperty(BandStyleKeys.FIXED_POSITION, RenderLength.AUTO));
        if (fixedPosition) {
            this.applyIndirectManualBreakIndicator(box);
        } else {
            box.setManualBreakIndicator(0);
        }
    }

    private void applyIndirectManualBreakIndicator(RenderBox node) {
        while (node != null) {
            if (node.getManualBreakIndicator() != 0) {
                return;
            }
            node.setManualBreakIndicator(2);
            node = node.getParent();
        }
    }

    private boolean updateStaticProperties(RenderBox box) {
        StaticBoxLayoutProperties sblp = box.getStaticBoxLayoutProperties();
        if (sblp.getNominalBaselineInfo() != null) {
            return false;
        }
        BoxDefinition boxDefinition = box.getBoxDefinition();
        long parentWidth = ProcessUtility.computeBlockContextWidth(box);
        sblp.setMarginTop(boxDefinition.getMarginTop().resolve(parentWidth));
        sblp.setMarginLeft(boxDefinition.getMarginLeft().resolve(parentWidth));
        sblp.setMarginBottom(boxDefinition.getMarginBottom().resolve(parentWidth));
        sblp.setMarginRight(boxDefinition.getMarginRight().resolve(parentWidth));
        Border border = boxDefinition.getBorder();
        sblp.setBorderTop(border.getTop().getWidth());
        sblp.setBorderLeft(border.getLeft().getWidth());
        sblp.setBorderBottom(border.getBottom().getWidth());
        sblp.setBorderRight(border.getRight().getWidth());
        StyleSheet style = box.getStyleSheet();
        int nodeType = box.getNodeType();
        if (nodeType == 322) {
            sblp.setAvoidPagebreakInside(true);
        } else {
            sblp.setAvoidPagebreakInside(style.getBooleanStyleProperty(ElementStyleKeys.AVOID_PAGEBREAK_INSIDE, false));
        }
        sblp.setDominantBaseline(-1);
        sblp.setOrphans(style.getIntStyleProperty(ElementStyleKeys.ORPHANS, 0));
        sblp.setWidows(style.getIntStyleProperty(ElementStyleKeys.WIDOWS, 0));
        ExtendedBaselineInfo baselineInfo = this.metaData.getBaselineInfo(120, style);
        if (baselineInfo == null) {
            throw new IllegalStateException();
        }
        sblp.setNominalBaselineInfo(baselineInfo);
        sblp.setFontFamily(this.metaData.getNormalizedFontFamilyName((String)style.getStyleProperty(TextStyleKeys.FONT)));
        Object collapse = style.getStyleProperty(TextStyleKeys.WHITE_SPACE_COLLAPSE);
        sblp.setPreserveSpace(WhitespaceCollapse.PRESERVE.equals(collapse));
        sblp.setOverflowX(style.getBooleanStyleProperty(ElementStyleKeys.OVERFLOW_X, this.overflowXSupported));
        sblp.setOverflowY(style.getBooleanStyleProperty(ElementStyleKeys.OVERFLOW_Y, this.overflowYSupported));
        sblp.setInvisibleConsumesSpace(style.getBooleanStyleProperty(ElementStyleKeys.INVISIBLE_CONSUMES_SPACE, nodeType == 130));
        sblp.setVisible(style.getBooleanStyleProperty(ElementStyleKeys.VISIBLE));
        this.computeBreakIndicator(box);
        return true;
    }

    protected boolean startBlockLevelBox(RenderBox box) {
        long age;
        long changeTracker = box.getChangeTracker();
        if (changeTracker == (age = box.getStaticBoxPropertiesAge())) {
            return false;
        }
        if (this.updateStaticProperties(box)) {
            long bcw = ProcessUtility.computeBlockContextWidth(box);
            long computedWidth = this.resolveComputedWidth(box);
            long insets = box.getInsets();
            box.setComputedWidth(Math.max(computedWidth, bcw));
            if ((box.getNodeType() & 0x42) == 66) {
                box.getStaticBoxLayoutProperties().setBlockContextWidth(0L);
            } else {
                long newBcw = Math.max(bcw - insets, computedWidth - insets);
                box.getStaticBoxLayoutProperties().setBlockContextWidth(Math.max(0L, newBcw));
            }
        }
        return true;
    }

    protected boolean startInlineLevelBox(RenderBox box) {
        long age;
        long changeTracker = box.getChangeTracker();
        if (changeTracker == (age = box.getStaticBoxPropertiesAge())) {
            return false;
        }
        if (this.updateStaticProperties(box)) {
            box.setComputedWidth(box.getInsets());
            box.getStaticBoxLayoutProperties().setBlockContextWidth(0L);
        }
        return true;
    }

    private long resolveComputedWidth(RenderBox box) {
        long bcw = ProcessUtility.computeBlockContextWidth(box);
        BoxDefinition boxDef = box.getBoxDefinition();
        RenderLength minLength = boxDef.getMinimumWidth();
        RenderLength prefLength = boxDef.getPreferredWidth();
        RenderLength maxLength = boxDef.getMaximumWidth();
        long min = minLength.resolve(bcw, 0L);
        long pref = prefLength.resolve(bcw, 0L);
        long max = maxLength.resolve(bcw, MAX_AUTO);
        return ProcessUtility.computeLength(min, max, pref);
    }

    protected boolean startCanvasLevelBox(RenderBox box) {
        long age;
        long changeTracker = box.getChangeTracker();
        if (changeTracker == (age = box.getStaticBoxPropertiesAge())) {
            return false;
        }
        if (this.updateStaticProperties(box)) {
            long computedWidth = this.resolveComputedWidth(box);
            box.setComputedWidth(computedWidth);
            if ((box.getNodeType() & 0x42) == 66) {
                box.getStaticBoxLayoutProperties().setBlockContextWidth(0L);
            } else {
                box.getStaticBoxLayoutProperties().setBlockContextWidth(Math.max(0L, computedWidth - box.getInsets()));
            }
        }
        return true;
    }

    protected boolean startRowLevelBox(RenderBox box) {
        long age;
        long changeTracker = box.getChangeTracker();
        if (changeTracker == (age = box.getStaticBoxPropertiesAge())) {
            return false;
        }
        if (this.updateStaticProperties(box)) {
            long computedWidth = this.resolveComputedWidth(box);
            box.setComputedWidth(computedWidth);
            if ((box.getNodeType() & 0x42) == 66) {
                box.getStaticBoxLayoutProperties().setBlockContextWidth(0L);
            } else {
                BoxDefinition boxDefinition = box.getBoxDefinition();
                StaticBoxLayoutProperties sblp = box.getStaticBoxLayoutProperties();
                long insets = sblp.getBorderLeft() + sblp.getBorderRight() + boxDefinition.getPaddingLeft() + boxDefinition.getPaddingRight();
                box.getStaticBoxLayoutProperties().setBlockContextWidth(Math.max(0L, computedWidth - insets));
            }
        }
        return true;
    }

    protected void finishInlineLevelBox(RenderBox box) {
        this.updateMinimumChunkWidth(box);
    }

    protected void finishCanvasLevelBox(RenderBox box) {
        this.updateMinimumChunkWidth(box);
    }

    protected void finishBlockLevelBox(RenderBox box) {
        this.updateMinimumChunkWidth(box);
    }

    protected void finishRowLevelBox(RenderBox box) {
        this.updateMinimumChunkWidth(box);
    }

    private void updateMinimumChunkWidth(RenderBox box) {
        long age;
        long changeTracker = box.getChangeTracker();
        if (changeTracker == (age = box.getStaticBoxPropertiesAge())) {
            return;
        }
        box.setStaticBoxPropertiesAge(changeTracker);
        int nodeType = box.getNodeType();
        if ((nodeType & 0x112) == 274) {
            this.updateParagraphChunkWidth(box);
            return;
        }
        long chunkWidth = 0L;
        for (RenderNode node = box.getFirstChild(); node != null; node = node.getNext()) {
            long minimumChunkWidth = node.getMinimumChunkWidth();
            if (chunkWidth >= minimumChunkWidth) continue;
            chunkWidth = minimumChunkWidth;
        }
        if ((nodeType & 0x42) == 66) {
            box.setMinimumChunkWidth(chunkWidth);
        } else {
            box.setMinimumChunkWidth(Math.max(chunkWidth, box.getComputedWidth()));
        }
    }

    protected void updateParagraphChunkWidth(RenderBox box) {
        ParagraphRenderBox paragraphRenderBox = (ParagraphRenderBox)box;
        RenderBox lineboxContainer = paragraphRenderBox.getLineboxContainer();
        RenderBox chunkBox = lineboxContainer == null ? paragraphRenderBox.getPool() : lineboxContainer;
        long chunkWidth = 0L;
        for (RenderNode node = chunkBox.getFirstChild(); node != null; node = node.getNext()) {
            long minimumChunkWidth = node.getMinimumChunkWidth();
            if (chunkWidth >= minimumChunkWidth) continue;
            chunkWidth = minimumChunkWidth;
        }
        box.setMinimumChunkWidth(Math.max(chunkWidth, box.getComputedWidth()));
        if (box.getStyleSheet().getBooleanStyleProperty(ElementStyleKeys.USE_MIN_CHUNKWIDTH)) {
            box.setComputedWidth(Math.max(box.getComputedWidth(), chunkWidth + box.getInsets()));
        }
    }
}

