/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process;

import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.filter.types.AutoLayoutBoxType;
import org.pentaho.reporting.engine.classic.core.layout.FileModelPrinter;
import org.pentaho.reporting.engine.classic.core.layout.model.BlockRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.CanvasRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.FinishedRenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.InlineRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.process.IterateStructuralProcessStep;
import org.pentaho.reporting.libraries.base.util.DebugLog;

public class CountBoxesStep
extends IterateStructuralProcessStep {
    private int totalCount;
    private int finishedBoxes;
    private int autoBoxes;
    private boolean enabled = "true".equals(ClassicEngineBoot.getInstance().getGlobalConfig().getConfigProperty("org.pentaho.reporting.engine.classic.core.layout.process.EnableCountBoxesStep", "false"));

    public void process(LogicalPageBox box) {
        if (!this.enabled) {
            return;
        }
        this.totalCount = 0;
        this.finishedBoxes = 0;
        this.autoBoxes = 0;
        this.startProcessing(box);
        DebugLog.log((Object)("CountBoxes: Total=" + this.totalCount + "; finished=" + this.finishedBoxes + "; auto=" + this.autoBoxes + " - " + "Finished-Ratio: " + (double)this.finishedBoxes / (double)this.totalCount * 100.0 + " AutoRatio: " + (double)this.autoBoxes / (double)this.totalCount * 100.0));
        if ((double)this.autoBoxes / (double)this.totalCount * 100.0 > 90.0) {
            FileModelPrinter.print(box);
            System.exit(0);
        }
    }

    protected void count(RenderNode node) {
        ++this.totalCount;
        if (node instanceof FinishedRenderNode) {
            ++this.finishedBoxes;
        }
        if (node.getElementType() instanceof AutoLayoutBoxType) {
            ++this.autoBoxes;
        }
    }

    protected boolean startCanvasBox(CanvasRenderBox box) {
        this.count(box);
        return true;
    }

    protected boolean startBlockBox(BlockRenderBox box) {
        this.count(box);
        return true;
    }

    protected boolean startInlineBox(InlineRenderBox box) {
        this.count(box);
        return true;
    }

    protected boolean startOtherBox(RenderBox box) {
        this.count(box);
        return true;
    }

    protected boolean startRowBox(RenderBox box) {
        this.count(box);
        return true;
    }

    protected void processOtherNode(RenderNode node) {
        this.count(node);
    }
}

