/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process;

import org.pentaho.reporting.engine.classic.core.layout.model.BlockRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.ParagraphRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.process.BoxShifter;
import org.pentaho.reporting.engine.classic.core.layout.process.IterateVisualProcessStep;

public final class FillFlowPagesStep
extends IterateVisualProcessStep {
    private long contentEnd;
    private long contentStart;

    public LogicalPageBox compute(LogicalPageBox pagebox, long pageStart, long pageEnd) {
        this.contentStart = pagebox.getHeaderArea().getHeight();
        this.contentEnd = pageEnd - pageStart + this.contentStart;
        LogicalPageBox derived = (LogicalPageBox)pagebox.derive(true);
        BoxShifter.shiftBoxUnchecked(derived, -pageStart + this.contentStart);
        this.processBoxChilds(derived);
        BlockRenderBox repeatFooterArea = derived.getRepeatFooterArea();
        long repeatFooterShift = this.contentEnd;
        BoxShifter.shiftBoxUnchecked(repeatFooterArea, repeatFooterShift);
        BlockRenderBox footerArea = derived.getFooterArea();
        long footerShift = this.contentEnd + repeatFooterArea.getHeight();
        BoxShifter.shiftBoxUnchecked(repeatFooterArea, footerShift);
        derived.setPageOffset(0L);
        derived.setPageEnd(this.contentEnd + footerArea.getHeight() + repeatFooterArea.getHeight());
        return derived;
    }

    protected void processParagraphChilds(ParagraphRenderBox box) {
        this.processBoxChilds(box);
    }

    protected boolean startBlockLevelBox(RenderBox box) {
        RenderNode node = box.getFirstChild();
        while (node != null) {
            RenderNode next;
            if (node.isIgnorableForRendering()) {
                node = node.getNext();
                continue;
            }
            if (node.getY() == this.contentStart && node.getHeight() == 0L) {
                node = node.getNext();
                continue;
            }
            if (node.getY() + node.getHeight() <= this.contentStart) {
                next = node.getNext();
                box.remove(node);
                node = next;
                continue;
            }
            if (node.getY() > this.contentEnd) {
                next = node.getNext();
                box.remove(node);
                node = next;
                continue;
            }
            node = node.getNext();
        }
        return true;
    }

    protected boolean startRowLevelBox(RenderBox box) {
        RenderNode node = box.getFirstChild();
        while (node != null) {
            RenderNode next;
            if (node.isIgnorableForRendering()) {
                node = node.getNext();
                continue;
            }
            if (node.getY() == this.contentStart && node.getHeight() == 0L) {
                node = node.getNext();
                continue;
            }
            if (node.getY() + node.getHeight() <= this.contentStart) {
                next = node.getNext();
                box.remove(node);
                node = next;
                continue;
            }
            if (node.getY() >= this.contentEnd) {
                next = node.getNext();
                box.remove(node);
                node = next;
                continue;
            }
            node = node.getNext();
        }
        return true;
    }

    protected boolean startCanvasLevelBox(RenderBox box) {
        RenderNode node = box.getFirstChild();
        while (node != null) {
            RenderNode next;
            if (node.isIgnorableForRendering()) {
                node = node.getNext();
                continue;
            }
            if (node.getY() == this.contentStart && node.getHeight() == 0L) {
                node = node.getNext();
                continue;
            }
            if (node.getY() + node.getHeight() <= this.contentStart) {
                next = node.getNext();
                box.remove(node);
                node = next;
                continue;
            }
            if (node.getY() >= this.contentEnd) {
                next = node.getNext();
                box.remove(node);
                node = next;
                continue;
            }
            node = node.getNext();
        }
        return true;
    }
}

