/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process;

import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.PageBreakPositionList;
import org.pentaho.reporting.engine.classic.core.layout.model.ParagraphRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.process.IterateVisualProcessStep;
import org.pentaho.reporting.engine.classic.core.layout.process.PaginationResult;
import org.pentaho.reporting.engine.classic.core.states.ReportStateKey;

public final class FlowPaginationStep
extends IterateVisualProcessStep {
    private boolean breakPending;
    private PageBreakPositionList breakUtility = new PageBreakPositionList();
    private boolean breakAdded;
    private ReportStateKey finalVisibleState;
    private long pageEnd;

    public PaginationResult performPagebreak(LogicalPageBox pageBox) {
        long lastChildY2;
        long lastChildY22;
        RenderNode lastChild = pageBox.getLastChild();
        if (lastChild != null && (lastChildY22 = lastChild.getY() + lastChild.getHeight()) < pageBox.getHeight()) {
            throw new IllegalStateException("Assertation failed: Block layouting did not proceed: " + lastChildY22 + " < " + pageBox.getHeight());
        }
        this.breakPending = false;
        this.breakAdded = false;
        this.finalVisibleState = null;
        this.pageEnd = pageBox.getHeight();
        PageBreakPositionList allPreviousBreak = pageBox.getAllVerticalBreaks();
        this.breakUtility.copyFrom(allPreviousBreak);
        if (this.startBlockLevelBox(pageBox)) {
            this.processBoxChilds(pageBox);
        }
        this.finishBlockLevelBox(pageBox);
        if (lastChild != null && (lastChildY2 = lastChild.getY() + lastChild.getHeight()) < pageBox.getHeight()) {
            throw new IllegalStateException("Assertation failed: Pagination violated block-constraints: " + lastChildY2 + " < " + pageBox.getHeight());
        }
        long masterBreak = this.breakUtility.getLastMasterBreak();
        boolean nextPageContainsContent = pageBox.getHeight() > masterBreak;
        return new PaginationResult(this.breakUtility, this.breakAdded, nextPageContainsContent, this.finalVisibleState);
    }

    protected void processParagraphChilds(ParagraphRenderBox box) {
        this.processBoxChilds(box);
    }

    protected boolean startBlockLevelBox(RenderBox box) {
        int breakIndicator = box.getManualBreakIndicator();
        if (box.getNodeType() == 530) {
            long boxY = box.getY();
            if (!this.breakAdded && boxY > this.breakUtility.getLastMasterBreak() && this.breakUtility.getLastMasterBreak() != boxY) {
                this.breakAdded = true;
                this.breakUtility.addMajorBreak(box.getY(), 0L);
            }
            this.breakPending = false;
            return false;
        }
        if (breakIndicator == 1 || this.breakPending) {
            long boxY = box.getY();
            if (!this.breakAdded && boxY > this.breakUtility.getLastMasterBreak() && this.breakUtility.getLastMasterBreak() != boxY) {
                this.breakAdded = true;
                this.breakUtility.addMajorBreak(box.getY(), 0L);
            }
            this.breakPending = false;
            return true;
        }
        if (breakIndicator == 0) {
            if (!this.breakAdded) {
                this.updateStateKeyDeep(box);
            }
            return false;
        }
        if (!this.breakAdded) {
            this.updateStateKey(box);
        }
        return true;
    }

    protected void processCanvasLevelNode(RenderNode node) {
        if (!this.breakAdded && node.getNodeType() == 129) {
            this.updateStateKey(node);
        }
    }

    protected void processBlockLevelNode(RenderNode node) {
        if (!this.breakAdded && node.getNodeType() == 129) {
            this.updateStateKey(node);
        }
    }

    protected void processRowLevelNode(RenderNode node) {
        if (!this.breakAdded && node.getNodeType() == 129) {
            this.updateStateKey(node);
        }
    }

    private void updateStateKey(RenderNode box) {
        ReportStateKey stateKey;
        long y = box.getY();
        if (y < this.pageEnd && (stateKey = box.getStateKey()) != null) {
            this.finalVisibleState = stateKey;
        }
    }

    private boolean updateStateKeyDeep(RenderBox box) {
        long y = box.getY();
        if (y < this.pageEnd) {
            ReportStateKey stateKey = box.getStateKey();
            if (stateKey != null) {
                this.finalVisibleState = stateKey;
                return true;
            }
            RenderNode lastChild = box.getLastChild();
            while (lastChild != null) {
                if (!((lastChild.getNodeType() & 2) == 2)) {
                    lastChild = lastChild.getPrev();
                    continue;
                }
                RenderBox lastBox = (RenderBox)lastChild;
                if (this.updateStateKeyDeep(lastBox)) {
                    return true;
                }
                lastChild = lastBox.getPrev();
            }
            return false;
        }
        return false;
    }

    protected void finishBlockLevelBox(RenderBox box) {
        if (!this.breakPending && box.isBreakAfter()) {
            this.breakPending = true;
        }
    }

    protected boolean startInlineLevelBox(RenderBox box) {
        return false;
    }

    protected boolean startCanvasLevelBox(RenderBox box) {
        return false;
    }

    protected boolean startRowLevelBox(RenderBox box) {
        return false;
    }
}

