/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process;

import org.pentaho.reporting.engine.classic.core.ElementAlignment;
import org.pentaho.reporting.engine.classic.core.layout.model.FinishedRenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.ParagraphPoolBox;
import org.pentaho.reporting.engine.classic.core.layout.model.ParagraphRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderLength;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableReplacedContentBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableText;
import org.pentaho.reporting.engine.classic.core.layout.model.WatermarkAreaBox;
import org.pentaho.reporting.engine.classic.core.layout.model.context.BoxDefinition;
import org.pentaho.reporting.engine.classic.core.layout.model.context.StaticBoxLayoutProperties;
import org.pentaho.reporting.engine.classic.core.layout.process.CacheBoxShifter;
import org.pentaho.reporting.engine.classic.core.layout.process.IterateVisualProcessStep;
import org.pentaho.reporting.engine.classic.core.layout.process.MajorAxisParagraphBreakState;
import org.pentaho.reporting.engine.classic.core.layout.process.ProcessUtility;
import org.pentaho.reporting.engine.classic.core.layout.process.ReplacedContentUtil;
import org.pentaho.reporting.engine.classic.core.layout.process.valign.BoxAlignContext;
import org.pentaho.reporting.engine.classic.core.layout.process.valign.InlineBlockAlignContext;
import org.pentaho.reporting.engine.classic.core.layout.process.valign.NodeAlignContext;
import org.pentaho.reporting.engine.classic.core.layout.process.valign.ReplacedContentAlignContext;
import org.pentaho.reporting.engine.classic.core.layout.process.valign.TextElementAlignContext;
import org.pentaho.reporting.engine.classic.core.layout.process.valign.VerticalAlignmentProcessor;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictGeomUtility;

public final class InfiniteMajorAxisLayoutStep
extends IterateVisualProcessStep {
    private static final long MAX_AUTO = StrictGeomUtility.toInternalValue(8.796093022208E12);
    private MajorAxisParagraphBreakState breakState = new MajorAxisParagraphBreakState();
    private VerticalAlignmentProcessor processor = new VerticalAlignmentProcessor();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compute(LogicalPageBox pageBox) {
        this.breakState.deinit();
        try {
            this.startProcessing(pageBox);
        }
        finally {
            this.breakState.deinit();
        }
    }

    public void continueComputation(RenderBox box) {
        if (box.getContentAreaX2() == 0L || box.getCachedWidth() == 0L) {
            throw new IllegalStateException("Box must be layouted a bit ..");
        }
        this.breakState.deinit();
        this.startProcessing(box);
        this.breakState.deinit();
    }

    protected boolean startBlockLevelBox(RenderBox box) {
        if (box.isCacheValid()) {
            return false;
        }
        box.setCachedY(this.computeVerticalBlockPosition(box));
        if (this.breakState.isActive()) {
            if (!this.breakState.isSuspended()) {
                throw new IllegalStateException("This cannot be.");
            }
            return false;
        }
        int nodeType = box.getNodeType();
        if (nodeType == 274) {
            ParagraphRenderBox paragraphBox = (ParagraphRenderBox)box;
            this.breakState.init(paragraphBox);
        } else if (nodeType == 258) {
            RenderableReplacedContentBox contentBox = (RenderableReplacedContentBox)box;
            contentBox.setCachedHeight(ReplacedContentUtil.computeHeight(contentBox, 0L, contentBox.getCachedWidth()));
        } else if (nodeType == 133138) {
            WatermarkAreaBox watermarkAreaBox = (WatermarkAreaBox)box;
            box.setCachedHeight(watermarkAreaBox.getLogicalPage().getPageHeight());
        }
        return true;
    }

    protected void processBlockLevelNode(RenderNode node) {
        node.setCachedY(this.computeVerticalBlockPosition(node));
        if (node.getNodeType() == 129) {
            FinishedRenderNode fnode = (FinishedRenderNode)node;
            node.setCachedHeight(fnode.getLayoutedHeight());
        }
    }

    protected void finishBlockLevelBox(RenderBox box) {
        if (box.isCacheValid()) {
            return;
        }
        int type = box.getNodeType();
        if (type == 133138) {
            WatermarkAreaBox watermarkAreaBox = (WatermarkAreaBox)box;
            box.setCachedHeight(watermarkAreaBox.getLogicalPage().getPageHeight());
        } else {
            RenderBox watermark = this.isWatermark(box);
            if (watermark != null) {
                WatermarkAreaBox watermarkAreaBox = (WatermarkAreaBox)watermark;
                box.setCachedHeight(watermarkAreaBox.getLogicalPage().getPageHeight());
            } else if ((type & 0x12) == 18) {
                box.setCachedHeight(this.computeBlockHeightAndAlign(box, 0L));
            } else if ((type & 0x82) == 130) {
                box.setCachedHeight(this.computeRowHeight(box, 0L));
            } else {
                box.setCachedHeight(this.computeCanvasHeight(box));
            }
        }
        if (this.breakState.isActive()) {
            Object suspender = this.breakState.getSuspendItem();
            if (box.getInstanceId() == suspender) {
                this.breakState.setSuspendItem(null);
                return;
            }
            if (suspender != null) {
                return;
            }
            if (type == 274) {
                this.breakState.deinit();
            }
        }
    }

    private RenderBox isWatermark(RenderBox box) {
        RenderBox parent = box.getParent();
        if (parent == null) {
            return null;
        }
        if (parent.getNodeType() == 133138) {
            return parent;
        }
        RenderBox parent2 = parent.getParent();
        if (parent2 == null) {
            return null;
        }
        if (parent2.getNodeType() == 133138) {
            return parent2;
        }
        return null;
    }

    private long computeVerticalBlockPosition(RenderNode node) {
        long marginTop = 0L;
        RenderBox parent = node.getParent();
        if (parent != null && (parent.getNodeType() & 0x12) == 18) {
            RenderNode prev = node.getPrev();
            if (prev != null) {
                return 0L + prev.getCachedY() + prev.getCachedHeight();
            }
            StaticBoxLayoutProperties blp = parent.getStaticBoxLayoutProperties();
            BoxDefinition bdef = parent.getBoxDefinition();
            long insetTop = blp.getBorderTop() + bdef.getPaddingTop();
            return 0L + insetTop + parent.getCachedY();
        }
        return 0L;
    }

    private long computeBlockHeightAndAlign(RenderBox box, long resolveSize) {
        long computedContentHeight;
        long rprefH;
        long usedHeight;
        long childY2;
        long childY1;
        BoxDefinition boxDefinition = box.getBoxDefinition();
        RenderLength preferredHeight = boxDefinition.getPreferredHeight();
        RenderLength minimumHeight = boxDefinition.getMinimumHeight();
        RenderLength maximumHeight = boxDefinition.getMaximumHeight();
        RenderNode lastChildNode = box.getLastChild();
        if (lastChildNode != null) {
            childY1 = box.getFirstChild().getCachedY();
            childY2 = lastChildNode.getCachedY() + lastChildNode.getCachedHeight() + lastChildNode.getEffectiveMarginBottom();
            usedHeight = childY2 - childY1;
        } else {
            usedHeight = 0L;
            childY2 = 0L;
            childY1 = 0L;
        }
        long rminH = minimumHeight.resolve(resolveSize, 0L);
        long rmaxH = maximumHeight.resolve(resolveSize, MAX_AUTO);
        StaticBoxLayoutProperties blp = box.getStaticBoxLayoutProperties();
        long insetBottom = blp.getBorderBottom() + boxDefinition.getPaddingBottom();
        long insetTop = blp.getBorderTop() + boxDefinition.getPaddingTop();
        if (boxDefinition.isSizeSpecifiesBorderBox()) {
            rprefH = preferredHeight.resolve(resolveSize, usedHeight + insetTop + insetBottom);
            long specifiedHeight = ProcessUtility.computeLength(rminH, rmaxH, rprefH);
            computedContentHeight = specifiedHeight - insetTop - insetBottom;
        } else {
            rprefH = preferredHeight.resolve(resolveSize, usedHeight);
            computedContentHeight = ProcessUtility.computeLength(rminH, rmaxH, rprefH);
        }
        if (lastChildNode != null && computedContentHeight > usedHeight) {
            ElementAlignment valign = box.getNodeLayoutProperties().getVerticalAlignment();
            if (ElementAlignment.BOTTOM.equals(valign)) {
                long boxBottom = box.getCachedY() + computedContentHeight - insetBottom;
                long delta = boxBottom - childY2;
                CacheBoxShifter.shiftBoxChilds(box, delta);
            } else if (ElementAlignment.MIDDLE.equals(valign)) {
                long extraHeight = computedContentHeight - usedHeight;
                long boxTop = box.getCachedY() + insetTop + extraHeight / 2L;
                long delta = boxTop - childY1;
                CacheBoxShifter.shiftBoxChilds(box, delta);
            }
        }
        long retval = Math.max(0L, computedContentHeight + insetTop + insetBottom);
        if (box instanceof WatermarkAreaBox) {
            WatermarkAreaBox watermarkAreaBox = (WatermarkAreaBox)box;
            LogicalPageBox lpb = watermarkAreaBox.getLogicalPage();
            return Math.max(retval, Math.max(0L, lpb.getPageHeight() - insetTop - insetBottom));
        }
        return retval;
    }

    private long computeRowHeight(RenderBox box, long resolveSize) {
        long computedHeight;
        long usedHeight;
        if (box.getNodeType() == 133138) {
            WatermarkAreaBox watermarkAreaBox = (WatermarkAreaBox)box;
            LogicalPageBox lpb = watermarkAreaBox.getLogicalPage();
            return lpb.getPageHeight();
        }
        BoxDefinition boxDefinition = box.getBoxDefinition();
        RenderLength preferredHeight = boxDefinition.getPreferredHeight();
        RenderLength minimumHeight = boxDefinition.getMinimumHeight();
        RenderLength maximumHeight = boxDefinition.getMaximumHeight();
        StaticBoxLayoutProperties blp = box.getStaticBoxLayoutProperties();
        long insetBottom = blp.getBorderBottom() + boxDefinition.getPaddingBottom();
        long insetTop = blp.getBorderTop() + boxDefinition.getPaddingTop();
        RenderNode child = box.getFirstChild();
        if (child != null) {
            long maxChildY2 = 0L;
            while (child != null) {
                maxChildY2 = Math.max(child.getCachedY() + child.getCachedHeight() + child.getEffectiveMarginBottom(), maxChildY2);
                child = child.getNext();
            }
            usedHeight = maxChildY2 - box.getCachedY();
        } else {
            usedHeight = insetTop;
        }
        long rminH = minimumHeight.resolve(resolveSize, 0L);
        long rmaxH = maximumHeight.resolve(resolveSize, MAX_AUTO);
        if (boxDefinition.isSizeSpecifiesBorderBox()) {
            long rprefH = preferredHeight.resolve(resolveSize, usedHeight + insetBottom);
            long specifiedHeight = ProcessUtility.computeLength(rminH, rmaxH, rprefH);
            computedHeight = Math.max(0L, specifiedHeight - insetTop - insetBottom);
        } else {
            long rprefH = preferredHeight.resolve(resolveSize, usedHeight - insetTop);
            computedHeight = Math.max(0L, ProcessUtility.computeLength(rminH, rmaxH, rprefH));
        }
        return Math.max(0L, computedHeight + insetTop + insetBottom);
    }

    protected void processParagraphChilds(ParagraphRenderBox box) {
        for (RenderNode node = box.getFirstChild(); node != null; node = node.getNext()) {
            ParagraphPoolBox inlineRenderBox = (ParagraphPoolBox)node;
            if (!this.startLine(inlineRenderBox)) continue;
            this.processBoxChilds(inlineRenderBox);
            this.finishLine(inlineRenderBox);
        }
    }

    private boolean startLine(ParagraphPoolBox box) {
        box.setCachedY(this.computeVerticalBlockPosition(box));
        if (!this.breakState.isActive()) {
            return false;
        }
        if (this.breakState.isSuspended()) {
            return false;
        }
        this.breakState.openContext(new BoxAlignContext(box));
        return true;
    }

    private void finishLine(ParagraphPoolBox inlineRenderBox) {
        if (!this.breakState.isActive() || this.breakState.isSuspended()) {
            return;
        }
        BoxAlignContext boxAlignContext = this.breakState.closeContext();
        StaticBoxLayoutProperties blp = inlineRenderBox.getStaticBoxLayoutProperties();
        BoxDefinition bdef = inlineRenderBox.getBoxDefinition();
        long insetTop = blp.getBorderTop() + bdef.getPaddingTop();
        long contentAreaY1 = inlineRenderBox.getCachedY() + insetTop;
        long lineHeight = inlineRenderBox.getLineHeight();
        this.processor.align(boxAlignContext, contentAreaY1, lineHeight);
    }

    protected boolean startInlineLevelBox(RenderBox box) {
        if (box.isCacheValid()) {
            return false;
        }
        box.setCachedY(this.computeVerticalInlinePosition(box));
        this.computeBaselineInfo(box);
        if (this.breakState == null) {
            return true;
        }
        if (this.breakState.isSuspended()) {
            return false;
        }
        int nodeType = box.getNodeType();
        if ((nodeType & 0x42) == 66) {
            this.breakState.openContext(new BoxAlignContext(box));
            return true;
        }
        if (nodeType == 258) {
            this.breakState.getCurrentLine().addChild(new ReplacedContentAlignContext((RenderableReplacedContentBox)box, 0L));
            return false;
        }
        this.breakState.getCurrentLine().addChild(new InlineBlockAlignContext(box));
        this.breakState.setSuspendItem(box.getInstanceId());
        return false;
    }

    private void computeBaselineInfo(RenderBox box) {
        if (box.getBaselineInfo() == null) {
            return;
        }
        for (RenderNode node = box.getFirstChild(); node != null; node = node.getNext()) {
            if (node.getNodeType() != 17) continue;
            RenderableText text = (RenderableText)node;
            box.setBaselineInfo(text.getBaselineInfo());
            break;
        }
        if (box.getBaselineInfo() == null) {
            box.setBaselineInfo(box.getStaticBoxLayoutProperties().getNominalBaselineInfo());
        }
    }

    protected void processInlineLevelNode(RenderNode node) {
        node.setCachedY(this.computeVerticalInlinePosition(node));
        if (!this.breakState.isActive() || this.breakState.isSuspended()) {
            return;
        }
        if (node.getNodeType() == 17) {
            this.breakState.getCurrentLine().addChild(new TextElementAlignContext((RenderableText)node));
        } else {
            this.breakState.getCurrentLine().addChild(new NodeAlignContext(node));
        }
    }

    protected void finishInlineLevelBox(RenderBox box) {
        if (box.isCacheValid()) {
            return;
        }
        if (!this.breakState.isActive()) {
            return;
        }
        int nodeType = box.getNodeType();
        if ((nodeType & 0x42) == 66) {
            this.breakState.closeContext();
            return;
        }
        Object suspender = this.breakState.getSuspendItem();
        if (box.getInstanceId() == suspender) {
            this.breakState.setSuspendItem(null);
            return;
        }
        if (suspender != null) {
            return;
        }
        if (nodeType == 274) {
            throw new IllegalStateException("This cannot be; Why is there a paragraph inside a inline context");
        }
    }

    private long computeVerticalInlinePosition(RenderNode node) {
        RenderBox parent = node.getParent();
        if (parent != null) {
            StaticBoxLayoutProperties blp = parent.getStaticBoxLayoutProperties();
            BoxDefinition bdef = parent.getBoxDefinition();
            long insetTop = blp.getBorderTop() + bdef.getPaddingTop();
            return insetTop + parent.getCachedY();
        }
        return 0L;
    }

    protected boolean startCanvasLevelBox(RenderBox box) {
        if (box.isCacheValid()) {
            return false;
        }
        box.setCachedY(this.computeVerticalCanvasPosition(box));
        if (!this.breakState.isActive()) {
            int nodeType = box.getNodeType();
            if (nodeType == 274) {
                ParagraphRenderBox paragraphBox = (ParagraphRenderBox)box;
                this.breakState.init(paragraphBox);
            } else if (nodeType == 258) {
                RenderableReplacedContentBox rpc = (RenderableReplacedContentBox)box;
                long computedHeight = ReplacedContentUtil.computeHeight(rpc, 0L, box.getCachedWidth());
                box.setCachedHeight(computedHeight);
            }
            return true;
        }
        if (!this.breakState.isSuspended()) {
            throw new IllegalStateException("This cannot be: No breakstate and not being suspended? Why this?");
        }
        return false;
    }

    protected void processCanvasLevelNode(RenderNode node) {
        node.setCachedY(this.computeVerticalCanvasPosition(node));
        if (node.getNodeType() == 129) {
            FinishedRenderNode fnode = (FinishedRenderNode)node;
            node.setCachedHeight(fnode.getLayoutedHeight());
        } else {
            node.setCachedHeight(0L);
        }
    }

    protected void finishCanvasLevelBox(RenderBox box) {
        if (box.isCacheValid()) {
            return;
        }
        int type = box.getNodeType();
        if ((type & 0x12) == 18) {
            box.setCachedHeight(this.computeBlockHeightAndAlign(box, 0L));
        } else if ((type & 0x82) == 130) {
            box.setCachedHeight(this.computeRowHeight(box, 0L));
        } else if (type != 258) {
            box.setCachedHeight(this.computeCanvasHeight(box));
        }
        if (this.breakState.isActive()) {
            Object suspender = this.breakState.getSuspendItem();
            if (box.getInstanceId() == suspender) {
                this.breakState.setSuspendItem(null);
                return;
            }
            if (suspender != null) {
                return;
            }
            if (type == 274) {
                this.breakState.deinit();
            }
        }
    }

    private long computeVerticalCanvasPosition(RenderNode node) {
        long insetsTop;
        long parentPosition;
        RenderBox parent = node.getParent();
        if (parent == null) {
            parentPosition = 0L;
        } else {
            StaticBoxLayoutProperties blp = parent.getStaticBoxLayoutProperties();
            BoxDefinition bdef = parent.getBoxDefinition();
            insetsTop = blp.getBorderTop() + bdef.getPaddingTop();
            parentPosition = parent.getCachedY() + insetsTop;
        }
        double posY = node.getNodeLayoutProperties().getPosY();
        if (node.isSizeSpecifiesBorderBox()) {
            return parentPosition + RenderLength.resolveLength(0L, posY);
        }
        if ((node.getNodeType() & 2) == 2) {
            RenderBox box = (RenderBox)node;
            StaticBoxLayoutProperties blp = box.getStaticBoxLayoutProperties();
            BoxDefinition bdef = box.getBoxDefinition();
            insetsTop = blp.getBorderTop() + bdef.getPaddingTop();
        } else {
            insetsTop = 0L;
        }
        return parentPosition + RenderLength.resolveLength(0L, posY) - insetsTop;
    }

    private long computeCanvasHeight(RenderBox box) {
        long prefHeightResolved;
        StaticBoxLayoutProperties blp = box.getStaticBoxLayoutProperties();
        BoxDefinition bdef = box.getBoxDefinition();
        BoxDefinition boxDefinition = box.getBoxDefinition();
        RenderLength minHeight = boxDefinition.getMinimumHeight();
        RenderLength preferredHeight = boxDefinition.getPreferredHeight();
        RenderLength maxHeight = boxDefinition.getMaximumHeight();
        long insetsTop = blp.getBorderTop() + bdef.getPaddingTop();
        long insetsBottom = blp.getBorderBottom() + bdef.getPaddingBottom();
        long insets = insetsTop + insetsBottom;
        long minHeightResolved = minHeight.resolve(0L);
        long consumedHeight = box.isSizeSpecifiesBorderBox() ? Math.max(minHeightResolved, insets) - insetsBottom : minHeightResolved + insetsTop;
        long boxY = box.getCachedY();
        for (RenderNode node = box.getFirstChild(); node != null; node = node.getNext()) {
            long childY2 = node.getCachedY() + node.getCachedHeight();
            long childLocalY2 = childY2 - boxY;
            if (childLocalY2 <= consumedHeight) continue;
            consumedHeight = childLocalY2;
        }
        consumedHeight += insetsBottom;
        long maxHeightResolved = maxHeight.resolve(0L, MAX_AUTO);
        if (box.isSizeSpecifiesBorderBox()) {
            prefHeightResolved = RenderLength.AUTO.equals(preferredHeight) ? consumedHeight : (!preferredHeight.isPercentage() ? preferredHeight.resolve(0L) : consumedHeight);
            long height = ProcessUtility.computeLength(minHeightResolved, maxHeightResolved, prefHeightResolved);
            return height;
        }
        consumedHeight = Math.max(0L, consumedHeight - insets);
        prefHeightResolved = RenderLength.AUTO.equals(preferredHeight) ? consumedHeight : (!preferredHeight.isPercentage() ? preferredHeight.resolve(0L) : consumedHeight);
        long height = ProcessUtility.computeLength(minHeightResolved, maxHeightResolved, prefHeightResolved);
        return height + insets;
    }

    protected boolean startRowLevelBox(RenderBox box) {
        if (box.isCacheValid()) {
            return false;
        }
        box.setCachedY(this.computeVerticalRowPosition(box));
        if (this.breakState.isActive()) {
            if (!this.breakState.isSuspended()) {
                throw new IllegalStateException("This cannot be.");
            }
            return false;
        }
        int nodeType = box.getNodeType();
        if (nodeType == 274) {
            ParagraphRenderBox paragraphBox = (ParagraphRenderBox)box;
            this.breakState.init(paragraphBox);
        } else if (nodeType == 258) {
            RenderableReplacedContentBox rpc = (RenderableReplacedContentBox)box;
            box.setCachedHeight(ReplacedContentUtil.computeHeight(rpc, 0L, box.getCachedWidth()));
        }
        return true;
    }

    protected void processRowLevelNode(RenderNode node) {
        node.setCachedY(this.computeVerticalRowPosition(node));
        int nodeType = node.getNodeType();
        if (nodeType == 129) {
            FinishedRenderNode fnode = (FinishedRenderNode)node;
            node.setCachedHeight(fnode.getLayoutedHeight());
        } else if ((nodeType & 0x42) == 66) {
            throw new IllegalStateException("A Inline-Box must be contained in a paragraph.");
        }
    }

    protected void finishRowLevelBox(RenderBox box) {
        if (box.isCacheValid()) {
            return;
        }
        int type = box.getNodeType();
        if ((type & 0x12) == 18) {
            box.setCachedHeight(this.computeBlockHeightAndAlign(box, 0L));
        } else if ((type & 0x82) == 130) {
            box.setCachedHeight(this.computeRowHeight(box, 0L));
        } else if (type != 258) {
            box.setCachedHeight(this.computeCanvasHeight(box));
        }
        if (this.breakState.isActive()) {
            Object suspender = this.breakState.getSuspendItem();
            if (box.getInstanceId() == suspender) {
                this.breakState.setSuspendItem(null);
                return;
            }
            if (suspender != null) {
                return;
            }
            if (type == 274) {
                this.breakState.deinit();
            }
        }
    }

    private long computeVerticalRowPosition(RenderNode node) {
        RenderBox parent = node.getParent();
        if (parent != null) {
            StaticBoxLayoutProperties blp = parent.getStaticBoxLayoutProperties();
            BoxDefinition bdef = parent.getBoxDefinition();
            long insetTop = blp.getBorderTop() + bdef.getPaddingTop();
            return insetTop + parent.getCachedY();
        }
        return 0L;
    }
}

