/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ElementAlignment;
import org.pentaho.reporting.engine.classic.core.layout.model.FinishedRenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.PageGrid;
import org.pentaho.reporting.engine.classic.core.layout.model.ParagraphPoolBox;
import org.pentaho.reporting.engine.classic.core.layout.model.ParagraphRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderLength;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.context.BoxDefinition;
import org.pentaho.reporting.engine.classic.core.layout.model.context.StaticBoxLayoutProperties;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.process.ComputeStaticPropertiesProcessStep;
import org.pentaho.reporting.engine.classic.core.layout.process.IterateVisualProcessStep;
import org.pentaho.reporting.engine.classic.core.layout.process.MinorAxisParagraphBreakState;
import org.pentaho.reporting.engine.classic.core.layout.process.ProcessUtility;
import org.pentaho.reporting.engine.classic.core.layout.process.alignment.CenterAlignmentProcessor;
import org.pentaho.reporting.engine.classic.core.layout.process.alignment.JustifyAlignmentProcessor;
import org.pentaho.reporting.engine.classic.core.layout.process.alignment.LeftAlignmentProcessor;
import org.pentaho.reporting.engine.classic.core.layout.process.alignment.RightAlignmentProcessor;
import org.pentaho.reporting.engine.classic.core.layout.process.alignment.TextAlignmentProcessor;
import org.pentaho.reporting.engine.classic.core.layout.process.layoutrules.EndSequenceElement;
import org.pentaho.reporting.engine.classic.core.layout.process.layoutrules.InlineBoxSequenceElement;
import org.pentaho.reporting.engine.classic.core.layout.process.layoutrules.InlineNodeSequenceElement;
import org.pentaho.reporting.engine.classic.core.layout.process.layoutrules.ReplacedContentSequenceElement;
import org.pentaho.reporting.engine.classic.core.layout.process.layoutrules.SequenceList;
import org.pentaho.reporting.engine.classic.core.layout.process.layoutrules.SpacerSequenceElement;
import org.pentaho.reporting.engine.classic.core.layout.process.layoutrules.StartSequenceElement;
import org.pentaho.reporting.engine.classic.core.layout.process.layoutrules.TextSequenceElement;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.style.TextStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.WhitespaceCollapse;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictGeomUtility;

public final class InfiniteMinorAxisLayoutStep
extends IterateVisualProcessStep {
    private static final Log logger = LogFactory.getLog(InfiniteMinorAxisLayoutStep.class);
    private static final long OVERFLOW_DUMMY_WIDTH = StrictGeomUtility.toInternalValue(20000.0);
    private MinorAxisParagraphBreakState breakState;
    private PageGrid pageGrid;
    private RenderBox continuedElement;
    private TextAlignmentProcessor centerProcessor;
    private TextAlignmentProcessor rightProcessor;
    private TextAlignmentProcessor leftProcessor;
    private TextAlignmentProcessor justifyProcessor;
    private OutputProcessorMetaData metaData;

    public InfiniteMinorAxisLayoutStep(OutputProcessorMetaData metaData) {
        this.metaData = metaData;
        this.breakState = new MinorAxisParagraphBreakState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compute(LogicalPageBox root) {
        try {
            this.continuedElement = null;
            this.pageGrid = root.getPageGrid();
            this.startProcessing(root);
        }
        finally {
            this.continuedElement = null;
            this.pageGrid = null;
            this.breakState.deinit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void continueComputation(PageGrid pageGrid, RenderBox box) {
        if (box.getContentAreaX2() == 0L || box.getCachedWidth() == 0L) {
            throw new IllegalStateException("Box must be layouted a bit ..");
        }
        try {
            this.pageGrid = pageGrid;
            this.breakState.deinit();
            this.continuedElement = box;
            this.startProcessing(box);
        }
        finally {
            this.continuedElement = null;
            this.pageGrid = null;
            this.breakState.deinit();
        }
    }

    protected boolean startBlockLevelBox(RenderBox box) {
        if (!this.breakState.isActive()) {
            if (box.isCacheValid()) {
                return false;
            }
            this.computeContentArea(box, this.computeBlockPosition(box));
            if (box.getNodeType() == 274) {
                ParagraphRenderBox paragraphBox = (ParagraphRenderBox)box;
                if (this.continuedElement == null) {
                    boolean unchanged;
                    long lineBoxChangeTracker = paragraphBox.getEffectiveLineboxContainer().getChangeTracker();
                    boolean bl = unchanged = lineBoxChangeTracker == paragraphBox.getMinorLayoutAge();
                    if (unchanged) {
                        return false;
                    }
                }
                paragraphBox.clearLayout();
                this.breakState.init(paragraphBox);
            }
            return true;
        }
        if (!this.breakState.isSuspended()) {
            throw new IllegalStateException("This cannot be.");
        }
        return false;
    }

    protected void finishBlockLevelBox(RenderBox box) {
        if (box.isCacheValid()) {
            return;
        }
        this.applyComputedWidth(box);
        if (this.breakState.isActive()) {
            Object suspender = this.breakState.getSuspendItem();
            if (box.getInstanceId() == suspender) {
                this.breakState.setSuspendItem(null);
                return;
            }
            if (suspender != null) {
                return;
            }
            if (box.getNodeType() == 274) {
                ParagraphRenderBox paraBox = (ParagraphRenderBox)box;
                paraBox.setMinorLayoutAge(paraBox.getEffectiveLineboxContainer().getChangeTracker());
                this.breakState.deinit();
            }
        }
    }

    private void computeContentArea(RenderBox box, long x) {
        if (box == this.continuedElement) {
            return;
        }
        BoxDefinition bdef = box.getBoxDefinition();
        StaticBoxLayoutProperties blp = box.getStaticBoxLayoutProperties();
        box.setCachedX(x);
        long leftPadding = blp.getBorderLeft() + bdef.getPaddingLeft();
        long rightPadding = blp.getBorderRight() + bdef.getPaddingRight();
        long computedWidth = box.getComputedWidth();
        long bcw = ProcessUtility.computeBlockContextWidth(box);
        BoxDefinition boxDef = box.getBoxDefinition();
        RenderLength minLength = boxDef.getMinimumWidth();
        RenderLength prefLength = boxDef.getPreferredWidth();
        RenderLength maxLength = boxDef.getMaximumWidth();
        long min = minLength.resolve(bcw, 0L);
        long max = maxLength.resolve(bcw, ComputeStaticPropertiesProcessStep.MAX_AUTO);
        long contentAreaX1 = x + leftPadding;
        box.setContentAreaX1(contentAreaX1);
        if (box.getBoxDefinition().isSizeSpecifiesBorderBox()) {
            long minChunkWidth = box.getStyleSheet().getBooleanStyleProperty(ElementStyleKeys.USE_MIN_CHUNKWIDTH) ? box.getMinimumChunkWidth() + leftPadding + rightPadding : leftPadding + rightPadding;
            long pref = prefLength.resolve(bcw, Math.max(computedWidth, minChunkWidth));
            long width = Math.max(0L, ProcessUtility.computeLength(min, max, pref));
            long contentAreaX2 = x + width - rightPadding;
            if (contentAreaX1 < contentAreaX2) {
                box.setContentAreaX2(contentAreaX2);
            } else {
                box.setContentAreaX2(contentAreaX1);
            }
        } else {
            long minChunkWidth = box.getStyleSheet().getBooleanStyleProperty(ElementStyleKeys.USE_MIN_CHUNKWIDTH) ? box.getMinimumChunkWidth() : 0L;
            long computedContentWidth = Math.max(0L, computedWidth - leftPadding - rightPadding);
            long pref = prefLength.resolve(bcw, Math.max(computedContentWidth, minChunkWidth));
            long width = Math.max(0L, ProcessUtility.computeLength(min, max, pref));
            box.setContentAreaX2(contentAreaX1 + width);
        }
    }

    private void computeNodeWidth(RenderNode box) {
        if (box == this.continuedElement) {
            return;
        }
        box.setCachedWidth(box.getComputedWidth());
    }

    private void applyStrictComputedWidth(RenderBox box) {
        BoxDefinition bdef = box.getBoxDefinition();
        StaticBoxLayoutProperties blp = box.getStaticBoxLayoutProperties();
        long leftPadding = blp.getBorderLeft() + bdef.getPaddingLeft();
        long rightPadding = blp.getBorderRight() + bdef.getPaddingRight();
        long computedWidth = box.getComputedWidth();
        long contentAreaX1 = box.getContentAreaX1();
        long usedX2 = box.getContentAreaX2();
        if (box.getStyleSheet().getBooleanStyleProperty(ElementStyleKeys.USE_MIN_CHUNKWIDTH)) {
            for (RenderNode node = box.getFirstChild(); node != null; node = node.getNext()) {
                long x2 = node.getCachedX() + node.getCachedWidth();
                if (x2 <= usedX2) continue;
                usedX2 = x2;
            }
        }
        long usedContentWidth = usedX2 - contentAreaX1;
        long bcw = ProcessUtility.computeBlockContextWidth(box);
        BoxDefinition boxDef = box.getBoxDefinition();
        RenderLength minLength = boxDef.getMinimumWidth();
        RenderLength prefLength = boxDef.getPreferredWidth();
        RenderLength maxLength = boxDef.getMaximumWidth();
        long min = minLength.resolve(bcw, 0L);
        long max = maxLength.resolve(bcw, ComputeStaticPropertiesProcessStep.MAX_AUTO);
        if (box.getBoxDefinition().isSizeSpecifiesBorderBox()) {
            long minChunkWidth = usedContentWidth + leftPadding + rightPadding;
            long pref = prefLength.resolve(bcw, Math.max(computedWidth, minChunkWidth));
            long width = Math.max(0L, ProcessUtility.computeLength(min, max, pref));
            long contentAreaX2 = box.getCachedX() + width - rightPadding;
            if (contentAreaX1 < contentAreaX2) {
                box.setContentAreaX2(contentAreaX2);
            } else {
                box.setContentAreaX2(contentAreaX1);
            }
        } else {
            long computedContentWidth = Math.max(0L, computedWidth - leftPadding - rightPadding);
            long pref = prefLength.resolve(bcw, Math.max(computedContentWidth, usedContentWidth));
            long width = Math.max(0L, ProcessUtility.computeLength(min, max, pref));
            box.setContentAreaX2(contentAreaX1 + width);
        }
        box.setCachedWidth(box.getContentAreaX2() + rightPadding - box.getCachedX());
    }

    private void applyComputedWidth(RenderBox box) {
        if (!RenderLength.AUTO.equals(box.getBoxDefinition().getPreferredWidth())) {
            long x = box.getCachedX();
            long contentEnd = box.getContentAreaX2();
            StaticBoxLayoutProperties blp = box.getStaticBoxLayoutProperties();
            BoxDefinition bdef = box.getBoxDefinition();
            long boxEnd = contentEnd + blp.getBorderRight() + bdef.getPaddingRight();
            box.setCachedWidth(boxEnd - x);
            return;
        }
        long nodeX2 = box.getContentAreaX2();
        if (box.getStyleSheet().getBooleanStyleProperty(ElementStyleKeys.USE_MIN_CHUNKWIDTH)) {
            for (RenderNode node = box.getFirstChild(); node != null; node = node.getNext()) {
                long nodeWidth = node.getCachedWidth() + node.getCachedX();
                if (nodeWidth <= nodeX2) continue;
                nodeX2 = nodeWidth;
            }
        }
        long x = box.getCachedX();
        StaticBoxLayoutProperties blp = box.getStaticBoxLayoutProperties();
        BoxDefinition bdef = box.getBoxDefinition();
        long boxEnd = nodeX2 + blp.getBorderRight() + bdef.getPaddingRight();
        box.setCachedWidth(boxEnd - x);
    }

    protected boolean startInlineLevelBox(RenderBox box) {
        if (!this.breakState.isActive()) {
            return !box.isCacheValid();
        }
        if (this.breakState.isSuspended()) {
            return false;
        }
        int nodeType = box.getNodeType();
        if (nodeType == 258) {
            this.breakState.add(ReplacedContentSequenceElement.INSTANCE, box);
            return false;
        }
        if ((nodeType & 0x42) == 66) {
            this.breakState.add(StartSequenceElement.INSTANCE, box);
            return true;
        }
        this.computeContentArea(box, 0L);
        this.breakState.add(InlineBoxSequenceElement.INSTANCE, box);
        this.breakState.setSuspendItem(box.getInstanceId());
        return false;
    }

    protected void finishInlineLevelBox(RenderBox box) {
        if (!this.breakState.isActive()) {
            return;
        }
        if (this.breakState.getSuspendItem() == box.getInstanceId()) {
            this.breakState.setSuspendItem(null);
            return;
        }
        int nodeType = box.getNodeType();
        if ((nodeType & 0x42) == 66) {
            this.breakState.add(EndSequenceElement.INSTANCE, box);
            return;
        }
        Object suspender = this.breakState.getSuspendItem();
        if (box.getInstanceId() == suspender) {
            this.breakState.setSuspendItem(null);
            return;
        }
        if (suspender != null) {
            return;
        }
        if (nodeType == 274) {
            throw new IllegalStateException("This cannot be: Why is there a paragrah inside a inline-box?");
        }
    }

    protected void processInlineLevelNode(RenderNode node) {
        if (!this.breakState.isActive() || this.breakState.isSuspended()) {
            return;
        }
        int nodeType = node.getNodeType();
        if (nodeType == 129) {
            FinishedRenderNode finNode = (FinishedRenderNode)node;
            node.setCachedWidth(finNode.getLayoutedWidth());
            return;
        }
        if (nodeType == 17) {
            this.breakState.add(TextSequenceElement.INSTANCE, node);
        } else if (nodeType == 65) {
            StyleSheet styleSheet = node.getStyleSheet();
            if (WhitespaceCollapse.PRESERVE.equals(styleSheet.getStyleProperty(TextStyleKeys.WHITE_SPACE_COLLAPSE)) && !styleSheet.getBooleanStyleProperty(TextStyleKeys.TRIM_TEXT_CONTENT)) {
                this.breakState.add(SpacerSequenceElement.INSTANCE, node);
            } else if (this.breakState.isContainsContent()) {
                this.breakState.add(SpacerSequenceElement.INSTANCE, node);
            }
        } else {
            this.breakState.add(InlineNodeSequenceElement.INSTANCE, node);
        }
    }

    protected void processBlockLevelNode(RenderNode node) {
        node.setCachedX(this.computeBlockPosition(node));
        if (node.getNodeType() == 129) {
            FinishedRenderNode finNode = (FinishedRenderNode)node;
            node.setCachedWidth(finNode.getLayoutedWidth());
        } else {
            this.computeNodeWidth(node);
        }
    }

    protected void processCanvasLevelNode(RenderNode node) {
        node.setCachedX(this.computeCanvasPosition(node));
        if (node.getNodeType() == 129) {
            FinishedRenderNode finNode = (FinishedRenderNode)node;
            node.setCachedWidth(finNode.getLayoutedWidth());
        } else {
            this.computeNodeWidth(node);
        }
    }

    protected void processParagraphChilds(ParagraphRenderBox box) {
        if (box.isComplexParagraph()) {
            RenderBox lineboxContainer = box.getLineboxContainer();
            for (RenderNode node = lineboxContainer.getFirstChild(); node != null; node = node.getNext()) {
                if (node.getNodeType() != 322) {
                    throw new IllegalStateException("Expected ParagraphPoolBox elements.");
                }
                ParagraphPoolBox inlineRenderBox = (ParagraphPoolBox)node;
                if (!this.startLine(inlineRenderBox)) continue;
                this.processBoxChilds(inlineRenderBox);
                this.finishLine(inlineRenderBox);
            }
        } else {
            ParagraphPoolBox node = box.getPool();
            if (this.startLine(node)) {
                this.processBoxChilds(node);
                this.finishLine(node);
            }
        }
    }

    private boolean startLine(RenderBox inlineRenderBox) {
        if (!this.breakState.isActive()) {
            return false;
        }
        if (this.breakState.isSuspended()) {
            return false;
        }
        this.breakState.clear();
        this.breakState.add(StartSequenceElement.INSTANCE, inlineRenderBox);
        return true;
    }

    private void finishLine(RenderBox inlineRenderBox) {
        if (!this.breakState.isActive() || this.breakState.isSuspended()) {
            throw new IllegalStateException("No active breakstate, finish-line cannot continue.");
        }
        this.breakState.add(EndSequenceElement.INSTANCE, inlineRenderBox);
        ParagraphRenderBox paragraph = this.breakState.getParagraph();
        ElementAlignment textAlignment = paragraph.getTextAlignment();
        long textIndent = paragraph.getTextIndent();
        long firstLineIndent = paragraph.getFirstLineIndent();
        TextAlignmentProcessor processor = this.create(textAlignment);
        SequenceList sequence = this.breakState.getSequence();
        boolean overflowX = paragraph.getStaticBoxLayoutProperties().isOverflowX();
        long x2 = overflowX ? OVERFLOW_DUMMY_WIDTH : paragraph.getContentAreaX2();
        long x1 = paragraph.getContentAreaX1();
        long lineStart = Math.min(x2, x1 + firstLineIndent);
        long lineEnd = x2;
        if (lineEnd - lineStart <= 0L) {
            long minimumChunkWidth = paragraph.getPool().getMinimumChunkWidth();
            processor.initialize(this.metaData, sequence, lineStart, lineStart + minimumChunkWidth, this.pageGrid, overflowX);
            logger.warn((Object)("Auto-Corrected zero-width first-line on paragraph " + paragraph.getName()));
        } else {
            processor.initialize(this.metaData, sequence, lineStart, lineEnd, this.pageGrid, overflowX);
        }
        while (processor.hasNext()) {
            RenderBox linebox = processor.next();
            if (linebox.getNodeType() != 322) {
                throw new IllegalStateException("Line must not be null");
            }
            paragraph.addGeneratedChild(linebox);
            if (!processor.hasNext()) continue;
            long innerLineEnd = x2;
            long innerLineStart = Math.min(x2, x1 + textIndent);
            if (innerLineEnd - innerLineStart <= 0L) {
                long minimumChunkWidth = paragraph.getPool().getMinimumChunkWidth();
                processor.updateLineSize(innerLineStart, innerLineStart + minimumChunkWidth);
                logger.warn((Object)("Auto-Corrected zero-width text-line on paragraph " + paragraph.getName()));
                continue;
            }
            processor.updateLineSize(innerLineStart, innerLineEnd);
        }
        processor.deinitialize();
    }

    private TextAlignmentProcessor create(ElementAlignment alignment) {
        if (ElementAlignment.CENTER.equals(alignment)) {
            if (this.centerProcessor == null) {
                this.centerProcessor = new CenterAlignmentProcessor();
            }
            return this.centerProcessor;
        }
        if (ElementAlignment.RIGHT.equals(alignment)) {
            if (this.rightProcessor == null) {
                this.rightProcessor = new RightAlignmentProcessor();
            }
            return this.rightProcessor;
        }
        if (ElementAlignment.JUSTIFY.equals(alignment)) {
            if (this.justifyProcessor == null) {
                this.justifyProcessor = new JustifyAlignmentProcessor();
            }
            return this.justifyProcessor;
        }
        if (this.leftProcessor == null) {
            this.leftProcessor = new LeftAlignmentProcessor();
        }
        return this.leftProcessor;
    }

    private long computeBlockPosition(RenderNode node) {
        RenderBox parent = node.getParent();
        if (parent == null) {
            return 0L;
        }
        return parent.getContentAreaX1();
    }

    private long computeCanvasPosition(RenderNode node) {
        RenderBox parent = node.getParent();
        if (parent == null) {
            return 0L;
        }
        long contentAreaX1 = parent.getContentAreaX1();
        long bcw = ProcessUtility.computeBlockContextWidth(node);
        double posX = node.getNodeLayoutProperties().getPosX();
        long position = RenderLength.resolveLength(bcw, posX);
        return contentAreaX1 + position;
    }

    protected boolean startCanvasLevelBox(RenderBox box) {
        if (!this.breakState.isActive()) {
            if (box.isCacheValid()) {
                return false;
            }
            if (box != this.continuedElement) {
                this.computeContentArea(box, this.computeCanvasPosition(box));
            }
            if (box.getNodeType() == 274) {
                ParagraphRenderBox paragraphBox = (ParagraphRenderBox)box;
                if (this.continuedElement == null) {
                    boolean unchanged;
                    long lineBoxChangeTracker = paragraphBox.getEffectiveLineboxContainer().getChangeTracker();
                    boolean bl = unchanged = lineBoxChangeTracker == paragraphBox.getMinorLayoutAge();
                    if (unchanged) {
                        return false;
                    }
                }
                paragraphBox.clearLayout();
                this.breakState.init(paragraphBox);
            }
            return true;
        }
        if (!this.breakState.isSuspended()) {
            throw new IllegalStateException("This cannot be.");
        }
        return false;
    }

    protected void finishCanvasLevelBox(RenderBox box) {
        if (box.isCacheValid()) {
            return;
        }
        this.applyStrictComputedWidth(box);
        if (this.breakState.isActive()) {
            Object suspender = this.breakState.getSuspendItem();
            if (box.getInstanceId() == suspender) {
                this.breakState.setSuspendItem(null);
                return;
            }
            if (suspender != null) {
                return;
            }
            if (box.getNodeType() == 274) {
                ParagraphRenderBox paraBox = (ParagraphRenderBox)box;
                paraBox.setMinorLayoutAge(paraBox.getEffectiveLineboxContainer().getChangeTracker());
                this.breakState.deinit();
            }
        }
    }

    protected boolean startRowLevelBox(RenderBox box) {
        if (!this.breakState.isActive()) {
            if (box.isCacheValid()) {
                return false;
            }
            if (box != this.continuedElement) {
                this.computeContentArea(box, this.computeRowPosition(box));
            }
            if (box.getNodeType() == 274) {
                ParagraphRenderBox paragraphBox = (ParagraphRenderBox)box;
                if (this.continuedElement == null) {
                    boolean unchanged;
                    long lineBoxChangeTracker = paragraphBox.getEffectiveLineboxContainer().getChangeTracker();
                    boolean bl = unchanged = lineBoxChangeTracker == paragraphBox.getMinorLayoutAge();
                    if (unchanged) {
                        return false;
                    }
                }
                paragraphBox.clearLayout();
                this.breakState.init(paragraphBox);
            }
            return true;
        }
        if (!this.breakState.isSuspended()) {
            throw new IllegalStateException("This cannot be.");
        }
        return false;
    }

    protected void processRowLevelNode(RenderNode node) {
        node.setCachedX(this.computeRowPosition(node));
        if (node.getNodeType() == 129) {
            FinishedRenderNode finNode = (FinishedRenderNode)node;
            node.setCachedWidth(finNode.getLayoutedWidth());
        } else {
            this.computeNodeWidth(node);
        }
    }

    protected void finishRowLevelBox(RenderBox box) {
        if (box.isCacheValid()) {
            return;
        }
        this.applyComputedWidth(box);
        if (this.breakState.isActive()) {
            Object suspender = this.breakState.getSuspendItem();
            if (box.getInstanceId() == suspender) {
                this.breakState.setSuspendItem(null);
                return;
            }
            if (suspender != null) {
                return;
            }
            if (box.getNodeType() == 274) {
                ParagraphRenderBox paraBox = (ParagraphRenderBox)box;
                paraBox.setMinorLayoutAge(paraBox.getEffectiveLineboxContainer().getChangeTracker());
                this.breakState.deinit();
            }
        }
    }

    private long computeRowPosition(RenderNode node) {
        long marginLeft = 0L;
        RenderBox parent = node.getParent();
        if (parent != null) {
            RenderNode prev = node.getPrev();
            if (prev != null) {
                return 0L + prev.getCachedX() + prev.getCachedWidth();
            }
            StaticBoxLayoutProperties blp = parent.getStaticBoxLayoutProperties();
            BoxDefinition bdef = parent.getBoxDefinition();
            long insetLeft = blp.getBorderLeft() + bdef.getPaddingLeft();
            return 0L + insetLeft + parent.getCachedX();
        }
        return 0L;
    }
}

