/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process;

import org.pentaho.reporting.engine.classic.core.layout.model.BlockRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.CanvasRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.InlineRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.ParagraphRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableReplacedContentBox;

public abstract class IterateStructuralProcessStep {
    protected IterateStructuralProcessStep() {
    }

    protected final void startProcessing(RenderNode node) {
        int nodeType = node.getNodeType();
        if (nodeType == 258) {
            this.processRenderableContent((RenderableReplacedContentBox)node);
        } else if ((nodeType & 2) == 2) {
            if ((nodeType & 0x12) == 18) {
                if (nodeType == 274) {
                    ParagraphRenderBox box = (ParagraphRenderBox)node;
                    if (this.startBlockBox(box)) {
                        this.processParagraphChilds(box);
                    }
                    this.finishBlockBox(box);
                } else if (nodeType == 1042) {
                    LogicalPageBox box = (LogicalPageBox)node;
                    if (this.startBlockBox(box)) {
                        this.startProcessing(box.getWatermarkArea());
                        this.startProcessing(box.getHeaderArea());
                        this.processBoxChilds(box);
                        this.startProcessing(box.getRepeatFooterArea());
                        this.startProcessing(box.getFooterArea());
                    }
                    this.finishBlockBox(box);
                } else {
                    BlockRenderBox box = (BlockRenderBox)node;
                    if (this.startBlockBox(box)) {
                        this.processBoxChilds(box);
                    }
                    this.finishBlockBox(box);
                }
            } else if ((nodeType & 0x22) == 34) {
                CanvasRenderBox box = (CanvasRenderBox)node;
                if (this.startCanvasBox(box)) {
                    this.processBoxChilds(box);
                }
                this.finishCanvasBox(box);
            } else if ((nodeType & 0x42) == 66) {
                InlineRenderBox box = (InlineRenderBox)node;
                if (this.startInlineBox(box)) {
                    this.processBoxChilds(box);
                }
                this.finishInlineBox(box);
            } else if ((nodeType & 0x82) == 130) {
                RenderBox box = (RenderBox)node;
                if (this.startRowBox(box)) {
                    this.processBoxChilds(box);
                }
                this.finishRowBox(box);
            } else {
                RenderBox box = (RenderBox)node;
                if (this.startOtherBox(box)) {
                    this.processBoxChilds(box);
                }
                this.finishOtherBox(box);
            }
        } else {
            this.processOtherNode(node);
        }
    }

    protected void finishCanvasBox(CanvasRenderBox box) {
    }

    protected boolean startCanvasBox(CanvasRenderBox box) {
        return true;
    }

    protected void processParagraphChilds(ParagraphRenderBox box) {
        this.processBoxChilds(box.getPool());
    }

    protected final void processBoxChilds(RenderBox box) {
        for (RenderNode node = box.getFirstChild(); node != null; node = node.getNext()) {
            this.startProcessing(node);
        }
    }

    protected void processOtherNode(RenderNode node) {
    }

    protected boolean startBlockBox(BlockRenderBox box) {
        return true;
    }

    protected void finishBlockBox(BlockRenderBox box) {
    }

    protected boolean startInlineBox(InlineRenderBox box) {
        return true;
    }

    protected void finishInlineBox(InlineRenderBox box) {
    }

    protected boolean startOtherBox(RenderBox box) {
        return true;
    }

    protected void finishOtherBox(RenderBox box) {
    }

    protected void processRenderableContent(RenderableReplacedContentBox box) {
    }

    protected boolean startRowBox(RenderBox box) {
        return true;
    }

    protected void finishRowBox(RenderBox box) {
    }
}

