/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process;

import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.ParagraphRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;

public abstract class IterateVisualProcessStep {
    protected IterateVisualProcessStep() {
    }

    protected final void startProcessing(RenderNode node) {
        RenderBox parent = node.getParent();
        if (parent == null) {
            this.processBlockLevelChild(node);
        } else {
            int parentType = parent.getNodeType();
            if ((parentType & 0x12) == 18) {
                this.processBlockLevelChild(node);
            } else if ((parentType & 0x22) == 34) {
                this.processCanvasLevelChild(node);
            } else if ((parentType & 0x42) == 66) {
                this.processInlineLevelChild(node);
            } else if ((parentType & 0x82) == 130) {
                this.processRowLevelChild(node);
            } else {
                this.processOtherLevelChild(node);
            }
        }
    }

    protected void processOtherLevelChild(RenderNode node) {
    }

    protected void processInlineLevelNode(RenderNode node) {
    }

    protected boolean startInlineLevelBox(RenderBox box) {
        return true;
    }

    protected void finishInlineLevelBox(RenderBox box) {
    }

    protected final void processInlineLevelChild(RenderNode node) {
        int type = node.getNodeType();
        if (type == 274) {
            ParagraphRenderBox box = (ParagraphRenderBox)node;
            if (this.startInlineLevelBox(box)) {
                this.processParagraphChilds(box);
            }
            this.finishInlineLevelBox(box);
        } else if ((type & 2) == 2) {
            RenderBox box = (RenderBox)node;
            if (this.startInlineLevelBox(box)) {
                this.processBoxChilds(box);
            }
            this.finishInlineLevelBox(box);
        } else {
            this.processInlineLevelNode(node);
        }
    }

    protected void processCanvasLevelNode(RenderNode node) {
    }

    protected boolean startCanvasLevelBox(RenderBox box) {
        return true;
    }

    protected void finishCanvasLevelBox(RenderBox box) {
    }

    protected final void processCanvasLevelChild(RenderNode node) {
        int nodeType = node.getNodeType();
        if (nodeType == 274) {
            ParagraphRenderBox box = (ParagraphRenderBox)node;
            if (this.startCanvasLevelBox(box)) {
                this.processParagraphChilds(box);
            }
            this.finishCanvasLevelBox(box);
        } else if ((nodeType & 2) == 2) {
            RenderBox box = (RenderBox)node;
            if (this.startCanvasLevelBox(box)) {
                this.processBoxChilds(box);
            }
            this.finishCanvasLevelBox(box);
        } else {
            this.processCanvasLevelNode(node);
        }
    }

    protected void processBlockLevelNode(RenderNode node) {
    }

    protected boolean startBlockLevelBox(RenderBox box) {
        return true;
    }

    protected void finishBlockLevelBox(RenderBox box) {
    }

    protected final void processBlockLevelChild(RenderNode node) {
        int nodeType = node.getNodeType();
        if (nodeType == 1042) {
            LogicalPageBox box = (LogicalPageBox)node;
            if (this.startBlockLevelBox(box)) {
                this.startProcessing(box.getWatermarkArea());
                this.startProcessing(box.getHeaderArea());
                this.processBoxChilds(box);
                this.startProcessing(box.getRepeatFooterArea());
                this.startProcessing(box.getFooterArea());
            }
            this.finishBlockLevelBox(box);
        } else if (nodeType == 274) {
            ParagraphRenderBox box = (ParagraphRenderBox)node;
            if (this.startBlockLevelBox(box)) {
                this.processParagraphChilds(box);
            }
            this.finishBlockLevelBox(box);
        } else if ((nodeType & 2) == 2) {
            RenderBox box = (RenderBox)node;
            if (this.startBlockLevelBox(box)) {
                this.processBoxChilds(box);
            }
            this.finishBlockLevelBox(box);
        } else {
            this.processBlockLevelNode(node);
        }
    }

    protected abstract void processParagraphChilds(ParagraphRenderBox var1);

    protected final void processBoxChilds(RenderBox box) {
        for (RenderNode node = box.getFirstChild(); node != null; node = node.getNext()) {
            this.startProcessing(node);
        }
    }

    protected final void processRowLevelChild(RenderNode node) {
        int nodeType = node.getNodeType();
        if (nodeType == 274) {
            ParagraphRenderBox box = (ParagraphRenderBox)node;
            if (this.startRowLevelBox(box)) {
                this.processParagraphChilds(box);
            }
            this.finishRowLevelBox(box);
        } else if ((nodeType & 2) == 2) {
            RenderBox box = (RenderBox)node;
            if (this.startRowLevelBox(box)) {
                this.processBoxChilds(box);
            }
            this.finishRowLevelBox(box);
        } else {
            this.processRowLevelNode(node);
        }
    }

    protected void processRowLevelNode(RenderNode node) {
    }

    protected boolean startRowLevelBox(RenderBox box) {
        return true;
    }

    protected void finishRowLevelBox(RenderBox box) {
    }
}

