/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process;

import org.pentaho.reporting.engine.classic.core.layout.model.ParagraphRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.process.valign.BoxAlignContext;
import org.pentaho.reporting.libraries.base.util.FastStack;

public final class MajorAxisParagraphBreakState {
    private BoxAlignContext currentLine;
    private Object suspendItem;
    private FastStack contexts = new FastStack(50);
    private ParagraphRenderBox paragraph;

    public void init(ParagraphRenderBox paragraph) {
        if (paragraph == null) {
            throw new NullPointerException();
        }
        this.paragraph = paragraph;
        this.contexts.clear();
        this.suspendItem = null;
    }

    public void deinit() {
        this.paragraph = null;
        this.suspendItem = null;
        this.contexts.clear();
    }

    public boolean isActive() {
        return this.paragraph != null;
    }

    public ParagraphRenderBox getParagraph() {
        return this.paragraph;
    }

    public Object getSuspendItem() {
        return this.suspendItem;
    }

    public void setSuspendItem(Object suspendItem) {
        this.suspendItem = suspendItem;
    }

    public boolean isSuspended() {
        return this.suspendItem != null;
    }

    public BoxAlignContext getCurrentLine() {
        return this.currentLine;
    }

    public void openContext(BoxAlignContext context) {
        if (this.currentLine != null) {
            this.currentLine.addChild(context);
        }
        this.contexts.push((Object)context);
        this.currentLine = context;
    }

    public BoxAlignContext closeContext() {
        BoxAlignContext context = (BoxAlignContext)this.contexts.pop();
        context.validate();
        this.currentLine = this.contexts.isEmpty() ? null : (BoxAlignContext)this.contexts.peek();
        return context;
    }
}

