/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process;

import org.pentaho.reporting.engine.classic.core.layout.model.ParagraphRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.process.layoutrules.DefaultSequenceList;
import org.pentaho.reporting.engine.classic.core.layout.process.layoutrules.InlineNodeSequenceElement;
import org.pentaho.reporting.engine.classic.core.layout.process.layoutrules.InlineSequenceElement;
import org.pentaho.reporting.engine.classic.core.layout.process.layoutrules.ReplacedContentSequenceElement;
import org.pentaho.reporting.engine.classic.core.layout.process.layoutrules.SequenceList;
import org.pentaho.reporting.engine.classic.core.layout.process.layoutrules.TextSequenceElement;

public final class MinorAxisParagraphBreakState {
    private Object suspendItem;
    private SequenceList primarySequence = new DefaultSequenceList();
    private ParagraphRenderBox paragraph;
    private boolean containsContent;

    public void init(ParagraphRenderBox paragraph) {
        if (paragraph == null) {
            throw new NullPointerException();
        }
        this.paragraph = paragraph;
        this.primarySequence.clear();
        this.suspendItem = null;
        this.containsContent = false;
    }

    public void deinit() {
        this.paragraph = null;
        this.primarySequence.clear();
        this.suspendItem = null;
        this.containsContent = false;
    }

    public boolean isActive() {
        return this.paragraph != null;
    }

    public ParagraphRenderBox getParagraph() {
        return this.paragraph;
    }

    public Object getSuspendItem() {
        return this.suspendItem;
    }

    public void setSuspendItem(Object suspendItem) {
        this.suspendItem = suspendItem;
    }

    public void add(InlineSequenceElement element, RenderNode node) {
        this.primarySequence.add(element, node);
        if (element instanceof TextSequenceElement || element instanceof InlineNodeSequenceElement || element instanceof ReplacedContentSequenceElement) {
            this.containsContent = true;
        }
    }

    public boolean isContainsContent() {
        return this.containsContent;
    }

    public boolean isSuspended() {
        return this.suspendItem != null;
    }

    public SequenceList getSequence() {
        return this.primarySequence;
    }

    public void clear() {
        this.primarySequence.clear();
        this.containsContent = false;
    }
}

