/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process;

public class PageableBreakContext {
    private long shift;
    private long initialShift;
    private long appliedShift;
    private boolean breakSuspended;

    public PageableBreakContext() {
    }

    public PageableBreakContext(PageableBreakContext parent, boolean useInitialShift) {
        this.updateFromParent(parent, useInitialShift);
    }

    public void updateFromParent(PageableBreakContext parent, boolean useInitialShift) {
        if (useInitialShift) {
            this.shift = parent.appliedShift;
            this.appliedShift = parent.appliedShift;
            this.initialShift = parent.appliedShift;
        } else {
            this.shift = parent.shift;
            this.appliedShift = parent.shift;
            this.initialShift = parent.shift;
        }
        this.breakSuspended = parent.breakSuspended;
    }

    public long getShift() {
        return this.shift;
    }

    public void setShift(long shift) {
        this.shift = shift;
    }

    public long getAppliedShift() {
        return this.appliedShift;
    }

    public void setAppliedShift(long appliedShift) {
        this.appliedShift = appliedShift;
    }

    public long getInitialShift() {
        return this.initialShift;
    }

    public boolean isBreakSuspended() {
        return this.breakSuspended;
    }

    public void suspendBreaks() {
        this.breakSuspended = true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PageableBreakContext");
        sb.append("{shift=").append(this.shift);
        sb.append(", initialShift=").append(this.initialShift);
        sb.append(", breakSuspended=").append(this.breakSuspended);
        sb.append('}');
        return sb.toString();
    }
}

