/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process;

import org.pentaho.reporting.engine.classic.core.layout.model.BlockRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.BreakMarkerRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.PageBreakPositionList;
import org.pentaho.reporting.engine.classic.core.layout.model.ParagraphRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderLength;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.context.StaticBoxLayoutProperties;
import org.pentaho.reporting.engine.classic.core.layout.process.BoxShifter;
import org.pentaho.reporting.engine.classic.core.layout.process.IterateVisualProcessStep;
import org.pentaho.reporting.engine.classic.core.layout.process.PageableBreakContext;
import org.pentaho.reporting.engine.classic.core.layout.process.PaginationResult;
import org.pentaho.reporting.engine.classic.core.states.ReportStateKey;

public final class PaginationStep
extends IterateVisualProcessStep {
    private boolean breakPending;
    private PageBreakPositionList breakUtility = new PageBreakPositionList();
    private long pageHeight;
    private long pageEnd;
    private ReportStateKey visualState;
    private BreakMarkerRenderBox breakIndicatorEncountered;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PaginationResult performPagebreak(LogicalPageBox pageBox) {
        long lastChildY2;
        RenderNode lastChild = pageBox.getLastChild();
        if (lastChild != null && (lastChildY2 = lastChild.getY() + lastChild.getHeight()) < pageBox.getHeight()) {
            throw new IllegalStateException("Assertation failed: Block layouting did not proceed: " + lastChildY2 + " < " + pageBox.getHeight());
        }
        this.pageHeight = pageBox.getPageHeight();
        this.breakIndicatorEncountered = null;
        try {
            long lastChildY22;
            long[] allCurrentBreaks = pageBox.getPhysicalBreaks(1);
            long pageOffset = pageBox.getPageOffset();
            if (allCurrentBreaks.length == 0) {
                throw new IllegalStateException("No page given. This is really bad.");
            }
            BlockRenderBox headerArea = pageBox.getHeaderArea();
            long headerHeight = Math.min(headerArea.getHeight(), allCurrentBreaks[0]);
            headerArea.setHeight(headerHeight);
            long lastBreakLocal = allCurrentBreaks[allCurrentBreaks.length - 1];
            BlockRenderBox footerArea = pageBox.getFooterArea();
            BlockRenderBox repeatFooterArea = pageBox.getRepeatFooterArea();
            long footerHeight = footerArea.getHeight();
            long repeatFooterHeight = repeatFooterArea.getHeight();
            if (allCurrentBreaks.length > 1) {
                long lastPageHeight = lastBreakLocal - allCurrentBreaks[allCurrentBreaks.length - 2];
                footerHeight = Math.min(footerHeight, lastPageHeight);
                footerArea.setHeight(footerHeight);
                repeatFooterHeight = Math.min(footerHeight, lastPageHeight);
                repeatFooterArea.setHeight(repeatFooterHeight);
            }
            if (headerHeight + footerHeight + repeatFooterHeight >= lastBreakLocal) {
                throw new IllegalStateException("Header and footer consume the whole page. No space left for normal-flow.");
            }
            PageBreakPositionList allPreviousBreak = pageBox.getAllVerticalBreaks();
            this.breakUtility.copyFrom(allPreviousBreak);
            if (allCurrentBreaks.length == 1) {
                this.breakUtility.addMajorBreak(pageOffset, headerHeight);
                this.breakUtility.addMajorBreak(lastBreakLocal - repeatFooterHeight - footerHeight - headerHeight + pageOffset, headerHeight);
            } else {
                this.breakUtility.addMajorBreak(pageOffset, headerHeight);
                int breakCount = allCurrentBreaks.length - 1;
                for (int i = 1; i < breakCount; ++i) {
                    long aBreak = allCurrentBreaks[i];
                    this.breakUtility.addMinorBreak(pageOffset + (aBreak - headerHeight));
                }
                this.breakUtility.addMajorBreak(pageOffset + (lastBreakLocal - headerHeight - repeatFooterHeight - footerHeight), headerHeight);
            }
            this.pageEnd = this.breakUtility.getLastMasterBreak();
            this.visualState = null;
            if (this.startBlockLevelBox(pageBox)) {
                this.processBoxChilds(pageBox);
            }
            this.finishBlockLevelBox(pageBox);
            if (lastChild != null && (lastChildY22 = lastChild.getY() + lastChild.getHeight()) < pageBox.getHeight()) {
                throw new IllegalStateException("Assertation failed: Pagination violated block-constraints: " + lastChildY22 + " < " + pageBox.getHeight());
            }
            PageableBreakContext context = (PageableBreakContext)pageBox.getBreakContext();
            if (context == null) {
                throw new IllegalStateException("After pagination, we have no break context. Why?");
            }
            long masterBreak = this.breakUtility.getLastMasterBreak();
            boolean overflow = this.breakIndicatorEncountered != null || pageBox.getHeight() > masterBreak;
            boolean nextPageContainsContent = pageBox.getHeight() > masterBreak;
            PaginationResult paginationResult = new PaginationResult(this.breakUtility, overflow, nextPageContainsContent, this.visualState);
            return paginationResult;
        }
        finally {
            this.visualState = null;
        }
    }

    protected void processParagraphChilds(ParagraphRenderBox box) {
        this.processBoxChilds(box);
    }

    private PageableBreakContext getBreakContext(RenderBox box, boolean createBoxIfNeeded, boolean useInitialShift) {
        Object boxContext = box.getBreakContext();
        RenderBox parentBox = box.getParent();
        if (boxContext instanceof PageableBreakContext) {
            PageableBreakContext context = (PageableBreakContext)boxContext;
            if (createBoxIfNeeded) {
                if (parentBox != null) {
                    PageableBreakContext parentContext = this.getBreakContext(parentBox, false, false);
                    context.updateFromParent(parentContext, useInitialShift);
                } else {
                    context.setShift(0L);
                    context.setAppliedShift(0L);
                }
            }
            return context;
        }
        if (!createBoxIfNeeded) {
            throw new IllegalStateException("How can i have a finish without a start?");
        }
        if (parentBox == null) {
            PageableBreakContext context = new PageableBreakContext();
            box.setBreakContext(context);
            return context;
        }
        PageableBreakContext parentContext = this.getBreakContext(parentBox, false, false);
        PageableBreakContext context = new PageableBreakContext(parentContext, useInitialShift);
        box.setBreakContext(context);
        return context;
    }

    protected boolean startBlockLevelBox(RenderBox box) {
        PageableBreakContext boxContext = this.getBreakContext(box, true, false);
        long shift = boxContext.getShift();
        if (!boxContext.isBreakSuspended() && this.breakIndicatorEncountered == null && box.getNodeType() == 530) {
            box.markPinned(this.pageEnd);
            this.breakIndicatorEncountered = (BreakMarkerRenderBox)box;
        }
        if (!box.isFinishedPaginate()) {
            if (box.isCommited()) {
                box.setFinishedPaginate(true);
            } else {
                StaticBoxLayoutProperties sblp = box.getStaticBoxLayoutProperties();
                if (sblp.isAvoidPagebreakInside() || sblp.getWidows() > 0 || sblp.getOrphans() > 0) {
                    long boxY = box.getY();
                    long nextMinorBreak = this.breakUtility.findNextBreakPosition(boxY + shift);
                    long spaceAvailable = nextMinorBreak - (boxY + shift);
                    if (spaceAvailable == 0L || box.isPinned()) {
                        box.setFinishedPaginate(true);
                    }
                } else {
                    box.setFinishedPaginate(true);
                }
            }
        }
        int breakIndicator = box.getManualBreakIndicator();
        RenderLength fixedPosition = box.getBoxDefinition().getFixedPosition();
        long fixedPositionResolved = fixedPosition.resolve(this.pageHeight, 0L);
        if (breakIndicator == 1 || this.breakPending) {
            long fixedPositionOnNextPage;
            long boxY = box.getY();
            long shiftedBoxY = boxY + shift;
            long nextNonShiftedMajorBreak = this.breakUtility.findNextMajorBreakPosition(shiftedBoxY);
            long nextMajorBreak = Math.max(nextNonShiftedMajorBreak, fixedPositionOnNextPage = this.breakUtility.computeFixedPositionInFlow(nextNonShiftedMajorBreak, fixedPositionResolved));
            if (nextMajorBreak < shiftedBoxY) {
                box.setY(boxY + shift);
            } else {
                long nextShift = nextMajorBreak - boxY;
                long shiftDelta = nextShift - shift;
                box.setY(boxY + nextShift);
                BoxShifter.extendHeight(box.getParent(), shiftDelta);
                boxContext.setShift(nextShift);
                boxContext.setAppliedShift(nextShift);
            }
            this.updateStateKey(box);
            box.markPinned(this.pageEnd);
            this.breakPending = false;
            return true;
        }
        if (RenderLength.AUTO.equals(fixedPosition)) {
            if (!this.breakUtility.isCrossingPagebreak(box, shift)) {
                if (breakIndicator == 0) {
                    BoxShifter.shiftBox(box, shift);
                    this.updateStateKeyDeep(box);
                    return false;
                }
                if (breakIndicator == 2) {
                    long boxY = box.getY();
                    box.setY(boxY + shift);
                    this.updateStateKey(box);
                    return true;
                }
                throw new IllegalStateException("The box contains an invalid BreakIndicator.");
            }
            long boxY = box.getY();
            long nextMinorBreak = this.breakUtility.findNextBreakPosition(boxY + shift);
            long spaceAvailable = nextMinorBreak - (boxY + shift);
            if (spaceAvailable == 0L) {
                box.setY(boxY + shift);
                this.updateStateKey(box);
                box.markPinned(this.pageEnd);
                return true;
            }
            long spaceConsumed = this.computeNonBreakableBoxHeight(box);
            if (spaceAvailable < spaceConsumed) {
                long nextShift = nextMinorBreak - boxY;
                long shiftDelta = nextShift - shift;
                box.setY(boxY + nextShift);
                BoxShifter.extendHeight(box.getParent(), shiftDelta);
                boxContext.setShift(nextShift);
                boxContext.setAppliedShift(nextShift);
                this.updateStateKey(box);
                box.markPinned(this.pageEnd);
                return true;
            }
            box.setY(boxY + shift);
            this.updateStateKey(box);
            return true;
        }
        long boxY = box.getY();
        long shiftedBoxPosition = boxY + shift;
        long fixedPositionInFlow = this.breakUtility.computeFixedPositionInFlow(shiftedBoxPosition, fixedPositionResolved);
        if (fixedPositionInFlow < shiftedBoxPosition) {
            long nextMinorBreak = this.breakUtility.findNextBreakPosition(shiftedBoxPosition);
            long spaceAvailable = nextMinorBreak - shiftedBoxPosition;
            if (spaceAvailable == 0L) {
                box.setY(boxY + shift);
                this.updateStateKey(box);
                box.markPinned(this.pageEnd);
                return true;
            }
            long nextShift = nextMinorBreak - boxY;
            long shiftDelta = nextShift - shift;
            box.setY(boxY + nextShift);
            BoxShifter.extendHeight(box.getParent(), shiftDelta);
            boxContext.setShift(nextShift);
            boxContext.setAppliedShift(nextShift);
            this.updateStateKey(box);
            box.markPinned(this.pageEnd);
            return true;
        }
        long fixedPositionDelta = fixedPositionInFlow - shiftedBoxPosition;
        if (!this.breakUtility.isCrossingPagebreakWithFixedPosition(shiftedBoxPosition, box.getHeight(), fixedPositionResolved)) {
            if (breakIndicator == 0) {
                BoxShifter.shiftBox(box, fixedPositionDelta);
                BoxShifter.extendHeight(box.getParent(), fixedPositionDelta);
                this.updateStateKeyDeep(box);
                return false;
            }
            if (breakIndicator == 2) {
                box.setY(fixedPositionInFlow);
                boxContext.setShift(shift + fixedPositionDelta);
                boxContext.setAppliedShift(shift + fixedPositionDelta);
                BoxShifter.extendHeight(box.getParent(), fixedPositionDelta);
                this.updateStateKey(box);
                return true;
            }
            throw new IllegalStateException("The box contains an invalid BreakIndicator.");
        }
        long nextMinorBreak = this.breakUtility.findNextBreakPosition(fixedPositionInFlow);
        long spaceAvailable = nextMinorBreak - fixedPositionInFlow;
        if (spaceAvailable == 0L) {
            boxContext.setShift(shift + fixedPositionDelta);
            boxContext.setAppliedShift(shift + fixedPositionDelta);
            box.setY(fixedPositionInFlow);
            BoxShifter.extendHeight(box.getParent(), fixedPositionDelta);
            this.updateStateKey(box);
            box.markPinned(this.pageEnd);
            return true;
        }
        long spaceConsumed = this.computeNonBreakableBoxHeight(box);
        if (spaceAvailable < spaceConsumed) {
            long nextShift = nextMinorBreak - boxY;
            long shiftDelta = nextShift - shift;
            box.setY(boxY + nextShift);
            BoxShifter.extendHeight(box.getParent(), shiftDelta);
            boxContext.setShift(nextShift);
            boxContext.setAppliedShift(nextShift);
            this.updateStateKey(box);
            box.markPinned(this.pageEnd);
            return true;
        }
        boxContext.setShift(shift + fixedPositionDelta);
        boxContext.setAppliedShift(shift + fixedPositionDelta);
        box.setY(fixedPositionInFlow);
        BoxShifter.extendHeight(box.getParent(), fixedPositionDelta);
        this.updateStateKey(box);
        return true;
    }

    private void updateStateKey(RenderBox box) {
        ReportStateKey stateKey;
        long y = box.getY();
        if (y < this.pageEnd && (stateKey = box.getStateKey()) != null) {
            this.visualState = stateKey;
        }
    }

    private boolean updateStateKeyDeep(RenderBox box) {
        long y = box.getY();
        if (y < this.pageEnd) {
            ReportStateKey stateKey = box.getStateKey();
            if (stateKey != null) {
                this.visualState = stateKey;
                return true;
            }
            RenderNode lastChild = box.getLastChild();
            while (lastChild != null) {
                if ((lastChild.getNodeType() & 2) != 2) {
                    lastChild = lastChild.getPrev();
                    continue;
                }
                RenderBox lastBox = (RenderBox)lastChild;
                if (this.updateStateKeyDeep(lastBox)) {
                    return true;
                }
                lastChild = lastBox.getPrev();
            }
            return false;
        }
        return false;
    }

    protected void processBlockLevelNode(RenderNode node) {
        PageableBreakContext context = this.getBreakContext(node.getParent(), false, false);
        node.setY(node.getY() + context.getShift());
        if (!this.breakPending && node.isBreakAfter()) {
            this.breakPending = true;
        }
    }

    protected void finishBlockLevelBox(RenderBox box) {
        RenderBox parentBox;
        PageableBreakContext context = this.getBreakContext(box, false, false);
        if (!this.breakPending && box.isBreakAfter()) {
            this.breakPending = true;
        }
        if ((parentBox = box.getParent()) == null) {
            return;
        }
        PageableBreakContext parentContext = this.getBreakContext(parentBox, false, false);
        parentContext.setShift(context.getShift());
    }

    protected boolean startInlineLevelBox(RenderBox box) {
        PageableBreakContext context = this.getBreakContext(box, true, true);
        context.suspendBreaks();
        BoxShifter.shiftBox(box, context.getShift());
        return false;
    }

    protected void processInlineLevelNode(RenderNode node) {
        PageableBreakContext context = this.getBreakContext(node.getParent(), false, false);
        node.setY(node.getY() + context.getShift());
    }

    protected void finishInlineLevelBox(RenderBox box) {
        PageableBreakContext context = this.getBreakContext(box, false, false);
        RenderBox parentBox = box.getParent();
        if (parentBox == null) {
            return;
        }
        PageableBreakContext parentContext = this.getBreakContext(parentBox, false, false);
        parentContext.setShift(context.getShift());
    }

    protected boolean startCanvasLevelBox(RenderBox box) {
        PageableBreakContext context = this.getBreakContext(box, true, true);
        context.suspendBreaks();
        box.setY(box.getY() + context.getShift());
        return true;
    }

    protected void finishCanvasLevelBox(RenderBox box) {
        PageableBreakContext context = this.getBreakContext(box, false, false);
        RenderBox parentBox = box.getParent();
        if (parentBox == null) {
            return;
        }
        PageableBreakContext parentContext = this.getBreakContext(parentBox, false, false);
        parentContext.setShift(context.getShift());
    }

    protected void processCanvasLevelNode(RenderNode node) {
        PageableBreakContext context = this.getBreakContext(node.getParent(), false, false);
        node.setY(node.getY() + context.getShift());
    }

    protected boolean startRowLevelBox(RenderBox box) {
        PageableBreakContext context = this.getBreakContext(box, true, true);
        context.suspendBreaks();
        box.setY(box.getY() + context.getShift());
        return true;
    }

    protected void finishRowLevelBox(RenderBox box) {
        PageableBreakContext context = this.getBreakContext(box, false, false);
        RenderBox parentBox = box.getParent();
        if (parentBox == null) {
            return;
        }
        PageableBreakContext parentContext = this.getBreakContext(parentBox, false, false);
        parentContext.setShift(context.getShift());
    }

    protected void processRowLevelNode(RenderNode node) {
        PageableBreakContext context = this.getBreakContext(node.getParent(), false, false);
        node.setY(node.getY() + context.getShift());
    }

    private long computeNonBreakableBoxHeight(RenderBox box) {
        RenderNode child;
        StaticBoxLayoutProperties sblp = box.getStaticBoxLayoutProperties();
        if (sblp.isAvoidPagebreakInside() && !box.isPinned()) {
            return box.getHeight();
        }
        if (box.isPinned()) {
            return 0L;
        }
        int nodeType = box.getNodeType();
        if (nodeType == 258 && sblp.isAvoidPagebreakInside() || (nodeType & 0x42) == 66) {
            return box.getHeight();
        }
        if ((nodeType & 0x12) != 18) {
            return 0L;
        }
        int orphans = sblp.getOrphans();
        int widows = sblp.getWidows();
        if (orphans == 0 && widows == 0) {
            return 0L;
        }
        int counter = 0;
        for (child = box.getFirstChild(); child != null && counter < orphans; ++counter, child = child.getNext()) {
        }
        long orphanHeight = child == null ? 0L : box.getY() - (child.getY() + child.getHeight());
        counter = 0;
        for (child = box.getLastChild(); child != null && counter < orphans; ++counter, child = child.getPrev()) {
        }
        long widowHeight = child == null ? 0L : box.getY() + box.getHeight() - child.getY();
        return Math.max(orphanHeight, widowHeight);
    }

    protected void processOtherLevelChild(RenderNode node) {
        PageableBreakContext context = this.getBreakContext(node.getParent(), false, false);
        node.setY(node.getY() + context.getShift());
    }
}

